/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer WafRule object
 */
public final class ALBWafRule implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String MODE_DETECTION_ONLY = "WAF_MODE_DETECTION_ONLY";

    public static final java.lang.String MODE_ENFORCEMENT = "WAF_MODE_ENFORCEMENT";

    public static final java.lang.String PHASE_CONNECTION = "WAF_PHASE_CONNECTION";

    public static final java.lang.String PHASE_REQUEST_HEADER = "WAF_PHASE_REQUEST_HEADER";

    public static final java.lang.String PHASE_REQUEST_BODY = "WAF_PHASE_REQUEST_BODY";

    public static final java.lang.String PHASE_RESPONSE_HEADER = "WAF_PHASE_RESPONSE_HEADER";

    public static final java.lang.String PHASE_RESPONSE_BODY = "WAF_PHASE_RESPONSE_BODY";

    public static final java.lang.String PHASE_LOGGING = "WAF_PHASE_LOGGING";

    private java.util.List<java.lang.String> aviTags;

    private java.lang.Boolean enable;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBWafExcludeListEntry> excludeList;

    private java.lang.Long index;

    private java.lang.Boolean isSensitive;

    private java.lang.String mode;

    private java.lang.String name;

    private java.lang.String phase;

    private java.lang.String rule;

    private java.lang.String ruleId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBWafRule() {
    }

    protected ALBWafRule(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Tags for WAF rule as per Modsec language. They are extracted from the tag
     * actions in a Modsec rule. This field is generated from the rule itself and
     * cannot be set by the user. Maximum of 64 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getAviTags() {
        return this.aviTags;
    }

    /**
     * Tags for WAF rule as per Modsec language. They are extracted from the tag
     * actions in a Modsec rule. This field is generated from the rule itself and
     * cannot be set by the user. Maximum of 64 items allowed.
     *
     * @param aviTags New value for the property.
     */
    public void setAviTags(java.util.List<java.lang.String> aviTags) {
        this.aviTags = aviTags;
    }

    /**
     * Enable or disable WAF Rule Group. Default value when not specified in API or
     * module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnable() {
        return this.enable;
    }

    /**
     * Enable or disable WAF Rule Group. Default value when not specified in API or
     * module is interpreted by ALB Controller as true.
     *
     * @param enable New value for the property.
     */
    public void setEnable(java.lang.Boolean enable) {
        this.enable = enable;
    }

    /**
     * Exclude list for the WAF rule. The fields in the exclude list entry are
     * logically and'ed to deduce the exclusion criteria. If there are multiple
     * excludelist entries, it will be 'logical or' of them. Maximum of 64 items
     * allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBWafExcludeListEntry> getExcludeList() {
        return this.excludeList;
    }

    /**
     * Exclude list for the WAF rule. The fields in the exclude list entry are
     * logically and'ed to deduce the exclusion criteria. If there are multiple
     * excludelist entries, it will be 'logical or' of them. Maximum of 64 items
     * allowed.
     *
     * @param excludeList New value for the property.
     */
    public void setExcludeList(java.util.List<com.vmware.nsx_global_policy.model.ALBWafExcludeListEntry> excludeList) {
        this.excludeList = excludeList;
    }

    /**
     * Number of index. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIndex() {
        return this.index;
    }

    /**
     * Number of index. format: int64
     *
     * @param index New value for the property.
     */
    public void setIndex(java.lang.Long index) {
        this.index = index;
    }

    /**
     * The rule field is sensitive and will not be displayed. Default value when not
     * specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsSensitive() {
        return this.isSensitive;
    }

    /**
     * The rule field is sensitive and will not be displayed. Default value when not
     * specified in API or module is interpreted by ALB Controller as false.
     *
     * @param isSensitive New value for the property.
     */
    public void setIsSensitive(java.lang.Boolean isSensitive) {
        this.isSensitive = isSensitive;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafRule#MODE_DETECTION_ONLY}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.ALBWafRule#MODE_ENFORCEMENT}</li>
     * </ul> WAF Rule mode. This can be detection or enforcement. If this is not set,
     * the Policy mode is used. This only takes effect if the policy allows delegation.
     * Enum options - WAF_MODE_DETECTION_ONLY, WAF_MODE_ENFORCEMENT.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMode() {
        return this.mode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafRule#MODE_DETECTION_ONLY}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.ALBWafRule#MODE_ENFORCEMENT}</li>
     * </ul> WAF Rule mode. This can be detection or enforcement. If this is not set,
     * the Policy mode is used. This only takes effect if the policy allows delegation.
     * Enum options - WAF_MODE_DETECTION_ONLY, WAF_MODE_ENFORCEMENT.
     *
     * @param mode New value for the property.
     */
    public void setMode(java.lang.String mode) {
        this.mode = mode;
    }

    /**
     * User-friendly optional name for a rule.
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * User-friendly optional name for a rule.
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_CONNECTION}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_REQUEST_HEADER}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_REQUEST_BODY}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_RESPONSE_HEADER}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_RESPONSE_BODY}</li>
     * <li> {@link com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_LOGGING}</li>
     * </ul> The execution phase where this rule will be executed. Enum options -
     * WAF_PHASE_CONNECTION, WAF_PHASE_REQUEST_HEADER, WAF_PHASE_REQUEST_BODY,
     * WAF_PHASE_RESPONSE_HEADER, WAF_PHASE_RESPONSE_BODY, WAF_PHASE_LOGGING.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPhase() {
        return this.phase;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_CONNECTION}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_REQUEST_HEADER}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_REQUEST_BODY}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_RESPONSE_HEADER}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_RESPONSE_BODY}</li>
     * <li> {@link com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_LOGGING}</li>
     * </ul> The execution phase where this rule will be executed. Enum options -
     * WAF_PHASE_CONNECTION, WAF_PHASE_REQUEST_HEADER, WAF_PHASE_REQUEST_BODY,
     * WAF_PHASE_RESPONSE_HEADER, WAF_PHASE_RESPONSE_BODY, WAF_PHASE_LOGGING.
     *
     * @param phase New value for the property.
     */
    public void setPhase(java.lang.String phase) {
        this.phase = phase;
    }

    /**
     * Rule as per Modsec language.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRule() {
        return this.rule;
    }

    /**
     * Rule as per Modsec language.
     *
     * @param rule New value for the property.
     */
    public void setRule(java.lang.String rule) {
        this.rule = rule;
    }

    /**
     * Identifier (id) for a rule per Modsec language. All SecRule and SecAction
     * directives require an id. It is extracted from the id action in a Modsec rule.
     * Rules within a single WAF Policy are required to have unique rule_ids.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRuleId() {
        return this.ruleId;
    }

    /**
     * Identifier (id) for a rule per Modsec language. All SecRule and SecAction
     * directives require an id. It is extracted from the id action in a Modsec rule.
     * Rules within a single WAF Policy are required to have unique rule_ids.
     *
     * @param ruleId New value for the property.
     */
    public void setRuleId(java.lang.String ruleId) {
        this.ruleId = ruleId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBWafRule;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("avi_tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.aviTags, this._getType().getField("avi_tags")));
        structValue.setField("enable",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enable, this._getType().getField("enable")));
        structValue.setField("exclude_list",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.excludeList, this._getType().getField("exclude_list")));
        structValue.setField("index",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.index, this._getType().getField("index")));
        structValue.setField("is_sensitive",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isSensitive, this._getType().getField("is_sensitive")));
        structValue.setField("mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.mode, this._getType().getField("mode")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("phase",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.phase, this._getType().getField("phase")));
        structValue.setField("rule",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rule, this._getType().getField("rule")));
        structValue.setField("rule_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ruleId, this._getType().getField("rule_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBWafRule;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBWafRule.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBWafRule _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBWafRule(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBWafRule _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBWafRule(structValue);
    }

    /**
     * Builder class for {@link ALBWafRule}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> aviTags;
        private java.lang.Boolean enable;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBWafExcludeListEntry> excludeList;
        private java.lang.Long index;
        private java.lang.Boolean isSensitive;
        private java.lang.String mode;
        private java.lang.String name;
        private java.lang.String phase;
        private java.lang.String rule;
        private java.lang.String ruleId;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBWafRule}.
         */
        public Builder() {
        }

        /**
         * Tags for WAF rule as per Modsec language. They are extracted from the tag
         * actions in a Modsec rule. This field is generated from the rule itself and
         * cannot be set by the user. Maximum of 64 items allowed.
         *
         * @param aviTags New value for the property.
         */
        public Builder setAviTags(java.util.List<java.lang.String> aviTags) {
            this.aviTags = aviTags;
            return this;
        }

        /**
         * Enable or disable WAF Rule Group. Default value when not specified in API or
         * module is interpreted by ALB Controller as true.
         *
         * @param enable New value for the property.
         */
        public Builder setEnable(java.lang.Boolean enable) {
            this.enable = enable;
            return this;
        }

        /**
         * Exclude list for the WAF rule. The fields in the exclude list entry are
         * logically and'ed to deduce the exclusion criteria. If there are multiple
         * excludelist entries, it will be 'logical or' of them. Maximum of 64 items
         * allowed.
         *
         * @param excludeList New value for the property.
         */
        public Builder setExcludeList(java.util.List<com.vmware.nsx_global_policy.model.ALBWafExcludeListEntry> excludeList) {
            this.excludeList = excludeList;
            return this;
        }

        /**
         * Number of index. format: int64
         *
         * @param index New value for the property.
         */
        public Builder setIndex(java.lang.Long index) {
            this.index = index;
            return this;
        }

        /**
         * The rule field is sensitive and will not be displayed. Default value when not
         * specified in API or module is interpreted by ALB Controller as false.
         *
         * @param isSensitive New value for the property.
         */
        public Builder setIsSensitive(java.lang.Boolean isSensitive) {
            this.isSensitive = isSensitive;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafRule#MODE_DETECTION_ONLY}</li> <li>
         * {@link com.vmware.nsx_global_policy.model.ALBWafRule#MODE_ENFORCEMENT}</li>
         * </ul> WAF Rule mode. This can be detection or enforcement. If this is not set,
         * the Policy mode is used. This only takes effect if the policy allows delegation.
         * Enum options - WAF_MODE_DETECTION_ONLY, WAF_MODE_ENFORCEMENT.
         *
         * @param mode New value for the property.
         */
        public Builder setMode(java.lang.String mode) {
            this.mode = mode;
            return this;
        }

        /**
         * User-friendly optional name for a rule.
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_CONNECTION}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_REQUEST_HEADER}</li> <li>
         * {@link com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_REQUEST_BODY}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_RESPONSE_HEADER}</li> <li>
         * {@link com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_RESPONSE_BODY}</li>
         * <li> {@link com.vmware.nsx_global_policy.model.ALBWafRule#PHASE_LOGGING}</li>
         * </ul> The execution phase where this rule will be executed. Enum options -
         * WAF_PHASE_CONNECTION, WAF_PHASE_REQUEST_HEADER, WAF_PHASE_REQUEST_BODY,
         * WAF_PHASE_RESPONSE_HEADER, WAF_PHASE_RESPONSE_BODY, WAF_PHASE_LOGGING.
         *
         * @param phase New value for the property.
         */
        public Builder setPhase(java.lang.String phase) {
            this.phase = phase;
            return this;
        }

        /**
         * Rule as per Modsec language.
         *
         * @param rule New value for the property.
         */
        public Builder setRule(java.lang.String rule) {
            this.rule = rule;
            return this;
        }

        /**
         * Identifier (id) for a rule per Modsec language. All SecRule and SecAction
         * directives require an id. It is extracted from the id action in a Modsec rule.
         * Rules within a single WAF Policy are required to have unique rule_ids.
         *
         * @param ruleId New value for the property.
         */
        public Builder setRuleId(java.lang.String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public ALBWafRule build() {
            ALBWafRule result = new ALBWafRule();
            result.setAviTags(this.aviTags);
            result.setEnable(this.enable);
            result.setExcludeList(this.excludeList);
            result.setIndex(this.index);
            result.setIsSensitive(this.isSensitive);
            result.setMode(this.mode);
            result.setName(this.name);
            result.setPhase(this.phase);
            result.setRule(this.rule);
            result.setRuleId(this.ruleId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("avi_tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("avi_tags",
                                                                                "aviTags",
                                                                                "getAviTags",
                                                                                "setAviTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable",
                                                                                "enable",
                                                                                "getEnable",
                                                                                "setEnable");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("exclude_list", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBWafExcludeListEntry; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("exclude_list",
                                                                                "excludeList",
                                                                                "getExcludeList",
                                                                                "setExcludeList");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("index", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("index",
                                                                                "index",
                                                                                "getIndex",
                                                                                "setIndex");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_sensitive", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_sensitive",
                                                                                "isSensitive",
                                                                                "getIsSensitive",
                                                                                "setIsSensitive");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mode",
                                                                                "mode",
                                                                                "getMode",
                                                                                "setMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("phase", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("phase",
                                                                                "phase",
                                                                                "getPhase",
                                                                                "setPhase");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rule", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rule",
                                                                                "rule",
                                                                                "getRule",
                                                                                "setRule");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rule_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rule_id",
                                                                                "ruleId",
                                                                                "getRuleId",
                                                                                "setRuleId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_waf_rule",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBWafRule.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

