/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Resource attribute on which constraint should be applied. Example - sourceGroups
 * attribute of Edge CommunicationEntry to be restricted, is given as: {
 * \"target_resource_type\":\"CommunicationEntry\", \"attribute\":\"sourceGroups\",
 * \"path_prefix\":\"/infra/domains/vmc-domain/edge-communication-maps/default/communication-entries\"
 * }
 */
public final class ConstraintTarget implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String attribute;

    private java.lang.String pathPrefix;

    private java.lang.String targetResourceType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ConstraintTarget() {
    }

    protected ConstraintTarget(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Attribute name of the target entity.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAttribute() {
        return this.attribute;
    }

    /**
     * Attribute name of the target entity.
     *
     * @param attribute New value for the property.
     */
    public void setAttribute(java.lang.String attribute) {
        this.attribute = attribute;
    }

    /**
     * Path prefix of the entity to apply constraint. This is required to further
     * disambiguiate if multiple policy entities share the same resource type. Example
     * - Edge FW and DFW use the same resource type CommunicationMap,
     * CommunicationEntry, Group, etc.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPathPrefix() {
        return this.pathPrefix;
    }

    /**
     * Path prefix of the entity to apply constraint. This is required to further
     * disambiguiate if multiple policy entities share the same resource type. Example
     * - Edge FW and DFW use the same resource type CommunicationMap,
     * CommunicationEntry, Group, etc.
     *
     * @param pathPrefix New value for the property.
     */
    public void setPathPrefix(java.lang.String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    /**
     * Resource type of the target entity. This is required in case the constraint
     * expressions do not specify target resource type.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTargetResourceType() {
        return this.targetResourceType;
    }

    /**
     * Resource type of the target entity. This is required in case the constraint
     * expressions do not specify target resource type.
     *
     * @param targetResourceType New value for the property.
     */
    public void setTargetResourceType(java.lang.String targetResourceType) {
        this.targetResourceType = targetResourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.constraintTarget;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("attribute",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.attribute, this._getType().getField("attribute")));
        structValue.setField("path_prefix",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pathPrefix, this._getType().getField("path_prefix")));
        structValue.setField("target_resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.targetResourceType, this._getType().getField("target_resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.constraintTarget;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.constraintTarget.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ConstraintTarget _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ConstraintTarget(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ConstraintTarget _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ConstraintTarget(structValue);
    }

    /**
     * Builder class for {@link ConstraintTarget}.
     */
    public static final class Builder {
        private java.lang.String attribute;
        private java.lang.String pathPrefix;
        private java.lang.String targetResourceType;

        /**
         * Constructor with parameters for the required properties of
         * {@link ConstraintTarget}.
         */
        public Builder() {
        }

        /**
         * Attribute name of the target entity.
         *
         * @param attribute New value for the property.
         */
        public Builder setAttribute(java.lang.String attribute) {
            this.attribute = attribute;
            return this;
        }

        /**
         * Path prefix of the entity to apply constraint. This is required to further
         * disambiguiate if multiple policy entities share the same resource type. Example
         * - Edge FW and DFW use the same resource type CommunicationMap,
         * CommunicationEntry, Group, etc.
         *
         * @param pathPrefix New value for the property.
         */
        public Builder setPathPrefix(java.lang.String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }

        /**
         * Resource type of the target entity. This is required in case the constraint
         * expressions do not specify target resource type.
         *
         * @param targetResourceType New value for the property.
         */
        public Builder setTargetResourceType(java.lang.String targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        public ConstraintTarget build() {
            ConstraintTarget result = new ConstraintTarget();
            result.setAttribute(this.attribute);
            result.setPathPrefix(this.pathPrefix);
            result.setTargetResourceType(this.targetResourceType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("attribute", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("attribute",
                                                                                "attribute",
                                                                                "getAttribute",
                                                                                "setAttribute");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("path_prefix", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("path_prefix",
                                                                                "pathPrefix",
                                                                                "getPathPrefix",
                                                                                "setPathPrefix");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("target_resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("target_resource_type",
                                                                                "targetResourceType",
                                                                                "getTargetResourceType",
                                                                                "setTargetResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.constraint_target",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ConstraintTarget.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

