/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Provides upgrade summary for a specific site.
 */
public final class FederationUpgradeSummary implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String OVERALL_UPGRADE_STATUS_SUCCESS = "SUCCESS";

    public static final java.lang.String OVERALL_UPGRADE_STATUS_FAILED = "FAILED";

    public static final java.lang.String OVERALL_UPGRADE_STATUS_IN_PROGRESS = "IN_PROGRESS";

    public static final java.lang.String OVERALL_UPGRADE_STATUS_NOT_STARTED = "NOT_STARTED";

    public static final java.lang.String OVERALL_UPGRADE_STATUS_PAUSED = "PAUSED";

    public static final java.lang.String SITE_TYPE_ACTIVE_GM_SITE = "ACTIVE_GM_SITE";

    public static final java.lang.String SITE_TYPE_STANDBY_GM_SITE = "STANDBY_GM_SITE";

    public static final java.lang.String SITE_TYPE_NON_GM_SITE = "NON_GM_SITE";

    private java.util.List<com.vmware.nsx_global_policy.model.FederationComponentUpgradeStatus> componentStatus;

    private java.lang.String currentVersion;

    private java.lang.String gpmName;

    private java.lang.String id;

    private java.lang.String lastUpgradeTimestamp;

    private java.lang.String name;

    private java.lang.String overallUpgradeStatus;

    private java.lang.String siteId;

    private java.lang.String siteIp;

    private java.lang.String siteType;

    private java.lang.String targetVersion;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public FederationUpgradeSummary() {
    }

    protected FederationUpgradeSummary(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * List of component statuses
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.FederationComponentUpgradeStatus> getComponentStatus() {
        return this.componentStatus;
    }

    /**
     * List of component statuses
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param componentStatus New value for the property.
     */
    public void setComponentStatus(java.util.List<com.vmware.nsx_global_policy.model.FederationComponentUpgradeStatus> componentStatus) {
        this.componentStatus = componentStatus;
    }

    /**
     * This is NSX version for the site.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCurrentVersion() {
        return this.currentVersion;
    }

    /**
     * This is NSX version for the site.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentVersion New value for the property.
     */
    public void setCurrentVersion(java.lang.String currentVersion) {
        this.currentVersion = currentVersion;
    }

    /**
     * Name of the global manager if present.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getGpmName() {
        return this.gpmName;
    }

    /**
     * Name of the global manager if present.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param gpmName New value for the property.
     */
    public void setGpmName(java.lang.String gpmName) {
        this.gpmName = gpmName;
    }

    /**
     * Unique identifier of this resource.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * Indicates the time when the site was upgraded.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastUpgradeTimestamp() {
        return this.lastUpgradeTimestamp;
    }

    /**
     * Indicates the time when the site was upgraded.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastUpgradeTimestamp New value for the property.
     */
    public void setLastUpgradeTimestamp(java.lang.String lastUpgradeTimestamp) {
        this.lastUpgradeTimestamp = lastUpgradeTimestamp;
    }

    /**
     * Name of the site.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * Name of the site.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_SUCCESS}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_FAILED}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_IN_PROGRESS}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_NOT_STARTED}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_PAUSED}</li>
     * </ul> Status of upgrade
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOverallUpgradeStatus() {
        return this.overallUpgradeStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_SUCCESS}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_FAILED}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_IN_PROGRESS}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_NOT_STARTED}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_PAUSED}</li>
     * </ul> Status of upgrade
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param overallUpgradeStatus New value for the property.
     */
    public void setOverallUpgradeStatus(java.lang.String overallUpgradeStatus) {
        this.overallUpgradeStatus = overallUpgradeStatus;
    }

    /**
     * This is the Site Manager generated UUID for every NSX deployment.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSiteId() {
        return this.siteId;
    }

    /**
     * This is the Site Manager generated UUID for every NSX deployment.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param siteId New value for the property.
     */
    public void setSiteId(java.lang.String siteId) {
        this.siteId = siteId;
    }

    /**
     * IP address of the site.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSiteIp() {
        return this.siteIp;
    }

    /**
     * IP address of the site.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param siteIp New value for the property.
     */
    public void setSiteIp(java.lang.String siteIp) {
        this.siteIp = siteIp;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#SITE_TYPE_ACTIVE_GM_SITE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#SITE_TYPE_STANDBY_GM_SITE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#SITE_TYPE_NON_GM_SITE}</li>
     * </ul> Type of this site.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSiteType() {
        return this.siteType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#SITE_TYPE_ACTIVE_GM_SITE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#SITE_TYPE_STANDBY_GM_SITE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#SITE_TYPE_NON_GM_SITE}</li>
     * </ul> Type of this site.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param siteType New value for the property.
     */
    public void setSiteType(java.lang.String siteType) {
        this.siteType = siteType;
    }

    /**
     * This is NSX target version for the site, if it is undergoing upgrade.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTargetVersion() {
        return this.targetVersion;
    }

    /**
     * This is NSX target version for the site, if it is undergoing upgrade.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param targetVersion New value for the property.
     */
    public void setTargetVersion(java.lang.String targetVersion) {
        this.targetVersion = targetVersion;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.federationUpgradeSummary;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("component_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.componentStatus, this._getType().getField("component_status")));
        structValue.setField("current_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentVersion, this._getType().getField("current_version")));
        structValue.setField("gpm_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.gpmName, this._getType().getField("gpm_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("last_upgrade_timestamp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastUpgradeTimestamp, this._getType().getField("last_upgrade_timestamp")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("overall_upgrade_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.overallUpgradeStatus, this._getType().getField("overall_upgrade_status")));
        structValue.setField("site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.siteId, this._getType().getField("site_id")));
        structValue.setField("site_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.siteIp, this._getType().getField("site_ip")));
        structValue.setField("site_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.siteType, this._getType().getField("site_type")));
        structValue.setField("target_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.targetVersion, this._getType().getField("target_version")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.federationUpgradeSummary;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.federationUpgradeSummary.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static FederationUpgradeSummary _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new FederationUpgradeSummary(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static FederationUpgradeSummary _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new FederationUpgradeSummary(structValue);
    }

    /**
     * Builder class for {@link FederationUpgradeSummary}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_global_policy.model.FederationComponentUpgradeStatus> componentStatus;
        private java.lang.String currentVersion;
        private java.lang.String gpmName;
        private java.lang.String id;
        private java.lang.String lastUpgradeTimestamp;
        private java.lang.String name;
        private java.lang.String overallUpgradeStatus;
        private java.lang.String siteId;
        private java.lang.String siteIp;
        private java.lang.String siteType;
        private java.lang.String targetVersion;

        /**
         * Constructor with parameters for the required properties of
         * {@link FederationUpgradeSummary}.
         */
        public Builder() {
        }

        /**
         * List of component statuses
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param componentStatus New value for the property.
         */
        public Builder setComponentStatus(java.util.List<com.vmware.nsx_global_policy.model.FederationComponentUpgradeStatus> componentStatus) {
            this.componentStatus = componentStatus;
            return this;
        }

        /**
         * This is NSX version for the site.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentVersion New value for the property.
         */
        public Builder setCurrentVersion(java.lang.String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        /**
         * Name of the global manager if present.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param gpmName New value for the property.
         */
        public Builder setGpmName(java.lang.String gpmName) {
            this.gpmName = gpmName;
            return this;
        }

        /**
         * Unique identifier of this resource.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Indicates the time when the site was upgraded.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastUpgradeTimestamp New value for the property.
         */
        public Builder setLastUpgradeTimestamp(java.lang.String lastUpgradeTimestamp) {
            this.lastUpgradeTimestamp = lastUpgradeTimestamp;
            return this;
        }

        /**
         * Name of the site.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_SUCCESS}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_FAILED}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_IN_PROGRESS}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_NOT_STARTED}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#OVERALL_UPGRADE_STATUS_PAUSED}</li>
         * </ul> Status of upgrade
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param overallUpgradeStatus New value for the property.
         */
        public Builder setOverallUpgradeStatus(java.lang.String overallUpgradeStatus) {
            this.overallUpgradeStatus = overallUpgradeStatus;
            return this;
        }

        /**
         * This is the Site Manager generated UUID for every NSX deployment.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param siteId New value for the property.
         */
        public Builder setSiteId(java.lang.String siteId) {
            this.siteId = siteId;
            return this;
        }

        /**
         * IP address of the site.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param siteIp New value for the property.
         */
        public Builder setSiteIp(java.lang.String siteIp) {
            this.siteIp = siteIp;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#SITE_TYPE_ACTIVE_GM_SITE}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#SITE_TYPE_STANDBY_GM_SITE}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.FederationUpgradeSummary#SITE_TYPE_NON_GM_SITE}</li>
         * </ul> Type of this site.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param siteType New value for the property.
         */
        public Builder setSiteType(java.lang.String siteType) {
            this.siteType = siteType;
            return this;
        }

        /**
         * This is NSX target version for the site, if it is undergoing upgrade.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param targetVersion New value for the property.
         */
        public Builder setTargetVersion(java.lang.String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public FederationUpgradeSummary build() {
            FederationUpgradeSummary result = new FederationUpgradeSummary();
            result.setComponentStatus(this.componentStatus);
            result.setCurrentVersion(this.currentVersion);
            result.setGpmName(this.gpmName);
            result.setId(this.id);
            result.setLastUpgradeTimestamp(this.lastUpgradeTimestamp);
            result.setName(this.name);
            result.setOverallUpgradeStatus(this.overallUpgradeStatus);
            result.setSiteId(this.siteId);
            result.setSiteIp(this.siteIp);
            result.setSiteType(this.siteType);
            result.setTargetVersion(this.targetVersion);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("component_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.federationComponentUpgradeStatus; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("component_status",
                                                                                "componentStatus",
                                                                                "getComponentStatus",
                                                                                "setComponentStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_version",
                                                                                "currentVersion",
                                                                                "getCurrentVersion",
                                                                                "setCurrentVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("gpm_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("gpm_name",
                                                                                "gpmName",
                                                                                "getGpmName",
                                                                                "setGpmName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("last_upgrade_timestamp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("last_upgrade_timestamp",
                                                                                "lastUpgradeTimestamp",
                                                                                "getLastUpgradeTimestamp",
                                                                                "setLastUpgradeTimestamp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("overall_upgrade_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("overall_upgrade_status",
                                                                                "overallUpgradeStatus",
                                                                                "getOverallUpgradeStatus",
                                                                                "setOverallUpgradeStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("site_id",
                                                                                "siteId",
                                                                                "getSiteId",
                                                                                "setSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("site_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("site_ip",
                                                                                "siteIp",
                                                                                "getSiteIp",
                                                                                "setSiteIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("site_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("site_type",
                                                                                "siteType",
                                                                                "getSiteType",
                                                                                "setSiteType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("target_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("target_version",
                                                                                "targetVersion",
                                                                                "getTargetVersion",
                                                                                "setTargetVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.federation_upgrade_summary",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.FederationUpgradeSummary.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

