/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * This action is used to rewrite URIs in matched HTTP request messages. Specify
 * the uri and uri_arguments fields in this condition to rewrite the matched HTTP
 * request message's URI and URI arguments to the new values. Full URI scheme of
 * HTTP messages have following syntax:
 * scheme:[//[user[:password]@]host[:port]][/path][?query][#fragment] The uri field
 * of this action is used to rewrite the /path part in above scheme. And the
 * uri_arguments field is used to rewrite the query part. Captured variables and
 * built-in variables can be used in the uri and uri_arguments fields. Check the
 * example in LBRuleAction to see how to use variables in this action.
 */
public final class LBHttpRequestUriRewriteAction implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LBHttpRequestUriRewriteAction";

    private java.lang.String uri;

    private java.lang.String uriArguments;

    private final java.lang.String type = "LBHttpRequestUriRewriteAction";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBHttpRequestUriRewriteAction() {
    }

    protected LBHttpRequestUriRewriteAction(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * URI of HTTP request.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUri() {
        return this.uri;
    }

    /**
     * URI of HTTP request.
     *
     * @param uri New value for the property.
     */
    public void setUri(java.lang.String uri) {
        this.uri = uri;
    }

    /**
     * Query string of URI, typically contains key value pairs, for example:
     * foo1=bar1&foo2=bar2.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUriArguments() {
        return this.uriArguments;
    }

    /**
     * Query string of URI, typically contains key value pairs, for example:
     * foo1=bar1&foo2=bar2.
     *
     * @param uriArguments New value for the property.
     */
    public void setUriArguments(java.lang.String uriArguments) {
        this.uriArguments = uriArguments;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBSELECTPOOLACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTURIREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREJECTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREDIRECTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBVARIABLEASSIGNMENTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCEONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCELEARNACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBJWTAUTHACTION}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBSSLMODESELECTIONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBCONNECTIONDROPACTION}</li>
     * </ul> The property identifies the load balancer rule action type.
     * The value of this property is automatically populated to {@code "LBHttpRequestUriRewriteAction"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestUriRewriteAction;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uri, this._getType().getField("uri")));
        structValue.setField("uri_arguments",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uriArguments, this._getType().getField("uri_arguments")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestUriRewriteAction;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestUriRewriteAction.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBHttpRequestUriRewriteAction _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBHttpRequestUriRewriteAction(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBHttpRequestUriRewriteAction _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBHttpRequestUriRewriteAction(structValue);
    }

    /**
     * Builder class for {@link LBHttpRequestUriRewriteAction}.
     */
    public static final class Builder {
        private java.lang.String uri;
        private java.lang.String uriArguments;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBHttpRequestUriRewriteAction}.
         */
        public Builder() {
        }

        /**
         * URI of HTTP request.
         *
         * @param uri New value for the property.
         */
        public Builder setUri(java.lang.String uri) {
            this.uri = uri;
            return this;
        }

        /**
         * Query string of URI, typically contains key value pairs, for example:
         * foo1=bar1&foo2=bar2.
         *
         * @param uriArguments New value for the property.
         */
        public Builder setUriArguments(java.lang.String uriArguments) {
            this.uriArguments = uriArguments;
            return this;
        }

        public LBHttpRequestUriRewriteAction build() {
            LBHttpRequestUriRewriteAction result = new LBHttpRequestUriRewriteAction();
            result.setUri(this.uri);
            result.setUriArguments(this.uriArguments);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("uri",
                                                                                "uri",
                                                                                "getUri",
                                                                                "setUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("uri_arguments", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("uri_arguments",
                                                                                "uriArguments",
                                                                                "getUriArguments",
                                                                                "setUriArguments");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.LB_http_request_uri_rewrite_action",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.LBHttpRequestUriRewriteAction.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LBHttpRequestUriRewriteAction");
    }
}

