/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * IP usage statistics in a IpAddressPool.
 */
public final class PolicyPoolUsage implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long allocatedIpAllocations;

    private java.lang.Long availableIps;

    private java.lang.Long requestedIpAllocations;

    private java.lang.Long totalIps;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PolicyPoolUsage() {
    }

    protected PolicyPoolUsage(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Total number of allocated IPs shown are from NSX manager. NSX manager uses
     * default release delay of 2 mins. Till this delay passes, IPs will be shown as
     * allocated (and counted in allocated ips). In this period of time there could be
     * mismatch in requested_ip_allocations and allocated_ip_allocations. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getAllocatedIpAllocations() {
        return this.allocatedIpAllocations;
    }

    /**
     * Total number of allocated IPs shown are from NSX manager. NSX manager uses
     * default release delay of 2 mins. Till this delay passes, IPs will be shown as
     * allocated (and counted in allocated ips). In this period of time there could be
     * mismatch in requested_ip_allocations and allocated_ip_allocations. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param allocatedIpAllocations New value for the property.
     */
    public void setAllocatedIpAllocations(java.lang.Long allocatedIpAllocations) {
        this.allocatedIpAllocations = allocatedIpAllocations;
    }

    /**
     * Total number of available IPs in a IpAddressPool format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getAvailableIps() {
        return this.availableIps;
    }

    /**
     * Total number of available IPs in a IpAddressPool format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param availableIps New value for the property.
     */
    public void setAvailableIps(java.lang.Long availableIps) {
        this.availableIps = availableIps;
    }

    /**
     * Total number of requested IP allocations in a IpAddressPool format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRequestedIpAllocations() {
        return this.requestedIpAllocations;
    }

    /**
     * Total number of requested IP allocations in a IpAddressPool format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param requestedIpAllocations New value for the property.
     */
    public void setRequestedIpAllocations(java.lang.Long requestedIpAllocations) {
        this.requestedIpAllocations = requestedIpAllocations;
    }

    /**
     * Total number of IPs in a IpAddressPool format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTotalIps() {
        return this.totalIps;
    }

    /**
     * Total number of IPs in a IpAddressPool format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param totalIps New value for the property.
     */
    public void setTotalIps(java.lang.Long totalIps) {
        this.totalIps = totalIps;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.policyPoolUsage;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("allocated_ip_allocations",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allocatedIpAllocations, this._getType().getField("allocated_ip_allocations")));
        structValue.setField("available_ips",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.availableIps, this._getType().getField("available_ips")));
        structValue.setField("requested_ip_allocations",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestedIpAllocations, this._getType().getField("requested_ip_allocations")));
        structValue.setField("total_ips",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.totalIps, this._getType().getField("total_ips")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.policyPoolUsage;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.policyPoolUsage.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PolicyPoolUsage _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyPoolUsage(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PolicyPoolUsage _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyPoolUsage(structValue);
    }

    /**
     * Builder class for {@link PolicyPoolUsage}.
     */
    public static final class Builder {
        private java.lang.Long allocatedIpAllocations;
        private java.lang.Long availableIps;
        private java.lang.Long requestedIpAllocations;
        private java.lang.Long totalIps;

        /**
         * Constructor with parameters for the required properties of
         * {@link PolicyPoolUsage}.
         */
        public Builder() {
        }

        /**
         * Total number of allocated IPs shown are from NSX manager. NSX manager uses
         * default release delay of 2 mins. Till this delay passes, IPs will be shown as
         * allocated (and counted in allocated ips). In this period of time there could be
         * mismatch in requested_ip_allocations and allocated_ip_allocations. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param allocatedIpAllocations New value for the property.
         */
        public Builder setAllocatedIpAllocations(java.lang.Long allocatedIpAllocations) {
            this.allocatedIpAllocations = allocatedIpAllocations;
            return this;
        }

        /**
         * Total number of available IPs in a IpAddressPool format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param availableIps New value for the property.
         */
        public Builder setAvailableIps(java.lang.Long availableIps) {
            this.availableIps = availableIps;
            return this;
        }

        /**
         * Total number of requested IP allocations in a IpAddressPool format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param requestedIpAllocations New value for the property.
         */
        public Builder setRequestedIpAllocations(java.lang.Long requestedIpAllocations) {
            this.requestedIpAllocations = requestedIpAllocations;
            return this;
        }

        /**
         * Total number of IPs in a IpAddressPool format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param totalIps New value for the property.
         */
        public Builder setTotalIps(java.lang.Long totalIps) {
            this.totalIps = totalIps;
            return this;
        }

        public PolicyPoolUsage build() {
            PolicyPoolUsage result = new PolicyPoolUsage();
            result.setAllocatedIpAllocations(this.allocatedIpAllocations);
            result.setAvailableIps(this.availableIps);
            result.setRequestedIpAllocations(this.requestedIpAllocations);
            result.setTotalIps(this.totalIps);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("allocated_ip_allocations", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allocated_ip_allocations",
                                                                                "allocatedIpAllocations",
                                                                                "getAllocatedIpAllocations",
                                                                                "setAllocatedIpAllocations");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("available_ips", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("available_ips",
                                                                                "availableIps",
                                                                                "getAvailableIps",
                                                                                "setAvailableIps");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("requested_ip_allocations", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("requested_ip_allocations",
                                                                                "requestedIpAllocations",
                                                                                "getRequestedIpAllocations",
                                                                                "setRequestedIpAllocations");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("total_ips", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("total_ips",
                                                                                "totalIps",
                                                                                "getTotalIps",
                                                                                "setTotalIps");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.policy_pool_usage",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.PolicyPoolUsage.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

