/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Contains realized state of the segment port. For example: transport node on
 * which the port is located, discovered and realized address bindings of the port.
 */
public final class SegmentPortState implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private com.vmware.nsx_global_policy.model.SegmentPortAttachmentState attachment;

    private java.util.List<com.vmware.nsx_global_policy.model.AddressBindingEntry> discoveredBindings;

    private java.util.List<com.vmware.nsx_global_policy.model.DuplicateAddressBindingEntry> duplicateBindings;

    private java.util.List<com.vmware.nsx_global_policy.model.AddressBindingEntry> realizedBindings;

    private java.util.List<java.lang.String> transportNodeIds;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SegmentPortState() {
    }

    protected SegmentPortState(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.SegmentPortAttachmentState getAttachment() {
        return this.attachment;
    }

    /**
     *
     *
     * @param attachment New value for the property.
     */
    public void setAttachment(com.vmware.nsx_global_policy.model.SegmentPortAttachmentState attachment) {
        this.attachment = attachment;
    }

    /**
     * Contains the list of address bindings for a segment port that were automatically
     * dicovered using various snooping methods like ARP, DHCP etc.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.AddressBindingEntry> getDiscoveredBindings() {
        return this.discoveredBindings;
    }

    /**
     * Contains the list of address bindings for a segment port that were automatically
     * dicovered using various snooping methods like ARP, DHCP etc.
     *
     * @param discoveredBindings New value for the property.
     */
    public void setDiscoveredBindings(java.util.List<com.vmware.nsx_global_policy.model.AddressBindingEntry> discoveredBindings) {
        this.discoveredBindings = discoveredBindings;
    }

    /**
     * If any address binding discovered on the port is also found on other port on the
     * same segment, then it is included in the duplicate bindings list along with the
     * ID of the port with which it conflicts.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.DuplicateAddressBindingEntry> getDuplicateBindings() {
        return this.duplicateBindings;
    }

    /**
     * If any address binding discovered on the port is also found on other port on the
     * same segment, then it is included in the duplicate bindings list along with the
     * ID of the port with which it conflicts.
     *
     * @param duplicateBindings New value for the property.
     */
    public void setDuplicateBindings(java.util.List<com.vmware.nsx_global_policy.model.DuplicateAddressBindingEntry> duplicateBindings) {
        this.duplicateBindings = duplicateBindings;
    }

    /**
     * List of segment port bindings that are realized. This list may be populated from
     * the discovered bindings or manual user specified bindings. This binding
     * configuration can be used by features such as firewall, spoof-guard, traceflow
     * etc.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.AddressBindingEntry> getRealizedBindings() {
        return this.realizedBindings;
    }

    /**
     * List of segment port bindings that are realized. This list may be populated from
     * the discovered bindings or manual user specified bindings. This binding
     * configuration can be used by features such as firewall, spoof-guard, traceflow
     * etc.
     *
     * @param realizedBindings New value for the property.
     */
    public void setRealizedBindings(java.util.List<com.vmware.nsx_global_policy.model.AddressBindingEntry> realizedBindings) {
        this.realizedBindings = realizedBindings;
    }

    /**
     * Identifiers of the transport nodes where the port is located
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getTransportNodeIds() {
        return this.transportNodeIds;
    }

    /**
     * Identifiers of the transport nodes where the port is located
     *
     * @param transportNodeIds New value for the property.
     */
    public void setTransportNodeIds(java.util.List<java.lang.String> transportNodeIds) {
        this.transportNodeIds = transportNodeIds;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortState;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("attachment",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.attachment, this._getType().getField("attachment")));
        structValue.setField("discovered_bindings",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.discoveredBindings, this._getType().getField("discovered_bindings")));
        structValue.setField("duplicate_bindings",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.duplicateBindings, this._getType().getField("duplicate_bindings")));
        structValue.setField("realized_bindings",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.realizedBindings, this._getType().getField("realized_bindings")));
        structValue.setField("transport_node_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportNodeIds, this._getType().getField("transport_node_ids")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortState;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortState.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SegmentPortState _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SegmentPortState(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SegmentPortState _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SegmentPortState(structValue);
    }

    /**
     * Builder class for {@link SegmentPortState}.
     */
    public static final class Builder {
        private com.vmware.nsx_global_policy.model.SegmentPortAttachmentState attachment;
        private java.util.List<com.vmware.nsx_global_policy.model.AddressBindingEntry> discoveredBindings;
        private java.util.List<com.vmware.nsx_global_policy.model.DuplicateAddressBindingEntry> duplicateBindings;
        private java.util.List<com.vmware.nsx_global_policy.model.AddressBindingEntry> realizedBindings;
        private java.util.List<java.lang.String> transportNodeIds;

        /**
         * Constructor with parameters for the required properties of
         * {@link SegmentPortState}.
         */
        public Builder() {
        }

        /**
         *
         *
         * @param attachment New value for the property.
         */
        public Builder setAttachment(com.vmware.nsx_global_policy.model.SegmentPortAttachmentState attachment) {
            this.attachment = attachment;
            return this;
        }

        /**
         * Contains the list of address bindings for a segment port that were automatically
         * dicovered using various snooping methods like ARP, DHCP etc.
         *
         * @param discoveredBindings New value for the property.
         */
        public Builder setDiscoveredBindings(java.util.List<com.vmware.nsx_global_policy.model.AddressBindingEntry> discoveredBindings) {
            this.discoveredBindings = discoveredBindings;
            return this;
        }

        /**
         * If any address binding discovered on the port is also found on other port on the
         * same segment, then it is included in the duplicate bindings list along with the
         * ID of the port with which it conflicts.
         *
         * @param duplicateBindings New value for the property.
         */
        public Builder setDuplicateBindings(java.util.List<com.vmware.nsx_global_policy.model.DuplicateAddressBindingEntry> duplicateBindings) {
            this.duplicateBindings = duplicateBindings;
            return this;
        }

        /**
         * List of segment port bindings that are realized. This list may be populated from
         * the discovered bindings or manual user specified bindings. This binding
         * configuration can be used by features such as firewall, spoof-guard, traceflow
         * etc.
         *
         * @param realizedBindings New value for the property.
         */
        public Builder setRealizedBindings(java.util.List<com.vmware.nsx_global_policy.model.AddressBindingEntry> realizedBindings) {
            this.realizedBindings = realizedBindings;
            return this;
        }

        /**
         * Identifiers of the transport nodes where the port is located
         *
         * @param transportNodeIds New value for the property.
         */
        public Builder setTransportNodeIds(java.util.List<java.lang.String> transportNodeIds) {
            this.transportNodeIds = transportNodeIds;
            return this;
        }

        public SegmentPortState build() {
            SegmentPortState result = new SegmentPortState();
            result.setAttachment(this.attachment);
            result.setDiscoveredBindings(this.discoveredBindings);
            result.setDuplicateBindings(this.duplicateBindings);
            result.setRealizedBindings(this.realizedBindings);
            result.setTransportNodeIds(this.transportNodeIds);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("attachment", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.segmentPortAttachmentState; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("attachment",
                                                                                "attachment",
                                                                                "getAttachment",
                                                                                "setAttachment");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("discovered_bindings", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.addressBindingEntry; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("discovered_bindings",
                                                                                "discoveredBindings",
                                                                                "getDiscoveredBindings",
                                                                                "setDiscoveredBindings");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("duplicate_bindings", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.duplicateAddressBindingEntry; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("duplicate_bindings",
                                                                                "duplicateBindings",
                                                                                "getDuplicateBindings",
                                                                                "setDuplicateBindings");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("realized_bindings", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.addressBindingEntry; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("realized_bindings",
                                                                                "realizedBindings",
                                                                                "getRealizedBindings",
                                                                                "setRealizedBindings");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_node_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_node_ids",
                                                                                "transportNodeIds",
                                                                                "getTransportNodeIds",
                                                                                "setTransportNodeIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.segment_port_state",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.SegmentPortState.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

