/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Source Field Evaluation represents an evaluation on resource fields. A source
 * field evaluation will be evaluated against an Event Source which is of type
 * Resource Operation. For instance, the attribute constraint could be related to
 * the necessity that one of the source fields equals one of the specified values.
 */
public final class SourceFieldEvaluation implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "SourceFieldEvaluation";

    public static final java.lang.String OPERATOR_EQ = "EQ";

    public static final java.lang.String OPERATOR_NOT_EQ = "NOT_EQ";

    private java.util.List<java.lang.String> expected;

    private java.lang.String fieldPointer;

    private java.lang.String operator;

    private final java.lang.String resourceType = "SourceFieldEvaluation";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SourceFieldEvaluation() {
    }

    protected SourceFieldEvaluation(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Expected values necessary to apply the specified operation on the source field
     * value.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getExpected() {
        return this.expected;
    }

    /**
     * Expected values necessary to apply the specified operation on the source field
     * value.
     *
     * @param expected New value for the property.
     */
    public void setExpected(java.util.List<java.lang.String> expected) {
        this.expected = expected;
    }

    /**
     * Field in the form of a pointer, describing the location of the attribute within
     * the source of the event.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFieldPointer() {
        return this.fieldPointer;
    }

    /**
     * Field in the form of a pointer, describing the location of the attribute within
     * the source of the event.
     *
     * @param fieldPointer New value for the property.
     */
    public void setFieldPointer(java.lang.String fieldPointer) {
        this.fieldPointer = fieldPointer;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.SourceFieldEvaluation#OPERATOR_EQ}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.SourceFieldEvaluation#OPERATOR_NOT_EQ}</li>
     * </ul> Logical operator.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOperator() {
        return this.operator;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.SourceFieldEvaluation#OPERATOR_EQ}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.SourceFieldEvaluation#OPERATOR_NOT_EQ}</li>
     * </ul> Logical operator.
     *
     * @param operator New value for the property.
     */
    public void setOperator(java.lang.String operator) {
        this.operator = operator;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.Evaluation#RESOURCE_TYPE_SOURCEFIELDEVALUATION}</li>
     * </ul> Criterion Evaluation resource type.
     * The value of this property is automatically populated to {@code "SourceFieldEvaluation"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.sourceFieldEvaluation;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("expected",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.expected, this._getType().getField("expected")));
        structValue.setField("field_pointer",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fieldPointer, this._getType().getField("field_pointer")));
        structValue.setField("operator",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.operator, this._getType().getField("operator")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.sourceFieldEvaluation;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.sourceFieldEvaluation.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SourceFieldEvaluation _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SourceFieldEvaluation(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SourceFieldEvaluation _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SourceFieldEvaluation(structValue);
    }

    /**
     * Builder class for {@link SourceFieldEvaluation}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> expected;
        private java.lang.String fieldPointer;
        private java.lang.String operator;

        /**
         * Constructor with parameters for the required properties of
         * {@link SourceFieldEvaluation}.
         */
        public Builder() {
        }

        /**
         * Expected values necessary to apply the specified operation on the source field
         * value.
         *
         * @param expected New value for the property.
         */
        public Builder setExpected(java.util.List<java.lang.String> expected) {
            this.expected = expected;
            return this;
        }

        /**
         * Field in the form of a pointer, describing the location of the attribute within
         * the source of the event.
         *
         * @param fieldPointer New value for the property.
         */
        public Builder setFieldPointer(java.lang.String fieldPointer) {
            this.fieldPointer = fieldPointer;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.SourceFieldEvaluation#OPERATOR_EQ}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.SourceFieldEvaluation#OPERATOR_NOT_EQ}</li>
         * </ul> Logical operator.
         *
         * @param operator New value for the property.
         */
        public Builder setOperator(java.lang.String operator) {
            this.operator = operator;
            return this;
        }

        public SourceFieldEvaluation build() {
            SourceFieldEvaluation result = new SourceFieldEvaluation();
            result.setExpected(this.expected);
            result.setFieldPointer(this.fieldPointer);
            result.setOperator(this.operator);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("expected", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("expected",
                                                                                "expected",
                                                                                "getExpected",
                                                                                "setExpected");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("field_pointer", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("field_pointer",
                                                                                "fieldPointer",
                                                                                "getFieldPointer",
                                                                                "setFieldPointer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("operator", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("operator",
                                                                                "operator",
                                                                                "getOperator",
                                                                                "setOperator");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.source_field_evaluation",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.SourceFieldEvaluation.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "SourceFieldEvaluation");
    }
}

