/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface Alarms extends com.vmware.vapi.bindings.Service, com.vmware.nsx.AlarmsTypes {

    /**
     * Returns alarm associated with alarm-id. If HTTP status 404 is returned, this
     * means the specified alarm-id is invalid or the alarm with alarm-id has been
     * deleted. An alarm is deleted by the system if it is RESOLVED and older than
     * eight days. The system can also delete the remaining RESOLVED alarms sooner to
     * free system resources when too many alarms are being generated. When this
     * happens the oldest day's RESOLVED alarms are deleted first.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param alarmId (required)
     * @return com.vmware.nsx.model.Alarm
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.Alarm get(java.lang.String alarmId);

    /**
     * Returns alarm associated with alarm-id. If HTTP status 404 is returned, this
     * means the specified alarm-id is invalid or the alarm with alarm-id has been
     * deleted. An alarm is deleted by the system if it is RESOLVED and older than
     * eight days. The system can also delete the remaining RESOLVED alarms sooner to
     * free system resources when too many alarms are being generated. When this
     * happens the oldest day's RESOLVED alarms are deleted first.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param alarmId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.Alarm
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.Alarm get(java.lang.String alarmId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns alarm associated with alarm-id. If HTTP status 404 is returned, this
     * means the specified alarm-id is invalid or the alarm with alarm-id has been
     * deleted. An alarm is deleted by the system if it is RESOLVED and older than
     * eight days. The system can also delete the remaining RESOLVED alarms sooner to
     * free system resources when too many alarms are being generated. When this
     * happens the oldest day's RESOLVED alarms are deleted first.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Alarm
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param alarmId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String alarmId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Alarm> asyncCallback);

    /**
     * Returns alarm associated with alarm-id. If HTTP status 404 is returned, this
     * means the specified alarm-id is invalid or the alarm with alarm-id has been
     * deleted. An alarm is deleted by the system if it is RESOLVED and older than
     * eight days. The system can also delete the remaining RESOLVED alarms sooner to
     * free system resources when too many alarms are being generated. When this
     * happens the oldest day's RESOLVED alarms are deleted first.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Alarm
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param alarmId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String alarmId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Alarm> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns a list of all Alarms currently known to the system.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param after Timestamp in milliseconds since epoch (optional)
     * @param before Timestamp in milliseconds since epoch (optional)
     * @param cursor Cursor for pagination (optional)
     * @param eventTag Event tag (optional)
     * @param eventType Event Type Filter (optional)
     * @param featureName Feature Name (optional)
     * @param id Alarm ID (optional)
     * @param intentPath Intent Path for entity ID (optional)
     * @param nodeId Node ID (optional)
     * @param nodeResourceType Node Resource Type (optional)
     * @param org Org ID (optional)
     * @param pageSize Page Size for pagination (optional)
     * @param project Project ID (optional)
     * @param severity Severity (optional)
     * @param sortAscending Represents order of sorting the values (optional, default to true)
     * @param sortBy Key for sorting on this column (optional)
     * @param status Status (optional)
     * @param vpc VPC ID (optional)
     * @return com.vmware.nsx.model.AlarmsListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.AlarmsListResult list(java.lang.Long after, java.lang.Long before, java.lang.String cursor, java.lang.String eventTag, java.lang.String eventType, java.lang.String featureName, java.lang.String id, java.lang.String intentPath, java.lang.String nodeId, java.lang.String nodeResourceType, java.lang.String org, java.lang.Long pageSize, java.lang.String project, java.lang.String severity, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String status, java.lang.String vpc);

    /**
     * Returns a list of all Alarms currently known to the system.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param after Timestamp in milliseconds since epoch (optional)
     * @param before Timestamp in milliseconds since epoch (optional)
     * @param cursor Cursor for pagination (optional)
     * @param eventTag Event tag (optional)
     * @param eventType Event Type Filter (optional)
     * @param featureName Feature Name (optional)
     * @param id Alarm ID (optional)
     * @param intentPath Intent Path for entity ID (optional)
     * @param nodeId Node ID (optional)
     * @param nodeResourceType Node Resource Type (optional)
     * @param org Org ID (optional)
     * @param pageSize Page Size for pagination (optional)
     * @param project Project ID (optional)
     * @param severity Severity (optional)
     * @param sortAscending Represents order of sorting the values (optional, default to true)
     * @param sortBy Key for sorting on this column (optional)
     * @param status Status (optional)
     * @param vpc VPC ID (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.AlarmsListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.AlarmsListResult list(java.lang.Long after, java.lang.Long before, java.lang.String cursor, java.lang.String eventTag, java.lang.String eventType, java.lang.String featureName, java.lang.String id, java.lang.String intentPath, java.lang.String nodeId, java.lang.String nodeResourceType, java.lang.String org, java.lang.Long pageSize, java.lang.String project, java.lang.String severity, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String status, java.lang.String vpc, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns a list of all Alarms currently known to the system.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.AlarmsListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param after Timestamp in milliseconds since epoch (optional)
     * @param before Timestamp in milliseconds since epoch (optional)
     * @param cursor Cursor for pagination (optional)
     * @param eventTag Event tag (optional)
     * @param eventType Event Type Filter (optional)
     * @param featureName Feature Name (optional)
     * @param id Alarm ID (optional)
     * @param intentPath Intent Path for entity ID (optional)
     * @param nodeId Node ID (optional)
     * @param nodeResourceType Node Resource Type (optional)
     * @param org Org ID (optional)
     * @param pageSize Page Size for pagination (optional)
     * @param project Project ID (optional)
     * @param severity Severity (optional)
     * @param sortAscending Represents order of sorting the values (optional, default to true)
     * @param sortBy Key for sorting on this column (optional)
     * @param status Status (optional)
     * @param vpc VPC ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.Long after, java.lang.Long before, java.lang.String cursor, java.lang.String eventTag, java.lang.String eventType, java.lang.String featureName, java.lang.String id, java.lang.String intentPath, java.lang.String nodeId, java.lang.String nodeResourceType, java.lang.String org, java.lang.Long pageSize, java.lang.String project, java.lang.String severity, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String status, java.lang.String vpc, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.AlarmsListResult> asyncCallback);

    /**
     * Returns a list of all Alarms currently known to the system.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.AlarmsListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param after Timestamp in milliseconds since epoch (optional)
     * @param before Timestamp in milliseconds since epoch (optional)
     * @param cursor Cursor for pagination (optional)
     * @param eventTag Event tag (optional)
     * @param eventType Event Type Filter (optional)
     * @param featureName Feature Name (optional)
     * @param id Alarm ID (optional)
     * @param intentPath Intent Path for entity ID (optional)
     * @param nodeId Node ID (optional)
     * @param nodeResourceType Node Resource Type (optional)
     * @param org Org ID (optional)
     * @param pageSize Page Size for pagination (optional)
     * @param project Project ID (optional)
     * @param severity Severity (optional)
     * @param sortAscending Represents order of sorting the values (optional, default to true)
     * @param sortBy Key for sorting on this column (optional)
     * @param status Status (optional)
     * @param vpc VPC ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.Long after, java.lang.Long before, java.lang.String cursor, java.lang.String eventTag, java.lang.String eventType, java.lang.String featureName, java.lang.String id, java.lang.String intentPath, java.lang.String nodeId, java.lang.String nodeResourceType, java.lang.String org, java.lang.Long pageSize, java.lang.String project, java.lang.String severity, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String status, java.lang.String vpc, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.AlarmsListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update status of an Alarm. The new_status value can be OPEN, ACKNOWLEDGED,
     * SUPPRESSED, or RESOLVED. If new_status is SUPPRESSED, the suppress_duration
     * query parameter must also be specified.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param alarmId (required)
     * @param newStatus Status (required)
     * @param suppressDuration Duration in hours for which Alarm should be suppressed (optional)
     * @return com.vmware.nsx.model.Alarm
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.Alarm setstatus(java.lang.String alarmId, java.lang.String newStatus, java.lang.Long suppressDuration);

    /**
     * Update status of an Alarm. The new_status value can be OPEN, ACKNOWLEDGED,
     * SUPPRESSED, or RESOLVED. If new_status is SUPPRESSED, the suppress_duration
     * query parameter must also be specified.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param alarmId (required)
     * @param newStatus Status (required)
     * @param suppressDuration Duration in hours for which Alarm should be suppressed (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.Alarm
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.Alarm setstatus(java.lang.String alarmId, java.lang.String newStatus, java.lang.Long suppressDuration, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update status of an Alarm. The new_status value can be OPEN, ACKNOWLEDGED,
     * SUPPRESSED, or RESOLVED. If new_status is SUPPRESSED, the suppress_duration
     * query parameter must also be specified.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Alarm
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param alarmId (required)
     * @param newStatus Status (required)
     * @param suppressDuration Duration in hours for which Alarm should be suppressed (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void setstatus(java.lang.String alarmId, java.lang.String newStatus, java.lang.Long suppressDuration, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Alarm> asyncCallback);

    /**
     * Update status of an Alarm. The new_status value can be OPEN, ACKNOWLEDGED,
     * SUPPRESSED, or RESOLVED. If new_status is SUPPRESSED, the suppress_duration
     * query parameter must also be specified.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Alarm
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param alarmId (required)
     * @param newStatus Status (required)
     * @param suppressDuration Duration in hours for which Alarm should be suppressed (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void setstatus(java.lang.String alarmId, java.lang.String newStatus, java.lang.Long suppressDuration, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Alarm> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Bulk update the status of zero or more Alarms that match the specified filters.
     * The new_status value can be OPEN, ACKNOWLEDGED, SUPPRESSED, or RESOLVED. If
     * new_status is SUPPRESSED, the suppress_duration query parameter must also be
     * specified.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param newStatus Status (required)
     * @param after Timestamp in milliseconds since epoch (optional)
     * @param before Timestamp in milliseconds since epoch (optional)
     * @param cursor Cursor for pagination (optional)
     * @param eventTag Event tag (optional)
     * @param eventType Event Type Filter (optional)
     * @param featureName Feature Name (optional)
     * @param id Alarm ID (optional)
     * @param intentPath Intent Path for entity ID (optional)
     * @param nodeId Node ID (optional)
     * @param nodeResourceType Node Resource Type (optional)
     * @param org Org ID (optional)
     * @param pageSize Page Size for pagination (optional)
     * @param project Project ID (optional)
     * @param severity Severity (optional)
     * @param sortAscending Represents order of sorting the values (optional, default to true)
     * @param sortBy Key for sorting on this column (optional)
     * @param status Status (optional)
     * @param suppressDuration Duration in hours for which Alarm should be suppressed (optional)
     * @param vpc VPC ID (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void setstatus0(java.lang.String newStatus, java.lang.Long after, java.lang.Long before, java.lang.String cursor, java.lang.String eventTag, java.lang.String eventType, java.lang.String featureName, java.lang.String id, java.lang.String intentPath, java.lang.String nodeId, java.lang.String nodeResourceType, java.lang.String org, java.lang.Long pageSize, java.lang.String project, java.lang.String severity, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String status, java.lang.Long suppressDuration, java.lang.String vpc);

    /**
     * Bulk update the status of zero or more Alarms that match the specified filters.
     * The new_status value can be OPEN, ACKNOWLEDGED, SUPPRESSED, or RESOLVED. If
     * new_status is SUPPRESSED, the suppress_duration query parameter must also be
     * specified.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param newStatus Status (required)
     * @param after Timestamp in milliseconds since epoch (optional)
     * @param before Timestamp in milliseconds since epoch (optional)
     * @param cursor Cursor for pagination (optional)
     * @param eventTag Event tag (optional)
     * @param eventType Event Type Filter (optional)
     * @param featureName Feature Name (optional)
     * @param id Alarm ID (optional)
     * @param intentPath Intent Path for entity ID (optional)
     * @param nodeId Node ID (optional)
     * @param nodeResourceType Node Resource Type (optional)
     * @param org Org ID (optional)
     * @param pageSize Page Size for pagination (optional)
     * @param project Project ID (optional)
     * @param severity Severity (optional)
     * @param sortAscending Represents order of sorting the values (optional, default to true)
     * @param sortBy Key for sorting on this column (optional)
     * @param status Status (optional)
     * @param suppressDuration Duration in hours for which Alarm should be suppressed (optional)
     * @param vpc VPC ID (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void setstatus0(java.lang.String newStatus, java.lang.Long after, java.lang.Long before, java.lang.String cursor, java.lang.String eventTag, java.lang.String eventType, java.lang.String featureName, java.lang.String id, java.lang.String intentPath, java.lang.String nodeId, java.lang.String nodeResourceType, java.lang.String org, java.lang.Long pageSize, java.lang.String project, java.lang.String severity, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String status, java.lang.Long suppressDuration, java.lang.String vpc, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Bulk update the status of zero or more Alarms that match the specified filters.
     * The new_status value can be OPEN, ACKNOWLEDGED, SUPPRESSED, or RESOLVED. If
     * new_status is SUPPRESSED, the suppress_duration query parameter must also be
     * specified.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param newStatus Status (required)
     * @param after Timestamp in milliseconds since epoch (optional)
     * @param before Timestamp in milliseconds since epoch (optional)
     * @param cursor Cursor for pagination (optional)
     * @param eventTag Event tag (optional)
     * @param eventType Event Type Filter (optional)
     * @param featureName Feature Name (optional)
     * @param id Alarm ID (optional)
     * @param intentPath Intent Path for entity ID (optional)
     * @param nodeId Node ID (optional)
     * @param nodeResourceType Node Resource Type (optional)
     * @param org Org ID (optional)
     * @param pageSize Page Size for pagination (optional)
     * @param project Project ID (optional)
     * @param severity Severity (optional)
     * @param sortAscending Represents order of sorting the values (optional, default to true)
     * @param sortBy Key for sorting on this column (optional)
     * @param status Status (optional)
     * @param suppressDuration Duration in hours for which Alarm should be suppressed (optional)
     * @param vpc VPC ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void setstatus0(java.lang.String newStatus, java.lang.Long after, java.lang.Long before, java.lang.String cursor, java.lang.String eventTag, java.lang.String eventType, java.lang.String featureName, java.lang.String id, java.lang.String intentPath, java.lang.String nodeId, java.lang.String nodeResourceType, java.lang.String org, java.lang.Long pageSize, java.lang.String project, java.lang.String severity, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String status, java.lang.Long suppressDuration, java.lang.String vpc, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Bulk update the status of zero or more Alarms that match the specified filters.
     * The new_status value can be OPEN, ACKNOWLEDGED, SUPPRESSED, or RESOLVED. If
     * new_status is SUPPRESSED, the suppress_duration query parameter must also be
     * specified.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param newStatus Status (required)
     * @param after Timestamp in milliseconds since epoch (optional)
     * @param before Timestamp in milliseconds since epoch (optional)
     * @param cursor Cursor for pagination (optional)
     * @param eventTag Event tag (optional)
     * @param eventType Event Type Filter (optional)
     * @param featureName Feature Name (optional)
     * @param id Alarm ID (optional)
     * @param intentPath Intent Path for entity ID (optional)
     * @param nodeId Node ID (optional)
     * @param nodeResourceType Node Resource Type (optional)
     * @param org Org ID (optional)
     * @param pageSize Page Size for pagination (optional)
     * @param project Project ID (optional)
     * @param severity Severity (optional)
     * @param sortAscending Represents order of sorting the values (optional, default to true)
     * @param sortBy Key for sorting on this column (optional)
     * @param status Status (optional)
     * @param suppressDuration Duration in hours for which Alarm should be suppressed (optional)
     * @param vpc VPC ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void setstatus0(java.lang.String newStatus, java.lang.Long after, java.lang.Long before, java.lang.String cursor, java.lang.String eventTag, java.lang.String eventType, java.lang.String featureName, java.lang.String id, java.lang.String intentPath, java.lang.String nodeId, java.lang.String nodeResourceType, java.lang.String org, java.lang.Long pageSize, java.lang.String project, java.lang.String severity, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String status, java.lang.Long suppressDuration, java.lang.String vpc, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
