/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface GlobalConfigs extends com.vmware.vapi.bindings.Service, com.vmware.nsx.GlobalConfigsTypes {

    /**
     * Returns global configurations that belong to the config type. This rest routine
     * is deprecated, and will be removed after a year. <br/> <br/> Use the following
     * Policy APIs for different global configs - <br/> OperationCollectorGlobalConfig
     * GET /policy/api/v1/infra/ops-global-config <br/> RoutingGlobalConfig GET
     * /policy/api/v1/infra/connectivity-global-config <br/> SecurityGlobalConfig GET
     * /policy/api/v1/infra/security-global-config <br/> IdsGlobalConfig GET
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig GET policy/api/v1/infra/settings/firewall/security
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param configType (required)
     * @return com.vmware.nsx.model.GlobalConfigs
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.vapi.bindings.Structure get(java.lang.String configType);

    /**
     * Returns global configurations that belong to the config type. This rest routine
     * is deprecated, and will be removed after a year. <br/> <br/> Use the following
     * Policy APIs for different global configs - <br/> OperationCollectorGlobalConfig
     * GET /policy/api/v1/infra/ops-global-config <br/> RoutingGlobalConfig GET
     * /policy/api/v1/infra/connectivity-global-config <br/> SecurityGlobalConfig GET
     * /policy/api/v1/infra/security-global-config <br/> IdsGlobalConfig GET
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig GET policy/api/v1/infra/settings/firewall/security
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param configType (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.GlobalConfigs
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.vapi.bindings.Structure get(java.lang.String configType, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns global configurations that belong to the config type. This rest routine
     * is deprecated, and will be removed after a year. <br/> <br/> Use the following
     * Policy APIs for different global configs - <br/> OperationCollectorGlobalConfig
     * GET /policy/api/v1/infra/ops-global-config <br/> RoutingGlobalConfig GET
     * /policy/api/v1/infra/connectivity-global-config <br/> SecurityGlobalConfig GET
     * /policy/api/v1/infra/security-global-config <br/> IdsGlobalConfig GET
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig GET policy/api/v1/infra/settings/firewall/security
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.GlobalConfigs
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param configType (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String configType, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Returns global configurations that belong to the config type. This rest routine
     * is deprecated, and will be removed after a year. <br/> <br/> Use the following
     * Policy APIs for different global configs - <br/> OperationCollectorGlobalConfig
     * GET /policy/api/v1/infra/ops-global-config <br/> RoutingGlobalConfig GET
     * /policy/api/v1/infra/connectivity-global-config <br/> SecurityGlobalConfig GET
     * /policy/api/v1/infra/security-global-config <br/> IdsGlobalConfig GET
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig GET policy/api/v1/infra/settings/firewall/security
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.GlobalConfigs
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param configType (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String configType, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns global configurations of a NSX domain grouped by the config types. These
     * global configurations are valid across NSX domain for their respective types
     * unless they are overridden by a more granular configurations. This rest routine
     * is deprecated, and will be removed after a year. <br/> <br/> The list API is
     * disaggregated to feature verticals. <br/> Use the following Policy APIs for
     * different global configs - <br/> OperationCollectorGlobalConfig GET
     * /policy/api/v1/infra/ops-global-config <br/> RoutingGlobalConfig GET
     * /policy/api/v1/infra/connectivity-global-config <br/> SecurityGlobalConfig GET
     * /policy/api/v1/infra/security-global-config <br/> IdsGlobalConfig GET
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig GET policy/api/v1/infra/settings/firewall/security
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.GlobalConfigsListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.GlobalConfigsListResult list();

    /**
     * Returns global configurations of a NSX domain grouped by the config types. These
     * global configurations are valid across NSX domain for their respective types
     * unless they are overridden by a more granular configurations. This rest routine
     * is deprecated, and will be removed after a year. <br/> <br/> The list API is
     * disaggregated to feature verticals. <br/> Use the following Policy APIs for
     * different global configs - <br/> OperationCollectorGlobalConfig GET
     * /policy/api/v1/infra/ops-global-config <br/> RoutingGlobalConfig GET
     * /policy/api/v1/infra/connectivity-global-config <br/> SecurityGlobalConfig GET
     * /policy/api/v1/infra/security-global-config <br/> IdsGlobalConfig GET
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig GET policy/api/v1/infra/settings/firewall/security
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.GlobalConfigsListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.GlobalConfigsListResult list(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns global configurations of a NSX domain grouped by the config types. These
     * global configurations are valid across NSX domain for their respective types
     * unless they are overridden by a more granular configurations. This rest routine
     * is deprecated, and will be removed after a year. <br/> <br/> The list API is
     * disaggregated to feature verticals. <br/> Use the following Policy APIs for
     * different global configs - <br/> OperationCollectorGlobalConfig GET
     * /policy/api/v1/infra/ops-global-config <br/> RoutingGlobalConfig GET
     * /policy/api/v1/infra/connectivity-global-config <br/> SecurityGlobalConfig GET
     * /policy/api/v1/infra/security-global-config <br/> IdsGlobalConfig GET
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig GET policy/api/v1/infra/settings/firewall/security
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.GlobalConfigsListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.GlobalConfigsListResult> asyncCallback);

    /**
     * Returns global configurations of a NSX domain grouped by the config types. These
     * global configurations are valid across NSX domain for their respective types
     * unless they are overridden by a more granular configurations. This rest routine
     * is deprecated, and will be removed after a year. <br/> <br/> The list API is
     * disaggregated to feature verticals. <br/> Use the following Policy APIs for
     * different global configs - <br/> OperationCollectorGlobalConfig GET
     * /policy/api/v1/infra/ops-global-config <br/> RoutingGlobalConfig GET
     * /policy/api/v1/infra/connectivity-global-config <br/> SecurityGlobalConfig GET
     * /policy/api/v1/infra/security-global-config <br/> IdsGlobalConfig GET
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig GET /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig GET policy/api/v1/infra/settings/firewall/security
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.GlobalConfigsListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.GlobalConfigsListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * It is similar to update global configurations but this request would trigger
     * update even if the configs are unmodified. However, the realization of the new
     * configurations is config-type specific. Refer to config-type specific
     * documentation for details about the configuration push state. This rest routine
     * is deprecated, and will be removed after a year. <br/> <br/> Use the following
     * Policy APIs for different global configs - <br/> OperationCollectorGlobalConfig
     * PUT /policy/api/v1/infra/ops-global-config <br/> RoutingGlobalConfig PUT
     * /policy/api/v1/infra/connectivity-global-config <br/> SecurityGlobalConfig PUT
     * /policy/api/v1/infra/security-global-config <br/> IdsGlobalConfig PUT
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig PUT /policy/api/v1/infra/settings/firewall/security
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param configType (required)
     * @param globalConfigs (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @return com.vmware.nsx.model.GlobalConfigs
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.vapi.bindings.Structure resyncconfig(java.lang.String configType, com.vmware.vapi.bindings.Structure globalConfigs);

    /**
     * It is similar to update global configurations but this request would trigger
     * update even if the configs are unmodified. However, the realization of the new
     * configurations is config-type specific. Refer to config-type specific
     * documentation for details about the configuration push state. This rest routine
     * is deprecated, and will be removed after a year. <br/> <br/> Use the following
     * Policy APIs for different global configs - <br/> OperationCollectorGlobalConfig
     * PUT /policy/api/v1/infra/ops-global-config <br/> RoutingGlobalConfig PUT
     * /policy/api/v1/infra/connectivity-global-config <br/> SecurityGlobalConfig PUT
     * /policy/api/v1/infra/security-global-config <br/> IdsGlobalConfig PUT
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig PUT /policy/api/v1/infra/settings/firewall/security
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param configType (required)
     * @param globalConfigs (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.GlobalConfigs
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.vapi.bindings.Structure resyncconfig(java.lang.String configType, com.vmware.vapi.bindings.Structure globalConfigs, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * It is similar to update global configurations but this request would trigger
     * update even if the configs are unmodified. However, the realization of the new
     * configurations is config-type specific. Refer to config-type specific
     * documentation for details about the configuration push state. This rest routine
     * is deprecated, and will be removed after a year. <br/> <br/> Use the following
     * Policy APIs for different global configs - <br/> OperationCollectorGlobalConfig
     * PUT /policy/api/v1/infra/ops-global-config <br/> RoutingGlobalConfig PUT
     * /policy/api/v1/infra/connectivity-global-config <br/> SecurityGlobalConfig PUT
     * /policy/api/v1/infra/security-global-config <br/> IdsGlobalConfig PUT
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig PUT /policy/api/v1/infra/settings/firewall/security
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.GlobalConfigs
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param configType (required)
     * @param globalConfigs (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void resyncconfig(java.lang.String configType, com.vmware.vapi.bindings.Structure globalConfigs, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * It is similar to update global configurations but this request would trigger
     * update even if the configs are unmodified. However, the realization of the new
     * configurations is config-type specific. Refer to config-type specific
     * documentation for details about the configuration push state. This rest routine
     * is deprecated, and will be removed after a year. <br/> <br/> Use the following
     * Policy APIs for different global configs - <br/> OperationCollectorGlobalConfig
     * PUT /policy/api/v1/infra/ops-global-config <br/> RoutingGlobalConfig PUT
     * /policy/api/v1/infra/connectivity-global-config <br/> SecurityGlobalConfig PUT
     * /policy/api/v1/infra/security-global-config <br/> IdsGlobalConfig PUT
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig PUT /policy/api/v1/infra/settings/firewall/security
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.GlobalConfigs
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param configType (required)
     * @param globalConfigs (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void resyncconfig(java.lang.String configType, com.vmware.vapi.bindings.Structure globalConfigs, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Updates global configurations that belong to a config type. The request must
     * include the updated values along with the unmodified values. The values that are
     * updated(different) would trigger update to config-type specific state. However,
     * the realization of the new configurations is config-type specific. Refer to
     * config-type specific documentation for details about the config- uration push
     * state. This rest routine is deprecated, and will be removed after a year. <br/>
     * <br/> Use the following Policy APIs for different global configs - <br/>
     * OperationCollectorGlobalConfig PUT /policy/api/v1/infra/ops-global-config <br/>
     * RoutingGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * SecurityGlobalConfig PUT /policy/api/v1/infra/security-global-config <br/>
     * IdsGlobalConfig PUT
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig PUT /policy/api/v1/infra/settings/firewall/security
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param configType (required)
     * @param globalConfigs (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @return com.vmware.nsx.model.GlobalConfigs
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.vapi.bindings.Structure update(java.lang.String configType, com.vmware.vapi.bindings.Structure globalConfigs);

    /**
     * Updates global configurations that belong to a config type. The request must
     * include the updated values along with the unmodified values. The values that are
     * updated(different) would trigger update to config-type specific state. However,
     * the realization of the new configurations is config-type specific. Refer to
     * config-type specific documentation for details about the config- uration push
     * state. This rest routine is deprecated, and will be removed after a year. <br/>
     * <br/> Use the following Policy APIs for different global configs - <br/>
     * OperationCollectorGlobalConfig PUT /policy/api/v1/infra/ops-global-config <br/>
     * RoutingGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * SecurityGlobalConfig PUT /policy/api/v1/infra/security-global-config <br/>
     * IdsGlobalConfig PUT
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig PUT /policy/api/v1/infra/settings/firewall/security
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param configType (required)
     * @param globalConfigs (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.GlobalConfigs
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.vapi.bindings.Structure update(java.lang.String configType, com.vmware.vapi.bindings.Structure globalConfigs, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Updates global configurations that belong to a config type. The request must
     * include the updated values along with the unmodified values. The values that are
     * updated(different) would trigger update to config-type specific state. However,
     * the realization of the new configurations is config-type specific. Refer to
     * config-type specific documentation for details about the config- uration push
     * state. This rest routine is deprecated, and will be removed after a year. <br/>
     * <br/> Use the following Policy APIs for different global configs - <br/>
     * OperationCollectorGlobalConfig PUT /policy/api/v1/infra/ops-global-config <br/>
     * RoutingGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * SecurityGlobalConfig PUT /policy/api/v1/infra/security-global-config <br/>
     * IdsGlobalConfig PUT
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig PUT /policy/api/v1/infra/settings/firewall/security
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.GlobalConfigs
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param configType (required)
     * @param globalConfigs (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String configType, com.vmware.vapi.bindings.Structure globalConfigs, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Updates global configurations that belong to a config type. The request must
     * include the updated values along with the unmodified values. The values that are
     * updated(different) would trigger update to config-type specific state. However,
     * the realization of the new configurations is config-type specific. Refer to
     * config-type specific documentation for details about the config- uration push
     * state. This rest routine is deprecated, and will be removed after a year. <br/>
     * <br/> Use the following Policy APIs for different global configs - <br/>
     * OperationCollectorGlobalConfig PUT /policy/api/v1/infra/ops-global-config <br/>
     * RoutingGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * SecurityGlobalConfig PUT /policy/api/v1/infra/security-global-config <br/>
     * IdsGlobalConfig PUT
     * /policy/api/v1/infra/settings/firewall/security/intrusion-services <br/>
     * FipsGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * SwitchingGlobalConfig PUT /policy/api/v1/infra/connectivity-global-config <br/>
     * FirewallGlobalConfig PUT /policy/api/v1/infra/settings/firewall/security
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.GlobalConfigs
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param configType (required)
     * @param globalConfigs (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.GlobalConfigs}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String configType, com.vmware.vapi.bindings.Structure globalConfigs, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
