/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface HostSwitchProfiles extends com.vmware.vapi.bindings.Service, com.vmware.nsx.HostSwitchProfilesTypes {

    /**
     * Creates a hostswitch profile. The resource_type is required. For uplink
     * profiles, the teaming and policy parameters are required. By default, the mtu is
     * 1600 and the transport_vlan is 0. The supported MTU range is 1280 through
     * (uplink_mtu_threshold). (uplink_mtu_threshold) is 9000 by default. Range can be
     * extended by modifying (uplink_mtu_threshold) in SwitchingGlobalConfig to the
     * required upper threshold. <br/> This api is now deprecated. Please use new api -
     * PUT policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param baseHostSwitchProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @return com.vmware.nsx.model.BaseHostSwitchProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure create(com.vmware.vapi.bindings.Structure baseHostSwitchProfile);

    /**
     * Creates a hostswitch profile. The resource_type is required. For uplink
     * profiles, the teaming and policy parameters are required. By default, the mtu is
     * 1600 and the transport_vlan is 0. The supported MTU range is 1280 through
     * (uplink_mtu_threshold). (uplink_mtu_threshold) is 9000 by default. Range can be
     * extended by modifying (uplink_mtu_threshold) in SwitchingGlobalConfig to the
     * required upper threshold. <br/> This api is now deprecated. Please use new api -
     * PUT policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param baseHostSwitchProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BaseHostSwitchProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure create(com.vmware.vapi.bindings.Structure baseHostSwitchProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a hostswitch profile. The resource_type is required. For uplink
     * profiles, the teaming and policy parameters are required. By default, the mtu is
     * 1600 and the transport_vlan is 0. The supported MTU range is 1280 through
     * (uplink_mtu_threshold). (uplink_mtu_threshold) is 9000 by default. Range can be
     * extended by modifying (uplink_mtu_threshold) in SwitchingGlobalConfig to the
     * required upper threshold. <br/> This api is now deprecated. Please use new api -
     * PUT policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseHostSwitchProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param baseHostSwitchProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.vapi.bindings.Structure baseHostSwitchProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Creates a hostswitch profile. The resource_type is required. For uplink
     * profiles, the teaming and policy parameters are required. By default, the mtu is
     * 1600 and the transport_vlan is 0. The supported MTU range is 1280 through
     * (uplink_mtu_threshold). (uplink_mtu_threshold) is 9000 by default. Range can be
     * extended by modifying (uplink_mtu_threshold) in SwitchingGlobalConfig to the
     * required upper threshold. <br/> This api is now deprecated. Please use new api -
     * PUT policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseHostSwitchProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param baseHostSwitchProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.vapi.bindings.Structure baseHostSwitchProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes a specified hostswitch profile. <br/> This api is now deprecated. Please
     * use new api - DELETE policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param hostSwitchProfileId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String hostSwitchProfileId);

    /**
     * Deletes a specified hostswitch profile. <br/> This api is now deprecated. Please
     * use new api - DELETE policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param hostSwitchProfileId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String hostSwitchProfileId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes a specified hostswitch profile. <br/> This api is now deprecated. Please
     * use new api - DELETE policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param hostSwitchProfileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String hostSwitchProfileId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes a specified hostswitch profile. <br/> This api is now deprecated. Please
     * use new api - DELETE policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param hostSwitchProfileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String hostSwitchProfileId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about a specified hostswitch profile. <br/> This api is now
     * deprecated. Please use new api -
     * policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param hostSwitchProfileId (required)
     * @return com.vmware.nsx.model.BaseHostSwitchProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure get(java.lang.String hostSwitchProfileId);

    /**
     * Returns information about a specified hostswitch profile. <br/> This api is now
     * deprecated. Please use new api -
     * policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param hostSwitchProfileId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BaseHostSwitchProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure get(java.lang.String hostSwitchProfileId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about a specified hostswitch profile. <br/> This api is now
     * deprecated. Please use new api -
     * policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseHostSwitchProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param hostSwitchProfileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String hostSwitchProfileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Returns information about a specified hostswitch profile. <br/> This api is now
     * deprecated. Please use new api -
     * policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseHostSwitchProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param hostSwitchProfileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String hostSwitchProfileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about the configured hostswitch profiles. Hostswitch
     * profiles define networking policies for hostswitches (sometimes referred to as
     * bridges in OVS). Currently, only uplink teaming is supported. Uplink teaming
     * allows NSX to load balance traffic across different physical NICs (PNICs) on the
     * hypervisor hosts. Multiple teaming policies are supported, including LACP
     * active, LACP passive, load balancing based on source ID, and failover order.
     * <br/> This api is now deprecated. Please use new api -
     * policy/api/v1/infra/host-switch-profiles
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param deploymentType Supported edge deployment type. (optional)
     * @param hostswitchProfileType Supported HostSwitch profiles. (optional)
     * @param includeSystemOwned Whether the list result contains system resources (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeType Fabric node type for which uplink profiles are to be listed (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param uplinkTeamingPolicyName The host switch profile's uplink teaming policy name (optional)
     * @return com.vmware.nsx.model.HostSwitchProfilesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.HostSwitchProfilesListResult list(java.lang.String cursor, java.lang.String deploymentType, java.lang.String hostswitchProfileType, java.lang.Boolean includeSystemOwned, java.lang.String includedFields, java.lang.String nodeType, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String uplinkTeamingPolicyName);

    /**
     * Returns information about the configured hostswitch profiles. Hostswitch
     * profiles define networking policies for hostswitches (sometimes referred to as
     * bridges in OVS). Currently, only uplink teaming is supported. Uplink teaming
     * allows NSX to load balance traffic across different physical NICs (PNICs) on the
     * hypervisor hosts. Multiple teaming policies are supported, including LACP
     * active, LACP passive, load balancing based on source ID, and failover order.
     * <br/> This api is now deprecated. Please use new api -
     * policy/api/v1/infra/host-switch-profiles
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param deploymentType Supported edge deployment type. (optional)
     * @param hostswitchProfileType Supported HostSwitch profiles. (optional)
     * @param includeSystemOwned Whether the list result contains system resources (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeType Fabric node type for which uplink profiles are to be listed (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param uplinkTeamingPolicyName The host switch profile's uplink teaming policy name (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.HostSwitchProfilesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.HostSwitchProfilesListResult list(java.lang.String cursor, java.lang.String deploymentType, java.lang.String hostswitchProfileType, java.lang.Boolean includeSystemOwned, java.lang.String includedFields, java.lang.String nodeType, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String uplinkTeamingPolicyName, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the configured hostswitch profiles. Hostswitch
     * profiles define networking policies for hostswitches (sometimes referred to as
     * bridges in OVS). Currently, only uplink teaming is supported. Uplink teaming
     * allows NSX to load balance traffic across different physical NICs (PNICs) on the
     * hypervisor hosts. Multiple teaming policies are supported, including LACP
     * active, LACP passive, load balancing based on source ID, and failover order.
     * <br/> This api is now deprecated. Please use new api -
     * policy/api/v1/infra/host-switch-profiles
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.HostSwitchProfilesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param deploymentType Supported edge deployment type. (optional)
     * @param hostswitchProfileType Supported HostSwitch profiles. (optional)
     * @param includeSystemOwned Whether the list result contains system resources (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeType Fabric node type for which uplink profiles are to be listed (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param uplinkTeamingPolicyName The host switch profile's uplink teaming policy name (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String deploymentType, java.lang.String hostswitchProfileType, java.lang.Boolean includeSystemOwned, java.lang.String includedFields, java.lang.String nodeType, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String uplinkTeamingPolicyName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.HostSwitchProfilesListResult> asyncCallback);

    /**
     * Returns information about the configured hostswitch profiles. Hostswitch
     * profiles define networking policies for hostswitches (sometimes referred to as
     * bridges in OVS). Currently, only uplink teaming is supported. Uplink teaming
     * allows NSX to load balance traffic across different physical NICs (PNICs) on the
     * hypervisor hosts. Multiple teaming policies are supported, including LACP
     * active, LACP passive, load balancing based on source ID, and failover order.
     * <br/> This api is now deprecated. Please use new api -
     * policy/api/v1/infra/host-switch-profiles
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.HostSwitchProfilesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param deploymentType Supported edge deployment type. (optional)
     * @param hostswitchProfileType Supported HostSwitch profiles. (optional)
     * @param includeSystemOwned Whether the list result contains system resources (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeType Fabric node type for which uplink profiles are to be listed (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param uplinkTeamingPolicyName The host switch profile's uplink teaming policy name (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String deploymentType, java.lang.String hostswitchProfileType, java.lang.Boolean includeSystemOwned, java.lang.String includedFields, java.lang.String nodeType, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String uplinkTeamingPolicyName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.HostSwitchProfilesListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies a specified hostswitch profile. The body of the PUT request must
     * include the resource_type. For uplink profiles, the put request must also
     * include teaming parameters. Modifiable attributes include display_name, mtu, and
     * transport_vlan. For uplink teaming policies, uplink_name and policy are also
     * modifiable. <br/> This api is now deprecated. Please use new api - PATCH
     * policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param hostSwitchProfileId (required)
     * @param baseHostSwitchProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @return com.vmware.nsx.model.BaseHostSwitchProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure update(java.lang.String hostSwitchProfileId, com.vmware.vapi.bindings.Structure baseHostSwitchProfile);

    /**
     * Modifies a specified hostswitch profile. The body of the PUT request must
     * include the resource_type. For uplink profiles, the put request must also
     * include teaming parameters. Modifiable attributes include display_name, mtu, and
     * transport_vlan. For uplink teaming policies, uplink_name and policy are also
     * modifiable. <br/> This api is now deprecated. Please use new api - PATCH
     * policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param hostSwitchProfileId (required)
     * @param baseHostSwitchProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BaseHostSwitchProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure update(java.lang.String hostSwitchProfileId, com.vmware.vapi.bindings.Structure baseHostSwitchProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies a specified hostswitch profile. The body of the PUT request must
     * include the resource_type. For uplink profiles, the put request must also
     * include teaming parameters. Modifiable attributes include display_name, mtu, and
     * transport_vlan. For uplink teaming policies, uplink_name and policy are also
     * modifiable. <br/> This api is now deprecated. Please use new api - PATCH
     * policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseHostSwitchProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param hostSwitchProfileId (required)
     * @param baseHostSwitchProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String hostSwitchProfileId, com.vmware.vapi.bindings.Structure baseHostSwitchProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Modifies a specified hostswitch profile. The body of the PUT request must
     * include the resource_type. For uplink profiles, the put request must also
     * include teaming parameters. Modifiable attributes include display_name, mtu, and
     * transport_vlan. For uplink teaming policies, uplink_name and policy are also
     * modifiable. <br/> This api is now deprecated. Please use new api - PATCH
     * policy/api/v1/infra/host-switch-profiles/uplinkProfile1
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseHostSwitchProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param hostSwitchProfileId (required)
     * @param baseHostSwitchProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseHostSwitchProfile}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String hostSwitchProfileId, com.vmware.vapi.bindings.Structure baseHostSwitchProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
