/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface Normalizations extends com.vmware.vapi.bindings.Service, com.vmware.nsx.NormalizationsTypes {

    /**
     * Returns the list of normalized resources based on the query parameters. Id and
     * Type of the resource on which the normalizations is to be performed, are to be
     * specified as query parameters in the URI. The target resource types to which
     * normalization is to be done should also be specified as query parameter. <br/>
     * This API has been deprecated, please use below effective membership APIs <br/>
     * GET /ns-groups/<ns-group-id>/effective-logical-switch-members GET
     * /ns-groups/<ns-group-id>/effective-logical-port-members GET
     * /ns-groups/<ns-group-id>/effective-ip-address-members GET
     * /ns-groups/<ns-group-id>/effective-vif-members GET
     * /ns-groups/<ns-group-id>/effective-transport-node-members GET
     * /ns-groups/<ns-group-id>/effective-virtual-machine-members GET
     * /ns-groups/<ns-group-id>/effective-cloud-native-service-instance-members GET
     * /ns-groups/<ns-group-id>/effective-physical-server-members GET
     * /ns-groups/<ns-group-id>/effective-directory-group-members GET
     * /ns-groups/<ns-group-id>/effective-ipset-members
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param preferredNormalizationType Resource type valid for use as target in normalization API. (required)
     * @param resourceId Identifier of the resource on which normalization is to be performed (required)
     * @param resourceType Resource type valid for use as source in normalization API. (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.NormalizedResourceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.NormalizedResourceListResult list(java.lang.String preferredNormalizationType, java.lang.String resourceId, java.lang.String resourceType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns the list of normalized resources based on the query parameters. Id and
     * Type of the resource on which the normalizations is to be performed, are to be
     * specified as query parameters in the URI. The target resource types to which
     * normalization is to be done should also be specified as query parameter. <br/>
     * This API has been deprecated, please use below effective membership APIs <br/>
     * GET /ns-groups/<ns-group-id>/effective-logical-switch-members GET
     * /ns-groups/<ns-group-id>/effective-logical-port-members GET
     * /ns-groups/<ns-group-id>/effective-ip-address-members GET
     * /ns-groups/<ns-group-id>/effective-vif-members GET
     * /ns-groups/<ns-group-id>/effective-transport-node-members GET
     * /ns-groups/<ns-group-id>/effective-virtual-machine-members GET
     * /ns-groups/<ns-group-id>/effective-cloud-native-service-instance-members GET
     * /ns-groups/<ns-group-id>/effective-physical-server-members GET
     * /ns-groups/<ns-group-id>/effective-directory-group-members GET
     * /ns-groups/<ns-group-id>/effective-ipset-members
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param preferredNormalizationType Resource type valid for use as target in normalization API. (required)
     * @param resourceId Identifier of the resource on which normalization is to be performed (required)
     * @param resourceType Resource type valid for use as source in normalization API. (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NormalizedResourceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.NormalizedResourceListResult list(java.lang.String preferredNormalizationType, java.lang.String resourceId, java.lang.String resourceType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the list of normalized resources based on the query parameters. Id and
     * Type of the resource on which the normalizations is to be performed, are to be
     * specified as query parameters in the URI. The target resource types to which
     * normalization is to be done should also be specified as query parameter. <br/>
     * This API has been deprecated, please use below effective membership APIs <br/>
     * GET /ns-groups/<ns-group-id>/effective-logical-switch-members GET
     * /ns-groups/<ns-group-id>/effective-logical-port-members GET
     * /ns-groups/<ns-group-id>/effective-ip-address-members GET
     * /ns-groups/<ns-group-id>/effective-vif-members GET
     * /ns-groups/<ns-group-id>/effective-transport-node-members GET
     * /ns-groups/<ns-group-id>/effective-virtual-machine-members GET
     * /ns-groups/<ns-group-id>/effective-cloud-native-service-instance-members GET
     * /ns-groups/<ns-group-id>/effective-physical-server-members GET
     * /ns-groups/<ns-group-id>/effective-directory-group-members GET
     * /ns-groups/<ns-group-id>/effective-ipset-members
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NormalizedResourceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param preferredNormalizationType Resource type valid for use as target in normalization API. (required)
     * @param resourceId Identifier of the resource on which normalization is to be performed (required)
     * @param resourceType Resource type valid for use as source in normalization API. (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String preferredNormalizationType, java.lang.String resourceId, java.lang.String resourceType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NormalizedResourceListResult> asyncCallback);

    /**
     * Returns the list of normalized resources based on the query parameters. Id and
     * Type of the resource on which the normalizations is to be performed, are to be
     * specified as query parameters in the URI. The target resource types to which
     * normalization is to be done should also be specified as query parameter. <br/>
     * This API has been deprecated, please use below effective membership APIs <br/>
     * GET /ns-groups/<ns-group-id>/effective-logical-switch-members GET
     * /ns-groups/<ns-group-id>/effective-logical-port-members GET
     * /ns-groups/<ns-group-id>/effective-ip-address-members GET
     * /ns-groups/<ns-group-id>/effective-vif-members GET
     * /ns-groups/<ns-group-id>/effective-transport-node-members GET
     * /ns-groups/<ns-group-id>/effective-virtual-machine-members GET
     * /ns-groups/<ns-group-id>/effective-cloud-native-service-instance-members GET
     * /ns-groups/<ns-group-id>/effective-physical-server-members GET
     * /ns-groups/<ns-group-id>/effective-directory-group-members GET
     * /ns-groups/<ns-group-id>/effective-ipset-members
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NormalizedResourceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param preferredNormalizationType Resource type valid for use as target in normalization API. (required)
     * @param resourceId Identifier of the resource on which normalization is to be performed (required)
     * @param resourceType Resource type valid for use as source in normalization API. (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String preferredNormalizationType, java.lang.String resourceId, java.lang.String resourceType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NormalizedResourceListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
