
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx;

/**
 * {@link NsxFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class NsxFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private NsxFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link NsxFactory} factory instance
     */
    public static NsxFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        NsxFactory instance = new NsxFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Alarms}
     */
    public com.vmware.nsx.Alarms alarmsService() {
        return this.stubFactory.createStub(Alarms.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Associations}
     */
    public com.vmware.nsx.Associations associationsService() {
        return this.stubFactory.createStub(Associations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.AutomaticHealthCheckToggle}
     */
    public com.vmware.nsx.AutomaticHealthCheckToggle automaticHealthCheckToggleService() {
        return this.stubFactory.createStub(AutomaticHealthCheckToggle.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.AutomaticHealthChecks}
     */
    public com.vmware.nsx.AutomaticHealthChecks automaticHealthChecksService() {
        return this.stubFactory.createStub(AutomaticHealthChecks.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Batch}
     */
    public com.vmware.nsx.Batch batchService() {
        return this.stubFactory.createStub(Batch.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.BridgeEndpointProfiles}
     */
    public com.vmware.nsx.BridgeEndpointProfiles bridgeEndpointProfilesService() {
        return this.stubFactory.createStub(BridgeEndpointProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.BridgeEndpoints}
     */
    public com.vmware.nsx.BridgeEndpoints bridgeEndpointsService() {
        return this.stubFactory.createStub(BridgeEndpoints.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Cluster}
     */
    public com.vmware.nsx.Cluster clusterService() {
        return this.stubFactory.createStub(Cluster.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.ClusterProfiles}
     */
    public com.vmware.nsx.ClusterProfiles clusterProfilesService() {
        return this.stubFactory.createStub(ClusterProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.EdgeClusters}
     */
    public com.vmware.nsx.EdgeClusters edgeClustersService() {
        return this.stubFactory.createStub(EdgeClusters.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.ErrorResolver}
     */
    public com.vmware.nsx.ErrorResolver errorResolverService() {
        return this.stubFactory.createStub(ErrorResolver.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Events}
     */
    public com.vmware.nsx.Events eventsService() {
        return this.stubFactory.createStub(Events.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.FailureDomains}
     */
    public com.vmware.nsx.FailureDomains failureDomainsService() {
        return this.stubFactory.createStub(FailureDomains.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.GlobalConfigs}
     */
    public com.vmware.nsx.GlobalConfigs globalConfigsService() {
        return this.stubFactory.createStub(GlobalConfigs.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.HostSwitchProfiles}
     */
    public com.vmware.nsx.HostSwitchProfiles hostSwitchProfilesService() {
        return this.stubFactory.createStub(HostSwitchProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.IpSets}
     */
    public com.vmware.nsx.IpSets ipSetsService() {
        return this.stubFactory.createStub(IpSets.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.IpfixCollectorProfiles}
     */
    public com.vmware.nsx.IpfixCollectorProfiles ipfixCollectorProfilesService() {
        return this.stubFactory.createStub(IpfixCollectorProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.IpfixProfiles}
     */
    public com.vmware.nsx.IpfixProfiles ipfixProfilesService() {
        return this.stubFactory.createStub(IpfixProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.LatencyProfiles}
     */
    public com.vmware.nsx.LatencyProfiles latencyProfilesService() {
        return this.stubFactory.createStub(LatencyProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Licenses}
     */
    public com.vmware.nsx.Licenses licensesService() {
        return this.stubFactory.createStub(Licenses.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Livetraces}
     */
    public com.vmware.nsx.Livetraces livetracesService() {
        return this.stubFactory.createStub(Livetraces.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.LogicalPorts}
     */
    public com.vmware.nsx.LogicalPorts logicalPortsService() {
        return this.stubFactory.createStub(LogicalPorts.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.LogicalRouterPorts}
     */
    public com.vmware.nsx.LogicalRouterPorts logicalRouterPortsService() {
        return this.stubFactory.createStub(LogicalRouterPorts.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.LogicalRouters}
     */
    public com.vmware.nsx.LogicalRouters logicalRoutersService() {
        return this.stubFactory.createStub(LogicalRouters.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.LogicalSwitches}
     */
    public com.vmware.nsx.LogicalSwitches logicalSwitchesService() {
        return this.stubFactory.createStub(LogicalSwitches.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.MacSets}
     */
    public com.vmware.nsx.MacSets macSetsService() {
        return this.stubFactory.createStub(MacSets.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.ManualHealthChecks}
     */
    public com.vmware.nsx.ManualHealthChecks manualHealthChecksService() {
        return this.stubFactory.createStub(ManualHealthChecks.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.MdProxies}
     */
    public com.vmware.nsx.MdProxies mdProxiesService() {
        return this.stubFactory.createStub(MdProxies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Migration}
     */
    public com.vmware.nsx.Migration migrationService() {
        return this.stubFactory.createStub(Migration.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.MirrorSessions}
     */
    public com.vmware.nsx.MirrorSessions mirrorSessionsService() {
        return this.stubFactory.createStub(MirrorSessions.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Node}
     */
    public com.vmware.nsx.Node nodeService() {
        return this.stubFactory.createStub(Node.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Normalizations}
     */
    public com.vmware.nsx.Normalizations normalizationsService() {
        return this.stubFactory.createStub(Normalizations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.NotificationWatchers}
     */
    public com.vmware.nsx.NotificationWatchers notificationWatchersService() {
        return this.stubFactory.createStub(NotificationWatchers.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.NsGroups}
     */
    public com.vmware.nsx.NsGroups nsGroupsService() {
        return this.stubFactory.createStub(NsGroups.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.NsProfiles}
     */
    public com.vmware.nsx.NsProfiles nsProfilesService() {
        return this.stubFactory.createStub(NsProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.NsServiceGroups}
     */
    public com.vmware.nsx.NsServiceGroups nsServiceGroupsService() {
        return this.stubFactory.createStub(NsServiceGroups.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.NsServices}
     */
    public com.vmware.nsx.NsServices nsServicesService() {
        return this.stubFactory.createStub(NsServices.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.NvdsUrt}
     */
    public com.vmware.nsx.NvdsUrt nvdsUrtService() {
        return this.stubFactory.createStub(NvdsUrt.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.ServiceConfigs}
     */
    public com.vmware.nsx.ServiceConfigs serviceConfigsService() {
        return this.stubFactory.createStub(ServiceConfigs.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Sites}
     */
    public com.vmware.nsx.Sites sitesService() {
        return this.stubFactory.createStub(Sites.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.SwitchingProfiles}
     */
    public com.vmware.nsx.SwitchingProfiles switchingProfilesService() {
        return this.stubFactory.createStub(SwitchingProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Tasks}
     */
    public com.vmware.nsx.Tasks tasksService() {
        return this.stubFactory.createStub(Tasks.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Traceflows}
     */
    public com.vmware.nsx.Traceflows traceflowsService() {
        return this.stubFactory.createStub(Traceflows.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.TransportNodeCollections}
     */
    public com.vmware.nsx.TransportNodeCollections transportNodeCollectionsService() {
        return this.stubFactory.createStub(TransportNodeCollections.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.TransportNodeProfiles}
     */
    public com.vmware.nsx.TransportNodeProfiles transportNodeProfilesService() {
        return this.stubFactory.createStub(TransportNodeProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.TransportNodes}
     */
    public com.vmware.nsx.TransportNodes transportNodesService() {
        return this.stubFactory.createStub(TransportNodes.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.TransportZones}
     */
    public com.vmware.nsx.TransportZones transportZonesService() {
        return this.stubFactory.createStub(TransportZones.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.TransportzoneProfiles}
     */
    public com.vmware.nsx.TransportzoneProfiles transportzoneProfilesService() {
        return this.stubFactory.createStub(TransportzoneProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.TrustManagement}
     */
    public com.vmware.nsx.TrustManagement trustManagementService() {
        return this.stubFactory.createStub(TrustManagement.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.UiViews}
     */
    public com.vmware.nsx.UiViews uiViewsService() {
        return this.stubFactory.createStub(UiViews.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.Upgrade}
     */
    public com.vmware.nsx.Upgrade upgradeService() {
        return this.stubFactory.createStub(Upgrade.class, this.stubConfig);
    }

    public com.vmware.nsx.aaa.AaaFactory aaa() {
        return com.vmware.nsx.aaa.AaaFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.administration.AdministrationFactory administration() {
        return com.vmware.nsx.administration.AdministrationFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.automatic_health_checks.AutomaticHealthChecksFactory automaticHealthChecks() {
        return com.vmware.nsx.automatic_health_checks.AutomaticHealthChecksFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.bridge_endpoints.BridgeEndpointsFactory bridgeEndpoints() {
        return com.vmware.nsx.bridge_endpoints.BridgeEndpointsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.capacity.CapacityFactory capacity() {
        return com.vmware.nsx.capacity.CapacityFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.cluster.ClusterFactory cluster() {
        return com.vmware.nsx.cluster.ClusterFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.configs.ConfigsFactory configs() {
        return com.vmware.nsx.configs.ConfigsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.dhcp.DhcpFactory dhcp() {
        return com.vmware.nsx.dhcp.DhcpFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.directory.DirectoryFactory directory() {
        return com.vmware.nsx.directory.DirectoryFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.dns.DnsFactory dns() {
        return com.vmware.nsx.dns.DnsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.edge_clusters.EdgeClustersFactory edgeClusters() {
        return com.vmware.nsx.edge_clusters.EdgeClustersFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.eula.EulaFactory eula() {
        return com.vmware.nsx.eula.EulaFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.fabric.FabricFactory fabric() {
        return com.vmware.nsx.fabric.FabricFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.firewall.FirewallFactory firewall() {
        return com.vmware.nsx.firewall.FirewallFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.hpm.HpmFactory hpm() {
        return com.vmware.nsx.hpm.HpmFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.idfw.IdfwFactory idfw() {
        return com.vmware.nsx.idfw.IdfwFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.intelligence.IntelligenceFactory intelligence() {
        return com.vmware.nsx.intelligence.IntelligenceFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.intrusion_services.IntrusionServicesFactory intrusionServices() {
        return com.vmware.nsx.intrusion_services.IntrusionServicesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.ip_sets.IpSetsFactory ipSets() {
        return com.vmware.nsx.ip_sets.IpSetsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.ipfix.IpfixFactory ipfix() {
        return com.vmware.nsx.ipfix.IpfixFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.ipv6.Ipv6Factory ipv6() {
        return com.vmware.nsx.ipv6.Ipv6Factory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.licenses.LicensesFactory licenses() {
        return com.vmware.nsx.licenses.LicensesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.livetraces.LivetracesFactory livetraces() {
        return com.vmware.nsx.livetraces.LivetracesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.loadbalancer.LoadbalancerFactory loadbalancer() {
        return com.vmware.nsx.loadbalancer.LoadbalancerFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.logical_ports.LogicalPortsFactory logicalPorts() {
        return com.vmware.nsx.logical_ports.LogicalPortsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.logical_router_ports.LogicalRouterPortsFactory logicalRouterPorts() {
        return com.vmware.nsx.logical_router_ports.LogicalRouterPortsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.logical_routers.LogicalRoutersFactory logicalRouters() {
        return com.vmware.nsx.logical_routers.LogicalRoutersFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.logical_switches.LogicalSwitchesFactory logicalSwitches() {
        return com.vmware.nsx.logical_switches.LogicalSwitchesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.mac_sets.MacSetsFactory macSets() {
        return com.vmware.nsx.mac_sets.MacSetsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.md_proxies.MdProxiesFactory mdProxies() {
        return com.vmware.nsx.md_proxies.MdProxiesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.migration.MigrationFactory migration() {
        return com.vmware.nsx.migration.MigrationFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.mirror_sessions.MirrorSessionsFactory mirrorSessions() {
        return com.vmware.nsx.mirror_sessions.MirrorSessionsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.model.ModelFactory model() {
        return com.vmware.nsx.model.ModelFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.node.NodeFactory node() {
        return com.vmware.nsx.node.NodeFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.notification_watchers.NotificationWatchersFactory notificationWatchers() {
        return com.vmware.nsx.notification_watchers.NotificationWatchersFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.ns_groups.NsGroupsFactory nsGroups() {
        return com.vmware.nsx.ns_groups.NsGroupsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.ns_profiles.NsProfilesFactory nsProfiles() {
        return com.vmware.nsx.ns_profiles.NsProfilesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.nvds_urt.NvdsUrtFactory nvdsUrt() {
        return com.vmware.nsx.nvds_urt.NvdsUrtFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.pktcap.PktcapFactory pktcap() {
        return com.vmware.nsx.pktcap.PktcapFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.pools.PoolsFactory pools() {
        return com.vmware.nsx.pools.PoolsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.proxy.ProxyFactory proxy() {
        return com.vmware.nsx.proxy.ProxyFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.realization_state_barrier.RealizationStateBarrierFactory realizationStateBarrier() {
        return com.vmware.nsx.realization_state_barrier.RealizationStateBarrierFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.repository.RepositoryFactory repository() {
        return com.vmware.nsx.repository.RepositoryFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.search.SearchFactory search() {
        return com.vmware.nsx.search.SearchFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.service_configs.ServiceConfigsFactory serviceConfigs() {
        return com.vmware.nsx.service_configs.ServiceConfigsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.serviceinsertion.ServiceinsertionFactory serviceinsertion() {
        return com.vmware.nsx.serviceinsertion.ServiceinsertionFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.sites.SitesFactory sites() {
        return com.vmware.nsx.sites.SitesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.switching_profiles.SwitchingProfilesFactory switchingProfiles() {
        return com.vmware.nsx.switching_profiles.SwitchingProfilesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.systemhealth.SystemhealthFactory systemhealth() {
        return com.vmware.nsx.systemhealth.SystemhealthFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.tasks.TasksFactory tasks() {
        return com.vmware.nsx.tasks.TasksFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.telemetry.TelemetryFactory telemetry() {
        return com.vmware.nsx.telemetry.TelemetryFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.traceflows.TraceflowsFactory traceflows() {
        return com.vmware.nsx.traceflows.TraceflowsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.transport_node_collections.TransportNodeCollectionsFactory transportNodeCollections() {
        return com.vmware.nsx.transport_node_collections.TransportNodeCollectionsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.transport_nodes.TransportNodesFactory transportNodes() {
        return com.vmware.nsx.transport_nodes.TransportNodesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.transport_zones.TransportZonesFactory transportZones() {
        return com.vmware.nsx.transport_zones.TransportZonesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.trust_management.TrustManagementFactory trustManagement() {
        return com.vmware.nsx.trust_management.TrustManagementFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.ui_views.UiViewsFactory uiViews() {
        return com.vmware.nsx.ui_views.UiViewsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.upgrade.UpgradeFactory upgrade() {
        return com.vmware.nsx.upgrade.UpgradeFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
