/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface SwitchingProfiles extends com.vmware.vapi.bindings.Service, com.vmware.nsx.SwitchingProfilesTypes {

    /**
     * Creates a new, custom qos, port-mirroring, spoof-guard or port-security
     * switching profile. You can override their default switching profile assignments
     * by creating a new switching profile and assigning it to one or more logical
     * switches. You cannot override the default ipfix or ip_discovery switching
     * profiles. <br/> This api is now deprecated. Please use new api - For eg. for QOS
     * profile, please use - PUT /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param baseSwitchingProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @return com.vmware.nsx.model.BaseSwitchingProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure create(com.vmware.vapi.bindings.Structure baseSwitchingProfile);

    /**
     * Creates a new, custom qos, port-mirroring, spoof-guard or port-security
     * switching profile. You can override their default switching profile assignments
     * by creating a new switching profile and assigning it to one or more logical
     * switches. You cannot override the default ipfix or ip_discovery switching
     * profiles. <br/> This api is now deprecated. Please use new api - For eg. for QOS
     * profile, please use - PUT /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param baseSwitchingProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BaseSwitchingProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure create(com.vmware.vapi.bindings.Structure baseSwitchingProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a new, custom qos, port-mirroring, spoof-guard or port-security
     * switching profile. You can override their default switching profile assignments
     * by creating a new switching profile and assigning it to one or more logical
     * switches. You cannot override the default ipfix or ip_discovery switching
     * profiles. <br/> This api is now deprecated. Please use new api - For eg. for QOS
     * profile, please use - PUT /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseSwitchingProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param baseSwitchingProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.vapi.bindings.Structure baseSwitchingProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Creates a new, custom qos, port-mirroring, spoof-guard or port-security
     * switching profile. You can override their default switching profile assignments
     * by creating a new switching profile and assigning it to one or more logical
     * switches. You cannot override the default ipfix or ip_discovery switching
     * profiles. <br/> This api is now deprecated. Please use new api - For eg. for QOS
     * profile, please use - PUT /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseSwitchingProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param baseSwitchingProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.vapi.bindings.Structure baseSwitchingProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes the specified switching profile. <br/> This api is now deprecated. Use
     * new api - for QOS profile, please use - DELETE
     * /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param switchingProfileId (required)
     * @param unbind force unbinding of logical switches and ports from a switching profile
     * (optional, default to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String switchingProfileId, java.lang.Boolean unbind);

    /**
     * Deletes the specified switching profile. <br/> This api is now deprecated. Use
     * new api - for QOS profile, please use - DELETE
     * /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param switchingProfileId (required)
     * @param unbind force unbinding of logical switches and ports from a switching profile
     * (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String switchingProfileId, java.lang.Boolean unbind, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes the specified switching profile. <br/> This api is now deprecated. Use
     * new api - for QOS profile, please use - DELETE
     * /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param switchingProfileId (required)
     * @param unbind force unbinding of logical switches and ports from a switching profile
     * (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String switchingProfileId, java.lang.Boolean unbind, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes the specified switching profile. <br/> This api is now deprecated. Use
     * new api - for QOS profile, please use - DELETE
     * /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param switchingProfileId (required)
     * @param unbind force unbinding of logical switches and ports from a switching profile
     * (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String switchingProfileId, java.lang.Boolean unbind, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about a specified switching profile. <br/> This api is now
     * deprecated. Please use new api - for QOS profile, please use -
     * /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param switchingProfileId (required)
     * @return com.vmware.nsx.model.BaseSwitchingProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure get(java.lang.String switchingProfileId);

    /**
     * Returns information about a specified switching profile. <br/> This api is now
     * deprecated. Please use new api - for QOS profile, please use -
     * /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param switchingProfileId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BaseSwitchingProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure get(java.lang.String switchingProfileId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about a specified switching profile. <br/> This api is now
     * deprecated. Please use new api - for QOS profile, please use -
     * /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseSwitchingProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param switchingProfileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String switchingProfileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Returns information about a specified switching profile. <br/> This api is now
     * deprecated. Please use new api - for QOS profile, please use -
     * /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseSwitchingProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param switchingProfileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String switchingProfileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about the system-default and user-configured switching
     * profiles. Each switching profile has a unique ID, a display name, and various
     * other read-only and configurable properties. The default switching profiles are
     * assigned automatically to each switch. <br/> This api is now deprecated. Please
     * use new api - for QOS profile, please use - /infra/qos-profiles
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeSystemOwned Whether the list result contains system resources (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param switchingProfileType comma-separated list of switching profile types, e.g.
     * ?switching_profile_type=QosSwitchingProfile,IpDiscoverySwitchingProfile
     * (optional)
     * @return com.vmware.nsx.model.SwitchingProfilesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.SwitchingProfilesListResult list(java.lang.String cursor, java.lang.Boolean includeSystemOwned, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String switchingProfileType);

    /**
     * Returns information about the system-default and user-configured switching
     * profiles. Each switching profile has a unique ID, a display name, and various
     * other read-only and configurable properties. The default switching profiles are
     * assigned automatically to each switch. <br/> This api is now deprecated. Please
     * use new api - for QOS profile, please use - /infra/qos-profiles
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeSystemOwned Whether the list result contains system resources (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param switchingProfileType comma-separated list of switching profile types, e.g.
     * ?switching_profile_type=QosSwitchingProfile,IpDiscoverySwitchingProfile
     * (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.SwitchingProfilesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.SwitchingProfilesListResult list(java.lang.String cursor, java.lang.Boolean includeSystemOwned, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String switchingProfileType, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the system-default and user-configured switching
     * profiles. Each switching profile has a unique ID, a display name, and various
     * other read-only and configurable properties. The default switching profiles are
     * assigned automatically to each switch. <br/> This api is now deprecated. Please
     * use new api - for QOS profile, please use - /infra/qos-profiles
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.SwitchingProfilesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeSystemOwned Whether the list result contains system resources (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param switchingProfileType comma-separated list of switching profile types, e.g.
     * ?switching_profile_type=QosSwitchingProfile,IpDiscoverySwitchingProfile
     * (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.Boolean includeSystemOwned, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String switchingProfileType, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.SwitchingProfilesListResult> asyncCallback);

    /**
     * Returns information about the system-default and user-configured switching
     * profiles. Each switching profile has a unique ID, a display name, and various
     * other read-only and configurable properties. The default switching profiles are
     * assigned automatically to each switch. <br/> This api is now deprecated. Please
     * use new api - for QOS profile, please use - /infra/qos-profiles
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.SwitchingProfilesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeSystemOwned Whether the list result contains system resources (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param switchingProfileType comma-separated list of switching profile types, e.g.
     * ?switching_profile_type=QosSwitchingProfile,IpDiscoverySwitchingProfile
     * (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.Boolean includeSystemOwned, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String switchingProfileType, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.SwitchingProfilesListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Updates the user-configurable parameters of a switching profile. Only the qos,
     * port-mirroring, spoof-guard and port-security switching profiles can be
     * modified. You cannot modify the ipfix or ip-discovery switching profiles. <br/>
     * This api is now deprecated. Use new api, for eg., QOS profile - PATCH
     * /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param switchingProfileId (required)
     * @param baseSwitchingProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @return com.vmware.nsx.model.BaseSwitchingProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure update(java.lang.String switchingProfileId, com.vmware.vapi.bindings.Structure baseSwitchingProfile);

    /**
     * Updates the user-configurable parameters of a switching profile. Only the qos,
     * port-mirroring, spoof-guard and port-security switching profiles can be
     * modified. You cannot modify the ipfix or ip-discovery switching profiles. <br/>
     * This api is now deprecated. Use new api, for eg., QOS profile - PATCH
     * /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param switchingProfileId (required)
     * @param baseSwitchingProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BaseSwitchingProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure update(java.lang.String switchingProfileId, com.vmware.vapi.bindings.Structure baseSwitchingProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Updates the user-configurable parameters of a switching profile. Only the qos,
     * port-mirroring, spoof-guard and port-security switching profiles can be
     * modified. You cannot modify the ipfix or ip-discovery switching profiles. <br/>
     * This api is now deprecated. Use new api, for eg., QOS profile - PATCH
     * /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseSwitchingProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param switchingProfileId (required)
     * @param baseSwitchingProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String switchingProfileId, com.vmware.vapi.bindings.Structure baseSwitchingProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Updates the user-configurable parameters of a switching profile. Only the qos,
     * port-mirroring, spoof-guard and port-security switching profiles can be
     * modified. You cannot modify the ipfix or ip-discovery switching profiles. <br/>
     * This api is now deprecated. Use new api, for eg., QOS profile - PATCH
     * /infra/qos-profiles/<qos-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BaseSwitchingProfile
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param switchingProfileId (required)
     * @param baseSwitchingProfile (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.BaseSwitchingProfile}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String switchingProfileId, com.vmware.vapi.bindings.Structure baseSwitchingProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
