/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface TransportNodes extends com.vmware.vapi.bindings.Service, com.vmware.nsx.TransportNodesTypes {

    /**
     * Edge transport node maintains its entry in many internal tables. In some cases a
     * few of these entries might not get cleaned up during edge transport node
     * deletion. This api cleans up any stale entries that may exist in the internal
     * tables that store the Edge Transport Node data.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void cleanstaleentries();

    /**
     * Edge transport node maintains its entry in many internal tables. In some cases a
     * few of these entries might not get cleaned up during edge transport node
     * deletion. This api cleans up any stale entries that may exist in the internal
     * tables that store the Edge Transport Node data.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void cleanstaleentries(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Edge transport node maintains its entry in many internal tables. In some cases a
     * few of these entries might not get cleaned up during edge transport node
     * deletion. This api cleans up any stale entries that may exist in the internal
     * tables that store the Edge Transport Node data.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void cleanstaleentries(com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Edge transport node maintains its entry in many internal tables. In some cases a
     * few of these entries might not get cleaned up during edge transport node
     * deletion. This api cleans up any stale entries that may exist in the internal
     * tables that store the Edge Transport Node data.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void cleanstaleentries(com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Transport nodes are hypervisor hosts and NSX Edges that will participate in an
     * NSX-T overlay. For a hypervisor host, this means that it hosts VMs that will
     * communicate over NSX-T logical switches. For NSX Edges, this means that it will
     * have logical router uplinks and downlinks. This API creates transport node for a
     * host node (hypervisor) or edge node (router) in the transport network. When you
     * run this command for a host, NSX Manager attempts to install the NSX kernel
     * modules, which are packaged as VIB, RPM, or DEB files. For the installation to
     * succeed, you must provide the host login credentials and the host thumbprint. To
     * get the ESXi host thumbprint, SSH to the host and run the <b>openssl x509 -in
     * /etc/vmware/ssl/rui.crt -fingerprint -sha256 -noout</b> command. To generate
     * host key thumbprint using SHA-256 algorithm please follow the steps below. Log
     * into the host, making sure that the connection is not vulnerable to a man in the
     * middle attack. Check whether a public key already exists. Host public key is
     * generally located at '/etc/ssh/ssh_host_rsa_key.pub'. If the key is not present
     * then generate a new key by running the following command and follow the
     * instructions. <b>ssh-keygen -t rsa</b> Now generate a SHA256 hash of the key
     * using the following command. Please make sure to pass the appropriate file name
     * if the public key is stored with a different file name other than the default
     * 'id_rsa.pub'. <b>awk '{print $2}' id_rsa.pub | base64 -d | sha256sum -b | sed
     * 's/ .*$//' | xxd -r -p | base64</b> This api is deprecated as part of FN+TN
     * unification. Please use Transport Node API to install NSX components on a node.
     * Additional documentation on creating a transport node can be found in the NSX-T
     * Installation Guide. In order for the transport node to forward packets, the
     * host_switch_spec property must be specified. Host switches (called bridges in
     * OVS on KVM hypervisors) are the individual switches within the host virtual
     * switch. Virtual machines are connected to the host switches. When creating a
     * transport node, you need to specify if the host switches are already manually
     * preconfigured on the node, or if NSX should create and manage the host switches.
     * You specify this choice by the type of host switches you pass in the
     * host_switch_spec property of the TransportNode request payload. For a KVM host,
     * you can preconfigure the host switch, or you can have NSX Manager perform the
     * configuration. For an ESXi host or NSX Edge node, NSX Manager always configures
     * the host switch. To preconfigure the host switches on a KVM host, pass an array
     * of PreconfiguredHostSwitchSpec objects that describes those host switches. In
     * the current NSX-T release, only one prefonfigured host switch can be specified.
     * See the PreconfiguredHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Preconfigured host switches are only supported
     * on KVM hosts, not on ESXi hosts or NSX Edge nodes. To allow NSX to manage the
     * host switch configuration on KVM hosts, ESXi hosts, or NSX Edge nodes, pass an
     * array of StandardHostSwitchSpec objects in the host_switch_spec property, and
     * NSX will automatically create host switches with the properties you provide. In
     * the current NSX-T release, up to 16 host switches can be automatically managed.
     * See the StandardHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Note: Previous versions of NSX-T also used a
     * property named transport_zone_endpoints at TransportNode level. This property is
     * deprecated which creates some combinations of new client along with old client
     * payloads. Examples [1] & [2] show old/existing client request and response by
     * populating transport_zone_endpoints property at TransportNode level. Example [3]
     * shows TransportNode creation request/response by populating
     * transport_zone_endpoints property at StandardHostSwitch level and other new
     * properties. The request should either provide node_deployement_info or node_id.
     * If the host node (hypervisor) or edge node (router) is already added in system
     * then it can be converted to transport node by providing node_id in request. If
     * host node (hypervisor) or edge node (router) is not already present in system
     * then information should be provided under node_deployment_info. This api is now
     * deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNode (required)
     * @return com.vmware.nsx.model.TransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNode create(com.vmware.nsx.model.TransportNode transportNode);

    /**
     * Transport nodes are hypervisor hosts and NSX Edges that will participate in an
     * NSX-T overlay. For a hypervisor host, this means that it hosts VMs that will
     * communicate over NSX-T logical switches. For NSX Edges, this means that it will
     * have logical router uplinks and downlinks. This API creates transport node for a
     * host node (hypervisor) or edge node (router) in the transport network. When you
     * run this command for a host, NSX Manager attempts to install the NSX kernel
     * modules, which are packaged as VIB, RPM, or DEB files. For the installation to
     * succeed, you must provide the host login credentials and the host thumbprint. To
     * get the ESXi host thumbprint, SSH to the host and run the <b>openssl x509 -in
     * /etc/vmware/ssl/rui.crt -fingerprint -sha256 -noout</b> command. To generate
     * host key thumbprint using SHA-256 algorithm please follow the steps below. Log
     * into the host, making sure that the connection is not vulnerable to a man in the
     * middle attack. Check whether a public key already exists. Host public key is
     * generally located at '/etc/ssh/ssh_host_rsa_key.pub'. If the key is not present
     * then generate a new key by running the following command and follow the
     * instructions. <b>ssh-keygen -t rsa</b> Now generate a SHA256 hash of the key
     * using the following command. Please make sure to pass the appropriate file name
     * if the public key is stored with a different file name other than the default
     * 'id_rsa.pub'. <b>awk '{print $2}' id_rsa.pub | base64 -d | sha256sum -b | sed
     * 's/ .*$//' | xxd -r -p | base64</b> This api is deprecated as part of FN+TN
     * unification. Please use Transport Node API to install NSX components on a node.
     * Additional documentation on creating a transport node can be found in the NSX-T
     * Installation Guide. In order for the transport node to forward packets, the
     * host_switch_spec property must be specified. Host switches (called bridges in
     * OVS on KVM hypervisors) are the individual switches within the host virtual
     * switch. Virtual machines are connected to the host switches. When creating a
     * transport node, you need to specify if the host switches are already manually
     * preconfigured on the node, or if NSX should create and manage the host switches.
     * You specify this choice by the type of host switches you pass in the
     * host_switch_spec property of the TransportNode request payload. For a KVM host,
     * you can preconfigure the host switch, or you can have NSX Manager perform the
     * configuration. For an ESXi host or NSX Edge node, NSX Manager always configures
     * the host switch. To preconfigure the host switches on a KVM host, pass an array
     * of PreconfiguredHostSwitchSpec objects that describes those host switches. In
     * the current NSX-T release, only one prefonfigured host switch can be specified.
     * See the PreconfiguredHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Preconfigured host switches are only supported
     * on KVM hosts, not on ESXi hosts or NSX Edge nodes. To allow NSX to manage the
     * host switch configuration on KVM hosts, ESXi hosts, or NSX Edge nodes, pass an
     * array of StandardHostSwitchSpec objects in the host_switch_spec property, and
     * NSX will automatically create host switches with the properties you provide. In
     * the current NSX-T release, up to 16 host switches can be automatically managed.
     * See the StandardHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Note: Previous versions of NSX-T also used a
     * property named transport_zone_endpoints at TransportNode level. This property is
     * deprecated which creates some combinations of new client along with old client
     * payloads. Examples [1] & [2] show old/existing client request and response by
     * populating transport_zone_endpoints property at TransportNode level. Example [3]
     * shows TransportNode creation request/response by populating
     * transport_zone_endpoints property at StandardHostSwitch level and other new
     * properties. The request should either provide node_deployement_info or node_id.
     * If the host node (hypervisor) or edge node (router) is already added in system
     * then it can be converted to transport node by providing node_id in request. If
     * host node (hypervisor) or edge node (router) is not already present in system
     * then information should be provided under node_deployment_info. This api is now
     * deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNode (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNode create(com.vmware.nsx.model.TransportNode transportNode, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Transport nodes are hypervisor hosts and NSX Edges that will participate in an
     * NSX-T overlay. For a hypervisor host, this means that it hosts VMs that will
     * communicate over NSX-T logical switches. For NSX Edges, this means that it will
     * have logical router uplinks and downlinks. This API creates transport node for a
     * host node (hypervisor) or edge node (router) in the transport network. When you
     * run this command for a host, NSX Manager attempts to install the NSX kernel
     * modules, which are packaged as VIB, RPM, or DEB files. For the installation to
     * succeed, you must provide the host login credentials and the host thumbprint. To
     * get the ESXi host thumbprint, SSH to the host and run the <b>openssl x509 -in
     * /etc/vmware/ssl/rui.crt -fingerprint -sha256 -noout</b> command. To generate
     * host key thumbprint using SHA-256 algorithm please follow the steps below. Log
     * into the host, making sure that the connection is not vulnerable to a man in the
     * middle attack. Check whether a public key already exists. Host public key is
     * generally located at '/etc/ssh/ssh_host_rsa_key.pub'. If the key is not present
     * then generate a new key by running the following command and follow the
     * instructions. <b>ssh-keygen -t rsa</b> Now generate a SHA256 hash of the key
     * using the following command. Please make sure to pass the appropriate file name
     * if the public key is stored with a different file name other than the default
     * 'id_rsa.pub'. <b>awk '{print $2}' id_rsa.pub | base64 -d | sha256sum -b | sed
     * 's/ .*$//' | xxd -r -p | base64</b> This api is deprecated as part of FN+TN
     * unification. Please use Transport Node API to install NSX components on a node.
     * Additional documentation on creating a transport node can be found in the NSX-T
     * Installation Guide. In order for the transport node to forward packets, the
     * host_switch_spec property must be specified. Host switches (called bridges in
     * OVS on KVM hypervisors) are the individual switches within the host virtual
     * switch. Virtual machines are connected to the host switches. When creating a
     * transport node, you need to specify if the host switches are already manually
     * preconfigured on the node, or if NSX should create and manage the host switches.
     * You specify this choice by the type of host switches you pass in the
     * host_switch_spec property of the TransportNode request payload. For a KVM host,
     * you can preconfigure the host switch, or you can have NSX Manager perform the
     * configuration. For an ESXi host or NSX Edge node, NSX Manager always configures
     * the host switch. To preconfigure the host switches on a KVM host, pass an array
     * of PreconfiguredHostSwitchSpec objects that describes those host switches. In
     * the current NSX-T release, only one prefonfigured host switch can be specified.
     * See the PreconfiguredHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Preconfigured host switches are only supported
     * on KVM hosts, not on ESXi hosts or NSX Edge nodes. To allow NSX to manage the
     * host switch configuration on KVM hosts, ESXi hosts, or NSX Edge nodes, pass an
     * array of StandardHostSwitchSpec objects in the host_switch_spec property, and
     * NSX will automatically create host switches with the properties you provide. In
     * the current NSX-T release, up to 16 host switches can be automatically managed.
     * See the StandardHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Note: Previous versions of NSX-T also used a
     * property named transport_zone_endpoints at TransportNode level. This property is
     * deprecated which creates some combinations of new client along with old client
     * payloads. Examples [1] & [2] show old/existing client request and response by
     * populating transport_zone_endpoints property at TransportNode level. Example [3]
     * shows TransportNode creation request/response by populating
     * transport_zone_endpoints property at StandardHostSwitch level and other new
     * properties. The request should either provide node_deployement_info or node_id.
     * If the host node (hypervisor) or edge node (router) is already added in system
     * then it can be converted to transport node by providing node_id in request. If
     * host node (hypervisor) or edge node (router) is not already present in system
     * then information should be provided under node_deployment_info. This api is now
     * deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNode (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx.model.TransportNode transportNode, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNode> asyncCallback);

    /**
     * Transport nodes are hypervisor hosts and NSX Edges that will participate in an
     * NSX-T overlay. For a hypervisor host, this means that it hosts VMs that will
     * communicate over NSX-T logical switches. For NSX Edges, this means that it will
     * have logical router uplinks and downlinks. This API creates transport node for a
     * host node (hypervisor) or edge node (router) in the transport network. When you
     * run this command for a host, NSX Manager attempts to install the NSX kernel
     * modules, which are packaged as VIB, RPM, or DEB files. For the installation to
     * succeed, you must provide the host login credentials and the host thumbprint. To
     * get the ESXi host thumbprint, SSH to the host and run the <b>openssl x509 -in
     * /etc/vmware/ssl/rui.crt -fingerprint -sha256 -noout</b> command. To generate
     * host key thumbprint using SHA-256 algorithm please follow the steps below. Log
     * into the host, making sure that the connection is not vulnerable to a man in the
     * middle attack. Check whether a public key already exists. Host public key is
     * generally located at '/etc/ssh/ssh_host_rsa_key.pub'. If the key is not present
     * then generate a new key by running the following command and follow the
     * instructions. <b>ssh-keygen -t rsa</b> Now generate a SHA256 hash of the key
     * using the following command. Please make sure to pass the appropriate file name
     * if the public key is stored with a different file name other than the default
     * 'id_rsa.pub'. <b>awk '{print $2}' id_rsa.pub | base64 -d | sha256sum -b | sed
     * 's/ .*$//' | xxd -r -p | base64</b> This api is deprecated as part of FN+TN
     * unification. Please use Transport Node API to install NSX components on a node.
     * Additional documentation on creating a transport node can be found in the NSX-T
     * Installation Guide. In order for the transport node to forward packets, the
     * host_switch_spec property must be specified. Host switches (called bridges in
     * OVS on KVM hypervisors) are the individual switches within the host virtual
     * switch. Virtual machines are connected to the host switches. When creating a
     * transport node, you need to specify if the host switches are already manually
     * preconfigured on the node, or if NSX should create and manage the host switches.
     * You specify this choice by the type of host switches you pass in the
     * host_switch_spec property of the TransportNode request payload. For a KVM host,
     * you can preconfigure the host switch, or you can have NSX Manager perform the
     * configuration. For an ESXi host or NSX Edge node, NSX Manager always configures
     * the host switch. To preconfigure the host switches on a KVM host, pass an array
     * of PreconfiguredHostSwitchSpec objects that describes those host switches. In
     * the current NSX-T release, only one prefonfigured host switch can be specified.
     * See the PreconfiguredHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Preconfigured host switches are only supported
     * on KVM hosts, not on ESXi hosts or NSX Edge nodes. To allow NSX to manage the
     * host switch configuration on KVM hosts, ESXi hosts, or NSX Edge nodes, pass an
     * array of StandardHostSwitchSpec objects in the host_switch_spec property, and
     * NSX will automatically create host switches with the properties you provide. In
     * the current NSX-T release, up to 16 host switches can be automatically managed.
     * See the StandardHostSwitchSpec schema definition for documentation on the
     * properties that must be provided. Note: Previous versions of NSX-T also used a
     * property named transport_zone_endpoints at TransportNode level. This property is
     * deprecated which creates some combinations of new client along with old client
     * payloads. Examples [1] & [2] show old/existing client request and response by
     * populating transport_zone_endpoints property at TransportNode level. Example [3]
     * shows TransportNode creation request/response by populating
     * transport_zone_endpoints property at StandardHostSwitch level and other new
     * properties. The request should either provide node_deployement_info or node_id.
     * If the host node (hypervisor) or edge node (router) is already added in system
     * then it can be converted to transport node by providing node_id in request. If
     * host node (hypervisor) or edge node (router) is not already present in system
     * then information should be provided under node_deployment_info. This api is now
     * deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNode (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx.model.TransportNode transportNode, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNode> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes the specified transport node. Query param force can be used to force
     * delete the host nodes. Force deletion of edge and public cloud gateway nodes is
     * not supported. Force delete is not supported if transport node is part of a
     * cluster on which Transport node profile is applied. If transport node delete is
     * called with query param force not being set or set to false and uninstall of NSX
     * components in the host fails, TransportNodeState object will be retained. If
     * transport node delete is called with query param force set to true and uninstall
     * of NSX components in the host fails, TransportNodeState object will be deleted.
     * It also removes the specified node (host or edge) from system. If unprepare_host
     * option is set to false, then host will be deleted without uninstalling the NSX
     * components from the host. This api is now deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param unprepareHost Uninstall NSX components from host while deleting (optional, default to true)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String transportNodeId, java.lang.Boolean force, java.lang.Boolean unprepareHost);

    /**
     * Deletes the specified transport node. Query param force can be used to force
     * delete the host nodes. Force deletion of edge and public cloud gateway nodes is
     * not supported. Force delete is not supported if transport node is part of a
     * cluster on which Transport node profile is applied. If transport node delete is
     * called with query param force not being set or set to false and uninstall of NSX
     * components in the host fails, TransportNodeState object will be retained. If
     * transport node delete is called with query param force set to true and uninstall
     * of NSX components in the host fails, TransportNodeState object will be deleted.
     * It also removes the specified node (host or edge) from system. If unprepare_host
     * option is set to false, then host will be deleted without uninstalling the NSX
     * components from the host. This api is now deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param unprepareHost Uninstall NSX components from host while deleting (optional, default to true)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String transportNodeId, java.lang.Boolean force, java.lang.Boolean unprepareHost, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes the specified transport node. Query param force can be used to force
     * delete the host nodes. Force deletion of edge and public cloud gateway nodes is
     * not supported. Force delete is not supported if transport node is part of a
     * cluster on which Transport node profile is applied. If transport node delete is
     * called with query param force not being set or set to false and uninstall of NSX
     * components in the host fails, TransportNodeState object will be retained. If
     * transport node delete is called with query param force set to true and uninstall
     * of NSX components in the host fails, TransportNodeState object will be deleted.
     * It also removes the specified node (host or edge) from system. If unprepare_host
     * option is set to false, then host will be deleted without uninstalling the NSX
     * components from the host. This api is now deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param unprepareHost Uninstall NSX components from host while deleting (optional, default to true)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String transportNodeId, java.lang.Boolean force, java.lang.Boolean unprepareHost, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes the specified transport node. Query param force can be used to force
     * delete the host nodes. Force deletion of edge and public cloud gateway nodes is
     * not supported. Force delete is not supported if transport node is part of a
     * cluster on which Transport node profile is applied. If transport node delete is
     * called with query param force not being set or set to false and uninstall of NSX
     * components in the host fails, TransportNodeState object will be retained. If
     * transport node delete is called with query param force set to true and uninstall
     * of NSX components in the host fails, TransportNodeState object will be deleted.
     * It also removes the specified node (host or edge) from system. If unprepare_host
     * option is set to false, then host will be deleted without uninstalling the NSX
     * components from the host. This api is now deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param unprepareHost Uninstall NSX components from host while deleting (optional, default to true)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String transportNodeId, java.lang.Boolean force, java.lang.Boolean unprepareHost, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Invoke DELETE request on target transport node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.TimedOut  Gateway Timeout
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void deleteontransportnode(java.lang.String targetNodeId, java.lang.String targetUri);

    /**
     * Invoke DELETE request on target transport node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.TimedOut  Gateway Timeout
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void deleteontransportnode(java.lang.String targetNodeId, java.lang.String targetUri, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Invoke DELETE request on target transport node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.TimedOut} -  Gateway Timeout<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void deleteontransportnode(java.lang.String targetNodeId, java.lang.String targetUri, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Invoke DELETE request on target transport node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.TimedOut} -  Gateway Timeout<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void deleteontransportnode(java.lang.String targetNodeId, java.lang.String targetUri, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Disable flow cache for edge transport node. Caution: This involves restart of
     * the edge dataplane and hence may lead to network disruption.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void disableflowcache(java.lang.String transportNodeId);

    /**
     * Disable flow cache for edge transport node. Caution: This involves restart of
     * the edge dataplane and hence may lead to network disruption.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void disableflowcache(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Disable flow cache for edge transport node. Caution: This involves restart of
     * the edge dataplane and hence may lead to network disruption.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void disableflowcache(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Disable flow cache for edge transport node. Caution: This involves restart of
     * the edge dataplane and hence may lead to network disruption.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void disableflowcache(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Enable flow cache for edge transport node. Caution: This involves restart of the
     * edge dataplane and hence may lead to network disruption.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void enableflowcache(java.lang.String transportNodeId);

    /**
     * Enable flow cache for edge transport node. Caution: This involves restart of the
     * edge dataplane and hence may lead to network disruption.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void enableflowcache(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Enable flow cache for edge transport node. Caution: This involves restart of the
     * edge dataplane and hence may lead to network disruption.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void enableflowcache(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Enable flow cache for edge transport node. Caution: This involves restart of the
     * edge dataplane and hence may lead to network disruption.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void enableflowcache(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about a specified transport node. This api is now
     * deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeId (required)
     * @return com.vmware.nsx.model.TransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNode get(java.lang.String transportNodeId);

    /**
     * Returns information about a specified transport node. This api is now
     * deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNode get(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about a specified transport node. This api is now
     * deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNode> asyncCallback);

    /**
     * Returns information about a specified transport node. This api is now
     * deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNode> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Invoke GET request on target transport node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.TimedOut  Gateway Timeout
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void getontransportnode(java.lang.String targetNodeId, java.lang.String targetUri);

    /**
     * Invoke GET request on target transport node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.TimedOut  Gateway Timeout
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void getontransportnode(java.lang.String targetNodeId, java.lang.String targetUri, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Invoke GET request on target transport node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.TimedOut} -  Gateway Timeout<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void getontransportnode(java.lang.String targetNodeId, java.lang.String targetUri, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Invoke GET request on target transport node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.TimedOut} -  Gateway Timeout<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void getontransportnode(java.lang.String targetNodeId, java.lang.String targetUri, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all transport nodes along with underlying host or edge
     * details. A transport node is a host or edge that contains hostswitches. A
     * hostswitch can have virtual machines connected to them. Because each transport
     * node has hostswitches, transport nodes can also have virtual tunnel endpoints,
     * which means that they can be part of the overlay. This api is now deprecated.
     * Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param inMaintenanceMode maintenance mode flag (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId node identifier (optional)
     * @param nodeIp Fabric node IP address (optional)
     * @param nodeTypes a list of fabric node types separated by comma or a single type (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @return com.vmware.nsx.model.TransportNodeListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNodeListResult list(java.lang.String cursor, java.lang.Boolean inMaintenanceMode, java.lang.String includedFields, java.lang.String nodeId, java.lang.String nodeIp, java.lang.String nodeTypes, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportZoneId);

    /**
     * Returns information about all transport nodes along with underlying host or edge
     * details. A transport node is a host or edge that contains hostswitches. A
     * hostswitch can have virtual machines connected to them. Because each transport
     * node has hostswitches, transport nodes can also have virtual tunnel endpoints,
     * which means that they can be part of the overlay. This api is now deprecated.
     * Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param inMaintenanceMode maintenance mode flag (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId node identifier (optional)
     * @param nodeIp Fabric node IP address (optional)
     * @param nodeTypes a list of fabric node types separated by comma or a single type (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNodeListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNodeListResult list(java.lang.String cursor, java.lang.Boolean inMaintenanceMode, java.lang.String includedFields, java.lang.String nodeId, java.lang.String nodeIp, java.lang.String nodeTypes, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportZoneId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all transport nodes along with underlying host or edge
     * details. A transport node is a host or edge that contains hostswitches. A
     * hostswitch can have virtual machines connected to them. Because each transport
     * node has hostswitches, transport nodes can also have virtual tunnel endpoints,
     * which means that they can be part of the overlay. This api is now deprecated.
     * Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param inMaintenanceMode maintenance mode flag (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId node identifier (optional)
     * @param nodeIp Fabric node IP address (optional)
     * @param nodeTypes a list of fabric node types separated by comma or a single type (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.Boolean inMaintenanceMode, java.lang.String includedFields, java.lang.String nodeId, java.lang.String nodeIp, java.lang.String nodeTypes, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportZoneId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeListResult> asyncCallback);

    /**
     * Returns information about all transport nodes along with underlying host or edge
     * details. A transport node is a host or edge that contains hostswitches. A
     * hostswitch can have virtual machines connected to them. Because each transport
     * node has hostswitches, transport nodes can also have virtual tunnel endpoints,
     * which means that they can be part of the overlay. This api is now deprecated.
     * Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param inMaintenanceMode maintenance mode flag (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId node identifier (optional)
     * @param nodeIp Fabric node IP address (optional)
     * @param nodeTypes a list of fabric node types separated by comma or a single type (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.Boolean inMaintenanceMode, java.lang.String includedFields, java.lang.String nodeId, java.lang.String nodeIp, java.lang.String nodeTypes, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportZoneId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Invoke POST request on target transport node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.TimedOut  Gateway Timeout
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void postontransportnode(java.lang.String targetNodeId, java.lang.String targetUri);

    /**
     * Invoke POST request on target transport node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.TimedOut  Gateway Timeout
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void postontransportnode(java.lang.String targetNodeId, java.lang.String targetUri, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Invoke POST request on target transport node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.TimedOut} -  Gateway Timeout<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void postontransportnode(java.lang.String targetNodeId, java.lang.String targetUri, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Invoke POST request on target transport node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.TimedOut} -  Gateway Timeout<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void postontransportnode(java.lang.String targetNodeId, java.lang.String targetUri, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Invoke PUT request on target transport node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.TimedOut  Gateway Timeout
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void putontransportnode(java.lang.String targetNodeId, java.lang.String targetUri);

    /**
     * Invoke PUT request on target transport node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.TimedOut  Gateway Timeout
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void putontransportnode(java.lang.String targetNodeId, java.lang.String targetUri, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Invoke PUT request on target transport node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.TimedOut} -  Gateway Timeout<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void putontransportnode(java.lang.String targetNodeId, java.lang.String targetUri, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Invoke PUT request on target transport node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.TimedOut} -  Gateway Timeout<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param targetNodeId Target node UUID (required)
     * @param targetUri URI of API to invoke on target node (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void putontransportnode(java.lang.String targetNodeId, java.lang.String targetUri, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Redeploys an edge node at NSX Manager that replaces the edge node with
     * identifier <node-id>. If NSX Manager can access the specified edge node, then
     * the node is put into maintenance mode and then the associated VM is deleted.
     * This is a means to reset all configuration on the edge node. The communication
     * channel between NSX Manager and edge is established after this operation.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeId (required)
     * @param transportNode (required)
     * @return com.vmware.nsx.model.TransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNode redeploy(java.lang.String nodeId, com.vmware.nsx.model.TransportNode transportNode);

    /**
     * Redeploys an edge node at NSX Manager that replaces the edge node with
     * identifier <node-id>. If NSX Manager can access the specified edge node, then
     * the node is put into maintenance mode and then the associated VM is deleted.
     * This is a means to reset all configuration on the edge node. The communication
     * channel between NSX Manager and edge is established after this operation.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeId (required)
     * @param transportNode (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNode redeploy(java.lang.String nodeId, com.vmware.nsx.model.TransportNode transportNode, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Redeploys an edge node at NSX Manager that replaces the edge node with
     * identifier <node-id>. If NSX Manager can access the specified edge node, then
     * the node is put into maintenance mode and then the associated VM is deleted.
     * This is a means to reset all configuration on the edge node. The communication
     * channel between NSX Manager and edge is established after this operation.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeId (required)
     * @param transportNode (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void redeploy(java.lang.String nodeId, com.vmware.nsx.model.TransportNode transportNode, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNode> asyncCallback);

    /**
     * Redeploys an edge node at NSX Manager that replaces the edge node with
     * identifier <node-id>. If NSX Manager can access the specified edge node, then
     * the node is put into maintenance mode and then the associated VM is deleted.
     * This is a means to reset all configuration on the edge node. The communication
     * channel between NSX Manager and edge is established after this operation.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param nodeId (required)
     * @param transportNode (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void redeploy(java.lang.String nodeId, com.vmware.nsx.model.TransportNode transportNode, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNode> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * The API is applicable for Edge transport nodes. If you update the edge
     * configuration and find a discrepancy in Edge configuration at NSX Manager in
     * compare with realized, then use this API to refresh configuration at NSX
     * Manager. It refreshes the Edge configuration from sources external to NSX
     * Manager like vSphere Server or the Edge node CLI. After this action, Edge
     * configuration at NSX Manager is updated and the API GET api/v1/transport-nodes
     * will show refreshed data. From 3.2 release onwards, refresh API updates the MP
     * intent by default.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeId (required)
     * @param readOnly Read-only flag for Refresh API (optional, default to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void refreshnodeconfiguration(java.lang.String transportNodeId, java.lang.Boolean readOnly);

    /**
     * The API is applicable for Edge transport nodes. If you update the edge
     * configuration and find a discrepancy in Edge configuration at NSX Manager in
     * compare with realized, then use this API to refresh configuration at NSX
     * Manager. It refreshes the Edge configuration from sources external to NSX
     * Manager like vSphere Server or the Edge node CLI. After this action, Edge
     * configuration at NSX Manager is updated and the API GET api/v1/transport-nodes
     * will show refreshed data. From 3.2 release onwards, refresh API updates the MP
     * intent by default.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeId (required)
     * @param readOnly Read-only flag for Refresh API (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void refreshnodeconfiguration(java.lang.String transportNodeId, java.lang.Boolean readOnly, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * The API is applicable for Edge transport nodes. If you update the edge
     * configuration and find a discrepancy in Edge configuration at NSX Manager in
     * compare with realized, then use this API to refresh configuration at NSX
     * Manager. It refreshes the Edge configuration from sources external to NSX
     * Manager like vSphere Server or the Edge node CLI. After this action, Edge
     * configuration at NSX Manager is updated and the API GET api/v1/transport-nodes
     * will show refreshed data. From 3.2 release onwards, refresh API updates the MP
     * intent by default.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param readOnly Read-only flag for Refresh API (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void refreshnodeconfiguration(java.lang.String transportNodeId, java.lang.Boolean readOnly, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * The API is applicable for Edge transport nodes. If you update the edge
     * configuration and find a discrepancy in Edge configuration at NSX Manager in
     * compare with realized, then use this API to refresh configuration at NSX
     * Manager. It refreshes the Edge configuration from sources external to NSX
     * Manager like vSphere Server or the Edge node CLI. After this action, Edge
     * configuration at NSX Manager is updated and the API GET api/v1/transport-nodes
     * will show refreshed data. From 3.2 release onwards, refresh API updates the MP
     * intent by default.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param readOnly Read-only flag for Refresh API (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void refreshnodeconfiguration(java.lang.String transportNodeId, java.lang.Boolean readOnly, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Restart the inventory sync for the node if it is currently internally paused.
     * After this action the next inventory sync coming from the node is processed.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void restartinventorysync(java.lang.String transportNodeId);

    /**
     * Restart the inventory sync for the node if it is currently internally paused.
     * After this action the next inventory sync coming from the node is processed.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void restartinventorysync(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Restart the inventory sync for the node if it is currently internally paused.
     * After this action the next inventory sync coming from the node is processed.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void restartinventorysync(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Restart the inventory sync for the node if it is currently internally paused.
     * After this action the next inventory sync coming from the node is processed.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void restartinventorysync(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * A host can be overridden to have different configuration than Transport Node
     * Profile(TNP) on cluster. This action will restore such overridden host back to
     * cluster level TNP. This API can be used in other case. When TNP is applied to a
     * cluster, if any validation fails (e.g. VMs running on host) then existing
     * transport node (TN) is not updated. In that case after the issue is resolved
     * manually (e.g. VMs powered off), you can call this API to update TN as per
     * cluster level TNP. <br/> This api is now deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>?action=restore_cluster_config
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void restoreclusterconfig(java.lang.String transportNodeId);

    /**
     * A host can be overridden to have different configuration than Transport Node
     * Profile(TNP) on cluster. This action will restore such overridden host back to
     * cluster level TNP. This API can be used in other case. When TNP is applied to a
     * cluster, if any validation fails (e.g. VMs running on host) then existing
     * transport node (TN) is not updated. In that case after the issue is resolved
     * manually (e.g. VMs powered off), you can call this API to update TN as per
     * cluster level TNP. <br/> This api is now deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>?action=restore_cluster_config
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void restoreclusterconfig(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * A host can be overridden to have different configuration than Transport Node
     * Profile(TNP) on cluster. This action will restore such overridden host back to
     * cluster level TNP. This API can be used in other case. When TNP is applied to a
     * cluster, if any validation fails (e.g. VMs running on host) then existing
     * transport node (TN) is not updated. In that case after the issue is resolved
     * manually (e.g. VMs powered off), you can call this API to update TN as per
     * cluster level TNP. <br/> This api is now deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>?action=restore_cluster_config
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void restoreclusterconfig(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * A host can be overridden to have different configuration than Transport Node
     * Profile(TNP) on cluster. This action will restore such overridden host back to
     * cluster level TNP. This API can be used in other case. When TNP is applied to a
     * cluster, if any validation fails (e.g. VMs running on host) then existing
     * transport node (TN) is not updated. In that case after the issue is resolved
     * manually (e.g. VMs powered off), you can call this API to update TN as per
     * cluster level TNP. <br/> This api is now deprecated. Please use new api -
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/host-transport-nodes/<host-transport-node-id>?action=restore_cluster_config
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void restoreclusterconfig(java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Resync the TransportNode configuration on a host. It is similar to updating the
     * TransportNode with existing configuration, but force synce these configurations
     * to the host (no backend optimizations).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportnodeId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void resynchostconfig(java.lang.String transportnodeId);

    /**
     * Resync the TransportNode configuration on a host. It is similar to updating the
     * TransportNode with existing configuration, but force synce these configurations
     * to the host (no backend optimizations).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportnodeId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void resynchostconfig(java.lang.String transportnodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Resync the TransportNode configuration on a host. It is similar to updating the
     * TransportNode with existing configuration, but force synce these configurations
     * to the host (no backend optimizations).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportnodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void resynchostconfig(java.lang.String transportnodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Resync the TransportNode configuration on a host. It is similar to updating the
     * TransportNode with existing configuration, but force synce these configurations
     * to the host (no backend optimizations).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportnodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void resynchostconfig(java.lang.String transportnodeId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     *
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeId (required)
     * @param transportNode (required)
     * @param esxMgmtIfMigrationDest The network ids to which the ESX vmk interfaces will be migrated (optional)
     * @param ifId The ESX vmk interfaces to migrate (optional)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param pingIp IP Addresses to ping right after ESX vmk interfaces were migrated. (optional)
     * @param skipValidation Whether to skip front-end validation for vmk/vnic/pnic migration (optional,
     * default to false)
     * @param vnic The ESX vmk interfaces and/or VM NIC to migrate (optional)
     * @param vnicMigrationDest The migration destinations of ESX vmk interfaces and/or VM NIC (optional)
     * @return com.vmware.nsx.model.TransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNode update(java.lang.String transportNodeId, com.vmware.nsx.model.TransportNode transportNode, java.lang.String esxMgmtIfMigrationDest, java.lang.String ifId, java.lang.Boolean overrideNsxOwnership, java.lang.String pingIp, java.lang.Boolean skipValidation, java.lang.String vnic, java.lang.String vnicMigrationDest);

    /**
     *
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeId (required)
     * @param transportNode (required)
     * @param esxMgmtIfMigrationDest The network ids to which the ESX vmk interfaces will be migrated (optional)
     * @param ifId The ESX vmk interfaces to migrate (optional)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param pingIp IP Addresses to ping right after ESX vmk interfaces were migrated. (optional)
     * @param skipValidation Whether to skip front-end validation for vmk/vnic/pnic migration (optional,
     * default to false)
     * @param vnic The ESX vmk interfaces and/or VM NIC to migrate (optional)
     * @param vnicMigrationDest The migration destinations of ESX vmk interfaces and/or VM NIC (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNode
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.TransportNode update(java.lang.String transportNodeId, com.vmware.nsx.model.TransportNode transportNode, java.lang.String esxMgmtIfMigrationDest, java.lang.String ifId, java.lang.Boolean overrideNsxOwnership, java.lang.String pingIp, java.lang.Boolean skipValidation, java.lang.String vnic, java.lang.String vnicMigrationDest, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     *
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param transportNode (required)
     * @param esxMgmtIfMigrationDest The network ids to which the ESX vmk interfaces will be migrated (optional)
     * @param ifId The ESX vmk interfaces to migrate (optional)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param pingIp IP Addresses to ping right after ESX vmk interfaces were migrated. (optional)
     * @param skipValidation Whether to skip front-end validation for vmk/vnic/pnic migration (optional,
     * default to false)
     * @param vnic The ESX vmk interfaces and/or VM NIC to migrate (optional)
     * @param vnicMigrationDest The migration destinations of ESX vmk interfaces and/or VM NIC (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String transportNodeId, com.vmware.nsx.model.TransportNode transportNode, java.lang.String esxMgmtIfMigrationDest, java.lang.String ifId, java.lang.Boolean overrideNsxOwnership, java.lang.String pingIp, java.lang.Boolean skipValidation, java.lang.String vnic, java.lang.String vnicMigrationDest, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNode> asyncCallback);

    /**
     *
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNode
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportNodeId (required)
     * @param transportNode (required)
     * @param esxMgmtIfMigrationDest The network ids to which the ESX vmk interfaces will be migrated (optional)
     * @param ifId The ESX vmk interfaces to migrate (optional)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param pingIp IP Addresses to ping right after ESX vmk interfaces were migrated. (optional)
     * @param skipValidation Whether to skip front-end validation for vmk/vnic/pnic migration (optional,
     * default to false)
     * @param vnic The ESX vmk interfaces and/or VM NIC to migrate (optional)
     * @param vnicMigrationDest The migration destinations of ESX vmk interfaces and/or VM NIC (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String transportNodeId, com.vmware.nsx.model.TransportNode transportNode, java.lang.String esxMgmtIfMigrationDest, java.lang.String ifId, java.lang.Boolean overrideNsxOwnership, java.lang.String pingIp, java.lang.Boolean skipValidation, java.lang.String vnic, java.lang.String vnicMigrationDest, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNode> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Put transport node into maintenance mode or exit from maintenance mode.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportnodeId (required)
     * @param action (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void updatemaintenancemode(java.lang.String transportnodeId, java.lang.String action);

    /**
     * Put transport node into maintenance mode or exit from maintenance mode.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportnodeId (required)
     * @param action (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void updatemaintenancemode(java.lang.String transportnodeId, java.lang.String action, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Put transport node into maintenance mode or exit from maintenance mode.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportnodeId (required)
     * @param action (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void updatemaintenancemode(java.lang.String transportnodeId, java.lang.String action, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Put transport node into maintenance mode or exit from maintenance mode.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportnodeId (required)
     * @param action (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void updatemaintenancemode(java.lang.String transportnodeId, java.lang.String action, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
