/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface TransportZones extends com.vmware.vapi.bindings.Service, com.vmware.nsx.TransportZonesTypes {

    /**
     * Creates a new transport zone. The required parameters is transport_type (OVERLAY
     * or VLAN). The optional parameters are description and display_name. <br/> This
     * api is now deprecated. Please use new api - PUT
     * /policy/api/v1/infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/transport-zones/<zone-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportZone (required)
     * @return com.vmware.nsx.model.TransportZone
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.TransportZone create(com.vmware.nsx.model.TransportZone transportZone);

    /**
     * Creates a new transport zone. The required parameters is transport_type (OVERLAY
     * or VLAN). The optional parameters are description and display_name. <br/> This
     * api is now deprecated. Please use new api - PUT
     * /policy/api/v1/infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/transport-zones/<zone-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportZone (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportZone
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.TransportZone create(com.vmware.nsx.model.TransportZone transportZone, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a new transport zone. The required parameters is transport_type (OVERLAY
     * or VLAN). The optional parameters are description and display_name. <br/> This
     * api is now deprecated. Please use new api - PUT
     * /policy/api/v1/infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/transport-zones/<zone-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportZone
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportZone (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.TransportZone transportZone, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportZone> asyncCallback);

    /**
     * Creates a new transport zone. The required parameters is transport_type (OVERLAY
     * or VLAN). The optional parameters are description and display_name. <br/> This
     * api is now deprecated. Please use new api - PUT
     * /policy/api/v1/infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/transport-zones/<zone-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportZone
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param transportZone (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.TransportZone transportZone, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportZone> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes an existing transport zone. <br/> This api is now deprecated. Please use
     * new api - DELETE
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/transport-zones/<zone-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param zoneId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String zoneId);

    /**
     * Deletes an existing transport zone. <br/> This api is now deprecated. Please use
     * new api - DELETE
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/transport-zones/<zone-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param zoneId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String zoneId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes an existing transport zone. <br/> This api is now deprecated. Please use
     * new api - DELETE
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/transport-zones/<zone-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param zoneId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String zoneId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes an existing transport zone. <br/> This api is now deprecated. Please use
     * new api - DELETE
     * /infra/sites/<site-id>/enforcement-points/<enforcementpoint-id>/transport-zones/<zone-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param zoneId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String zoneId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about a single transport zone. <br/> This api is now
     * deprecated. Please use new api -
     * /policy/api/v1/infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/transport-zones/<zone-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param zoneId (required)
     * @return com.vmware.nsx.model.TransportZone
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.TransportZone get(java.lang.String zoneId);

    /**
     * Returns information about a single transport zone. <br/> This api is now
     * deprecated. Please use new api -
     * /policy/api/v1/infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/transport-zones/<zone-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param zoneId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportZone
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.TransportZone get(java.lang.String zoneId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about a single transport zone. <br/> This api is now
     * deprecated. Please use new api -
     * /policy/api/v1/infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/transport-zones/<zone-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportZone
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param zoneId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String zoneId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportZone> asyncCallback);

    /**
     * Returns information about a single transport zone. <br/> This api is now
     * deprecated. Please use new api -
     * /policy/api/v1/infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/transport-zones/<zone-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportZone
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param zoneId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String zoneId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportZone> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about configured transport zones. NSX requires at least one
     * transport zone. NSX uses transport zones to provide connectivity based on the
     * topology of the underlying network, trust zones, or organizational separations.
     * For example, you might have hypervisors that use one network for management
     * traffic and a different network for VM traffic. This architecture would require
     * two transport zones. The combination of transport zones plus transport
     * connectors enables NSX to form tunnels between hypervisors. Transport zones
     * define which interfaces on the hypervisors can communicate with which other
     * interfaces on other hypervisors to establish overlay tunnels or provide
     * connectivity to a VLAN. A logical switch can be in one (and only one) transport
     * zone. This means that all of a switch's interfaces must be in the same transport
     * zone. However, each hypervisor virtual switch (OVS or VDS) has multiple
     * interfaces (connectors), and each connector can be attached to a different
     * logical switch. For example, on a single hypervisor with two connectors,
     * connector A can be attached to logical switch 1 in transport zone A, while
     * connector B is attached to logical switch 2 in transport zone B. In this way, a
     * single hypervisor can participate in multiple transport zones. The API for
     * creating a transport zone requires that a single host switch be specified for
     * each transport zone, and multiple transport zones can share the same host
     * switch. <br/> This api is now deprecated. Please use new api -
     * /policy/api/v1/infra/sites/<site-id>/enforcement-points/
     * <enforcementpoint-id>/transport-zones
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param displayName The transport zone's display name (optional)
     * @param includeSystemOwned Filter to indicate whether to include system owned Transport Zones. (optional,
     * default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param isDefault Filter to choose if default transport zones will be returned (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportType Filter to choose the type of transport zones to return (optional)
     * @param uplinkTeamingPolicyName The transport zone's uplink teaming policy name (optional)
     * @return com.vmware.nsx.model.TransportZoneListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.TransportZoneListResult list(java.lang.String cursor, java.lang.String displayName, java.lang.Boolean includeSystemOwned, java.lang.String includedFields, java.lang.Boolean isDefault, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportType, java.lang.String uplinkTeamingPolicyName);

    /**
     * Returns information about configured transport zones. NSX requires at least one
     * transport zone. NSX uses transport zones to provide connectivity based on the
     * topology of the underlying network, trust zones, or organizational separations.
     * For example, you might have hypervisors that use one network for management
     * traffic and a different network for VM traffic. This architecture would require
     * two transport zones. The combination of transport zones plus transport
     * connectors enables NSX to form tunnels between hypervisors. Transport zones
     * define which interfaces on the hypervisors can communicate with which other
     * interfaces on other hypervisors to establish overlay tunnels or provide
     * connectivity to a VLAN. A logical switch can be in one (and only one) transport
     * zone. This means that all of a switch's interfaces must be in the same transport
     * zone. However, each hypervisor virtual switch (OVS or VDS) has multiple
     * interfaces (connectors), and each connector can be attached to a different
     * logical switch. For example, on a single hypervisor with two connectors,
     * connector A can be attached to logical switch 1 in transport zone A, while
     * connector B is attached to logical switch 2 in transport zone B. In this way, a
     * single hypervisor can participate in multiple transport zones. The API for
     * creating a transport zone requires that a single host switch be specified for
     * each transport zone, and multiple transport zones can share the same host
     * switch. <br/> This api is now deprecated. Please use new api -
     * /policy/api/v1/infra/sites/<site-id>/enforcement-points/
     * <enforcementpoint-id>/transport-zones
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param displayName The transport zone's display name (optional)
     * @param includeSystemOwned Filter to indicate whether to include system owned Transport Zones. (optional,
     * default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param isDefault Filter to choose if default transport zones will be returned (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportType Filter to choose the type of transport zones to return (optional)
     * @param uplinkTeamingPolicyName The transport zone's uplink teaming policy name (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportZoneListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.TransportZoneListResult list(java.lang.String cursor, java.lang.String displayName, java.lang.Boolean includeSystemOwned, java.lang.String includedFields, java.lang.Boolean isDefault, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportType, java.lang.String uplinkTeamingPolicyName, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about configured transport zones. NSX requires at least one
     * transport zone. NSX uses transport zones to provide connectivity based on the
     * topology of the underlying network, trust zones, or organizational separations.
     * For example, you might have hypervisors that use one network for management
     * traffic and a different network for VM traffic. This architecture would require
     * two transport zones. The combination of transport zones plus transport
     * connectors enables NSX to form tunnels between hypervisors. Transport zones
     * define which interfaces on the hypervisors can communicate with which other
     * interfaces on other hypervisors to establish overlay tunnels or provide
     * connectivity to a VLAN. A logical switch can be in one (and only one) transport
     * zone. This means that all of a switch's interfaces must be in the same transport
     * zone. However, each hypervisor virtual switch (OVS or VDS) has multiple
     * interfaces (connectors), and each connector can be attached to a different
     * logical switch. For example, on a single hypervisor with two connectors,
     * connector A can be attached to logical switch 1 in transport zone A, while
     * connector B is attached to logical switch 2 in transport zone B. In this way, a
     * single hypervisor can participate in multiple transport zones. The API for
     * creating a transport zone requires that a single host switch be specified for
     * each transport zone, and multiple transport zones can share the same host
     * switch. <br/> This api is now deprecated. Please use new api -
     * /policy/api/v1/infra/sites/<site-id>/enforcement-points/
     * <enforcementpoint-id>/transport-zones
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportZoneListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param displayName The transport zone's display name (optional)
     * @param includeSystemOwned Filter to indicate whether to include system owned Transport Zones. (optional,
     * default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param isDefault Filter to choose if default transport zones will be returned (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportType Filter to choose the type of transport zones to return (optional)
     * @param uplinkTeamingPolicyName The transport zone's uplink teaming policy name (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String displayName, java.lang.Boolean includeSystemOwned, java.lang.String includedFields, java.lang.Boolean isDefault, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportType, java.lang.String uplinkTeamingPolicyName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportZoneListResult> asyncCallback);

    /**
     * Returns information about configured transport zones. NSX requires at least one
     * transport zone. NSX uses transport zones to provide connectivity based on the
     * topology of the underlying network, trust zones, or organizational separations.
     * For example, you might have hypervisors that use one network for management
     * traffic and a different network for VM traffic. This architecture would require
     * two transport zones. The combination of transport zones plus transport
     * connectors enables NSX to form tunnels between hypervisors. Transport zones
     * define which interfaces on the hypervisors can communicate with which other
     * interfaces on other hypervisors to establish overlay tunnels or provide
     * connectivity to a VLAN. A logical switch can be in one (and only one) transport
     * zone. This means that all of a switch's interfaces must be in the same transport
     * zone. However, each hypervisor virtual switch (OVS or VDS) has multiple
     * interfaces (connectors), and each connector can be attached to a different
     * logical switch. For example, on a single hypervisor with two connectors,
     * connector A can be attached to logical switch 1 in transport zone A, while
     * connector B is attached to logical switch 2 in transport zone B. In this way, a
     * single hypervisor can participate in multiple transport zones. The API for
     * creating a transport zone requires that a single host switch be specified for
     * each transport zone, and multiple transport zones can share the same host
     * switch. <br/> This api is now deprecated. Please use new api -
     * /policy/api/v1/infra/sites/<site-id>/enforcement-points/
     * <enforcementpoint-id>/transport-zones
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportZoneListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param displayName The transport zone's display name (optional)
     * @param includeSystemOwned Filter to indicate whether to include system owned Transport Zones. (optional,
     * default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param isDefault Filter to choose if default transport zones will be returned (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param transportType Filter to choose the type of transport zones to return (optional)
     * @param uplinkTeamingPolicyName The transport zone's uplink teaming policy name (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String displayName, java.lang.Boolean includeSystemOwned, java.lang.String includedFields, java.lang.Boolean isDefault, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String transportType, java.lang.String uplinkTeamingPolicyName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportZoneListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Updates an existing transport zone. Modifiable parameters are is_default,
     * description, and display_name. <br/> This api is now deprecated. Use new api -
     * PATCH /infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/transport-zones/<zone-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param zoneId (required)
     * @param transportZone (required)
     * @return com.vmware.nsx.model.TransportZone
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.TransportZone update(java.lang.String zoneId, com.vmware.nsx.model.TransportZone transportZone);

    /**
     * Updates an existing transport zone. Modifiable parameters are is_default,
     * description, and display_name. <br/> This api is now deprecated. Use new api -
     * PATCH /infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/transport-zones/<zone-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param zoneId (required)
     * @param transportZone (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportZone
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.TransportZone update(java.lang.String zoneId, com.vmware.nsx.model.TransportZone transportZone, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Updates an existing transport zone. Modifiable parameters are is_default,
     * description, and display_name. <br/> This api is now deprecated. Use new api -
     * PATCH /infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/transport-zones/<zone-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportZone
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param zoneId (required)
     * @param transportZone (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String zoneId, com.vmware.nsx.model.TransportZone transportZone, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportZone> asyncCallback);

    /**
     * Updates an existing transport zone. Modifiable parameters are is_default,
     * description, and display_name. <br/> This api is now deprecated. Use new api -
     * PATCH /infra/sites/<site-id>/enforcement-points/<enforcementpoint-
     * id>/transport-zones/<zone-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportZone
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param zoneId (required)
     * @param transportZone (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String zoneId, com.vmware.nsx.model.TransportZone transportZone, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportZone> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
