/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.dhcp.
 * Used by client-side stubs.
 */

package com.vmware.nsx.dhcp;

public interface ServerProfiles extends com.vmware.vapi.bindings.Service, com.vmware.nsx.dhcp.ServerProfilesTypes {

    /**
     * Create a DHCP server profile. If no edge member is specified, edge members to
     * run the dhcp servers will be auto-allocated from the edge cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param dhcpProfile (required)
     * @return com.vmware.nsx.model.DhcpProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DhcpProfile create(com.vmware.nsx.model.DhcpProfile dhcpProfile);

    /**
     * Create a DHCP server profile. If no edge member is specified, edge members to
     * run the dhcp servers will be auto-allocated from the edge cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param dhcpProfile (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DhcpProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DhcpProfile create(com.vmware.nsx.model.DhcpProfile dhcpProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create a DHCP server profile. If no edge member is specified, edge members to
     * run the dhcp servers will be auto-allocated from the edge cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DhcpProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param dhcpProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.DhcpProfile dhcpProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DhcpProfile> asyncCallback);

    /**
     * Create a DHCP server profile. If no edge member is specified, edge members to
     * run the dhcp servers will be auto-allocated from the edge cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DhcpProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param dhcpProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.DhcpProfile dhcpProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DhcpProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete a DHCP server profile specified by the profile id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param profileId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String profileId);

    /**
     * Delete a DHCP server profile specified by the profile id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param profileId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String profileId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete a DHCP server profile specified by the profile id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String profileId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete a DHCP server profile specified by the profile id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String profileId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Return the DHCP profile specified by the profile id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param profileId (required)
     * @return com.vmware.nsx.model.DhcpProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DhcpProfile get(java.lang.String profileId);

    /**
     * Return the DHCP profile specified by the profile id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param profileId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DhcpProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DhcpProfile get(java.lang.String profileId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return the DHCP profile specified by the profile id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DhcpProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String profileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DhcpProfile> asyncCallback);

    /**
     * Return the DHCP profile specified by the profile id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DhcpProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String profileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DhcpProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get a paginated list of DHCP server profiles.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.DhcpProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DhcpProfileListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Get a paginated list of DHCP server profiles.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DhcpProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DhcpProfileListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get a paginated list of DHCP server profiles.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DhcpProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DhcpProfileListResult> asyncCallback);

    /**
     * Get a paginated list of DHCP server profiles.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DhcpProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DhcpProfileListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * As changing edge-cluster-id of a DhcpProfile by a PUT is disallowed, this
     * re-allocate API is used to modify the edge-cluster-id and members of a given
     * DhcpProfile. Only the edge-cluster-id and the edge-cluster-member-indexes fields
     * will be picked up by this re-allication API. The othere fields in the payload
     * will be ignored. If the edge-cluster-id in the payload DhcpProfile is different
     * from the current edge-cluster-id of the profile, the referencing DHCP server(s)
     * will be re-allocated to the new edge cluster. If the edge-cluster-id is not
     * changed, the referencing DHCP server(s) will be re-allocated to the given edge
     * members in the edge cluster. In this case, this REST API will act same as that
     * of updating a DhcpProfile. If the edge cluster member indexes are provided, they
     * should exist in the given edge cluster. If the indexes are not specified in the
     * DhcpProfile, edge members will be auto-allocated from the given edge cluster.
     * Please note that re-allocating edge-cluster will cause lose of all exisitng DHCP
     * lease information. This API is used only when loosing DHCP leases is not a real
     * problem, e.g. cross-site migration or failover and all client hosts will be
     * reboot and get new IP addresses.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serverProfileId (required)
     * @param dhcpProfile (required)
     * @return com.vmware.nsx.model.DhcpProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DhcpProfile reallocate(java.lang.String serverProfileId, com.vmware.nsx.model.DhcpProfile dhcpProfile);

    /**
     * As changing edge-cluster-id of a DhcpProfile by a PUT is disallowed, this
     * re-allocate API is used to modify the edge-cluster-id and members of a given
     * DhcpProfile. Only the edge-cluster-id and the edge-cluster-member-indexes fields
     * will be picked up by this re-allication API. The othere fields in the payload
     * will be ignored. If the edge-cluster-id in the payload DhcpProfile is different
     * from the current edge-cluster-id of the profile, the referencing DHCP server(s)
     * will be re-allocated to the new edge cluster. If the edge-cluster-id is not
     * changed, the referencing DHCP server(s) will be re-allocated to the given edge
     * members in the edge cluster. In this case, this REST API will act same as that
     * of updating a DhcpProfile. If the edge cluster member indexes are provided, they
     * should exist in the given edge cluster. If the indexes are not specified in the
     * DhcpProfile, edge members will be auto-allocated from the given edge cluster.
     * Please note that re-allocating edge-cluster will cause lose of all exisitng DHCP
     * lease information. This API is used only when loosing DHCP leases is not a real
     * problem, e.g. cross-site migration or failover and all client hosts will be
     * reboot and get new IP addresses.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serverProfileId (required)
     * @param dhcpProfile (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DhcpProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DhcpProfile reallocate(java.lang.String serverProfileId, com.vmware.nsx.model.DhcpProfile dhcpProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * As changing edge-cluster-id of a DhcpProfile by a PUT is disallowed, this
     * re-allocate API is used to modify the edge-cluster-id and members of a given
     * DhcpProfile. Only the edge-cluster-id and the edge-cluster-member-indexes fields
     * will be picked up by this re-allication API. The othere fields in the payload
     * will be ignored. If the edge-cluster-id in the payload DhcpProfile is different
     * from the current edge-cluster-id of the profile, the referencing DHCP server(s)
     * will be re-allocated to the new edge cluster. If the edge-cluster-id is not
     * changed, the referencing DHCP server(s) will be re-allocated to the given edge
     * members in the edge cluster. In this case, this REST API will act same as that
     * of updating a DhcpProfile. If the edge cluster member indexes are provided, they
     * should exist in the given edge cluster. If the indexes are not specified in the
     * DhcpProfile, edge members will be auto-allocated from the given edge cluster.
     * Please note that re-allocating edge-cluster will cause lose of all exisitng DHCP
     * lease information. This API is used only when loosing DHCP leases is not a real
     * problem, e.g. cross-site migration or failover and all client hosts will be
     * reboot and get new IP addresses.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DhcpProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serverProfileId (required)
     * @param dhcpProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void reallocate(java.lang.String serverProfileId, com.vmware.nsx.model.DhcpProfile dhcpProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DhcpProfile> asyncCallback);

    /**
     * As changing edge-cluster-id of a DhcpProfile by a PUT is disallowed, this
     * re-allocate API is used to modify the edge-cluster-id and members of a given
     * DhcpProfile. Only the edge-cluster-id and the edge-cluster-member-indexes fields
     * will be picked up by this re-allication API. The othere fields in the payload
     * will be ignored. If the edge-cluster-id in the payload DhcpProfile is different
     * from the current edge-cluster-id of the profile, the referencing DHCP server(s)
     * will be re-allocated to the new edge cluster. If the edge-cluster-id is not
     * changed, the referencing DHCP server(s) will be re-allocated to the given edge
     * members in the edge cluster. In this case, this REST API will act same as that
     * of updating a DhcpProfile. If the edge cluster member indexes are provided, they
     * should exist in the given edge cluster. If the indexes are not specified in the
     * DhcpProfile, edge members will be auto-allocated from the given edge cluster.
     * Please note that re-allocating edge-cluster will cause lose of all exisitng DHCP
     * lease information. This API is used only when loosing DHCP leases is not a real
     * problem, e.g. cross-site migration or failover and all client hosts will be
     * reboot and get new IP addresses.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DhcpProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serverProfileId (required)
     * @param dhcpProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void reallocate(java.lang.String serverProfileId, com.vmware.nsx.model.DhcpProfile dhcpProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DhcpProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If both the edge_cluster_member_indexes in the DhcpProfile are changed in a same
     * PUT API, e.g. change from [a,b] to [x,y], the current DHCP server leases will be
     * lost, which could cause the network crash due to ip conflicts. Hence the
     * suggestion is to change only one member index in one single update, e.g. from
     * [a, b] to [a,y]. Please note, the edge_cluster_id in DhcpProfile can NOT be
     * changed by this PUT operation because all existing DHCP leases will lost. If
     * losing leases is not a problem, a dedicated re-allocation API is suggested to
     * modify the edge-cluster-id, i.e. \"POST
     * /api/v1/dhcp/dhcp-profiles/<profileiid>?action=reallocate\". Meanwhile, if the
     * edge_cluster_member_indexes was specified currently but now is changed to none
     * (not specified) via a PUT operation, the edge nodes will not be auto-selected
     * from edge cluster. Instead, the previously-allocated edge nodes will continue to
     * be used by the DHCP server. This is because changing both edge nodes of a DHCP
     * server will lose all existing leases. In case re-allocation is required and
     * leases lost is not a problem (or can be recovered), please invoke the reallocate
     * API mentioned above with new DhcpProfile to accomplish the intent.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param profileId (required)
     * @param dhcpProfile (required)
     * @return com.vmware.nsx.model.DhcpProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DhcpProfile update(java.lang.String profileId, com.vmware.nsx.model.DhcpProfile dhcpProfile);

    /**
     * If both the edge_cluster_member_indexes in the DhcpProfile are changed in a same
     * PUT API, e.g. change from [a,b] to [x,y], the current DHCP server leases will be
     * lost, which could cause the network crash due to ip conflicts. Hence the
     * suggestion is to change only one member index in one single update, e.g. from
     * [a, b] to [a,y]. Please note, the edge_cluster_id in DhcpProfile can NOT be
     * changed by this PUT operation because all existing DHCP leases will lost. If
     * losing leases is not a problem, a dedicated re-allocation API is suggested to
     * modify the edge-cluster-id, i.e. \"POST
     * /api/v1/dhcp/dhcp-profiles/<profileiid>?action=reallocate\". Meanwhile, if the
     * edge_cluster_member_indexes was specified currently but now is changed to none
     * (not specified) via a PUT operation, the edge nodes will not be auto-selected
     * from edge cluster. Instead, the previously-allocated edge nodes will continue to
     * be used by the DHCP server. This is because changing both edge nodes of a DHCP
     * server will lose all existing leases. In case re-allocation is required and
     * leases lost is not a problem (or can be recovered), please invoke the reallocate
     * API mentioned above with new DhcpProfile to accomplish the intent.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param profileId (required)
     * @param dhcpProfile (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DhcpProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DhcpProfile update(java.lang.String profileId, com.vmware.nsx.model.DhcpProfile dhcpProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If both the edge_cluster_member_indexes in the DhcpProfile are changed in a same
     * PUT API, e.g. change from [a,b] to [x,y], the current DHCP server leases will be
     * lost, which could cause the network crash due to ip conflicts. Hence the
     * suggestion is to change only one member index in one single update, e.g. from
     * [a, b] to [a,y]. Please note, the edge_cluster_id in DhcpProfile can NOT be
     * changed by this PUT operation because all existing DHCP leases will lost. If
     * losing leases is not a problem, a dedicated re-allocation API is suggested to
     * modify the edge-cluster-id, i.e. \"POST
     * /api/v1/dhcp/dhcp-profiles/<profileiid>?action=reallocate\". Meanwhile, if the
     * edge_cluster_member_indexes was specified currently but now is changed to none
     * (not specified) via a PUT operation, the edge nodes will not be auto-selected
     * from edge cluster. Instead, the previously-allocated edge nodes will continue to
     * be used by the DHCP server. This is because changing both edge nodes of a DHCP
     * server will lose all existing leases. In case re-allocation is required and
     * leases lost is not a problem (or can be recovered), please invoke the reallocate
     * API mentioned above with new DhcpProfile to accomplish the intent.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DhcpProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId (required)
     * @param dhcpProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String profileId, com.vmware.nsx.model.DhcpProfile dhcpProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DhcpProfile> asyncCallback);

    /**
     * If both the edge_cluster_member_indexes in the DhcpProfile are changed in a same
     * PUT API, e.g. change from [a,b] to [x,y], the current DHCP server leases will be
     * lost, which could cause the network crash due to ip conflicts. Hence the
     * suggestion is to change only one member index in one single update, e.g. from
     * [a, b] to [a,y]. Please note, the edge_cluster_id in DhcpProfile can NOT be
     * changed by this PUT operation because all existing DHCP leases will lost. If
     * losing leases is not a problem, a dedicated re-allocation API is suggested to
     * modify the edge-cluster-id, i.e. \"POST
     * /api/v1/dhcp/dhcp-profiles/<profileiid>?action=reallocate\". Meanwhile, if the
     * edge_cluster_member_indexes was specified currently but now is changed to none
     * (not specified) via a PUT operation, the edge nodes will not be auto-selected
     * from edge cluster. Instead, the previously-allocated edge nodes will continue to
     * be used by the DHCP server. This is because changing both edge nodes of a DHCP
     * server will lose all existing leases. In case re-allocation is required and
     * leases lost is not a problem (or can be recovered), please invoke the reallocate
     * API mentioned above with new DhcpProfile to accomplish the intent.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DhcpProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param profileId (required)
     * @param dhcpProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String profileId, com.vmware.nsx.model.DhcpProfile dhcpProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DhcpProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
