/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.directory.domains.
 * Used by client-side stubs.
 */

package com.vmware.nsx.directory.domains;

public interface Groups extends com.vmware.vapi.bindings.Service, com.vmware.nsx.directory.domains.GroupsTypes {

    /**
     * Search for directory groups within a domain based on the substring of a
     * distinguished name. (e.g. CN=User,DC=acme,DC=com) The search filter pattern can
     * optionally support multiple (up to 100 maximum) search pattern separated by '|'
     * (url encoded %7C). In this case, the search results will be returned as the
     * union of all matching criteria. (e.g.
     * CN=Ann,CN=Users,DC=acme,DC=com|CN=Bob,CN=Users,DC=acme,DC=com) <br/> <br/> Use
     * the following Policy API - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/groups
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Directory domain identifier (required)
     * @param filterValue Name search filter value (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.DirectoryGroupListResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DirectoryGroupListResults list(java.lang.String domainId, java.lang.String filterValue, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Search for directory groups within a domain based on the substring of a
     * distinguished name. (e.g. CN=User,DC=acme,DC=com) The search filter pattern can
     * optionally support multiple (up to 100 maximum) search pattern separated by '|'
     * (url encoded %7C). In this case, the search results will be returned as the
     * union of all matching criteria. (e.g.
     * CN=Ann,CN=Users,DC=acme,DC=com|CN=Bob,CN=Users,DC=acme,DC=com) <br/> <br/> Use
     * the following Policy API - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/groups
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Directory domain identifier (required)
     * @param filterValue Name search filter value (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DirectoryGroupListResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DirectoryGroupListResults list(java.lang.String domainId, java.lang.String filterValue, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Search for directory groups within a domain based on the substring of a
     * distinguished name. (e.g. CN=User,DC=acme,DC=com) The search filter pattern can
     * optionally support multiple (up to 100 maximum) search pattern separated by '|'
     * (url encoded %7C). In this case, the search results will be returned as the
     * union of all matching criteria. (e.g.
     * CN=Ann,CN=Users,DC=acme,DC=com|CN=Bob,CN=Users,DC=acme,DC=com) <br/> <br/> Use
     * the following Policy API - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/groups
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DirectoryGroupListResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param filterValue Name search filter value (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String domainId, java.lang.String filterValue, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DirectoryGroupListResults> asyncCallback);

    /**
     * Search for directory groups within a domain based on the substring of a
     * distinguished name. (e.g. CN=User,DC=acme,DC=com) The search filter pattern can
     * optionally support multiple (up to 100 maximum) search pattern separated by '|'
     * (url encoded %7C). In this case, the search results will be returned as the
     * union of all matching criteria. (e.g.
     * CN=Ann,CN=Users,DC=acme,DC=com|CN=Bob,CN=Users,DC=acme,DC=com) <br/> <br/> Use
     * the following Policy API - <br/> GET
     * /policy/api/v1/infra/firewall-identity-stores/<firewall-identity-store-id>/groups
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DirectoryGroupListResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param domainId Directory domain identifier (required)
     * @param filterValue Name search filter value (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String domainId, java.lang.String filterValue, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DirectoryGroupListResults> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
