/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.dns.forwarders.
 * Used by client-side stubs.
 */

package com.vmware.nsx.dns.forwarders;

public interface Nslookup extends com.vmware.vapi.bindings.Service, com.vmware.nsx.dns.forwarders.NslookupTypes {

    /**
     * Query the nameserver for an ip-address or a FQDN of the given an address
     * optionally using an specified DNS server. If the address is a fqdn, nslookup
     * will resolve ip-address with it. If the address is an ip-address, do a reverse
     * lookup and answer fqdn(s).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param forwarderId (required)
     * @param address IP address or FQDN for nslookup (optional)
     * @param serverIp IPv4 address (optional)
     * @param sourceIp IPv4 address (optional)
     * @return com.vmware.nsx.model.DnsAnswer
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DnsAnswer get(java.lang.String forwarderId, java.lang.String address, java.lang.String serverIp, java.lang.String sourceIp);

    /**
     * Query the nameserver for an ip-address or a FQDN of the given an address
     * optionally using an specified DNS server. If the address is a fqdn, nslookup
     * will resolve ip-address with it. If the address is an ip-address, do a reverse
     * lookup and answer fqdn(s).
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param forwarderId (required)
     * @param address IP address or FQDN for nslookup (optional)
     * @param serverIp IPv4 address (optional)
     * @param sourceIp IPv4 address (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DnsAnswer
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DnsAnswer get(java.lang.String forwarderId, java.lang.String address, java.lang.String serverIp, java.lang.String sourceIp, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Query the nameserver for an ip-address or a FQDN of the given an address
     * optionally using an specified DNS server. If the address is a fqdn, nslookup
     * will resolve ip-address with it. If the address is an ip-address, do a reverse
     * lookup and answer fqdn(s).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DnsAnswer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param forwarderId (required)
     * @param address IP address or FQDN for nslookup (optional)
     * @param serverIp IPv4 address (optional)
     * @param sourceIp IPv4 address (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String forwarderId, java.lang.String address, java.lang.String serverIp, java.lang.String sourceIp, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DnsAnswer> asyncCallback);

    /**
     * Query the nameserver for an ip-address or a FQDN of the given an address
     * optionally using an specified DNS server. If the address is a fqdn, nslookup
     * will resolve ip-address with it. If the address is an ip-address, do a reverse
     * lookup and answer fqdn(s).
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DnsAnswer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param forwarderId (required)
     * @param address IP address or FQDN for nslookup (optional)
     * @param serverIp IPv4 address (optional)
     * @param sourceIp IPv4 address (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String forwarderId, java.lang.String address, java.lang.String serverIp, java.lang.String sourceIp, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DnsAnswer> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
