/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.firewall.
 * Used by client-side stubs.
 */

package com.vmware.nsx.firewall;

public interface Sections extends com.vmware.vapi.bindings.Service, com.vmware.nsx.firewall.SectionsTypes {

    /**
     * Creates new empty firewall section in the system. <br/> <br/> Use the following
     * Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param firewallSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @return com.vmware.nsx.model.FirewallSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSection create(com.vmware.nsx.model.FirewallSection firewallSection, java.lang.String id, java.lang.String operation);

    /**
     * Creates new empty firewall section in the system. <br/> <br/> Use the following
     * Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param firewallSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSection create(com.vmware.nsx.model.FirewallSection firewallSection, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates new empty firewall section in the system. <br/> <br/> Use the following
     * Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param firewallSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.FirewallSection firewallSection, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSection> asyncCallback);

    /**
     * Creates new empty firewall section in the system. <br/> <br/> Use the following
     * Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param firewallSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.FirewallSection firewallSection, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Creates a new firewall section with rules. The limit on the number of rules is
     * defined by maxItems in collection types for FirewallRule (FirewallRuleXXXList
     * types). When invoked on a section with a large number of rules, this API is
     * supported only at low rates of invocation (not more than 4-5 times per minute).
     * The typical latency of this API with about 1024 rules is about 4-5 seconds. This
     * API should not be invoked with large payloads at automation speeds. More than 50
     * rules with a large number of rule references is not supported. Instead, to
     * create sections, use: POST /api/v1/firewall/sections To create rules, use: POST
     * /api/v1/firewall/sections/<section-id>/rules <br/> <br/> Use the following
     * Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param firewallSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @return com.vmware.nsx.model.FirewallSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSectionRuleList createwithrules(com.vmware.nsx.model.FirewallSectionRuleList firewallSectionRuleList, java.lang.String id, java.lang.String operation);

    /**
     * Creates a new firewall section with rules. The limit on the number of rules is
     * defined by maxItems in collection types for FirewallRule (FirewallRuleXXXList
     * types). When invoked on a section with a large number of rules, this API is
     * supported only at low rates of invocation (not more than 4-5 times per minute).
     * The typical latency of this API with about 1024 rules is about 4-5 seconds. This
     * API should not be invoked with large payloads at automation speeds. More than 50
     * rules with a large number of rule references is not supported. Instead, to
     * create sections, use: POST /api/v1/firewall/sections To create rules, use: POST
     * /api/v1/firewall/sections/<section-id>/rules <br/> <br/> Use the following
     * Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param firewallSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSectionRuleList createwithrules(com.vmware.nsx.model.FirewallSectionRuleList firewallSectionRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a new firewall section with rules. The limit on the number of rules is
     * defined by maxItems in collection types for FirewallRule (FirewallRuleXXXList
     * types). When invoked on a section with a large number of rules, this API is
     * supported only at low rates of invocation (not more than 4-5 times per minute).
     * The typical latency of this API with about 1024 rules is about 4-5 seconds. This
     * API should not be invoked with large payloads at automation speeds. More than 50
     * rules with a large number of rule references is not supported. Instead, to
     * create sections, use: POST /api/v1/firewall/sections To create rules, use: POST
     * /api/v1/firewall/sections/<section-id>/rules <br/> <br/> Use the following
     * Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param firewallSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void createwithrules(com.vmware.nsx.model.FirewallSectionRuleList firewallSectionRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSectionRuleList> asyncCallback);

    /**
     * Creates a new firewall section with rules. The limit on the number of rules is
     * defined by maxItems in collection types for FirewallRule (FirewallRuleXXXList
     * types). When invoked on a section with a large number of rules, this API is
     * supported only at low rates of invocation (not more than 4-5 times per minute).
     * The typical latency of this API with about 1024 rules is about 4-5 seconds. This
     * API should not be invoked with large payloads at automation speeds. More than 50
     * rules with a large number of rule references is not supported. Instead, to
     * create sections, use: POST /api/v1/firewall/sections To create rules, use: POST
     * /api/v1/firewall/sections/<section-id>/rules <br/> <br/> Use the following
     * Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param firewallSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void createwithrules(com.vmware.nsx.model.FirewallSectionRuleList firewallSectionRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSectionRuleList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Removes firewall section from the system. Firewall section with rules can only
     * be deleted by passing \"cascade=true\" parameter. <br/> <br/> Use the following
     * Policy API - <br/> DELETE
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param cascade Flag to cascade delete of this object to all it's child objects. (optional,
     * default to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String sectionId, java.lang.Boolean cascade);

    /**
     * Removes firewall section from the system. Firewall section with rules can only
     * be deleted by passing \"cascade=true\" parameter. <br/> <br/> Use the following
     * Policy API - <br/> DELETE
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param cascade Flag to cascade delete of this object to all it's child objects. (optional,
     * default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String sectionId, java.lang.Boolean cascade, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Removes firewall section from the system. Firewall section with rules can only
     * be deleted by passing \"cascade=true\" parameter. <br/> <br/> Use the following
     * Policy API - <br/> DELETE
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param cascade Flag to cascade delete of this object to all it's child objects. (optional,
     * default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String sectionId, java.lang.Boolean cascade, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Removes firewall section from the system. Firewall section with rules can only
     * be deleted by passing \"cascade=true\" parameter. <br/> <br/> Use the following
     * Policy API - <br/> DELETE
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param cascade Flag to cascade delete of this object to all it's child objects. (optional,
     * default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String sectionId, java.lang.Boolean cascade, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about firewall section for the identifier. <br/> <br/> Use
     * the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @return com.vmware.nsx.model.FirewallSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSection get(java.lang.String sectionId);

    /**
     * Returns information about firewall section for the identifier. <br/> <br/> Use
     * the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSection get(java.lang.String sectionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about firewall section for the identifier. <br/> <br/> Use
     * the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String sectionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSection> asyncCallback);

    /**
     * Returns information about firewall section for the identifier. <br/> <br/> Use
     * the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String sectionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     *
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param appliedTos AppliedTo's referenced by this section or section's Distributed Service Rules .
     * (optional)
     * @param contextProfiles Limits results to sections having rules with specific Context Profiles.
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param deepSearch Toggle to search with direct or indirect references. (optional, default to
     * false)
     * @param destinations Destinations referenced by this section's Distributed Service Rules . (optional)
     * @param enforcedOn Type of attachment for logical port; for query only. (optional)
     * @param excludeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param extendedSources Limits results to sections having rules with specific Extended Sources.
     * (optional)
     * @param filterType Filter type (optional, default to FILTER)
     * @param includeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param locked Limit results to sections which are locked/unlocked (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param searchInvalidReferences Return invalid references in results. (optional, default to false)
     * @param searchScope Limit result to sections of a specific enforcement point (optional)
     * @param services NSService referenced by this section's Distributed Service Rules . (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param sources Sources referenced by this section's Distributed Service Rules . (optional)
     * @param type Section Type (optional, default to LAYER3)
     * @return com.vmware.nsx.model.FirewallSectionListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSectionListResult list(java.lang.String appliedTos, java.lang.String contextProfiles, java.lang.String cursor, java.lang.Boolean deepSearch, java.lang.String destinations, java.lang.String enforcedOn, java.lang.String excludeAppliedToType, java.lang.String extendedSources, java.lang.String filterType, java.lang.String includeAppliedToType, java.lang.String includedFields, java.lang.Boolean locked, java.lang.Long pageSize, java.lang.Boolean searchInvalidReferences, java.lang.String searchScope, java.lang.String services, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String sources, java.lang.String type);

    /**
     *
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param appliedTos AppliedTo's referenced by this section or section's Distributed Service Rules .
     * (optional)
     * @param contextProfiles Limits results to sections having rules with specific Context Profiles.
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param deepSearch Toggle to search with direct or indirect references. (optional, default to
     * false)
     * @param destinations Destinations referenced by this section's Distributed Service Rules . (optional)
     * @param enforcedOn Type of attachment for logical port; for query only. (optional)
     * @param excludeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param extendedSources Limits results to sections having rules with specific Extended Sources.
     * (optional)
     * @param filterType Filter type (optional, default to FILTER)
     * @param includeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param locked Limit results to sections which are locked/unlocked (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param searchInvalidReferences Return invalid references in results. (optional, default to false)
     * @param searchScope Limit result to sections of a specific enforcement point (optional)
     * @param services NSService referenced by this section's Distributed Service Rules . (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param sources Sources referenced by this section's Distributed Service Rules . (optional)
     * @param type Section Type (optional, default to LAYER3)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallSectionListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSectionListResult list(java.lang.String appliedTos, java.lang.String contextProfiles, java.lang.String cursor, java.lang.Boolean deepSearch, java.lang.String destinations, java.lang.String enforcedOn, java.lang.String excludeAppliedToType, java.lang.String extendedSources, java.lang.String filterType, java.lang.String includeAppliedToType, java.lang.String includedFields, java.lang.Boolean locked, java.lang.Long pageSize, java.lang.Boolean searchInvalidReferences, java.lang.String searchScope, java.lang.String services, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String sources, java.lang.String type, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     *
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSectionListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param appliedTos AppliedTo's referenced by this section or section's Distributed Service Rules .
     * (optional)
     * @param contextProfiles Limits results to sections having rules with specific Context Profiles.
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param deepSearch Toggle to search with direct or indirect references. (optional, default to
     * false)
     * @param destinations Destinations referenced by this section's Distributed Service Rules . (optional)
     * @param enforcedOn Type of attachment for logical port; for query only. (optional)
     * @param excludeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param extendedSources Limits results to sections having rules with specific Extended Sources.
     * (optional)
     * @param filterType Filter type (optional, default to FILTER)
     * @param includeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param locked Limit results to sections which are locked/unlocked (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param searchInvalidReferences Return invalid references in results. (optional, default to false)
     * @param searchScope Limit result to sections of a specific enforcement point (optional)
     * @param services NSService referenced by this section's Distributed Service Rules . (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param sources Sources referenced by this section's Distributed Service Rules . (optional)
     * @param type Section Type (optional, default to LAYER3)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String appliedTos, java.lang.String contextProfiles, java.lang.String cursor, java.lang.Boolean deepSearch, java.lang.String destinations, java.lang.String enforcedOn, java.lang.String excludeAppliedToType, java.lang.String extendedSources, java.lang.String filterType, java.lang.String includeAppliedToType, java.lang.String includedFields, java.lang.Boolean locked, java.lang.Long pageSize, java.lang.Boolean searchInvalidReferences, java.lang.String searchScope, java.lang.String services, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String sources, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSectionListResult> asyncCallback);

    /**
     *
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSectionListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param appliedTos AppliedTo's referenced by this section or section's Distributed Service Rules .
     * (optional)
     * @param contextProfiles Limits results to sections having rules with specific Context Profiles.
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param deepSearch Toggle to search with direct or indirect references. (optional, default to
     * false)
     * @param destinations Destinations referenced by this section's Distributed Service Rules . (optional)
     * @param enforcedOn Type of attachment for logical port; for query only. (optional)
     * @param excludeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param extendedSources Limits results to sections having rules with specific Extended Sources.
     * (optional)
     * @param filterType Filter type (optional, default to FILTER)
     * @param includeAppliedToType Resource type valid for use as AppliedTo filter in section API (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param locked Limit results to sections which are locked/unlocked (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param searchInvalidReferences Return invalid references in results. (optional, default to false)
     * @param searchScope Limit result to sections of a specific enforcement point (optional)
     * @param services NSService referenced by this section's Distributed Service Rules . (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param sources Sources referenced by this section's Distributed Service Rules . (optional)
     * @param type Section Type (optional, default to LAYER3)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String appliedTos, java.lang.String contextProfiles, java.lang.String cursor, java.lang.Boolean deepSearch, java.lang.String destinations, java.lang.String enforcedOn, java.lang.String excludeAppliedToType, java.lang.String extendedSources, java.lang.String filterType, java.lang.String includeAppliedToType, java.lang.String includedFields, java.lang.Boolean locked, java.lang.Long pageSize, java.lang.Boolean searchInvalidReferences, java.lang.String searchScope, java.lang.String services, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String sources, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSectionListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns firewall section information with rules for a section identifier. When
     * invoked on a section with a large number of rules, this API is supported only at
     * low rates of invocation (not more than 4-5 times per minute). The typical
     * latency of this API with about 1024 rules is about 4-5 seconds. This API should
     * not be invoked with large payloads at automation speeds. More than 50 rules with
     * a large number rule references is not supported. Instead, to read firewall
     * rules, use: GET /api/v1/firewall/sections/<section-id>/rules with the
     * appropriate page_size. <br/> <br/> Use the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @return com.vmware.nsx.model.FirewallSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSectionRuleList listwithrules(java.lang.String sectionId);

    /**
     * Returns firewall section information with rules for a section identifier. When
     * invoked on a section with a large number of rules, this API is supported only at
     * low rates of invocation (not more than 4-5 times per minute). The typical
     * latency of this API with about 1024 rules is about 4-5 seconds. This API should
     * not be invoked with large payloads at automation speeds. More than 50 rules with
     * a large number rule references is not supported. Instead, to read firewall
     * rules, use: GET /api/v1/firewall/sections/<section-id>/rules with the
     * appropriate page_size. <br/> <br/> Use the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSectionRuleList listwithrules(java.lang.String sectionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns firewall section information with rules for a section identifier. When
     * invoked on a section with a large number of rules, this API is supported only at
     * low rates of invocation (not more than 4-5 times per minute). The typical
     * latency of this API with about 1024 rules is about 4-5 seconds. This API should
     * not be invoked with large payloads at automation speeds. More than 50 rules with
     * a large number rule references is not supported. Instead, to read firewall
     * rules, use: GET /api/v1/firewall/sections/<section-id>/rules with the
     * appropriate page_size. <br/> <br/> Use the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void listwithrules(java.lang.String sectionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSectionRuleList> asyncCallback);

    /**
     * Returns firewall section information with rules for a section identifier. When
     * invoked on a section with a large number of rules, this API is supported only at
     * low rates of invocation (not more than 4-5 times per minute). The typical
     * latency of this API with about 1024 rules is about 4-5 seconds. This API should
     * not be invoked with large payloads at automation speeds. More than 50 rules with
     * a large number rule references is not supported. Instead, to read firewall
     * rules, use: GET /api/v1/firewall/sections/<section-id>/rules with the
     * appropriate page_size. <br/> <br/> Use the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void listwithrules(java.lang.String sectionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSectionRuleList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Lock a section. <br/> <br/> Use the following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param firewallSectionLock (required)
     * @return com.vmware.nsx.model.FirewallSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.ResourceBusy  Locked
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSection lock(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionLock firewallSectionLock);

    /**
     * Lock a section. <br/> <br/> Use the following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param firewallSectionLock (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.ResourceBusy  Locked
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSection lock(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionLock firewallSectionLock, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Lock a section. <br/> <br/> Use the following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.ResourceBusy} -  Locked<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallSectionLock (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void lock(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionLock firewallSectionLock, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSection> asyncCallback);

    /**
     * Lock a section. <br/> <br/> Use the following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.ResourceBusy} -  Locked<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallSectionLock (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void lock(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionLock firewallSectionLock, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies an existing firewall section along with its relative position among
     * other firewall sections in the system. Simultaneous update (modify) operations
     * on same section are not allowed to prevent overwriting stale contents to
     * firewall section. If a concurrent update is performed, HTTP response code 409
     * will be returned to the client operating on stale data. That client should
     * retrieve the firewall section again and re-apply its update. <br/> <br/> Use the
     * following Policy API - <br/> POST
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>?action=revise
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param firewallSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @return com.vmware.nsx.model.FirewallSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSection revise(java.lang.String sectionId, com.vmware.nsx.model.FirewallSection firewallSection, java.lang.String id, java.lang.String operation);

    /**
     * Modifies an existing firewall section along with its relative position among
     * other firewall sections in the system. Simultaneous update (modify) operations
     * on same section are not allowed to prevent overwriting stale contents to
     * firewall section. If a concurrent update is performed, HTTP response code 409
     * will be returned to the client operating on stale data. That client should
     * retrieve the firewall section again and re-apply its update. <br/> <br/> Use the
     * following Policy API - <br/> POST
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>?action=revise
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param firewallSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSection revise(java.lang.String sectionId, com.vmware.nsx.model.FirewallSection firewallSection, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies an existing firewall section along with its relative position among
     * other firewall sections in the system. Simultaneous update (modify) operations
     * on same section are not allowed to prevent overwriting stale contents to
     * firewall section. If a concurrent update is performed, HTTP response code 409
     * will be returned to the client operating on stale data. That client should
     * retrieve the firewall section again and re-apply its update. <br/> <br/> Use the
     * following Policy API - <br/> POST
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>?action=revise
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void revise(java.lang.String sectionId, com.vmware.nsx.model.FirewallSection firewallSection, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSection> asyncCallback);

    /**
     * Modifies an existing firewall section along with its relative position among
     * other firewall sections in the system. Simultaneous update (modify) operations
     * on same section are not allowed to prevent overwriting stale contents to
     * firewall section. If a concurrent update is performed, HTTP response code 409
     * will be returned to the client operating on stale data. That client should
     * retrieve the firewall section again and re-apply its update. <br/> <br/> Use the
     * following Policy API - <br/> POST
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>?action=revise
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallSection (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void revise(java.lang.String sectionId, com.vmware.nsx.model.FirewallSection firewallSection, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies an existing firewall section along with its relative position among
     * other firewall sections with rules. When invoked on a large number of rules,
     * this API is supported only at low rates of invocation (not more than 2 times per
     * minute). The typical latency of this API with about 1024 rules is about 15
     * seconds in a cluster setup. This API should not be invoked with large payloads
     * at automation speeds. Instead, to move a section above or below another section,
     * use: POST /api/v1/firewall/sections/<section-id>?action=revise To modify rules,
     * use: PUT /api/v1/firewall/sections/<section-id>/rules/<rule-id> Simultaneous
     * update (modify) operations on same section are not allowed to prevent
     * overwriting stale contents to firewall section. If a concurrent update is
     * performed, HTTP response code 409 will be returned to the client operating on
     * stale data. That client should retrieve the firewall section again and re-apply
     * its update. <br/> <br/> Use the following Policy API - <br/> POST
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>?action=revise
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param firewallSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @return com.vmware.nsx.model.FirewallSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSectionRuleList revisewithrules(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionRuleList firewallSectionRuleList, java.lang.String id, java.lang.String operation);

    /**
     * Modifies an existing firewall section along with its relative position among
     * other firewall sections with rules. When invoked on a large number of rules,
     * this API is supported only at low rates of invocation (not more than 2 times per
     * minute). The typical latency of this API with about 1024 rules is about 15
     * seconds in a cluster setup. This API should not be invoked with large payloads
     * at automation speeds. Instead, to move a section above or below another section,
     * use: POST /api/v1/firewall/sections/<section-id>?action=revise To modify rules,
     * use: PUT /api/v1/firewall/sections/<section-id>/rules/<rule-id> Simultaneous
     * update (modify) operations on same section are not allowed to prevent
     * overwriting stale contents to firewall section. If a concurrent update is
     * performed, HTTP response code 409 will be returned to the client operating on
     * stale data. That client should retrieve the firewall section again and re-apply
     * its update. <br/> <br/> Use the following Policy API - <br/> POST
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>?action=revise
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param firewallSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSectionRuleList revisewithrules(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionRuleList firewallSectionRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies an existing firewall section along with its relative position among
     * other firewall sections with rules. When invoked on a large number of rules,
     * this API is supported only at low rates of invocation (not more than 2 times per
     * minute). The typical latency of this API with about 1024 rules is about 15
     * seconds in a cluster setup. This API should not be invoked with large payloads
     * at automation speeds. Instead, to move a section above or below another section,
     * use: POST /api/v1/firewall/sections/<section-id>?action=revise To modify rules,
     * use: PUT /api/v1/firewall/sections/<section-id>/rules/<rule-id> Simultaneous
     * update (modify) operations on same section are not allowed to prevent
     * overwriting stale contents to firewall section. If a concurrent update is
     * performed, HTTP response code 409 will be returned to the client operating on
     * stale data. That client should retrieve the firewall section again and re-apply
     * its update. <br/> <br/> Use the following Policy API - <br/> POST
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>?action=revise
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void revisewithrules(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionRuleList firewallSectionRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSectionRuleList> asyncCallback);

    /**
     * Modifies an existing firewall section along with its relative position among
     * other firewall sections with rules. When invoked on a large number of rules,
     * this API is supported only at low rates of invocation (not more than 2 times per
     * minute). The typical latency of this API with about 1024 rules is about 15
     * seconds in a cluster setup. This API should not be invoked with large payloads
     * at automation speeds. Instead, to move a section above or below another section,
     * use: POST /api/v1/firewall/sections/<section-id>?action=revise To modify rules,
     * use: PUT /api/v1/firewall/sections/<section-id>/rules/<rule-id> Simultaneous
     * update (modify) operations on same section are not allowed to prevent
     * overwriting stale contents to firewall section. If a concurrent update is
     * performed, HTTP response code 409 will be returned to the client operating on
     * stale data. That client should retrieve the firewall section again and re-apply
     * its update. <br/> <br/> Use the following Policy API - <br/> POST
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>?action=revise
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallSectionRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void revisewithrules(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionRuleList firewallSectionRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSectionRuleList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Unlock a section. <br/> <br/> Use the following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param firewallSectionLock (required)
     * @return com.vmware.nsx.model.FirewallSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.ResourceBusy  Locked
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSection unlock(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionLock firewallSectionLock);

    /**
     * Unlock a section. <br/> <br/> Use the following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param firewallSectionLock (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.ResourceBusy  Locked
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSection unlock(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionLock firewallSectionLock, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Unlock a section. <br/> <br/> Use the following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.ResourceBusy} -  Locked<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallSectionLock (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void unlock(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionLock firewallSectionLock, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSection> asyncCallback);

    /**
     * Unlock a section. <br/> <br/> Use the following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.ResourceBusy} -  Locked<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallSectionLock (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void unlock(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionLock firewallSectionLock, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies the specified section, but does not modify the section's associated
     * rules. Simultaneous update (modify) operations on same section are not allowed
     * to prevent overwriting stale contents to firewall section. If a concurrent
     * update is performed, HTTP response code 409 will be returned to the client
     * operating on stale data. That client should retrieve the firewall section again
     * and re-apply its update. <br/> <br/> Use the following Policy API - <br/>
     * PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param firewallSection (required)
     * @return com.vmware.nsx.model.FirewallSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSection update(java.lang.String sectionId, com.vmware.nsx.model.FirewallSection firewallSection);

    /**
     * Modifies the specified section, but does not modify the section's associated
     * rules. Simultaneous update (modify) operations on same section are not allowed
     * to prevent overwriting stale contents to firewall section. If a concurrent
     * update is performed, HTTP response code 409 will be returned to the client
     * operating on stale data. That client should retrieve the firewall section again
     * and re-apply its update. <br/> <br/> Use the following Policy API - <br/>
     * PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param firewallSection (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallSection
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSection update(java.lang.String sectionId, com.vmware.nsx.model.FirewallSection firewallSection, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies the specified section, but does not modify the section's associated
     * rules. Simultaneous update (modify) operations on same section are not allowed
     * to prevent overwriting stale contents to firewall section. If a concurrent
     * update is performed, HTTP response code 409 will be returned to the client
     * operating on stale data. That client should retrieve the firewall section again
     * and re-apply its update. <br/> <br/> Use the following Policy API - <br/>
     * PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallSection (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String sectionId, com.vmware.nsx.model.FirewallSection firewallSection, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSection> asyncCallback);

    /**
     * Modifies the specified section, but does not modify the section's associated
     * rules. Simultaneous update (modify) operations on same section are not allowed
     * to prevent overwriting stale contents to firewall section. If a concurrent
     * update is performed, HTTP response code 409 will be returned to the client
     * operating on stale data. That client should retrieve the firewall section again
     * and re-apply its update. <br/> <br/> Use the following Policy API - <br/>
     * PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallSection (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String sectionId, com.vmware.nsx.model.FirewallSection firewallSection, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies existing firewall section along with its association with rules. When
     * invoked on a large number of rules, this API is supported only at low rates of
     * invocation (not more than 2 times per minute). The typical latency of this API
     * with about 1024 rules is about 15 seconds in a cluster setup. This API should
     * not be invoked with large payloads at automation speeds. Instead, to update rule
     * content, use: PUT /api/v1/firewall/sections/<section-id>/rules/<rule-id>
     * Simultaneous update (modify) operations on same section are not allowed to
     * prevent overwriting stale contents to firewall section. If a concurrent update
     * is performed, HTTP response code 409 will be returned to the client operating on
     * stale data. That client should retrieve the firewall section again and re-apply
     * its update. <br/> <br/> Use the following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param firewallSectionRuleList (required)
     * @return com.vmware.nsx.model.FirewallSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSectionRuleList updatewithrules(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionRuleList firewallSectionRuleList);

    /**
     * Modifies existing firewall section along with its association with rules. When
     * invoked on a large number of rules, this API is supported only at low rates of
     * invocation (not more than 2 times per minute). The typical latency of this API
     * with about 1024 rules is about 15 seconds in a cluster setup. This API should
     * not be invoked with large payloads at automation speeds. Instead, to update rule
     * content, use: PUT /api/v1/firewall/sections/<section-id>/rules/<rule-id>
     * Simultaneous update (modify) operations on same section are not allowed to
     * prevent overwriting stale contents to firewall section. If a concurrent update
     * is performed, HTTP response code 409 will be returned to the client operating on
     * stale data. That client should retrieve the firewall section again and re-apply
     * its update. <br/> <br/> Use the following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param firewallSectionRuleList (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallSectionRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallSectionRuleList updatewithrules(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionRuleList firewallSectionRuleList, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies existing firewall section along with its association with rules. When
     * invoked on a large number of rules, this API is supported only at low rates of
     * invocation (not more than 2 times per minute). The typical latency of this API
     * with about 1024 rules is about 15 seconds in a cluster setup. This API should
     * not be invoked with large payloads at automation speeds. Instead, to update rule
     * content, use: PUT /api/v1/firewall/sections/<section-id>/rules/<rule-id>
     * Simultaneous update (modify) operations on same section are not allowed to
     * prevent overwriting stale contents to firewall section. If a concurrent update
     * is performed, HTTP response code 409 will be returned to the client operating on
     * stale data. That client should retrieve the firewall section again and re-apply
     * its update. <br/> <br/> Use the following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallSectionRuleList (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void updatewithrules(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionRuleList firewallSectionRuleList, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSectionRuleList> asyncCallback);

    /**
     * Modifies existing firewall section along with its association with rules. When
     * invoked on a large number of rules, this API is supported only at low rates of
     * invocation (not more than 2 times per minute). The typical latency of this API
     * with about 1024 rules is about 15 seconds in a cluster setup. This API should
     * not be invoked with large payloads at automation speeds. Instead, to update rule
     * content, use: PUT /api/v1/firewall/sections/<section-id>/rules/<rule-id>
     * Simultaneous update (modify) operations on same section are not allowed to
     * prevent overwriting stale contents to firewall section. If a concurrent update
     * is performed, HTTP response code 409 will be returned to the client operating on
     * stale data. That client should retrieve the firewall section again and re-apply
     * its update. <br/> <br/> Use the following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallSectionRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallSectionRuleList (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void updatewithrules(java.lang.String sectionId, com.vmware.nsx.model.FirewallSectionRuleList firewallSectionRuleList, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallSectionRuleList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
