/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.firewall.rules.
 * Used by client-side stubs.
 */

package com.vmware.nsx.firewall.rules;

public interface State extends com.vmware.vapi.bindings.Service, com.vmware.nsx.firewall.rules.StateTypes {

    /**
     * Return realized state information of a firewall rule. Returned response is same
     * as rule's section realization state response. <br/> <br/> Use the following
     * Policy APIs - <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entities?intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     * <br/> GET
     * /policy/api/v1/infra/realized-state/status?intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     * <br/> GET
     * /policy/api/v1/infra/realized-state/status?include_enforced_status=true&intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ruleId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @return com.vmware.nsx.model.RuleState
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.RuleState get(java.lang.String ruleId, java.lang.Long barrierId, java.lang.String requestId);

    /**
     * Return realized state information of a firewall rule. Returned response is same
     * as rule's section realization state response. <br/> <br/> Use the following
     * Policy APIs - <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entities?intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     * <br/> GET
     * /policy/api/v1/infra/realized-state/status?intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     * <br/> GET
     * /policy/api/v1/infra/realized-state/status?include_enforced_status=true&intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ruleId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.RuleState
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.RuleState get(java.lang.String ruleId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return realized state information of a firewall rule. Returned response is same
     * as rule's section realization state response. <br/> <br/> Use the following
     * Policy APIs - <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entities?intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     * <br/> GET
     * /policy/api/v1/infra/realized-state/status?intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     * <br/> GET
     * /policy/api/v1/infra/realized-state/status?include_enforced_status=true&intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.RuleState
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param ruleId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String ruleId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.RuleState> asyncCallback);

    /**
     * Return realized state information of a firewall rule. Returned response is same
     * as rule's section realization state response. <br/> <br/> Use the following
     * Policy APIs - <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entities?intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     * <br/> GET
     * /policy/api/v1/infra/realized-state/status?intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     * <br/> GET
     * /policy/api/v1/infra/realized-state/status?include_enforced_status=true&intent_path=/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.RuleState
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param ruleId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String ruleId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.RuleState> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
