/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.firewall.sections.rules.
 * Used by client-side stubs.
 */

package com.vmware.nsx.firewall.sections.rules;

public interface Stats extends com.vmware.vapi.bindings.Service, com.vmware.nsx.firewall.sections.rules.StatsTypes {

    /**
     * Get aggregated statistics for all rules for a given firewall section. The API
     * only supports access to cached (source=cached) statistical data collected
     * offline in the system. Data includes total number of packets, bytes, sessions
     * counters and popularity index for a firewall rule and overall session count, max
     * session count and max popularity index for all firewall rules on transport nodes
     * or edge nodes. Aggregated statistics like maximum popularity index, maximum
     * session count and total session count are computed with lower frequency compared
     * to individual generic rule statistics, hence they may have a computation delay
     * up to 15 minutes to reflect in response to this API. <br/> <br/> Use the
     * following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/statistics
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param source Data source type. (optional)
     * @return com.vmware.nsx.model.FirewallStatsList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallStatsList get(java.lang.String sectionId, java.lang.String source);

    /**
     * Get aggregated statistics for all rules for a given firewall section. The API
     * only supports access to cached (source=cached) statistical data collected
     * offline in the system. Data includes total number of packets, bytes, sessions
     * counters and popularity index for a firewall rule and overall session count, max
     * session count and max popularity index for all firewall rules on transport nodes
     * or edge nodes. Aggregated statistics like maximum popularity index, maximum
     * session count and total session count are computed with lower frequency compared
     * to individual generic rule statistics, hence they may have a computation delay
     * up to 15 minutes to reflect in response to this API. <br/> <br/> Use the
     * following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/statistics
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param source Data source type. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallStatsList
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallStatsList get(java.lang.String sectionId, java.lang.String source, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get aggregated statistics for all rules for a given firewall section. The API
     * only supports access to cached (source=cached) statistical data collected
     * offline in the system. Data includes total number of packets, bytes, sessions
     * counters and popularity index for a firewall rule and overall session count, max
     * session count and max popularity index for all firewall rules on transport nodes
     * or edge nodes. Aggregated statistics like maximum popularity index, maximum
     * session count and total session count are computed with lower frequency compared
     * to individual generic rule statistics, hence they may have a computation delay
     * up to 15 minutes to reflect in response to this API. <br/> <br/> Use the
     * following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/statistics
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallStatsList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String sectionId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallStatsList> asyncCallback);

    /**
     * Get aggregated statistics for all rules for a given firewall section. The API
     * only supports access to cached (source=cached) statistical data collected
     * offline in the system. Data includes total number of packets, bytes, sessions
     * counters and popularity index for a firewall rule and overall session count, max
     * session count and max popularity index for all firewall rules on transport nodes
     * or edge nodes. Aggregated statistics like maximum popularity index, maximum
     * session count and total session count are computed with lower frequency compared
     * to individual generic rule statistics, hence they may have a computation delay
     * up to 15 minutes to reflect in response to this API. <br/> <br/> Use the
     * following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/statistics
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallStatsList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String sectionId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallStatsList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get aggregated statistics for a rule for given firewall section. The API only
     * supports access to cached (source=cached) statistical data collected offline in
     * the system. Data includes total number of packets, bytes, sessions counters and
     * popularity index for a firewall rule and overall session count, max session
     * count and max popularity index for all firewall rules on transport nodes or edge
     * nodes. Aggregated statistics like maximum popularity index, maximum session
     * count and total session count are computed with lower frequency compared to
     * individual generic rule statistics, hence they may have a computation delay up
     * to 15 minutes to reflect in response to this API. <br/> <br/> Use the following
     * Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>/statistics
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param source Data source type. (optional)
     * @return com.vmware.nsx.model.FirewallStats
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallStats get0(java.lang.String sectionId, java.lang.String ruleId, java.lang.String source);

    /**
     * Get aggregated statistics for a rule for given firewall section. The API only
     * supports access to cached (source=cached) statistical data collected offline in
     * the system. Data includes total number of packets, bytes, sessions counters and
     * popularity index for a firewall rule and overall session count, max session
     * count and max popularity index for all firewall rules on transport nodes or edge
     * nodes. Aggregated statistics like maximum popularity index, maximum session
     * count and total session count are computed with lower frequency compared to
     * individual generic rule statistics, hence they may have a computation delay up
     * to 15 minutes to reflect in response to this API. <br/> <br/> Use the following
     * Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>/statistics
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param source Data source type. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallStats
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallStats get0(java.lang.String sectionId, java.lang.String ruleId, java.lang.String source, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get aggregated statistics for a rule for given firewall section. The API only
     * supports access to cached (source=cached) statistical data collected offline in
     * the system. Data includes total number of packets, bytes, sessions counters and
     * popularity index for a firewall rule and overall session count, max session
     * count and max popularity index for all firewall rules on transport nodes or edge
     * nodes. Aggregated statistics like maximum popularity index, maximum session
     * count and total session count are computed with lower frequency compared to
     * individual generic rule statistics, hence they may have a computation delay up
     * to 15 minutes to reflect in response to this API. <br/> <br/> Use the following
     * Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>/statistics
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallStats
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get0(java.lang.String sectionId, java.lang.String ruleId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallStats> asyncCallback);

    /**
     * Get aggregated statistics for a rule for given firewall section. The API only
     * supports access to cached (source=cached) statistical data collected offline in
     * the system. Data includes total number of packets, bytes, sessions counters and
     * popularity index for a firewall rule and overall session count, max session
     * count and max popularity index for all firewall rules on transport nodes or edge
     * nodes. Aggregated statistics like maximum popularity index, maximum session
     * count and total session count are computed with lower frequency compared to
     * individual generic rule statistics, hence they may have a computation delay up
     * to 15 minutes to reflect in response to this API. <br/> <br/> Use the following
     * Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>/statistics
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallStats
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get0(java.lang.String sectionId, java.lang.String ruleId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallStats> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
