/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.loadbalancer.services.
 * Used by client-side stubs.
 */

package com.vmware.nsx.loadbalancer.services;

public interface Status extends com.vmware.vapi.bindings.Service, com.vmware.nsx.loadbalancer.services.StatusTypes {

    /**
     * Returns the status of the given load balancer service.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param includeInstanceDetails Flag to indicate whether include detail information (optional, default to false)
     * @param source Data source type. (optional)
     * @param transportNodeIds The UUIDs of transport nodes (optional)
     * @return com.vmware.nsx.model.LbServiceStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LbServiceStatus get(java.lang.String serviceId, java.lang.Boolean includeInstanceDetails, java.lang.String source, java.lang.String transportNodeIds);

    /**
     * Returns the status of the given load balancer service.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param includeInstanceDetails Flag to indicate whether include detail information (optional, default to false)
     * @param source Data source type. (optional)
     * @param transportNodeIds The UUIDs of transport nodes (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LbServiceStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LbServiceStatus get(java.lang.String serviceId, java.lang.Boolean includeInstanceDetails, java.lang.String source, java.lang.String transportNodeIds, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the status of the given load balancer service.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LbServiceStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param includeInstanceDetails Flag to indicate whether include detail information (optional, default to false)
     * @param source Data source type. (optional)
     * @param transportNodeIds The UUIDs of transport nodes (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String serviceId, java.lang.Boolean includeInstanceDetails, java.lang.String source, java.lang.String transportNodeIds, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LbServiceStatus> asyncCallback);

    /**
     * Returns the status of the given load balancer service.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LbServiceStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param includeInstanceDetails Flag to indicate whether include detail information (optional, default to false)
     * @param source Data source type. (optional)
     * @param transportNodeIds The UUIDs of transport nodes (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String serviceId, java.lang.Boolean includeInstanceDetails, java.lang.String source, java.lang.String transportNodeIds, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LbServiceStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
