/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_ports.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_ports;

public interface MacTable extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_ports.MacTableTypes {

    /**
     * Returns MAC table of a specified logical port. If the target transport node id
     * is not provided, the NSX manager will ask the controller for the transport node
     * where the logical port is located. The query parameter \"source=cached\" is not
     * supported. MAC table retrieval is not supported on logical ports that are
     * attached to a logical router. <br/> <br/> This api is deprecated from 3.2.2.
     * Please use policy api - <br/>
     * /infra/segments/<segment-id>/ports/<segment-port-id>/mac-table
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param lportId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @return com.vmware.nsx.model.LogicalPortMacAddressListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPortMacAddressListResult list(java.lang.String lportId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId);

    /**
     * Returns MAC table of a specified logical port. If the target transport node id
     * is not provided, the NSX manager will ask the controller for the transport node
     * where the logical port is located. The query parameter \"source=cached\" is not
     * supported. MAC table retrieval is not supported on logical ports that are
     * attached to a logical router. <br/> <br/> This api is deprecated from 3.2.2.
     * Please use policy api - <br/>
     * /infra/segments/<segment-id>/ports/<segment-port-id>/mac-table
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param lportId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalPortMacAddressListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPortMacAddressListResult list(java.lang.String lportId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns MAC table of a specified logical port. If the target transport node id
     * is not provided, the NSX manager will ask the controller for the transport node
     * where the logical port is located. The query parameter \"source=cached\" is not
     * supported. MAC table retrieval is not supported on logical ports that are
     * attached to a logical router. <br/> <br/> This api is deprecated from 3.2.2.
     * Please use policy api - <br/>
     * /infra/segments/<segment-id>/ports/<segment-port-id>/mac-table
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPortMacAddressListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param lportId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String lportId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPortMacAddressListResult> asyncCallback);

    /**
     * Returns MAC table of a specified logical port. If the target transport node id
     * is not provided, the NSX manager will ask the controller for the transport node
     * where the logical port is located. The query parameter \"source=cached\" is not
     * supported. MAC table retrieval is not supported on logical ports that are
     * attached to a logical router. <br/> <br/> This api is deprecated from 3.2.2.
     * Please use policy api - <br/>
     * /infra/segments/<segment-id>/ports/<segment-port-id>/mac-table
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPortMacAddressListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param lportId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String lportId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPortMacAddressListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
