/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_ports.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_ports;

public interface Status extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_ports.StatusTypes {

    /**
     * Returns operational status of a specified logical port. <br/> <br/> This api is
     * deprecated from 3.2.2. Please use policy api - <br/>
     * /infra/segments/<segment-id>/ports/<segment-port-id>/status
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param lportId (required)
     * @param source Data source type. (optional)
     * @return com.vmware.nsx.model.LogicalPortOperationalStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPortOperationalStatus get(java.lang.String lportId, java.lang.String source);

    /**
     * Returns operational status of a specified logical port. <br/> <br/> This api is
     * deprecated from 3.2.2. Please use policy api - <br/>
     * /infra/segments/<segment-id>/ports/<segment-port-id>/status
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param lportId (required)
     * @param source Data source type. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalPortOperationalStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPortOperationalStatus get(java.lang.String lportId, java.lang.String source, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns operational status of a specified logical port. <br/> <br/> This api is
     * deprecated from 3.2.2. Please use policy api - <br/>
     * /infra/segments/<segment-id>/ports/<segment-port-id>/status
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPortOperationalStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param lportId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String lportId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPortOperationalStatus> asyncCallback);

    /**
     * Returns operational status of a specified logical port. <br/> <br/> This api is
     * deprecated from 3.2.2. Please use policy api - <br/>
     * /infra/segments/<segment-id>/ports/<segment-port-id>/status
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPortOperationalStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param lportId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String lportId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPortOperationalStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns operational status of all logical ports. The query parameter
     * \"source=realtime\" is not supported. Pagination is not supported for this API.
     * The query parameters \"cursor\", \"sort_ascending\", \"sort_by\", \"page_size\"
     * and \"included_fields\" will be ignored. <br/> <br/> This api is deprecated from
     * 3.2.2. Please use policy api - <br/>
     * /search/query?query=resource_type:SegmentPort&included_fields=id&included_fields=admin_state
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param attachmentId Logical Port attachment Id (optional)
     * @param attachmentType Type of attachment for logical port; for query only. (optional)
     * @param bridgeClusterId Bridge Cluster identifier (optional)
     * @param containerPortsOnly Only container VIF logical ports will be returned if true (optional, default to
     * false)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical port. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param logicalSwitchId Logical Switch identifier (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param parentVifId ID of the VIF of type PARENT (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param switchingProfileId Network Profile identifier (optional)
     * @param transportNodeId Transport node identifier (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @return com.vmware.nsx.model.LogicalPortStatusSummary
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPortStatusSummary getall(java.lang.String attachmentId, java.lang.String attachmentType, java.lang.String bridgeClusterId, java.lang.Boolean containerPortsOnly, java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.String logicalSwitchId, java.lang.Long pageSize, java.lang.String parentVifId, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String switchingProfileId, java.lang.String transportNodeId, java.lang.String transportZoneId);

    /**
     * Returns operational status of all logical ports. The query parameter
     * \"source=realtime\" is not supported. Pagination is not supported for this API.
     * The query parameters \"cursor\", \"sort_ascending\", \"sort_by\", \"page_size\"
     * and \"included_fields\" will be ignored. <br/> <br/> This api is deprecated from
     * 3.2.2. Please use policy api - <br/>
     * /search/query?query=resource_type:SegmentPort&included_fields=id&included_fields=admin_state
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param attachmentId Logical Port attachment Id (optional)
     * @param attachmentType Type of attachment for logical port; for query only. (optional)
     * @param bridgeClusterId Bridge Cluster identifier (optional)
     * @param containerPortsOnly Only container VIF logical ports will be returned if true (optional, default to
     * false)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical port. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param logicalSwitchId Logical Switch identifier (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param parentVifId ID of the VIF of type PARENT (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param switchingProfileId Network Profile identifier (optional)
     * @param transportNodeId Transport node identifier (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalPortStatusSummary
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalPortStatusSummary getall(java.lang.String attachmentId, java.lang.String attachmentType, java.lang.String bridgeClusterId, java.lang.Boolean containerPortsOnly, java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.String logicalSwitchId, java.lang.Long pageSize, java.lang.String parentVifId, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String switchingProfileId, java.lang.String transportNodeId, java.lang.String transportZoneId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns operational status of all logical ports. The query parameter
     * \"source=realtime\" is not supported. Pagination is not supported for this API.
     * The query parameters \"cursor\", \"sort_ascending\", \"sort_by\", \"page_size\"
     * and \"included_fields\" will be ignored. <br/> <br/> This api is deprecated from
     * 3.2.2. Please use policy api - <br/>
     * /search/query?query=resource_type:SegmentPort&included_fields=id&included_fields=admin_state
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPortStatusSummary
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param attachmentId Logical Port attachment Id (optional)
     * @param attachmentType Type of attachment for logical port; for query only. (optional)
     * @param bridgeClusterId Bridge Cluster identifier (optional)
     * @param containerPortsOnly Only container VIF logical ports will be returned if true (optional, default to
     * false)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical port. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param logicalSwitchId Logical Switch identifier (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param parentVifId ID of the VIF of type PARENT (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param switchingProfileId Network Profile identifier (optional)
     * @param transportNodeId Transport node identifier (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void getall(java.lang.String attachmentId, java.lang.String attachmentType, java.lang.String bridgeClusterId, java.lang.Boolean containerPortsOnly, java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.String logicalSwitchId, java.lang.Long pageSize, java.lang.String parentVifId, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String switchingProfileId, java.lang.String transportNodeId, java.lang.String transportZoneId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPortStatusSummary> asyncCallback);

    /**
     * Returns operational status of all logical ports. The query parameter
     * \"source=realtime\" is not supported. Pagination is not supported for this API.
     * The query parameters \"cursor\", \"sort_ascending\", \"sort_by\", \"page_size\"
     * and \"included_fields\" will be ignored. <br/> <br/> This api is deprecated from
     * 3.2.2. Please use policy api - <br/>
     * /search/query?query=resource_type:SegmentPort&included_fields=id&included_fields=admin_state
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalPortStatusSummary
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param attachmentId Logical Port attachment Id (optional)
     * @param attachmentType Type of attachment for logical port; for query only. (optional)
     * @param bridgeClusterId Bridge Cluster identifier (optional)
     * @param containerPortsOnly Only container VIF logical ports will be returned if true (optional, default to
     * false)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param diagnostic Flag to enable showing of transit logical port. (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param logicalSwitchId Logical Switch identifier (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param parentVifId ID of the VIF of type PARENT (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param switchingProfileId Network Profile identifier (optional)
     * @param transportNodeId Transport node identifier (optional)
     * @param transportZoneId Transport zone identifier (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void getall(java.lang.String attachmentId, java.lang.String attachmentType, java.lang.String bridgeClusterId, java.lang.Boolean containerPortsOnly, java.lang.String cursor, java.lang.Boolean diagnostic, java.lang.String includedFields, java.lang.String logicalSwitchId, java.lang.Long pageSize, java.lang.String parentVifId, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String switchingProfileId, java.lang.String transportNodeId, java.lang.String transportZoneId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalPortStatusSummary> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
