/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_routers.routing.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_routers.routing;

public interface BfdConfig extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_routers.routing.BfdConfigTypes {

    /**
     * Returns the BFD configuration for all routing BFD peers. This will be inherited
     * | by all BFD peers for LogicalRouter unless overriden while configuring the
     * Peer. <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>
     * <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @return com.vmware.nsx.model.BfdConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BfdConfig get(java.lang.String logicalRouterId);

    /**
     * Returns the BFD configuration for all routing BFD peers. This will be inherited
     * | by all BFD peers for LogicalRouter unless overriden while configuring the
     * Peer. <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>
     * <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BfdConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BfdConfig get(java.lang.String logicalRouterId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the BFD configuration for all routing BFD peers. This will be inherited
     * | by all BFD peers for LogicalRouter unless overriden while configuring the
     * Peer. <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>
     * <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BfdConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BfdConfig> asyncCallback);

    /**
     * Returns the BFD configuration for all routing BFD peers. This will be inherited
     * | by all BFD peers for LogicalRouter unless overriden while configuring the
     * Peer. <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>
     * <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BfdConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BfdConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies the BFD configuration for routing BFD peers. Note - the configuration |
     * changes apply only to those routing BFD peers for which the BFD configuration
     * has | not been overridden at Peer level. <br/> <br/> Please use below Policy
     * APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>
     * <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param bfdConfig (required)
     * @return com.vmware.nsx.model.BfdConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BfdConfig update(java.lang.String logicalRouterId, com.vmware.nsx.model.BfdConfig bfdConfig);

    /**
     * Modifies the BFD configuration for routing BFD peers. Note - the configuration |
     * changes apply only to those routing BFD peers for which the BFD configuration
     * has | not been overridden at Peer level. <br/> <br/> Please use below Policy
     * APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>
     * <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param bfdConfig (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BfdConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BfdConfig update(java.lang.String logicalRouterId, com.vmware.nsx.model.BfdConfig bfdConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies the BFD configuration for routing BFD peers. Note - the configuration |
     * changes apply only to those routing BFD peers for which the BFD configuration
     * has | not been overridden at Peer level. <br/> <br/> Please use below Policy
     * APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>
     * <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BfdConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param bfdConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterId, com.vmware.nsx.model.BfdConfig bfdConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BfdConfig> asyncCallback);

    /**
     * Modifies the BFD configuration for routing BFD peers. Note - the configuration |
     * changes apply only to those routing BFD peers for which the BFD configuration
     * has | not been overridden at Peer level. <br/> <br/> Please use below Policy
     * APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>
     * <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BfdConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param bfdConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterId, com.vmware.nsx.model.BfdConfig bfdConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BfdConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
