/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_routers.routing.bgp.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_routers.routing.bgp;

public interface Neighbors extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_routers.routing.bgp.NeighborsTypes {

    /**
     * Add a new BGP Neighbor on a Logical Router <br/> <br/> Please use below Policy
     * APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param bgpNeighbor (required)
     * @return com.vmware.nsx.model.BgpNeighbor
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighbor create(java.lang.String logicalRouterId, com.vmware.nsx.model.BgpNeighbor bgpNeighbor);

    /**
     * Add a new BGP Neighbor on a Logical Router <br/> <br/> Please use below Policy
     * APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param bgpNeighbor (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BgpNeighbor
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighbor create(java.lang.String logicalRouterId, com.vmware.nsx.model.BgpNeighbor bgpNeighbor, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Add a new BGP Neighbor on a Logical Router <br/> <br/> Please use below Policy
     * APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighbor
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param bgpNeighbor (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(java.lang.String logicalRouterId, com.vmware.nsx.model.BgpNeighbor bgpNeighbor, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighbor> asyncCallback);

    /**
     * Add a new BGP Neighbor on a Logical Router <br/> <br/> Please use below Policy
     * APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighbor
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param bgpNeighbor (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(java.lang.String logicalRouterId, com.vmware.nsx.model.BgpNeighbor bgpNeighbor, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighbor> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete a specific BGP Neighbor on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String id);

    /**
     * Delete a specific BGP Neighbor on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete a specific BGP Neighbor on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete a specific BGP Neighbor on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read a specific BGP Neighbor on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @return com.vmware.nsx.model.BgpNeighbor
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighbor get(java.lang.String logicalRouterId, java.lang.String id);

    /**
     * Read a specific BGP Neighbor on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BgpNeighbor
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighbor get(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read a specific BGP Neighbor on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighbor
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighbor> asyncCallback);

    /**
     * Read a specific BGP Neighbor on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighbor
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighbor> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Paginated list of BGP Neighbors on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.BgpNeighborListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighborListResult list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Paginated list of BGP Neighbors on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BgpNeighborListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighborListResult list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Paginated list of BGP Neighbors on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighborListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighborListResult> asyncCallback);

    /**
     * Paginated list of BGP Neighbors on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighborListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighborListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read a specific BGP Neighbor details with password on a Logical Router <br/>
     * <br/> Please use below Policy API. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @return com.vmware.nsx.model.BgpNeighbor
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighbor showsensitivedata(java.lang.String logicalRouterId, java.lang.String id);

    /**
     * Read a specific BGP Neighbor details with password on a Logical Router <br/>
     * <br/> Please use below Policy API. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BgpNeighbor
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighbor showsensitivedata(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read a specific BGP Neighbor details with password on a Logical Router <br/>
     * <br/> Please use below Policy API. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighbor
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void showsensitivedata(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighbor> asyncCallback);

    /**
     * Read a specific BGP Neighbor details with password on a Logical Router <br/>
     * <br/> Please use below Policy API. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighbor
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void showsensitivedata(java.lang.String logicalRouterId, java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighbor> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Unset/Delete the password property on the specific BGP Neighbor. No other
     * property of the BgpNeighbor can be updated using this API <br/> <br/> Please use
     * below Policy APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param action (optional)
     * @return com.vmware.nsx.model.BgpNeighbor
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighbor unsetpassword(java.lang.String logicalRouterId, java.lang.String id, java.lang.String action);

    /**
     * Unset/Delete the password property on the specific BGP Neighbor. No other
     * property of the BgpNeighbor can be updated using this API <br/> <br/> Please use
     * below Policy APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param action (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BgpNeighbor
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighbor unsetpassword(java.lang.String logicalRouterId, java.lang.String id, java.lang.String action, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Unset/Delete the password property on the specific BGP Neighbor. No other
     * property of the BgpNeighbor can be updated using this API <br/> <br/> Please use
     * below Policy APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighbor
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param action (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void unsetpassword(java.lang.String logicalRouterId, java.lang.String id, java.lang.String action, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighbor> asyncCallback);

    /**
     * Unset/Delete the password property on the specific BGP Neighbor. No other
     * property of the BgpNeighbor can be updated using this API <br/> <br/> Please use
     * below Policy APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighbor
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param action (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void unsetpassword(java.lang.String logicalRouterId, java.lang.String id, java.lang.String action, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighbor> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update a specific BGP Neighbor on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param bgpNeighbor (required)
     * @return com.vmware.nsx.model.BgpNeighbor
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighbor update(java.lang.String logicalRouterId, java.lang.String id, com.vmware.nsx.model.BgpNeighbor bgpNeighbor);

    /**
     * Update a specific BGP Neighbor on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param bgpNeighbor (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BgpNeighbor
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.BgpNeighbor update(java.lang.String logicalRouterId, java.lang.String id, com.vmware.nsx.model.BgpNeighbor bgpNeighbor, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update a specific BGP Neighbor on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighbor
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param bgpNeighbor (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterId, java.lang.String id, com.vmware.nsx.model.BgpNeighbor bgpNeighbor, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighbor> asyncCallback);

    /**
     * Update a specific BGP Neighbor on a Logical Router <br/> <br/> Please use below
     * Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/bgp/neighbors/<neighbor-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighbor
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param id (required)
     * @param bgpNeighbor (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterId, java.lang.String id, com.vmware.nsx.model.BgpNeighbor bgpNeighbor, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighbor> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
