/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_routers.service_cluster.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_routers.service_cluster;

public interface State extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_routers.service_cluster.StateTypes {

    /**
     * Return realized state information of a logical service router cluster. Any
     * configuration update that affects the logical service router cluster can use
     * this API to get its realized state by passing a request_id returned by the
     * configuration change operation. e.g. Update configuration of nat, bgp, bfd, etc.
     * What is a Service Router? When a service cannot be distributed is enabled on a
     * Logical Router, a Service Router (SR) is instantiated. Some examples of services
     * that are not distributed are NAT, DHCP server, Metadata Proxy, Edge Firewall,
     * Load Balancer and so on. <br/> <br/> Please use below policy apis instead of
     * this API. <br/> GET /infra/tier-0s/<tier-0-id>/state <br/> GET
     * /infra/tier-1s/<tier-1-id>/state <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @return com.vmware.nsx.model.LogicalServiceRouterClusterState
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalServiceRouterClusterState get(java.lang.String logicalRouterId, java.lang.Long barrierId, java.lang.String requestId);

    /**
     * Return realized state information of a logical service router cluster. Any
     * configuration update that affects the logical service router cluster can use
     * this API to get its realized state by passing a request_id returned by the
     * configuration change operation. e.g. Update configuration of nat, bgp, bfd, etc.
     * What is a Service Router? When a service cannot be distributed is enabled on a
     * Logical Router, a Service Router (SR) is instantiated. Some examples of services
     * that are not distributed are NAT, DHCP server, Metadata Proxy, Edge Firewall,
     * Load Balancer and so on. <br/> <br/> Please use below policy apis instead of
     * this API. <br/> GET /infra/tier-0s/<tier-0-id>/state <br/> GET
     * /infra/tier-1s/<tier-1-id>/state <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalServiceRouterClusterState
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalServiceRouterClusterState get(java.lang.String logicalRouterId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return realized state information of a logical service router cluster. Any
     * configuration update that affects the logical service router cluster can use
     * this API to get its realized state by passing a request_id returned by the
     * configuration change operation. e.g. Update configuration of nat, bgp, bfd, etc.
     * What is a Service Router? When a service cannot be distributed is enabled on a
     * Logical Router, a Service Router (SR) is instantiated. Some examples of services
     * that are not distributed are NAT, DHCP server, Metadata Proxy, Edge Firewall,
     * Load Balancer and so on. <br/> <br/> Please use below policy apis instead of
     * this API. <br/> GET /infra/tier-0s/<tier-0-id>/state <br/> GET
     * /infra/tier-1s/<tier-1-id>/state <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalServiceRouterClusterState
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalServiceRouterClusterState> asyncCallback);

    /**
     * Return realized state information of a logical service router cluster. Any
     * configuration update that affects the logical service router cluster can use
     * this API to get its realized state by passing a request_id returned by the
     * configuration change operation. e.g. Update configuration of nat, bgp, bfd, etc.
     * What is a Service Router? When a service cannot be distributed is enabled on a
     * Logical Router, a Service Router (SR) is instantiated. Some examples of services
     * that are not distributed are NAT, DHCP server, Metadata Proxy, Edge Firewall,
     * Load Balancer and so on. <br/> <br/> Please use below policy apis instead of
     * this API. <br/> GET /infra/tier-0s/<tier-0-id>/state <br/> GET
     * /infra/tier-1s/<tier-1-id>/state <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalServiceRouterClusterState
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalServiceRouterClusterState> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
