/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_switches.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_switches;

public interface Statistics extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_switches.StatisticsTypes {

    /**
     * Returns statistics of a specified logical switch. The query parameter
     * \"source=realtime\" is not supported.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param lswitchId (required)
     * @param source Data source type. (optional)
     * @return com.vmware.nsx.model.LogicalSwitchStatistics
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.LogicalSwitchStatistics get(java.lang.String lswitchId, java.lang.String source);

    /**
     * Returns statistics of a specified logical switch. The query parameter
     * \"source=realtime\" is not supported.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param lswitchId (required)
     * @param source Data source type. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalSwitchStatistics
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.LogicalSwitchStatistics get(java.lang.String lswitchId, java.lang.String source, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns statistics of a specified logical switch. The query parameter
     * \"source=realtime\" is not supported.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalSwitchStatistics
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param lswitchId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String lswitchId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalSwitchStatistics> asyncCallback);

    /**
     * Returns statistics of a specified logical switch. The query parameter
     * \"source=realtime\" is not supported.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalSwitchStatistics
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param lswitchId (required)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String lswitchId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalSwitchStatistics> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
