/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.migration.
 * Used by client-side stubs.
 */

package com.vmware.nsx.migration;

public interface Setup extends com.vmware.vapi.bindings.Service, com.vmware.nsx.migration.SetupTypes {

    /**
     * Add ALB endpoint details for non cross VC migration modes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param aviEndPoint (required)
     * @throws com.vmware.vapi.std.errors.Unauthenticated  Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void addalbinfo(com.vmware.nsx.model.AviEndPoint aviEndPoint);

    /**
     * Add ALB endpoint details for non cross VC migration modes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param aviEndPoint (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.Unauthenticated  Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void addalbinfo(com.vmware.nsx.model.AviEndPoint aviEndPoint, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Add ALB endpoint details for non cross VC migration modes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} -  Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param aviEndPoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void addalbinfo(com.vmware.nsx.model.AviEndPoint aviEndPoint, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Add ALB endpoint details for non cross VC migration modes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} -  Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param aviEndPoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void addalbinfo(com.vmware.nsx.model.AviEndPoint aviEndPoint, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Add NSX-V to NSX-T site mapping.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param v2tSiteMappingSpec (required)
     * @throws com.vmware.vapi.std.errors.Unauthenticated  Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void addv2tsitemapping(com.vmware.nsx.model.V2tSiteMappingSpec v2tSiteMappingSpec);

    /**
     * Add NSX-V to NSX-T site mapping.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param v2tSiteMappingSpec (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.Unauthenticated  Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void addv2tsitemapping(com.vmware.nsx.model.V2tSiteMappingSpec v2tSiteMappingSpec, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Add NSX-V to NSX-T site mapping.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} -  Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param v2tSiteMappingSpec (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void addv2tsitemapping(com.vmware.nsx.model.V2tSiteMappingSpec v2tSiteMappingSpec, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Add NSX-V to NSX-T site mapping.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} -  Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param v2tSiteMappingSpec (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void addv2tsitemapping(com.vmware.nsx.model.V2tSiteMappingSpec v2tSiteMappingSpec, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get setup details of NSX-V to be migrated.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.MigrationSetupInfo
     * @throws com.vmware.vapi.std.errors.Unauthenticated  Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.MigrationSetupInfo get();

    /**
     * Get setup details of NSX-V to be migrated.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.MigrationSetupInfo
     * @throws com.vmware.vapi.std.errors.Unauthenticated  Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.MigrationSetupInfo get(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get setup details of NSX-V to be migrated.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.MigrationSetupInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} -  Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.MigrationSetupInfo> asyncCallback);

    /**
     * Get setup details of NSX-V to be migrated.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.MigrationSetupInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} -  Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.MigrationSetupInfo> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * This API is to support the add Host workflow on NSX-T once the V2T migration
     * process has started. There are two high level cases. For each case, please refer
     * to the detailed steps. Case - 1 : For migration mode -
     * CONFIG_AND_EDGE_MIGRATION_WITH_BYOT,
     * CONFIG_AND_EDGE_MIGRATION_WITH_BYOT_ON_FEDERATION 1. Verify that overall
     * migration status is in SUCCESS state in migration co-ordinator. This means all
     * migration stages are completed and we are at a point where we can move workloads
     * using the pre-migrate, post-migrate API's. 2. Follow steps mentioned in product
     * documentation to add a new host to cluster. 3. Invoke this API (Accept Host
     * Transport Node) to perform the V2T migration steps on newly added host transport
     * node. Once API is successful, make sure that newly added HOST can take worklods
     * (Ex: Traffic checks, etc.,). For Case-1, this API should be invoked only when
     * following conditions are met. - The overall migration status is in SUCCESS
     * status. - All the migration stages are completed and we are at a point where we
     * can move workloads. - The migration mode selected has to be among the ones
     * designated for case-1 - The new host has been added to a cluster by following
     * all the steps mentioned in product documentation. Case - 2 : For migration modes
     * that perform HOST migration. 1. Verify that overall migration status is in
     * PAUSED state in migration co-ordinator. 2. Follow steps mentioned in product
     * documentation to add a new host to cluster. 3. Invoke the migration co-ordinator
     * sync HOST groups API. This will result in migration co-ordinator updating its
     * inventory and accouting for the newly added host transport node. At this point,
     * the list host upgrade units API call to MC will also show the newly added host
     * transport node. But do NOT resume the migration. Since this host transport node
     * is added after the V2T migration has started, we need to perform migration steps
     * on this host through this special API (Accept Host Transport Node) 4. Invoke
     * this API (Accept Host Transport Node) to perform the V2T migration steps on
     * newly added host transport node. Once the API is successful, we should be seeing
     * that migration status has been marked as SUCCESS for the newly added host
     * transport node. Very Importnant Note : Make sure that migration status is PAUSED
     * in migration co-ordinator when performing steps 2 through 4. Also ensure that
     * all the steps 2 through 4 pass without failures. For Case-2, this API should be
     * invoked only when following conditions are met. - The overall migration status
     * is in PAUSED status. - The migration mode selected has HOST component in it. -
     * All the migration stages before HOST stage are completed. - The new host has
     * been added to a cluster by following all the steps mentioned in product
     * documentation.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param newHostTransportNodeSpec (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void migratenewlyaddedhosttransportnode(com.vmware.nsx.model.NewHostTransportNodeSpec newHostTransportNodeSpec);

    /**
     * This API is to support the add Host workflow on NSX-T once the V2T migration
     * process has started. There are two high level cases. For each case, please refer
     * to the detailed steps. Case - 1 : For migration mode -
     * CONFIG_AND_EDGE_MIGRATION_WITH_BYOT,
     * CONFIG_AND_EDGE_MIGRATION_WITH_BYOT_ON_FEDERATION 1. Verify that overall
     * migration status is in SUCCESS state in migration co-ordinator. This means all
     * migration stages are completed and we are at a point where we can move workloads
     * using the pre-migrate, post-migrate API's. 2. Follow steps mentioned in product
     * documentation to add a new host to cluster. 3. Invoke this API (Accept Host
     * Transport Node) to perform the V2T migration steps on newly added host transport
     * node. Once API is successful, make sure that newly added HOST can take worklods
     * (Ex: Traffic checks, etc.,). For Case-1, this API should be invoked only when
     * following conditions are met. - The overall migration status is in SUCCESS
     * status. - All the migration stages are completed and we are at a point where we
     * can move workloads. - The migration mode selected has to be among the ones
     * designated for case-1 - The new host has been added to a cluster by following
     * all the steps mentioned in product documentation. Case - 2 : For migration modes
     * that perform HOST migration. 1. Verify that overall migration status is in
     * PAUSED state in migration co-ordinator. 2. Follow steps mentioned in product
     * documentation to add a new host to cluster. 3. Invoke the migration co-ordinator
     * sync HOST groups API. This will result in migration co-ordinator updating its
     * inventory and accouting for the newly added host transport node. At this point,
     * the list host upgrade units API call to MC will also show the newly added host
     * transport node. But do NOT resume the migration. Since this host transport node
     * is added after the V2T migration has started, we need to perform migration steps
     * on this host through this special API (Accept Host Transport Node) 4. Invoke
     * this API (Accept Host Transport Node) to perform the V2T migration steps on
     * newly added host transport node. Once the API is successful, we should be seeing
     * that migration status has been marked as SUCCESS for the newly added host
     * transport node. Very Importnant Note : Make sure that migration status is PAUSED
     * in migration co-ordinator when performing steps 2 through 4. Also ensure that
     * all the steps 2 through 4 pass without failures. For Case-2, this API should be
     * invoked only when following conditions are met. - The overall migration status
     * is in PAUSED status. - The migration mode selected has HOST component in it. -
     * All the migration stages before HOST stage are completed. - The new host has
     * been added to a cluster by following all the steps mentioned in product
     * documentation.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param newHostTransportNodeSpec (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void migratenewlyaddedhosttransportnode(com.vmware.nsx.model.NewHostTransportNodeSpec newHostTransportNodeSpec, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This API is to support the add Host workflow on NSX-T once the V2T migration
     * process has started. There are two high level cases. For each case, please refer
     * to the detailed steps. Case - 1 : For migration mode -
     * CONFIG_AND_EDGE_MIGRATION_WITH_BYOT,
     * CONFIG_AND_EDGE_MIGRATION_WITH_BYOT_ON_FEDERATION 1. Verify that overall
     * migration status is in SUCCESS state in migration co-ordinator. This means all
     * migration stages are completed and we are at a point where we can move workloads
     * using the pre-migrate, post-migrate API's. 2. Follow steps mentioned in product
     * documentation to add a new host to cluster. 3. Invoke this API (Accept Host
     * Transport Node) to perform the V2T migration steps on newly added host transport
     * node. Once API is successful, make sure that newly added HOST can take worklods
     * (Ex: Traffic checks, etc.,). For Case-1, this API should be invoked only when
     * following conditions are met. - The overall migration status is in SUCCESS
     * status. - All the migration stages are completed and we are at a point where we
     * can move workloads. - The migration mode selected has to be among the ones
     * designated for case-1 - The new host has been added to a cluster by following
     * all the steps mentioned in product documentation. Case - 2 : For migration modes
     * that perform HOST migration. 1. Verify that overall migration status is in
     * PAUSED state in migration co-ordinator. 2. Follow steps mentioned in product
     * documentation to add a new host to cluster. 3. Invoke the migration co-ordinator
     * sync HOST groups API. This will result in migration co-ordinator updating its
     * inventory and accouting for the newly added host transport node. At this point,
     * the list host upgrade units API call to MC will also show the newly added host
     * transport node. But do NOT resume the migration. Since this host transport node
     * is added after the V2T migration has started, we need to perform migration steps
     * on this host through this special API (Accept Host Transport Node) 4. Invoke
     * this API (Accept Host Transport Node) to perform the V2T migration steps on
     * newly added host transport node. Once the API is successful, we should be seeing
     * that migration status has been marked as SUCCESS for the newly added host
     * transport node. Very Importnant Note : Make sure that migration status is PAUSED
     * in migration co-ordinator when performing steps 2 through 4. Also ensure that
     * all the steps 2 through 4 pass without failures. For Case-2, this API should be
     * invoked only when following conditions are met. - The overall migration status
     * is in PAUSED status. - The migration mode selected has HOST component in it. -
     * All the migration stages before HOST stage are completed. - The new host has
     * been added to a cluster by following all the steps mentioned in product
     * documentation.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param newHostTransportNodeSpec (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void migratenewlyaddedhosttransportnode(com.vmware.nsx.model.NewHostTransportNodeSpec newHostTransportNodeSpec, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * This API is to support the add Host workflow on NSX-T once the V2T migration
     * process has started. There are two high level cases. For each case, please refer
     * to the detailed steps. Case - 1 : For migration mode -
     * CONFIG_AND_EDGE_MIGRATION_WITH_BYOT,
     * CONFIG_AND_EDGE_MIGRATION_WITH_BYOT_ON_FEDERATION 1. Verify that overall
     * migration status is in SUCCESS state in migration co-ordinator. This means all
     * migration stages are completed and we are at a point where we can move workloads
     * using the pre-migrate, post-migrate API's. 2. Follow steps mentioned in product
     * documentation to add a new host to cluster. 3. Invoke this API (Accept Host
     * Transport Node) to perform the V2T migration steps on newly added host transport
     * node. Once API is successful, make sure that newly added HOST can take worklods
     * (Ex: Traffic checks, etc.,). For Case-1, this API should be invoked only when
     * following conditions are met. - The overall migration status is in SUCCESS
     * status. - All the migration stages are completed and we are at a point where we
     * can move workloads. - The migration mode selected has to be among the ones
     * designated for case-1 - The new host has been added to a cluster by following
     * all the steps mentioned in product documentation. Case - 2 : For migration modes
     * that perform HOST migration. 1. Verify that overall migration status is in
     * PAUSED state in migration co-ordinator. 2. Follow steps mentioned in product
     * documentation to add a new host to cluster. 3. Invoke the migration co-ordinator
     * sync HOST groups API. This will result in migration co-ordinator updating its
     * inventory and accouting for the newly added host transport node. At this point,
     * the list host upgrade units API call to MC will also show the newly added host
     * transport node. But do NOT resume the migration. Since this host transport node
     * is added after the V2T migration has started, we need to perform migration steps
     * on this host through this special API (Accept Host Transport Node) 4. Invoke
     * this API (Accept Host Transport Node) to perform the V2T migration steps on
     * newly added host transport node. Once the API is successful, we should be seeing
     * that migration status has been marked as SUCCESS for the newly added host
     * transport node. Very Importnant Note : Make sure that migration status is PAUSED
     * in migration co-ordinator when performing steps 2 through 4. Also ensure that
     * all the steps 2 through 4 pass without failures. For Case-2, this API should be
     * invoked only when following conditions are met. - The overall migration status
     * is in PAUSED status. - The migration mode selected has HOST component in it. -
     * All the migration stages before HOST stage are completed. - The new host has
     * been added to a cluster by following all the steps mentioned in product
     * documentation.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param newHostTransportNodeSpec (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void migratenewlyaddedhosttransportnode(com.vmware.nsx.model.NewHostTransportNodeSpec newHostTransportNodeSpec, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Set the NSX-V ESG to NSX-T Router mapping option.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param mappingOption Mapping option (required)
     * @throws com.vmware.vapi.std.errors.Unauthenticated  Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void setesgtoroutermappingoption(java.lang.String mappingOption);

    /**
     * Set the NSX-V ESG to NSX-T Router mapping option.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param mappingOption Mapping option (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.Unauthenticated  Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void setesgtoroutermappingoption(java.lang.String mappingOption, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Set the NSX-V ESG to NSX-T Router mapping option.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} -  Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param mappingOption Mapping option (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void setesgtoroutermappingoption(java.lang.String mappingOption, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Set the NSX-V ESG to NSX-T Router mapping option.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} -  Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param mappingOption Mapping option (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void setesgtoroutermappingoption(java.lang.String mappingOption, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Provide setup details of NSX-V to be migrated.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param migrationSetupInfo (required)
     * @return com.vmware.nsx.model.MigrationSetupInfo
     * @throws com.vmware.vapi.std.errors.Unauthenticated  Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.MigrationSetupInfo update(com.vmware.nsx.model.MigrationSetupInfo migrationSetupInfo);

    /**
     * Provide setup details of NSX-V to be migrated.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param migrationSetupInfo (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.MigrationSetupInfo
     * @throws com.vmware.vapi.std.errors.Unauthenticated  Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.MigrationSetupInfo update(com.vmware.nsx.model.MigrationSetupInfo migrationSetupInfo, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Provide setup details of NSX-V to be migrated.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.MigrationSetupInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} -  Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param migrationSetupInfo (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(com.vmware.nsx.model.MigrationSetupInfo migrationSetupInfo, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.MigrationSetupInfo> asyncCallback);

    /**
     * Provide setup details of NSX-V to be migrated.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.MigrationSetupInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} -  Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param migrationSetupInfo (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(com.vmware.nsx.model.MigrationSetupInfo migrationSetupInfo, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.MigrationSetupInfo> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
