/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.migration.vmgroup.actions.
 * Used by client-side stubs.
 */

package com.vmware.nsx.migration.vmgroup.actions;

public interface GetVmGroupExecutionDetails extends com.vmware.vapi.bindings.Service, com.vmware.nsx.migration.vmgroup.actions.GetVmGroupExecutionDetailsTypes {

    /**
     * The result includes a \"logical_switch_id_to_vm_instance_id_and_vnics_map\" list
     * and an optional \"failedVmInstanceIds\" list which includes the uuids of VMs
     * that are not found in the source VC. Construct a map of vmInstanceUuid to (vnic,
     * ls_id) from the \"logical_switch_id_to_vm_instance_id_and_vnics_map\", then use
     * the map to populate the relocate spec of each VM and migrate the VM as below:
     * The VM object can be found in source VC by the vmInstanceUuid using VC API
     * serviceinstance.content.searchIndex.FindByUuid(uuid=vmInstanceUuid,
     * vmSearch=True, instanceUuid=True) For each VM vNIC, if the device key \"vnic\"
     * is not found in the map of vmInstanceUuid to (vnic, ls_id), then skip the vNIC.
     * Otherwise form a VIF-id for the vNIC by vmInstanceUuid + ':' + str(vnic), e.g.
     * \"52630e5d-ce6f-fac0-424c-4aa4bdf6bd56:4001\", and use it to setup the vNIC's
     * network backing. For VDS6.x migration, opaque-network backing in NVDS will be
     * used; setup the vNIC device as below: - vdevice.backing =
     * vim.vm.device.VirtualEthernetCard.OpaqueNetworkBackingInfo() -
     * vdevice.backing.opaqueNetworkId = ls_id - vdevice.backing.opaqueNetworkType =
     * 'nsx.LogicalSwitch' - vdevice.externalId = VIF-id For VDS 7.0 and later
     * versions, \"nsx\" LogicalSwitch backing in VDS will be used. Go through all VDS
     * DVPGs in the target VC to find each DVPG whose config.backingType is \"nsx\" and
     * config.logicalSwitchUuid is not blank, build a map of
     * dvpg.config.logicalSwitchUuid to [dvpg.key,
     * dvpg.config.distributedVirtualSwitch.uuid] once. For each vNIC device, get the
     * dvpg value from the map by the ls_id and then set it up as below: - vdsPgConn =
     * vim.dvs.PortConnection() - vdsPgConn.portgroupKey = dvpg.key -
     * vdsPgConn.switchUuid = dvpg.config.distributedVirtualSwitch.uuid -
     * vdevice.backing =
     * vim.vm.device.VirtualEthernetCard.DistributedVirtualPortBackingInfo() -
     * vdevice.backing.port = vdsPgConn - vdevice.externalId = VIF-id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param groupId User defined VM group ID (required)
     * @param federationSiteId ID of the site in NSX-T Federation (optional)
     * @return com.vmware.nsx.model.VmGroupExecutionDetails
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.VmGroupExecutionDetails list(java.lang.String groupId, java.lang.String federationSiteId);

    /**
     * The result includes a \"logical_switch_id_to_vm_instance_id_and_vnics_map\" list
     * and an optional \"failedVmInstanceIds\" list which includes the uuids of VMs
     * that are not found in the source VC. Construct a map of vmInstanceUuid to (vnic,
     * ls_id) from the \"logical_switch_id_to_vm_instance_id_and_vnics_map\", then use
     * the map to populate the relocate spec of each VM and migrate the VM as below:
     * The VM object can be found in source VC by the vmInstanceUuid using VC API
     * serviceinstance.content.searchIndex.FindByUuid(uuid=vmInstanceUuid,
     * vmSearch=True, instanceUuid=True) For each VM vNIC, if the device key \"vnic\"
     * is not found in the map of vmInstanceUuid to (vnic, ls_id), then skip the vNIC.
     * Otherwise form a VIF-id for the vNIC by vmInstanceUuid + ':' + str(vnic), e.g.
     * \"52630e5d-ce6f-fac0-424c-4aa4bdf6bd56:4001\", and use it to setup the vNIC's
     * network backing. For VDS6.x migration, opaque-network backing in NVDS will be
     * used; setup the vNIC device as below: - vdevice.backing =
     * vim.vm.device.VirtualEthernetCard.OpaqueNetworkBackingInfo() -
     * vdevice.backing.opaqueNetworkId = ls_id - vdevice.backing.opaqueNetworkType =
     * 'nsx.LogicalSwitch' - vdevice.externalId = VIF-id For VDS 7.0 and later
     * versions, \"nsx\" LogicalSwitch backing in VDS will be used. Go through all VDS
     * DVPGs in the target VC to find each DVPG whose config.backingType is \"nsx\" and
     * config.logicalSwitchUuid is not blank, build a map of
     * dvpg.config.logicalSwitchUuid to [dvpg.key,
     * dvpg.config.distributedVirtualSwitch.uuid] once. For each vNIC device, get the
     * dvpg value from the map by the ls_id and then set it up as below: - vdsPgConn =
     * vim.dvs.PortConnection() - vdsPgConn.portgroupKey = dvpg.key -
     * vdsPgConn.switchUuid = dvpg.config.distributedVirtualSwitch.uuid -
     * vdevice.backing =
     * vim.vm.device.VirtualEthernetCard.DistributedVirtualPortBackingInfo() -
     * vdevice.backing.port = vdsPgConn - vdevice.externalId = VIF-id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param groupId User defined VM group ID (required)
     * @param federationSiteId ID of the site in NSX-T Federation (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.VmGroupExecutionDetails
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx.model.VmGroupExecutionDetails list(java.lang.String groupId, java.lang.String federationSiteId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * The result includes a \"logical_switch_id_to_vm_instance_id_and_vnics_map\" list
     * and an optional \"failedVmInstanceIds\" list which includes the uuids of VMs
     * that are not found in the source VC. Construct a map of vmInstanceUuid to (vnic,
     * ls_id) from the \"logical_switch_id_to_vm_instance_id_and_vnics_map\", then use
     * the map to populate the relocate spec of each VM and migrate the VM as below:
     * The VM object can be found in source VC by the vmInstanceUuid using VC API
     * serviceinstance.content.searchIndex.FindByUuid(uuid=vmInstanceUuid,
     * vmSearch=True, instanceUuid=True) For each VM vNIC, if the device key \"vnic\"
     * is not found in the map of vmInstanceUuid to (vnic, ls_id), then skip the vNIC.
     * Otherwise form a VIF-id for the vNIC by vmInstanceUuid + ':' + str(vnic), e.g.
     * \"52630e5d-ce6f-fac0-424c-4aa4bdf6bd56:4001\", and use it to setup the vNIC's
     * network backing. For VDS6.x migration, opaque-network backing in NVDS will be
     * used; setup the vNIC device as below: - vdevice.backing =
     * vim.vm.device.VirtualEthernetCard.OpaqueNetworkBackingInfo() -
     * vdevice.backing.opaqueNetworkId = ls_id - vdevice.backing.opaqueNetworkType =
     * 'nsx.LogicalSwitch' - vdevice.externalId = VIF-id For VDS 7.0 and later
     * versions, \"nsx\" LogicalSwitch backing in VDS will be used. Go through all VDS
     * DVPGs in the target VC to find each DVPG whose config.backingType is \"nsx\" and
     * config.logicalSwitchUuid is not blank, build a map of
     * dvpg.config.logicalSwitchUuid to [dvpg.key,
     * dvpg.config.distributedVirtualSwitch.uuid] once. For each vNIC device, get the
     * dvpg value from the map by the ls_id and then set it up as below: - vdsPgConn =
     * vim.dvs.PortConnection() - vdsPgConn.portgroupKey = dvpg.key -
     * vdsPgConn.switchUuid = dvpg.config.distributedVirtualSwitch.uuid -
     * vdevice.backing =
     * vim.vm.device.VirtualEthernetCard.DistributedVirtualPortBackingInfo() -
     * vdevice.backing.port = vdsPgConn - vdevice.externalId = VIF-id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VmGroupExecutionDetails
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param groupId User defined VM group ID (required)
     * @param federationSiteId ID of the site in NSX-T Federation (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String groupId, java.lang.String federationSiteId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VmGroupExecutionDetails> asyncCallback);

    /**
     * The result includes a \"logical_switch_id_to_vm_instance_id_and_vnics_map\" list
     * and an optional \"failedVmInstanceIds\" list which includes the uuids of VMs
     * that are not found in the source VC. Construct a map of vmInstanceUuid to (vnic,
     * ls_id) from the \"logical_switch_id_to_vm_instance_id_and_vnics_map\", then use
     * the map to populate the relocate spec of each VM and migrate the VM as below:
     * The VM object can be found in source VC by the vmInstanceUuid using VC API
     * serviceinstance.content.searchIndex.FindByUuid(uuid=vmInstanceUuid,
     * vmSearch=True, instanceUuid=True) For each VM vNIC, if the device key \"vnic\"
     * is not found in the map of vmInstanceUuid to (vnic, ls_id), then skip the vNIC.
     * Otherwise form a VIF-id for the vNIC by vmInstanceUuid + ':' + str(vnic), e.g.
     * \"52630e5d-ce6f-fac0-424c-4aa4bdf6bd56:4001\", and use it to setup the vNIC's
     * network backing. For VDS6.x migration, opaque-network backing in NVDS will be
     * used; setup the vNIC device as below: - vdevice.backing =
     * vim.vm.device.VirtualEthernetCard.OpaqueNetworkBackingInfo() -
     * vdevice.backing.opaqueNetworkId = ls_id - vdevice.backing.opaqueNetworkType =
     * 'nsx.LogicalSwitch' - vdevice.externalId = VIF-id For VDS 7.0 and later
     * versions, \"nsx\" LogicalSwitch backing in VDS will be used. Go through all VDS
     * DVPGs in the target VC to find each DVPG whose config.backingType is \"nsx\" and
     * config.logicalSwitchUuid is not blank, build a map of
     * dvpg.config.logicalSwitchUuid to [dvpg.key,
     * dvpg.config.distributedVirtualSwitch.uuid] once. For each vNIC device, get the
     * dvpg value from the map by the ls_id and then set it up as below: - vdsPgConn =
     * vim.dvs.PortConnection() - vdsPgConn.portgroupKey = dvpg.key -
     * vdsPgConn.switchUuid = dvpg.config.distributedVirtualSwitch.uuid -
     * vdevice.backing =
     * vim.vm.device.VirtualEthernetCard.DistributedVirtualPortBackingInfo() -
     * vdevice.backing.port = vdsPgConn - vdevice.externalId = VIF-id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VmGroupExecutionDetails
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param groupId User defined VM group ID (required)
     * @param federationSiteId ID of the site in NSX-T Federation (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String groupId, java.lang.String federationSiteId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VmGroupExecutionDetails> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
