/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Information about a management plane node this transport node is configured to
 * communicate with
 */
public final class BrokerProperties implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String brokerFqdn;

    private java.lang.String brokerIpAddress;

    private java.lang.String brokerIsMaster;

    private java.lang.String brokerPort;

    private java.lang.String brokerSslCertThumbprint;

    private java.lang.String brokerVirtualHost;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public BrokerProperties() {
    }

    protected BrokerProperties(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Fully qualified domain name of the message bus broker on the management plane
     * node.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBrokerFqdn() {
        return this.brokerFqdn;
    }

    /**
     * Fully qualified domain name of the message bus broker on the management plane
     * node.
     *
     * @param brokerFqdn New value for the property.
     */
    public void setBrokerFqdn(java.lang.String brokerFqdn) {
        this.brokerFqdn = brokerFqdn;
    }

    /**
     * IP address or hostname of the message bus broker on the management plane node.
     * format: hostname-or-ipv4
     *
     * @return The current value of the property.
     */
    public java.lang.String getBrokerIpAddress() {
        return this.brokerIpAddress;
    }

    /**
     * IP address or hostname of the message bus broker on the management plane node.
     * format: hostname-or-ipv4
     *
     * @param brokerIpAddress New value for the property.
     */
    public void setBrokerIpAddress(java.lang.String brokerIpAddress) {
        this.brokerIpAddress = brokerIpAddress;
    }

    /**
     * Indicates whether this broker is the master.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBrokerIsMaster() {
        return this.brokerIsMaster;
    }

    /**
     * Indicates whether this broker is the master.
     *
     * @param brokerIsMaster New value for the property.
     */
    public void setBrokerIsMaster(java.lang.String brokerIsMaster) {
        this.brokerIsMaster = brokerIsMaster;
    }

    /**
     * Port number of the message bus broker on the management plane node.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBrokerPort() {
        return this.brokerPort;
    }

    /**
     * Port number of the message bus broker on the management plane node.
     *
     * @param brokerPort New value for the property.
     */
    public void setBrokerPort(java.lang.String brokerPort) {
        this.brokerPort = brokerPort;
    }

    /**
     * Certificate thumbprint of the message bus broker on the management plane node.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBrokerSslCertThumbprint() {
        return this.brokerSslCertThumbprint;
    }

    /**
     * Certificate thumbprint of the message bus broker on the management plane node.
     *
     * @param brokerSslCertThumbprint New value for the property.
     */
    public void setBrokerSslCertThumbprint(java.lang.String brokerSslCertThumbprint) {
        this.brokerSslCertThumbprint = brokerSslCertThumbprint;
    }

    /**
     * Type of host running the broker.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBrokerVirtualHost() {
        return this.brokerVirtualHost;
    }

    /**
     * Type of host running the broker.
     *
     * @param brokerVirtualHost New value for the property.
     */
    public void setBrokerVirtualHost(java.lang.String brokerVirtualHost) {
        this.brokerVirtualHost = brokerVirtualHost;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.brokerProperties;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("BrokerFqdn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.brokerFqdn, this._getType().getField("BrokerFqdn")));
        structValue.setField("BrokerIpAddress",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.brokerIpAddress, this._getType().getField("BrokerIpAddress")));
        structValue.setField("BrokerIsMaster",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.brokerIsMaster, this._getType().getField("BrokerIsMaster")));
        structValue.setField("BrokerPort",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.brokerPort, this._getType().getField("BrokerPort")));
        structValue.setField("BrokerSslCertThumbprint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.brokerSslCertThumbprint, this._getType().getField("BrokerSslCertThumbprint")));
        structValue.setField("BrokerVirtualHost",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.brokerVirtualHost, this._getType().getField("BrokerVirtualHost")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.brokerProperties;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.brokerProperties.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static BrokerProperties _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new BrokerProperties(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static BrokerProperties _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new BrokerProperties(structValue);
    }

    /**
     * Builder class for {@link BrokerProperties}.
     */
    public static final class Builder {
        private java.lang.String brokerFqdn;
        private java.lang.String brokerIpAddress;
        private java.lang.String brokerIsMaster;
        private java.lang.String brokerPort;
        private java.lang.String brokerSslCertThumbprint;
        private java.lang.String brokerVirtualHost;

        /**
         * Constructor with parameters for the required properties of
         * {@link BrokerProperties}.
         */
        public Builder() {
        }

        /**
         * Fully qualified domain name of the message bus broker on the management plane
         * node.
         *
         * @param brokerFqdn New value for the property.
         */
        public Builder setBrokerFqdn(java.lang.String brokerFqdn) {
            this.brokerFqdn = brokerFqdn;
            return this;
        }

        /**
         * IP address or hostname of the message bus broker on the management plane node.
         * format: hostname-or-ipv4
         *
         * @param brokerIpAddress New value for the property.
         */
        public Builder setBrokerIpAddress(java.lang.String brokerIpAddress) {
            this.brokerIpAddress = brokerIpAddress;
            return this;
        }

        /**
         * Indicates whether this broker is the master.
         *
         * @param brokerIsMaster New value for the property.
         */
        public Builder setBrokerIsMaster(java.lang.String brokerIsMaster) {
            this.brokerIsMaster = brokerIsMaster;
            return this;
        }

        /**
         * Port number of the message bus broker on the management plane node.
         *
         * @param brokerPort New value for the property.
         */
        public Builder setBrokerPort(java.lang.String brokerPort) {
            this.brokerPort = brokerPort;
            return this;
        }

        /**
         * Certificate thumbprint of the message bus broker on the management plane node.
         *
         * @param brokerSslCertThumbprint New value for the property.
         */
        public Builder setBrokerSslCertThumbprint(java.lang.String brokerSslCertThumbprint) {
            this.brokerSslCertThumbprint = brokerSslCertThumbprint;
            return this;
        }

        /**
         * Type of host running the broker.
         *
         * @param brokerVirtualHost New value for the property.
         */
        public Builder setBrokerVirtualHost(java.lang.String brokerVirtualHost) {
            this.brokerVirtualHost = brokerVirtualHost;
            return this;
        }

        public BrokerProperties build() {
            BrokerProperties result = new BrokerProperties();
            result.setBrokerFqdn(this.brokerFqdn);
            result.setBrokerIpAddress(this.brokerIpAddress);
            result.setBrokerIsMaster(this.brokerIsMaster);
            result.setBrokerPort(this.brokerPort);
            result.setBrokerSslCertThumbprint(this.brokerSslCertThumbprint);
            result.setBrokerVirtualHost(this.brokerVirtualHost);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("BrokerFqdn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("BrokerFqdn",
                                                                                "brokerFqdn",
                                                                                "getBrokerFqdn",
                                                                                "setBrokerFqdn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("BrokerIpAddress", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("BrokerIpAddress",
                                                                                "brokerIpAddress",
                                                                                "getBrokerIpAddress",
                                                                                "setBrokerIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("BrokerIsMaster", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("BrokerIsMaster",
                                                                                "brokerIsMaster",
                                                                                "getBrokerIsMaster",
                                                                                "setBrokerIsMaster");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("BrokerPort", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("BrokerPort",
                                                                                "brokerPort",
                                                                                "getBrokerPort",
                                                                                "setBrokerPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("BrokerSslCertThumbprint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("BrokerSslCertThumbprint",
                                                                                "brokerSslCertThumbprint",
                                                                                "getBrokerSslCertThumbprint",
                                                                                "setBrokerSslCertThumbprint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("BrokerVirtualHost", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("BrokerVirtualHost",
                                                                                "brokerVirtualHost",
                                                                                "getBrokerVirtualHost",
                                                                                "setBrokerVirtualHost");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.broker_properties",
                                                            fields,
                                                            com.vmware.nsx.model.BrokerProperties.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

