/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The configuration of the NSX cluster. The cluster configuration consists of a
 * list of cluster node attributes.
 */
public final class ClusterConfiguration implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String clusterId;

    private java.lang.Long configVersion;

    private java.util.List<com.vmware.nsx.model.ClusterNode> nodes;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ClusterConfiguration() {
    }

    protected ClusterConfiguration(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * UUID of the cluster
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getClusterId() {
        return this.clusterId;
    }

    /**
     * UUID of the cluster
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param clusterId New value for the property.
     */
    public void setClusterId(java.lang.String clusterId) {
        this.clusterId = clusterId;
    }

    /**
     * Cluster configuration version format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getConfigVersion() {
        return this.configVersion;
    }

    /**
     * Cluster configuration version format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param configVersion New value for the property.
     */
    public void setConfigVersion(java.lang.Long configVersion) {
        this.configVersion = configVersion;
    }

    /**
     * Nodes in the cluster configuration
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ClusterNode> getNodes() {
        return this.nodes;
    }

    /**
     * Nodes in the cluster configuration
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nodes New value for the property.
     */
    public void setNodes(java.util.List<com.vmware.nsx.model.ClusterNode> nodes) {
        this.nodes = nodes;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.clusterConfiguration;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("cluster_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clusterId, this._getType().getField("cluster_id")));
        structValue.setField("config_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.configVersion, this._getType().getField("config_version")));
        structValue.setField("nodes",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodes, this._getType().getField("nodes")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.clusterConfiguration;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.clusterConfiguration.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ClusterConfiguration _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ClusterConfiguration(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ClusterConfiguration _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ClusterConfiguration(structValue);
    }

    /**
     * Builder class for {@link ClusterConfiguration}.
     */
    public static final class Builder {
        private java.lang.String clusterId;
        private java.lang.Long configVersion;
        private java.util.List<com.vmware.nsx.model.ClusterNode> nodes;

        /**
         * Constructor with parameters for the required properties of
         * {@link ClusterConfiguration}.
         */
        public Builder() {
        }

        /**
         * UUID of the cluster
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param clusterId New value for the property.
         */
        public Builder setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        /**
         * Cluster configuration version format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param configVersion New value for the property.
         */
        public Builder setConfigVersion(java.lang.Long configVersion) {
            this.configVersion = configVersion;
            return this;
        }

        /**
         * Nodes in the cluster configuration
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nodes New value for the property.
         */
        public Builder setNodes(java.util.List<com.vmware.nsx.model.ClusterNode> nodes) {
            this.nodes = nodes;
            return this;
        }

        public ClusterConfiguration build() {
            ClusterConfiguration result = new ClusterConfiguration();
            result.setClusterId(this.clusterId);
            result.setConfigVersion(this.configVersion);
            result.setNodes(this.nodes);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("cluster_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cluster_id",
                                                                                "clusterId",
                                                                                "getClusterId",
                                                                                "setClusterId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("config_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("config_version",
                                                                                "configVersion",
                                                                                "getConfigVersion",
                                                                                "setConfigVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nodes", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.clusterNode; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nodes",
                                                                                "nodes",
                                                                                "getNodes",
                                                                                "setNodes");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.cluster_configuration",
                                                            fields,
                                                            com.vmware.nsx.model.ClusterConfiguration.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

