/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * This type contains the attributes and status of a group member.
 */
public final class ClusterGroupMemberStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String MEMBER_STATUS_UP = "UP";

    public static final java.lang.String MEMBER_STATUS_DOWN = "DOWN";

    public static final java.lang.String MEMBER_STATUS_UNKNOWN = "UNKNOWN";

    private java.lang.String memberFqdn;

    private java.lang.String memberIp;

    private java.lang.String memberIpv6;

    private java.lang.String memberStatus;

    private java.lang.String memberUuid;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ClusterGroupMemberStatus() {
    }

    protected ClusterGroupMemberStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * FQDN of the group member format: hostname
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMemberFqdn() {
        return this.memberFqdn;
    }

    /**
     * FQDN of the group member format: hostname
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param memberFqdn New value for the property.
     */
    public void setMemberFqdn(java.lang.String memberFqdn) {
        this.memberFqdn = memberFqdn;
    }

    /**
     * IP of the group member format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMemberIp() {
        return this.memberIp;
    }

    /**
     * IP of the group member format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param memberIp New value for the property.
     */
    public void setMemberIp(java.lang.String memberIp) {
        this.memberIp = memberIp;
    }

    /**
     * IPv6 of the group member format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMemberIpv6() {
        return this.memberIpv6;
    }

    /**
     * IPv6 of the group member format: ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param memberIpv6 New value for the property.
     */
    public void setMemberIpv6(java.lang.String memberIpv6) {
        this.memberIpv6 = memberIpv6;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ClusterGroupMemberStatus#MEMBER_STATUS_UP}</li> <li> {@link
     * com.vmware.nsx.model.ClusterGroupMemberStatus#MEMBER_STATUS_DOWN}</li> <li>
     * {@link com.vmware.nsx.model.ClusterGroupMemberStatus#MEMBER_STATUS_UNKNOWN}</li>
     * </ul> Status of the group member
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMemberStatus() {
        return this.memberStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ClusterGroupMemberStatus#MEMBER_STATUS_UP}</li> <li> {@link
     * com.vmware.nsx.model.ClusterGroupMemberStatus#MEMBER_STATUS_DOWN}</li> <li>
     * {@link com.vmware.nsx.model.ClusterGroupMemberStatus#MEMBER_STATUS_UNKNOWN}</li>
     * </ul> Status of the group member
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param memberStatus New value for the property.
     */
    public void setMemberStatus(java.lang.String memberStatus) {
        this.memberStatus = memberStatus;
    }

    /**
     * UUID of the group member
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMemberUuid() {
        return this.memberUuid;
    }

    /**
     * UUID of the group member
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param memberUuid New value for the property.
     */
    public void setMemberUuid(java.lang.String memberUuid) {
        this.memberUuid = memberUuid;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.clusterGroupMemberStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("member_fqdn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.memberFqdn, this._getType().getField("member_fqdn")));
        structValue.setField("member_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.memberIp, this._getType().getField("member_ip")));
        structValue.setField("member_ipv6",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.memberIpv6, this._getType().getField("member_ipv6")));
        structValue.setField("member_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.memberStatus, this._getType().getField("member_status")));
        structValue.setField("member_uuid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.memberUuid, this._getType().getField("member_uuid")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.clusterGroupMemberStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.clusterGroupMemberStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ClusterGroupMemberStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ClusterGroupMemberStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ClusterGroupMemberStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ClusterGroupMemberStatus(structValue);
    }

    /**
     * Builder class for {@link ClusterGroupMemberStatus}.
     */
    public static final class Builder {
        private java.lang.String memberFqdn;
        private java.lang.String memberIp;
        private java.lang.String memberIpv6;
        private java.lang.String memberStatus;
        private java.lang.String memberUuid;

        /**
         * Constructor with parameters for the required properties of
         * {@link ClusterGroupMemberStatus}.
         */
        public Builder() {
        }

        /**
         * FQDN of the group member format: hostname
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param memberFqdn New value for the property.
         */
        public Builder setMemberFqdn(java.lang.String memberFqdn) {
            this.memberFqdn = memberFqdn;
            return this;
        }

        /**
         * IP of the group member format: ip
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param memberIp New value for the property.
         */
        public Builder setMemberIp(java.lang.String memberIp) {
            this.memberIp = memberIp;
            return this;
        }

        /**
         * IPv6 of the group member format: ip
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param memberIpv6 New value for the property.
         */
        public Builder setMemberIpv6(java.lang.String memberIpv6) {
            this.memberIpv6 = memberIpv6;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.ClusterGroupMemberStatus#MEMBER_STATUS_UP}</li> <li> {@link
         * com.vmware.nsx.model.ClusterGroupMemberStatus#MEMBER_STATUS_DOWN}</li> <li>
         * {@link com.vmware.nsx.model.ClusterGroupMemberStatus#MEMBER_STATUS_UNKNOWN}</li>
         * </ul> Status of the group member
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param memberStatus New value for the property.
         */
        public Builder setMemberStatus(java.lang.String memberStatus) {
            this.memberStatus = memberStatus;
            return this;
        }

        /**
         * UUID of the group member
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param memberUuid New value for the property.
         */
        public Builder setMemberUuid(java.lang.String memberUuid) {
            this.memberUuid = memberUuid;
            return this;
        }

        public ClusterGroupMemberStatus build() {
            ClusterGroupMemberStatus result = new ClusterGroupMemberStatus();
            result.setMemberFqdn(this.memberFqdn);
            result.setMemberIp(this.memberIp);
            result.setMemberIpv6(this.memberIpv6);
            result.setMemberStatus(this.memberStatus);
            result.setMemberUuid(this.memberUuid);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("member_fqdn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("member_fqdn",
                                                                                "memberFqdn",
                                                                                "getMemberFqdn",
                                                                                "setMemberFqdn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("member_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("member_ip",
                                                                                "memberIp",
                                                                                "getMemberIp",
                                                                                "setMemberIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("member_ipv6", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("member_ipv6",
                                                                                "memberIpv6",
                                                                                "getMemberIpv6",
                                                                                "setMemberIpv6");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("member_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("member_status",
                                                                                "memberStatus",
                                                                                "getMemberStatus",
                                                                                "setMemberStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("member_uuid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("member_uuid",
                                                                                "memberUuid",
                                                                                "getMemberUuid",
                                                                                "setMemberUuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.cluster_group_member_status",
                                                            fields,
                                                            com.vmware.nsx.model.ClusterGroupMemberStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

