/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * DHCP filtering configuration
 */
public final class DhcpFilter implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean clientBlockEnabled;

    private java.lang.Boolean serverBlockEnabled;

    private java.lang.Boolean v6ClientBlockEnabled;

    private java.lang.Boolean v6ServerBlockEnabled;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DhcpFilter() {
    }

    protected DhcpFilter(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Indicates whether DHCP client blocking is enabled
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getClientBlockEnabled() {
        return this.clientBlockEnabled;
    }

    /**
     * Indicates whether DHCP client blocking is enabled
     *
     * @param clientBlockEnabled New value for the property.
     */
    public void setClientBlockEnabled(java.lang.Boolean clientBlockEnabled) {
        this.clientBlockEnabled = clientBlockEnabled;
    }

    /**
     * Indicates whether DHCP server blocking is enabled
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getServerBlockEnabled() {
        return this.serverBlockEnabled;
    }

    /**
     * Indicates whether DHCP server blocking is enabled
     *
     * @param serverBlockEnabled New value for the property.
     */
    public void setServerBlockEnabled(java.lang.Boolean serverBlockEnabled) {
        this.serverBlockEnabled = serverBlockEnabled;
    }

    /**
     * Indiactes whether DHCP v6 client blocking is enabled
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getV6ClientBlockEnabled() {
        return this.v6ClientBlockEnabled;
    }

    /**
     * Indiactes whether DHCP v6 client blocking is enabled
     *
     * @param v6ClientBlockEnabled New value for the property.
     */
    public void setV6ClientBlockEnabled(java.lang.Boolean v6ClientBlockEnabled) {
        this.v6ClientBlockEnabled = v6ClientBlockEnabled;
    }

    /**
     * Indiactes whether DHCP V6 server blocking is enabled
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getV6ServerBlockEnabled() {
        return this.v6ServerBlockEnabled;
    }

    /**
     * Indiactes whether DHCP V6 server blocking is enabled
     *
     * @param v6ServerBlockEnabled New value for the property.
     */
    public void setV6ServerBlockEnabled(java.lang.Boolean v6ServerBlockEnabled) {
        this.v6ServerBlockEnabled = v6ServerBlockEnabled;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.dhcpFilter;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("client_block_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientBlockEnabled, this._getType().getField("client_block_enabled")));
        structValue.setField("server_block_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverBlockEnabled, this._getType().getField("server_block_enabled")));
        structValue.setField("v6_client_block_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.v6ClientBlockEnabled, this._getType().getField("v6_client_block_enabled")));
        structValue.setField("v6_server_block_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.v6ServerBlockEnabled, this._getType().getField("v6_server_block_enabled")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.dhcpFilter;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.dhcpFilter.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DhcpFilter _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DhcpFilter(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DhcpFilter _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DhcpFilter(structValue);
    }

    /**
     * Builder class for {@link DhcpFilter}.
     */
    public static final class Builder {
        private java.lang.Boolean clientBlockEnabled;
        private java.lang.Boolean serverBlockEnabled;
        private java.lang.Boolean v6ClientBlockEnabled;
        private java.lang.Boolean v6ServerBlockEnabled;

        /**
         * Constructor with parameters for the required properties of
         * {@link DhcpFilter}.
         */
        public Builder() {
        }

        /**
         * Indicates whether DHCP client blocking is enabled
         *
         * @param clientBlockEnabled New value for the property.
         */
        public Builder setClientBlockEnabled(java.lang.Boolean clientBlockEnabled) {
            this.clientBlockEnabled = clientBlockEnabled;
            return this;
        }

        /**
         * Indicates whether DHCP server blocking is enabled
         *
         * @param serverBlockEnabled New value for the property.
         */
        public Builder setServerBlockEnabled(java.lang.Boolean serverBlockEnabled) {
            this.serverBlockEnabled = serverBlockEnabled;
            return this;
        }

        /**
         * Indiactes whether DHCP v6 client blocking is enabled
         *
         * @param v6ClientBlockEnabled New value for the property.
         */
        public Builder setV6ClientBlockEnabled(java.lang.Boolean v6ClientBlockEnabled) {
            this.v6ClientBlockEnabled = v6ClientBlockEnabled;
            return this;
        }

        /**
         * Indiactes whether DHCP V6 server blocking is enabled
         *
         * @param v6ServerBlockEnabled New value for the property.
         */
        public Builder setV6ServerBlockEnabled(java.lang.Boolean v6ServerBlockEnabled) {
            this.v6ServerBlockEnabled = v6ServerBlockEnabled;
            return this;
        }

        public DhcpFilter build() {
            DhcpFilter result = new DhcpFilter();
            result.setClientBlockEnabled(this.clientBlockEnabled);
            result.setServerBlockEnabled(this.serverBlockEnabled);
            result.setV6ClientBlockEnabled(this.v6ClientBlockEnabled);
            result.setV6ServerBlockEnabled(this.v6ServerBlockEnabled);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("client_block_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_block_enabled",
                                                                                "clientBlockEnabled",
                                                                                "getClientBlockEnabled",
                                                                                "setClientBlockEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_block_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_block_enabled",
                                                                                "serverBlockEnabled",
                                                                                "getServerBlockEnabled",
                                                                                "setServerBlockEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("v6_client_block_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("v6_client_block_enabled",
                                                                                "v6ClientBlockEnabled",
                                                                                "getV6ClientBlockEnabled",
                                                                                "setV6ClientBlockEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("v6_server_block_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("v6_server_block_enabled",
                                                                                "v6ServerBlockEnabled",
                                                                                "getV6ServerBlockEnabled",
                                                                                "setV6ServerBlockEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.dhcp_filter",
                                                            fields,
                                                            com.vmware.nsx.model.DhcpFilter.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

