/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * IPSec VPN tunnel traffic statistics.
 */
public final class IPSecVPNTunnelTrafficStatistics implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String TUNNEL_STATUS_UP = "UP";

    public static final java.lang.String TUNNEL_STATUS_DOWN = "DOWN";

    public static final java.lang.String TUNNEL_STATUS_NEGOTIATING = "NEGOTIATING";

    private java.lang.Long bytesIn;

    private java.lang.Long bytesOut;

    private java.lang.Long decryptionFailures;

    private java.lang.Long droppedPacketsIn;

    private java.lang.Long droppedPacketsOut;

    private java.lang.Long encryptionFailures;

    private java.lang.Long integrityFailures;

    private java.lang.String localSubnet;

    private java.lang.Long nomatchingPolicyErrors;

    private java.lang.Long packetsIn;

    private java.lang.Long packetsOut;

    private java.lang.Long packetsReceiveOtherError;

    private java.lang.Long packetsSentOtherError;

    private java.lang.String peerSubnet;

    private java.lang.String policyId;

    private java.lang.Long replayErrors;

    private java.lang.Long saMismatchErrorsIn;

    private java.lang.Long saMismatchErrorsOut;

    private java.lang.Long seqNumberOverflowError;

    private java.lang.String tunnelDownReason;

    private java.lang.String tunnelStatus;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IPSecVPNTunnelTrafficStatistics() {
    }

    protected IPSecVPNTunnelTrafficStatistics(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Total number of incoming bytes on inbound Security association (SA). format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getBytesIn() {
        return this.bytesIn;
    }

    /**
     * Total number of incoming bytes on inbound Security association (SA). format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param bytesIn New value for the property.
     */
    public void setBytesIn(java.lang.Long bytesIn) {
        this.bytesIn = bytesIn;
    }

    /**
     * Total number of outgoing bytes on outbound Security association (SA). format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getBytesOut() {
        return this.bytesOut;
    }

    /**
     * Total number of outgoing bytes on outbound Security association (SA). format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param bytesOut New value for the property.
     */
    public void setBytesOut(java.lang.Long bytesOut) {
        this.bytesOut = bytesOut;
    }

    /**
     * Total number of packets dropped due to decryption failures. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDecryptionFailures() {
        return this.decryptionFailures;
    }

    /**
     * Total number of packets dropped due to decryption failures. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param decryptionFailures New value for the property.
     */
    public void setDecryptionFailures(java.lang.Long decryptionFailures) {
        this.decryptionFailures = decryptionFailures;
    }

    /**
     * Total number of incoming packets dropped on inbound security association.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDroppedPacketsIn() {
        return this.droppedPacketsIn;
    }

    /**
     * Total number of incoming packets dropped on inbound security association.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param droppedPacketsIn New value for the property.
     */
    public void setDroppedPacketsIn(java.lang.Long droppedPacketsIn) {
        this.droppedPacketsIn = droppedPacketsIn;
    }

    /**
     * Total number of outgoing packets dropped on outbound security association.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDroppedPacketsOut() {
        return this.droppedPacketsOut;
    }

    /**
     * Total number of outgoing packets dropped on outbound security association.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param droppedPacketsOut New value for the property.
     */
    public void setDroppedPacketsOut(java.lang.Long droppedPacketsOut) {
        this.droppedPacketsOut = droppedPacketsOut;
    }

    /**
     * Total number of packets dropped because of failure in encryption. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getEncryptionFailures() {
        return this.encryptionFailures;
    }

    /**
     * Total number of packets dropped because of failure in encryption. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param encryptionFailures New value for the property.
     */
    public void setEncryptionFailures(java.lang.Long encryptionFailures) {
        this.encryptionFailures = encryptionFailures;
    }

    /**
     * Total number of packets dropped due to integrity failures. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIntegrityFailures() {
        return this.integrityFailures;
    }

    /**
     * Total number of packets dropped due to integrity failures. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param integrityFailures New value for the property.
     */
    public void setIntegrityFailures(java.lang.Long integrityFailures) {
        this.integrityFailures = integrityFailures;
    }

    /**
     * Local subnet to which a tunnel belongs.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLocalSubnet() {
        return this.localSubnet;
    }

    /**
     * Local subnet to which a tunnel belongs.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param localSubnet New value for the property.
     */
    public void setLocalSubnet(java.lang.String localSubnet) {
        this.localSubnet = localSubnet;
    }

    /**
     * Number of packets dropped because of no matching policy is available. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNomatchingPolicyErrors() {
        return this.nomatchingPolicyErrors;
    }

    /**
     * Number of packets dropped because of no matching policy is available. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nomatchingPolicyErrors New value for the property.
     */
    public void setNomatchingPolicyErrors(java.lang.Long nomatchingPolicyErrors) {
        this.nomatchingPolicyErrors = nomatchingPolicyErrors;
    }

    /**
     * Total number of incoming packets on inbound Security association (SA). format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPacketsIn() {
        return this.packetsIn;
    }

    /**
     * Total number of incoming packets on inbound Security association (SA). format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param packetsIn New value for the property.
     */
    public void setPacketsIn(java.lang.Long packetsIn) {
        this.packetsIn = packetsIn;
    }

    /**
     * Total number of outgoing packets on outbound Security association (SA). format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPacketsOut() {
        return this.packetsOut;
    }

    /**
     * Total number of outgoing packets on outbound Security association (SA). format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param packetsOut New value for the property.
     */
    public void setPacketsOut(java.lang.Long packetsOut) {
        this.packetsOut = packetsOut;
    }

    /**
     * Total number of incoming packets dropped on inbound Security association
     * (SA)(misc). format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPacketsReceiveOtherError() {
        return this.packetsReceiveOtherError;
    }

    /**
     * Total number of incoming packets dropped on inbound Security association
     * (SA)(misc). format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param packetsReceiveOtherError New value for the property.
     */
    public void setPacketsReceiveOtherError(java.lang.Long packetsReceiveOtherError) {
        this.packetsReceiveOtherError = packetsReceiveOtherError;
    }

    /**
     * Total number of packets dropped while sending for any reason. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPacketsSentOtherError() {
        return this.packetsSentOtherError;
    }

    /**
     * Total number of packets dropped while sending for any reason. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param packetsSentOtherError New value for the property.
     */
    public void setPacketsSentOtherError(java.lang.Long packetsSentOtherError) {
        this.packetsSentOtherError = packetsSentOtherError;
    }

    /**
     * Peer subnet to which a tunnel belongs.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPeerSubnet() {
        return this.peerSubnet;
    }

    /**
     * Peer subnet to which a tunnel belongs.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param peerSubnet New value for the property.
     */
    public void setPeerSubnet(java.lang.String peerSubnet) {
        this.peerSubnet = peerSubnet;
    }

    /**
     * Policy UUID of IPSec Tunnel.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPolicyId() {
        return this.policyId;
    }

    /**
     * Policy UUID of IPSec Tunnel.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param policyId New value for the property.
     */
    public void setPolicyId(java.lang.String policyId) {
        this.policyId = policyId;
    }

    /**
     * Total number of packets dropped due to replay check on that Security association
     * (SA). format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getReplayErrors() {
        return this.replayErrors;
    }

    /**
     * Total number of packets dropped due to replay check on that Security association
     * (SA). format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param replayErrors New value for the property.
     */
    public void setReplayErrors(java.lang.Long replayErrors) {
        this.replayErrors = replayErrors;
    }

    /**
     * Totoal number of security association (SA) mismatch errors on incoming packets.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSaMismatchErrorsIn() {
        return this.saMismatchErrorsIn;
    }

    /**
     * Totoal number of security association (SA) mismatch errors on incoming packets.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param saMismatchErrorsIn New value for the property.
     */
    public void setSaMismatchErrorsIn(java.lang.Long saMismatchErrorsIn) {
        this.saMismatchErrorsIn = saMismatchErrorsIn;
    }

    /**
     * Totoal number of security association (SA) mismatch errors on outgoing packets.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSaMismatchErrorsOut() {
        return this.saMismatchErrorsOut;
    }

    /**
     * Totoal number of security association (SA) mismatch errors on outgoing packets.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param saMismatchErrorsOut New value for the property.
     */
    public void setSaMismatchErrorsOut(java.lang.Long saMismatchErrorsOut) {
        this.saMismatchErrorsOut = saMismatchErrorsOut;
    }

    /**
     * Total number of packets dropped while sending due to overflow in sequence
     * number. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSeqNumberOverflowError() {
        return this.seqNumberOverflowError;
    }

    /**
     * Total number of packets dropped while sending due to overflow in sequence
     * number. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param seqNumberOverflowError New value for the property.
     */
    public void setSeqNumberOverflowError(java.lang.Long seqNumberOverflowError) {
        this.seqNumberOverflowError = seqNumberOverflowError;
    }

    /**
     * Gives the detailed reason about the tunnel when it is down. If tunnel is UP
     * tunnel down reason will be empty.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTunnelDownReason() {
        return this.tunnelDownReason;
    }

    /**
     * Gives the detailed reason about the tunnel when it is down. If tunnel is UP
     * tunnel down reason will be empty.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param tunnelDownReason New value for the property.
     */
    public void setTunnelDownReason(java.lang.String tunnelDownReason) {
        this.tunnelDownReason = tunnelDownReason;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelTrafficStatistics#TUNNEL_STATUS_UP}</li> <li>
     * {@link
     * com.vmware.nsx.model.IPSecVPNTunnelTrafficStatistics#TUNNEL_STATUS_DOWN}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelTrafficStatistics#TUNNEL_STATUS_NEGOTIATING}</li>
     * </ul> Specifies the status of tunnel. If all the SA (Security association) are
     * negotiated then tunnels status will be UP. If negotiation fails for the SAs
     * status will be DOWN, if SAs are in negotiating phase tunnels status will be
     * NEGOTIATING.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTunnelStatus() {
        return this.tunnelStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelTrafficStatistics#TUNNEL_STATUS_UP}</li> <li>
     * {@link
     * com.vmware.nsx.model.IPSecVPNTunnelTrafficStatistics#TUNNEL_STATUS_DOWN}</li>
     * <li> {@link
     * com.vmware.nsx.model.IPSecVPNTunnelTrafficStatistics#TUNNEL_STATUS_NEGOTIATING}</li>
     * </ul> Specifies the status of tunnel. If all the SA (Security association) are
     * negotiated then tunnels status will be UP. If negotiation fails for the SAs
     * status will be DOWN, if SAs are in negotiating phase tunnels status will be
     * NEGOTIATING.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param tunnelStatus New value for the property.
     */
    public void setTunnelStatus(java.lang.String tunnelStatus) {
        this.tunnelStatus = tunnelStatus;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.IPSecVPNTunnelTrafficStatistics;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("bytes_in",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bytesIn, this._getType().getField("bytes_in")));
        structValue.setField("bytes_out",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bytesOut, this._getType().getField("bytes_out")));
        structValue.setField("decryption_failures",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.decryptionFailures, this._getType().getField("decryption_failures")));
        structValue.setField("dropped_packets_in",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.droppedPacketsIn, this._getType().getField("dropped_packets_in")));
        structValue.setField("dropped_packets_out",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.droppedPacketsOut, this._getType().getField("dropped_packets_out")));
        structValue.setField("encryption_failures",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.encryptionFailures, this._getType().getField("encryption_failures")));
        structValue.setField("integrity_failures",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.integrityFailures, this._getType().getField("integrity_failures")));
        structValue.setField("local_subnet",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.localSubnet, this._getType().getField("local_subnet")));
        structValue.setField("nomatching_policy_errors",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nomatchingPolicyErrors, this._getType().getField("nomatching_policy_errors")));
        structValue.setField("packets_in",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.packetsIn, this._getType().getField("packets_in")));
        structValue.setField("packets_out",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.packetsOut, this._getType().getField("packets_out")));
        structValue.setField("packets_receive_other_error",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.packetsReceiveOtherError, this._getType().getField("packets_receive_other_error")));
        structValue.setField("packets_sent_other_error",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.packetsSentOtherError, this._getType().getField("packets_sent_other_error")));
        structValue.setField("peer_subnet",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.peerSubnet, this._getType().getField("peer_subnet")));
        structValue.setField("policy_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.policyId, this._getType().getField("policy_id")));
        structValue.setField("replay_errors",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.replayErrors, this._getType().getField("replay_errors")));
        structValue.setField("sa_mismatch_errors_in",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.saMismatchErrorsIn, this._getType().getField("sa_mismatch_errors_in")));
        structValue.setField("sa_mismatch_errors_out",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.saMismatchErrorsOut, this._getType().getField("sa_mismatch_errors_out")));
        structValue.setField("seq_number_overflow_error",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.seqNumberOverflowError, this._getType().getField("seq_number_overflow_error")));
        structValue.setField("tunnel_down_reason",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tunnelDownReason, this._getType().getField("tunnel_down_reason")));
        structValue.setField("tunnel_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tunnelStatus, this._getType().getField("tunnel_status")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.IPSecVPNTunnelTrafficStatistics;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.IPSecVPNTunnelTrafficStatistics.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IPSecVPNTunnelTrafficStatistics _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IPSecVPNTunnelTrafficStatistics(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IPSecVPNTunnelTrafficStatistics _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IPSecVPNTunnelTrafficStatistics(structValue);
    }

    /**
     * Builder class for {@link IPSecVPNTunnelTrafficStatistics}.
     */
    public static final class Builder {
        private java.lang.Long bytesIn;
        private java.lang.Long bytesOut;
        private java.lang.Long decryptionFailures;
        private java.lang.Long droppedPacketsIn;
        private java.lang.Long droppedPacketsOut;
        private java.lang.Long encryptionFailures;
        private java.lang.Long integrityFailures;
        private java.lang.String localSubnet;
        private java.lang.Long nomatchingPolicyErrors;
        private java.lang.Long packetsIn;
        private java.lang.Long packetsOut;
        private java.lang.Long packetsReceiveOtherError;
        private java.lang.Long packetsSentOtherError;
        private java.lang.String peerSubnet;
        private java.lang.String policyId;
        private java.lang.Long replayErrors;
        private java.lang.Long saMismatchErrorsIn;
        private java.lang.Long saMismatchErrorsOut;
        private java.lang.Long seqNumberOverflowError;
        private java.lang.String tunnelDownReason;
        private java.lang.String tunnelStatus;

        /**
         * Constructor with parameters for the required properties of
         * {@link IPSecVPNTunnelTrafficStatistics}.
         */
        public Builder() {
        }

        /**
         * Total number of incoming bytes on inbound Security association (SA). format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param bytesIn New value for the property.
         */
        public Builder setBytesIn(java.lang.Long bytesIn) {
            this.bytesIn = bytesIn;
            return this;
        }

        /**
         * Total number of outgoing bytes on outbound Security association (SA). format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param bytesOut New value for the property.
         */
        public Builder setBytesOut(java.lang.Long bytesOut) {
            this.bytesOut = bytesOut;
            return this;
        }

        /**
         * Total number of packets dropped due to decryption failures. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param decryptionFailures New value for the property.
         */
        public Builder setDecryptionFailures(java.lang.Long decryptionFailures) {
            this.decryptionFailures = decryptionFailures;
            return this;
        }

        /**
         * Total number of incoming packets dropped on inbound security association.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param droppedPacketsIn New value for the property.
         */
        public Builder setDroppedPacketsIn(java.lang.Long droppedPacketsIn) {
            this.droppedPacketsIn = droppedPacketsIn;
            return this;
        }

        /**
         * Total number of outgoing packets dropped on outbound security association.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param droppedPacketsOut New value for the property.
         */
        public Builder setDroppedPacketsOut(java.lang.Long droppedPacketsOut) {
            this.droppedPacketsOut = droppedPacketsOut;
            return this;
        }

        /**
         * Total number of packets dropped because of failure in encryption. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param encryptionFailures New value for the property.
         */
        public Builder setEncryptionFailures(java.lang.Long encryptionFailures) {
            this.encryptionFailures = encryptionFailures;
            return this;
        }

        /**
         * Total number of packets dropped due to integrity failures. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param integrityFailures New value for the property.
         */
        public Builder setIntegrityFailures(java.lang.Long integrityFailures) {
            this.integrityFailures = integrityFailures;
            return this;
        }

        /**
         * Local subnet to which a tunnel belongs.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param localSubnet New value for the property.
         */
        public Builder setLocalSubnet(java.lang.String localSubnet) {
            this.localSubnet = localSubnet;
            return this;
        }

        /**
         * Number of packets dropped because of no matching policy is available. format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nomatchingPolicyErrors New value for the property.
         */
        public Builder setNomatchingPolicyErrors(java.lang.Long nomatchingPolicyErrors) {
            this.nomatchingPolicyErrors = nomatchingPolicyErrors;
            return this;
        }

        /**
         * Total number of incoming packets on inbound Security association (SA). format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param packetsIn New value for the property.
         */
        public Builder setPacketsIn(java.lang.Long packetsIn) {
            this.packetsIn = packetsIn;
            return this;
        }

        /**
         * Total number of outgoing packets on outbound Security association (SA). format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param packetsOut New value for the property.
         */
        public Builder setPacketsOut(java.lang.Long packetsOut) {
            this.packetsOut = packetsOut;
            return this;
        }

        /**
         * Total number of incoming packets dropped on inbound Security association
         * (SA)(misc). format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param packetsReceiveOtherError New value for the property.
         */
        public Builder setPacketsReceiveOtherError(java.lang.Long packetsReceiveOtherError) {
            this.packetsReceiveOtherError = packetsReceiveOtherError;
            return this;
        }

        /**
         * Total number of packets dropped while sending for any reason. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param packetsSentOtherError New value for the property.
         */
        public Builder setPacketsSentOtherError(java.lang.Long packetsSentOtherError) {
            this.packetsSentOtherError = packetsSentOtherError;
            return this;
        }

        /**
         * Peer subnet to which a tunnel belongs.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param peerSubnet New value for the property.
         */
        public Builder setPeerSubnet(java.lang.String peerSubnet) {
            this.peerSubnet = peerSubnet;
            return this;
        }

        /**
         * Policy UUID of IPSec Tunnel.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param policyId New value for the property.
         */
        public Builder setPolicyId(java.lang.String policyId) {
            this.policyId = policyId;
            return this;
        }

        /**
         * Total number of packets dropped due to replay check on that Security association
         * (SA). format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param replayErrors New value for the property.
         */
        public Builder setReplayErrors(java.lang.Long replayErrors) {
            this.replayErrors = replayErrors;
            return this;
        }

        /**
         * Totoal number of security association (SA) mismatch errors on incoming packets.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param saMismatchErrorsIn New value for the property.
         */
        public Builder setSaMismatchErrorsIn(java.lang.Long saMismatchErrorsIn) {
            this.saMismatchErrorsIn = saMismatchErrorsIn;
            return this;
        }

        /**
         * Totoal number of security association (SA) mismatch errors on outgoing packets.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param saMismatchErrorsOut New value for the property.
         */
        public Builder setSaMismatchErrorsOut(java.lang.Long saMismatchErrorsOut) {
            this.saMismatchErrorsOut = saMismatchErrorsOut;
            return this;
        }

        /**
         * Total number of packets dropped while sending due to overflow in sequence
         * number. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param seqNumberOverflowError New value for the property.
         */
        public Builder setSeqNumberOverflowError(java.lang.Long seqNumberOverflowError) {
            this.seqNumberOverflowError = seqNumberOverflowError;
            return this;
        }

        /**
         * Gives the detailed reason about the tunnel when it is down. If tunnel is UP
         * tunnel down reason will be empty.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param tunnelDownReason New value for the property.
         */
        public Builder setTunnelDownReason(java.lang.String tunnelDownReason) {
            this.tunnelDownReason = tunnelDownReason;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelTrafficStatistics#TUNNEL_STATUS_UP}</li> <li>
         * {@link
         * com.vmware.nsx.model.IPSecVPNTunnelTrafficStatistics#TUNNEL_STATUS_DOWN}</li>
         * <li> {@link
         * com.vmware.nsx.model.IPSecVPNTunnelTrafficStatistics#TUNNEL_STATUS_NEGOTIATING}</li>
         * </ul> Specifies the status of tunnel. If all the SA (Security association) are
         * negotiated then tunnels status will be UP. If negotiation fails for the SAs
         * status will be DOWN, if SAs are in negotiating phase tunnels status will be
         * NEGOTIATING.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param tunnelStatus New value for the property.
         */
        public Builder setTunnelStatus(java.lang.String tunnelStatus) {
            this.tunnelStatus = tunnelStatus;
            return this;
        }

        public IPSecVPNTunnelTrafficStatistics build() {
            IPSecVPNTunnelTrafficStatistics result = new IPSecVPNTunnelTrafficStatistics();
            result.setBytesIn(this.bytesIn);
            result.setBytesOut(this.bytesOut);
            result.setDecryptionFailures(this.decryptionFailures);
            result.setDroppedPacketsIn(this.droppedPacketsIn);
            result.setDroppedPacketsOut(this.droppedPacketsOut);
            result.setEncryptionFailures(this.encryptionFailures);
            result.setIntegrityFailures(this.integrityFailures);
            result.setLocalSubnet(this.localSubnet);
            result.setNomatchingPolicyErrors(this.nomatchingPolicyErrors);
            result.setPacketsIn(this.packetsIn);
            result.setPacketsOut(this.packetsOut);
            result.setPacketsReceiveOtherError(this.packetsReceiveOtherError);
            result.setPacketsSentOtherError(this.packetsSentOtherError);
            result.setPeerSubnet(this.peerSubnet);
            result.setPolicyId(this.policyId);
            result.setReplayErrors(this.replayErrors);
            result.setSaMismatchErrorsIn(this.saMismatchErrorsIn);
            result.setSaMismatchErrorsOut(this.saMismatchErrorsOut);
            result.setSeqNumberOverflowError(this.seqNumberOverflowError);
            result.setTunnelDownReason(this.tunnelDownReason);
            result.setTunnelStatus(this.tunnelStatus);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("bytes_in", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bytes_in",
                                                                                "bytesIn",
                                                                                "getBytesIn",
                                                                                "setBytesIn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bytes_out", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bytes_out",
                                                                                "bytesOut",
                                                                                "getBytesOut",
                                                                                "setBytesOut");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("decryption_failures", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("decryption_failures",
                                                                                "decryptionFailures",
                                                                                "getDecryptionFailures",
                                                                                "setDecryptionFailures");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dropped_packets_in", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dropped_packets_in",
                                                                                "droppedPacketsIn",
                                                                                "getDroppedPacketsIn",
                                                                                "setDroppedPacketsIn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dropped_packets_out", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dropped_packets_out",
                                                                                "droppedPacketsOut",
                                                                                "getDroppedPacketsOut",
                                                                                "setDroppedPacketsOut");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("encryption_failures", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("encryption_failures",
                                                                                "encryptionFailures",
                                                                                "getEncryptionFailures",
                                                                                "setEncryptionFailures");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("integrity_failures", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("integrity_failures",
                                                                                "integrityFailures",
                                                                                "getIntegrityFailures",
                                                                                "setIntegrityFailures");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("local_subnet", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("local_subnet",
                                                                                "localSubnet",
                                                                                "getLocalSubnet",
                                                                                "setLocalSubnet");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nomatching_policy_errors", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nomatching_policy_errors",
                                                                                "nomatchingPolicyErrors",
                                                                                "getNomatchingPolicyErrors",
                                                                                "setNomatchingPolicyErrors");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("packets_in", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("packets_in",
                                                                                "packetsIn",
                                                                                "getPacketsIn",
                                                                                "setPacketsIn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("packets_out", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("packets_out",
                                                                                "packetsOut",
                                                                                "getPacketsOut",
                                                                                "setPacketsOut");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("packets_receive_other_error", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("packets_receive_other_error",
                                                                                "packetsReceiveOtherError",
                                                                                "getPacketsReceiveOtherError",
                                                                                "setPacketsReceiveOtherError");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("packets_sent_other_error", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("packets_sent_other_error",
                                                                                "packetsSentOtherError",
                                                                                "getPacketsSentOtherError",
                                                                                "setPacketsSentOtherError");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("peer_subnet", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("peer_subnet",
                                                                                "peerSubnet",
                                                                                "getPeerSubnet",
                                                                                "setPeerSubnet");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("policy_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("policy_id",
                                                                                "policyId",
                                                                                "getPolicyId",
                                                                                "setPolicyId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("replay_errors", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("replay_errors",
                                                                                "replayErrors",
                                                                                "getReplayErrors",
                                                                                "setReplayErrors");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sa_mismatch_errors_in", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sa_mismatch_errors_in",
                                                                                "saMismatchErrorsIn",
                                                                                "getSaMismatchErrorsIn",
                                                                                "setSaMismatchErrorsIn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sa_mismatch_errors_out", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sa_mismatch_errors_out",
                                                                                "saMismatchErrorsOut",
                                                                                "getSaMismatchErrorsOut",
                                                                                "setSaMismatchErrorsOut");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("seq_number_overflow_error", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("seq_number_overflow_error",
                                                                                "seqNumberOverflowError",
                                                                                "getSeqNumberOverflowError",
                                                                                "setSeqNumberOverflowError");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tunnel_down_reason", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tunnel_down_reason",
                                                                                "tunnelDownReason",
                                                                                "getTunnelDownReason",
                                                                                "setTunnelDownReason");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tunnel_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tunnel_status",
                                                                                "tunnelStatus",
                                                                                "getTunnelStatus",
                                                                                "setTunnelStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.IP_sec_VPN_tunnel_traffic_statistics",
                                                            fields,
                                                            com.vmware.nsx.model.IPSecVPNTunnelTrafficStatistics.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

