/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * DHCP server to support IPv6 DHCP service. Properties defined at DHCP server
 * level can be overridden by ip-pool or static-binding level properties.
 */
public final class IPv6DhcpServer implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String dhcpServerIp;

    private java.util.List<java.lang.String> dnsNameservers;

    private java.util.List<java.lang.String> domainNames;

    private java.lang.String serverId;

    private java.util.List<java.lang.String> sntpServers;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IPv6DhcpServer() {
    }

    protected IPv6DhcpServer(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * DHCP server ip in CIDR format. format: ipv6-cidr-block
     *
     * @return The current value of the property.
     */
    public java.lang.String getDhcpServerIp() {
        return this.dhcpServerIp;
    }

    /**
     * DHCP server ip in CIDR format. format: ipv6-cidr-block
     *
     * @param dhcpServerIp New value for the property.
     */
    public void setDhcpServerIp(java.lang.String dhcpServerIp) {
        this.dhcpServerIp = dhcpServerIp;
    }

    /**
     * Primary and secondary DNS server address to assign host. They can be overridden
     * by ip-pool or static-binding level property. format: ipv6
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDnsNameservers() {
        return this.dnsNameservers;
    }

    /**
     * Primary and secondary DNS server address to assign host. They can be overridden
     * by ip-pool or static-binding level property. format: ipv6
     *
     * @param dnsNameservers New value for the property.
     */
    public void setDnsNameservers(java.util.List<java.lang.String> dnsNameservers) {
        this.dnsNameservers = dnsNameservers;
    }

    /**
     * Host name or prefix to be assigned to host. It can be overridden by ip-pool or
     * static-binding level property.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDomainNames() {
        return this.domainNames;
    }

    /**
     * Host name or prefix to be assigned to host. It can be overridden by ip-pool or
     * static-binding level property.
     *
     * @param domainNames New value for the property.
     */
    public void setDomainNames(java.util.List<java.lang.String> domainNames) {
        this.domainNames = domainNames;
    }

    /**
     * DHCP server id.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServerId() {
        return this.serverId;
    }

    /**
     * DHCP server id.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param serverId New value for the property.
     */
    public void setServerId(java.lang.String serverId) {
        this.serverId = serverId;
    }

    /**
     * SNTP server ips. format: ipv6
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getSntpServers() {
        return this.sntpServers;
    }

    /**
     * SNTP server ips. format: ipv6
     *
     * @param sntpServers New value for the property.
     */
    public void setSntpServers(java.util.List<java.lang.String> sntpServers) {
        this.sntpServers = sntpServers;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.IPv6DhcpServer;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dhcp_server_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpServerIp, this._getType().getField("dhcp_server_ip")));
        structValue.setField("dns_nameservers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dnsNameservers, this._getType().getField("dns_nameservers")));
        structValue.setField("domain_names",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.domainNames, this._getType().getField("domain_names")));
        structValue.setField("server_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverId, this._getType().getField("server_id")));
        structValue.setField("sntp_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sntpServers, this._getType().getField("sntp_servers")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.IPv6DhcpServer;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.IPv6DhcpServer.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IPv6DhcpServer _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IPv6DhcpServer(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IPv6DhcpServer _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IPv6DhcpServer(structValue);
    }

    /**
     * Builder class for {@link IPv6DhcpServer}.
     */
    public static final class Builder {
        private java.lang.String dhcpServerIp;
        private java.util.List<java.lang.String> dnsNameservers;
        private java.util.List<java.lang.String> domainNames;
        private java.lang.String serverId;
        private java.util.List<java.lang.String> sntpServers;

        /**
         * Constructor with parameters for the required properties of
         * {@link IPv6DhcpServer}.
         */
        public Builder() {
        }

        /**
         * DHCP server ip in CIDR format. format: ipv6-cidr-block
         *
         * @param dhcpServerIp New value for the property.
         */
        public Builder setDhcpServerIp(java.lang.String dhcpServerIp) {
            this.dhcpServerIp = dhcpServerIp;
            return this;
        }

        /**
         * Primary and secondary DNS server address to assign host. They can be overridden
         * by ip-pool or static-binding level property. format: ipv6
         *
         * @param dnsNameservers New value for the property.
         */
        public Builder setDnsNameservers(java.util.List<java.lang.String> dnsNameservers) {
            this.dnsNameservers = dnsNameservers;
            return this;
        }

        /**
         * Host name or prefix to be assigned to host. It can be overridden by ip-pool or
         * static-binding level property.
         *
         * @param domainNames New value for the property.
         */
        public Builder setDomainNames(java.util.List<java.lang.String> domainNames) {
            this.domainNames = domainNames;
            return this;
        }

        /**
         * DHCP server id.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param serverId New value for the property.
         */
        public Builder setServerId(java.lang.String serverId) {
            this.serverId = serverId;
            return this;
        }

        /**
         * SNTP server ips. format: ipv6
         *
         * @param sntpServers New value for the property.
         */
        public Builder setSntpServers(java.util.List<java.lang.String> sntpServers) {
            this.sntpServers = sntpServers;
            return this;
        }

        public IPv6DhcpServer build() {
            IPv6DhcpServer result = new IPv6DhcpServer();
            result.setDhcpServerIp(this.dhcpServerIp);
            result.setDnsNameservers(this.dnsNameservers);
            result.setDomainNames(this.domainNames);
            result.setServerId(this.serverId);
            result.setSntpServers(this.sntpServers);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dhcp_server_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_server_ip",
                                                                                "dhcpServerIp",
                                                                                "getDhcpServerIp",
                                                                                "setDhcpServerIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dns_nameservers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dns_nameservers",
                                                                                "dnsNameservers",
                                                                                "getDnsNameservers",
                                                                                "setDnsNameservers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("domain_names", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("domain_names",
                                                                                "domainNames",
                                                                                "getDomainNames",
                                                                                "setDomainNames");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_id",
                                                                                "serverId",
                                                                                "getServerId",
                                                                                "setServerId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sntp_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sntp_servers",
                                                                                "sntpServers",
                                                                                "getSntpServers",
                                                                                "setSntpServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.I_pv6_dhcp_server",
                                                            fields,
                                                            com.vmware.nsx.model.IPv6DhcpServer.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

