/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Identity Firewall master switch setting. This setting enables or disables
 * Identity Firewall feature across the system. It affects compute collections,
 * hypervisor and virtual machines. This operation is expensive and also has big
 * impact and implication on system perforamce.
 */
public final class IdfwMasterSwitchSetting implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean idfwMasterSwitchEnabled;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IdfwMasterSwitchSetting() {
    }

    protected IdfwMasterSwitchSetting(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * IDFW master switch (true=Enabled / false=Disabled).
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIdfwMasterSwitchEnabled() {
        return this.idfwMasterSwitchEnabled;
    }

    /**
     * IDFW master switch (true=Enabled / false=Disabled).
     *
     * @param idfwMasterSwitchEnabled New value for the property.
     */
    public void setIdfwMasterSwitchEnabled(java.lang.Boolean idfwMasterSwitchEnabled) {
        this.idfwMasterSwitchEnabled = idfwMasterSwitchEnabled;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.idfwMasterSwitchSetting;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("idfw_master_switch_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.idfwMasterSwitchEnabled, this._getType().getField("idfw_master_switch_enabled")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.idfwMasterSwitchSetting;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.idfwMasterSwitchSetting.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IdfwMasterSwitchSetting _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IdfwMasterSwitchSetting(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IdfwMasterSwitchSetting _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IdfwMasterSwitchSetting(structValue);
    }

    /**
     * Builder class for {@link IdfwMasterSwitchSetting}.
     */
    public static final class Builder {
        private java.lang.Boolean idfwMasterSwitchEnabled;

        /**
         * Constructor with parameters for the required properties of
         * {@link IdfwMasterSwitchSetting}.
         */
        public Builder() {
        }

        /**
         * IDFW master switch (true=Enabled / false=Disabled).
         *
         * @param idfwMasterSwitchEnabled New value for the property.
         */
        public Builder setIdfwMasterSwitchEnabled(java.lang.Boolean idfwMasterSwitchEnabled) {
            this.idfwMasterSwitchEnabled = idfwMasterSwitchEnabled;
            return this;
        }

        public IdfwMasterSwitchSetting build() {
            IdfwMasterSwitchSetting result = new IdfwMasterSwitchSetting();
            result.setIdfwMasterSwitchEnabled(this.idfwMasterSwitchEnabled);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("idfw_master_switch_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("idfw_master_switch_enabled",
                                                                                "idfwMasterSwitchEnabled",
                                                                                "getIdfwMasterSwitchEnabled",
                                                                                "setIdfwMasterSwitchEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.idfw_master_switch_setting",
                                                            fields,
                                                            com.vmware.nsx.model.IdfwMasterSwitchSetting.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

