/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

public final class IpDiscoverySwitchingProfile implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "IpDiscoverySwitchingProfile";

    private java.lang.Long arpBindingsLimit;

    private java.lang.Long arpNdBindingTimeout;

    private java.lang.Boolean arpSnoopingEnabled;

    private java.lang.Boolean dhcpSnoopingEnabled;

    private java.lang.Boolean dhcpv6SnoopingEnabled;

    private com.vmware.nsx.model.DuplicateIPDetection duplicateIpDetection;

    private java.lang.Long ndBindingsLimit;

    private java.lang.Boolean ndSnoopingEnabled;

    private java.lang.Boolean trustOnFirstUseEnabled;

    private java.lang.Boolean vmToolsEnabled;

    private java.lang.Boolean vmToolsV6Enabled;

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private final java.lang.String resourceType = "IpDiscoverySwitchingProfile";

    private java.util.List<com.vmware.nsx.model.Tag> tags;

    private java.util.List<java.lang.String> requiredCapabilities;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IpDiscoverySwitchingProfile() {
    }

    protected IpDiscoverySwitchingProfile(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Indicates the number of arp snooped IP addresses to be remembered per
     * LogicalPort. Decreasing this value, will retain the latest bindings from the
     * existing list of address bindings. Increasing this value will retain existing
     * bindings and also learn any new address bindings discovered on the port until
     * the new limit is reached. This limit only applies to IPv4 addresses and is
     * independent of the nd_bindings_limit used for IPv6 snooping. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getArpBindingsLimit() {
        return this.arpBindingsLimit;
    }

    /**
     * Indicates the number of arp snooped IP addresses to be remembered per
     * LogicalPort. Decreasing this value, will retain the latest bindings from the
     * existing list of address bindings. Increasing this value will retain existing
     * bindings and also learn any new address bindings discovered on the port until
     * the new limit is reached. This limit only applies to IPv4 addresses and is
     * independent of the nd_bindings_limit used for IPv6 snooping. format: int32
     *
     * @param arpBindingsLimit New value for the property.
     */
    public void setArpBindingsLimit(java.lang.Long arpBindingsLimit) {
        this.arpBindingsLimit = arpBindingsLimit;
    }

    /**
     * This property controls the ARP and ND cache timeout period.It is recommended
     * that this property be greater than the ARP/ND cache timeout on the VM. format:
     * int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getArpNdBindingTimeout() {
        return this.arpNdBindingTimeout;
    }

    /**
     * This property controls the ARP and ND cache timeout period.It is recommended
     * that this property be greater than the ARP/ND cache timeout on the VM. format:
     * int32
     *
     * @param arpNdBindingTimeout New value for the property.
     */
    public void setArpNdBindingTimeout(java.lang.Long arpNdBindingTimeout) {
        this.arpNdBindingTimeout = arpNdBindingTimeout;
    }

    /**
     * Indicates whether ARP snooping is enabled
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getArpSnoopingEnabled() {
        return this.arpSnoopingEnabled;
    }

    /**
     * Indicates whether ARP snooping is enabled
     *
     * @param arpSnoopingEnabled New value for the property.
     */
    public void setArpSnoopingEnabled(java.lang.Boolean arpSnoopingEnabled) {
        this.arpSnoopingEnabled = arpSnoopingEnabled;
    }

    /**
     * Indicates whether DHCP snooping is enabled
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDhcpSnoopingEnabled() {
        return this.dhcpSnoopingEnabled;
    }

    /**
     * Indicates whether DHCP snooping is enabled
     *
     * @param dhcpSnoopingEnabled New value for the property.
     */
    public void setDhcpSnoopingEnabled(java.lang.Boolean dhcpSnoopingEnabled) {
        this.dhcpSnoopingEnabled = dhcpSnoopingEnabled;
    }

    /**
     * This option is the IPv6 equivalent of DHCP snooping.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDhcpv6SnoopingEnabled() {
        return this.dhcpv6SnoopingEnabled;
    }

    /**
     * This option is the IPv6 equivalent of DHCP snooping.
     *
     * @param dhcpv6SnoopingEnabled New value for the property.
     */
    public void setDhcpv6SnoopingEnabled(java.lang.Boolean dhcpv6SnoopingEnabled) {
        this.dhcpv6SnoopingEnabled = dhcpv6SnoopingEnabled;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.DuplicateIPDetection getDuplicateIpDetection() {
        return this.duplicateIpDetection;
    }

    /**
     *
     *
     * @param duplicateIpDetection New value for the property.
     */
    public void setDuplicateIpDetection(com.vmware.nsx.model.DuplicateIPDetection duplicateIpDetection) {
        this.duplicateIpDetection = duplicateIpDetection;
    }

    /**
     * Indicates the number of neighbor-discovery snooped IP addresses to be remembered
     * per LogicalPort. Decreasing this value, will retain the latest bindings from the
     * existing list of address bindings. Increasing this value will retain existing
     * bindings and also learn any new address bindings discovered on the port until
     * the new limit is reached. This limit only applies to IPv6 addresses and is
     * independent of the arp_bindings_limit used for IPv4 snooping. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNdBindingsLimit() {
        return this.ndBindingsLimit;
    }

    /**
     * Indicates the number of neighbor-discovery snooped IP addresses to be remembered
     * per LogicalPort. Decreasing this value, will retain the latest bindings from the
     * existing list of address bindings. Increasing this value will retain existing
     * bindings and also learn any new address bindings discovered on the port until
     * the new limit is reached. This limit only applies to IPv6 addresses and is
     * independent of the arp_bindings_limit used for IPv4 snooping. format: int32
     *
     * @param ndBindingsLimit New value for the property.
     */
    public void setNdBindingsLimit(java.lang.Long ndBindingsLimit) {
        this.ndBindingsLimit = ndBindingsLimit;
    }

    /**
     * This option is the IPv6 equivalent of ARP snooping.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getNdSnoopingEnabled() {
        return this.ndSnoopingEnabled;
    }

    /**
     * This option is the IPv6 equivalent of ARP snooping.
     *
     * @param ndSnoopingEnabled New value for the property.
     */
    public void setNdSnoopingEnabled(java.lang.Boolean ndSnoopingEnabled) {
        this.ndSnoopingEnabled = ndSnoopingEnabled;
    }

    /**
     * ARP snooping being inherently susceptible to ARP spoofing, uses a
     * turst-on-fisrt-use (TOFU) paradigm where only the first IP address discovered
     * via ARP snooping is trusted. The remaining are ignored. In order to allow for
     * more flexibility, we allow the user to configure how many ARP snooped address
     * bindings should be trusted for the lifetime of the logical port. This is
     * controlled by the arp_bindings_limit property in the IP Discovery profile. We
     * refer to this extension of TOFU as N-TOFU. However, if TOFU is disabled, then N
     * ARP snooped IP addresses will be trusted until they are timed out, where N is
     * configured by arp_bindings_limit.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getTrustOnFirstUseEnabled() {
        return this.trustOnFirstUseEnabled;
    }

    /**
     * ARP snooping being inherently susceptible to ARP spoofing, uses a
     * turst-on-fisrt-use (TOFU) paradigm where only the first IP address discovered
     * via ARP snooping is trusted. The remaining are ignored. In order to allow for
     * more flexibility, we allow the user to configure how many ARP snooped address
     * bindings should be trusted for the lifetime of the logical port. This is
     * controlled by the arp_bindings_limit property in the IP Discovery profile. We
     * refer to this extension of TOFU as N-TOFU. However, if TOFU is disabled, then N
     * ARP snooped IP addresses will be trusted until they are timed out, where N is
     * configured by arp_bindings_limit.
     *
     * @param trustOnFirstUseEnabled New value for the property.
     */
    public void setTrustOnFirstUseEnabled(java.lang.Boolean trustOnFirstUseEnabled) {
        this.trustOnFirstUseEnabled = trustOnFirstUseEnabled;
    }

    /**
     * This option is only supported on ESX where vm-tools is installed.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getVmToolsEnabled() {
        return this.vmToolsEnabled;
    }

    /**
     * This option is only supported on ESX where vm-tools is installed.
     *
     * @param vmToolsEnabled New value for the property.
     */
    public void setVmToolsEnabled(java.lang.Boolean vmToolsEnabled) {
        this.vmToolsEnabled = vmToolsEnabled;
    }

    /**
     * This option is only supported on ESX where vm-tools is installed.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getVmToolsV6Enabled() {
        return this.vmToolsV6Enabled;
    }

    /**
     * This option is only supported on ESX where vm-tools is installed.
     *
     * @param vmToolsV6Enabled New value for the property.
     */
    public void setVmToolsV6Enabled(java.lang.Boolean vmToolsV6Enabled) {
        this.vmToolsV6Enabled = vmToolsV6Enabled;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     *
     * The value of this property is automatically populated to {@code "IpDiscoverySwitchingProfile"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getRequiredCapabilities() {
        return this.requiredCapabilities;
    }

    /**
     *
     *
     * @param requiredCapabilities New value for the property.
     */
    public void setRequiredCapabilities(java.util.List<java.lang.String> requiredCapabilities) {
        this.requiredCapabilities = requiredCapabilities;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.ipDiscoverySwitchingProfile;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("arp_bindings_limit",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.arpBindingsLimit, this._getType().getField("arp_bindings_limit")));
        structValue.setField("arp_nd_binding_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.arpNdBindingTimeout, this._getType().getField("arp_nd_binding_timeout")));
        structValue.setField("arp_snooping_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.arpSnoopingEnabled, this._getType().getField("arp_snooping_enabled")));
        structValue.setField("dhcp_snooping_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpSnoopingEnabled, this._getType().getField("dhcp_snooping_enabled")));
        structValue.setField("dhcpv6_snooping_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpv6SnoopingEnabled, this._getType().getField("dhcpv6_snooping_enabled")));
        structValue.setField("duplicate_ip_detection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.duplicateIpDetection, this._getType().getField("duplicate_ip_detection")));
        structValue.setField("nd_bindings_limit",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ndBindingsLimit, this._getType().getField("nd_bindings_limit")));
        structValue.setField("nd_snooping_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ndSnoopingEnabled, this._getType().getField("nd_snooping_enabled")));
        structValue.setField("trust_on_first_use_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.trustOnFirstUseEnabled, this._getType().getField("trust_on_first_use_enabled")));
        structValue.setField("vm_tools_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vmToolsEnabled, this._getType().getField("vm_tools_enabled")));
        structValue.setField("vm_tools_v6_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vmToolsV6Enabled, this._getType().getField("vm_tools_v6_enabled")));
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("required_capabilities",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requiredCapabilities, this._getType().getField("required_capabilities")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.ipDiscoverySwitchingProfile;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.ipDiscoverySwitchingProfile.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IpDiscoverySwitchingProfile _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IpDiscoverySwitchingProfile(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IpDiscoverySwitchingProfile _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IpDiscoverySwitchingProfile(structValue);
    }

    /**
     * Builder class for {@link IpDiscoverySwitchingProfile}.
     */
    public static final class Builder {
        private java.lang.Long arpBindingsLimit;
        private java.lang.Long arpNdBindingTimeout;
        private java.lang.Boolean arpSnoopingEnabled;
        private java.lang.Boolean dhcpSnoopingEnabled;
        private java.lang.Boolean dhcpv6SnoopingEnabled;
        private com.vmware.nsx.model.DuplicateIPDetection duplicateIpDetection;
        private java.lang.Long ndBindingsLimit;
        private java.lang.Boolean ndSnoopingEnabled;
        private java.lang.Boolean trustOnFirstUseEnabled;
        private java.lang.Boolean vmToolsEnabled;
        private java.lang.Boolean vmToolsV6Enabled;
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.util.List<com.vmware.nsx.model.Tag> tags;
        private java.util.List<java.lang.String> requiredCapabilities;

        /**
         * Constructor with parameters for the required properties of
         * {@link IpDiscoverySwitchingProfile}.
         */
        public Builder() {
        }

        /**
         * Indicates the number of arp snooped IP addresses to be remembered per
         * LogicalPort. Decreasing this value, will retain the latest bindings from the
         * existing list of address bindings. Increasing this value will retain existing
         * bindings and also learn any new address bindings discovered on the port until
         * the new limit is reached. This limit only applies to IPv4 addresses and is
         * independent of the nd_bindings_limit used for IPv6 snooping. format: int32
         *
         * @param arpBindingsLimit New value for the property.
         */
        public Builder setArpBindingsLimit(java.lang.Long arpBindingsLimit) {
            this.arpBindingsLimit = arpBindingsLimit;
            return this;
        }

        /**
         * This property controls the ARP and ND cache timeout period.It is recommended
         * that this property be greater than the ARP/ND cache timeout on the VM. format:
         * int32
         *
         * @param arpNdBindingTimeout New value for the property.
         */
        public Builder setArpNdBindingTimeout(java.lang.Long arpNdBindingTimeout) {
            this.arpNdBindingTimeout = arpNdBindingTimeout;
            return this;
        }

        /**
         * Indicates whether ARP snooping is enabled
         *
         * @param arpSnoopingEnabled New value for the property.
         */
        public Builder setArpSnoopingEnabled(java.lang.Boolean arpSnoopingEnabled) {
            this.arpSnoopingEnabled = arpSnoopingEnabled;
            return this;
        }

        /**
         * Indicates whether DHCP snooping is enabled
         *
         * @param dhcpSnoopingEnabled New value for the property.
         */
        public Builder setDhcpSnoopingEnabled(java.lang.Boolean dhcpSnoopingEnabled) {
            this.dhcpSnoopingEnabled = dhcpSnoopingEnabled;
            return this;
        }

        /**
         * This option is the IPv6 equivalent of DHCP snooping.
         *
         * @param dhcpv6SnoopingEnabled New value for the property.
         */
        public Builder setDhcpv6SnoopingEnabled(java.lang.Boolean dhcpv6SnoopingEnabled) {
            this.dhcpv6SnoopingEnabled = dhcpv6SnoopingEnabled;
            return this;
        }

        /**
         *
         *
         * @param duplicateIpDetection New value for the property.
         */
        public Builder setDuplicateIpDetection(com.vmware.nsx.model.DuplicateIPDetection duplicateIpDetection) {
            this.duplicateIpDetection = duplicateIpDetection;
            return this;
        }

        /**
         * Indicates the number of neighbor-discovery snooped IP addresses to be remembered
         * per LogicalPort. Decreasing this value, will retain the latest bindings from the
         * existing list of address bindings. Increasing this value will retain existing
         * bindings and also learn any new address bindings discovered on the port until
         * the new limit is reached. This limit only applies to IPv6 addresses and is
         * independent of the arp_bindings_limit used for IPv4 snooping. format: int32
         *
         * @param ndBindingsLimit New value for the property.
         */
        public Builder setNdBindingsLimit(java.lang.Long ndBindingsLimit) {
            this.ndBindingsLimit = ndBindingsLimit;
            return this;
        }

        /**
         * This option is the IPv6 equivalent of ARP snooping.
         *
         * @param ndSnoopingEnabled New value for the property.
         */
        public Builder setNdSnoopingEnabled(java.lang.Boolean ndSnoopingEnabled) {
            this.ndSnoopingEnabled = ndSnoopingEnabled;
            return this;
        }

        /**
         * ARP snooping being inherently susceptible to ARP spoofing, uses a
         * turst-on-fisrt-use (TOFU) paradigm where only the first IP address discovered
         * via ARP snooping is trusted. The remaining are ignored. In order to allow for
         * more flexibility, we allow the user to configure how many ARP snooped address
         * bindings should be trusted for the lifetime of the logical port. This is
         * controlled by the arp_bindings_limit property in the IP Discovery profile. We
         * refer to this extension of TOFU as N-TOFU. However, if TOFU is disabled, then N
         * ARP snooped IP addresses will be trusted until they are timed out, where N is
         * configured by arp_bindings_limit.
         *
         * @param trustOnFirstUseEnabled New value for the property.
         */
        public Builder setTrustOnFirstUseEnabled(java.lang.Boolean trustOnFirstUseEnabled) {
            this.trustOnFirstUseEnabled = trustOnFirstUseEnabled;
            return this;
        }

        /**
         * This option is only supported on ESX where vm-tools is installed.
         *
         * @param vmToolsEnabled New value for the property.
         */
        public Builder setVmToolsEnabled(java.lang.Boolean vmToolsEnabled) {
            this.vmToolsEnabled = vmToolsEnabled;
            return this;
        }

        /**
         * This option is only supported on ESX where vm-tools is installed.
         *
         * @param vmToolsV6Enabled New value for the property.
         */
        public Builder setVmToolsV6Enabled(java.lang.Boolean vmToolsV6Enabled) {
            this.vmToolsV6Enabled = vmToolsV6Enabled;
            return this;
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         *
         *
         * @param requiredCapabilities New value for the property.
         */
        public Builder setRequiredCapabilities(java.util.List<java.lang.String> requiredCapabilities) {
            this.requiredCapabilities = requiredCapabilities;
            return this;
        }

        public IpDiscoverySwitchingProfile build() {
            IpDiscoverySwitchingProfile result = new IpDiscoverySwitchingProfile();
            result.setArpBindingsLimit(this.arpBindingsLimit);
            result.setArpNdBindingTimeout(this.arpNdBindingTimeout);
            result.setArpSnoopingEnabled(this.arpSnoopingEnabled);
            result.setDhcpSnoopingEnabled(this.dhcpSnoopingEnabled);
            result.setDhcpv6SnoopingEnabled(this.dhcpv6SnoopingEnabled);
            result.setDuplicateIpDetection(this.duplicateIpDetection);
            result.setNdBindingsLimit(this.ndBindingsLimit);
            result.setNdSnoopingEnabled(this.ndSnoopingEnabled);
            result.setTrustOnFirstUseEnabled(this.trustOnFirstUseEnabled);
            result.setVmToolsEnabled(this.vmToolsEnabled);
            result.setVmToolsV6Enabled(this.vmToolsV6Enabled);
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setTags(this.tags);
            result.setRequiredCapabilities(this.requiredCapabilities);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("arp_bindings_limit", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("arp_bindings_limit",
                                                                                "arpBindingsLimit",
                                                                                "getArpBindingsLimit",
                                                                                "setArpBindingsLimit");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("arp_nd_binding_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("arp_nd_binding_timeout",
                                                                                "arpNdBindingTimeout",
                                                                                "getArpNdBindingTimeout",
                                                                                "setArpNdBindingTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("arp_snooping_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("arp_snooping_enabled",
                                                                                "arpSnoopingEnabled",
                                                                                "getArpSnoopingEnabled",
                                                                                "setArpSnoopingEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dhcp_snooping_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_snooping_enabled",
                                                                                "dhcpSnoopingEnabled",
                                                                                "getDhcpSnoopingEnabled",
                                                                                "setDhcpSnoopingEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dhcpv6_snooping_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcpv6_snooping_enabled",
                                                                                "dhcpv6SnoopingEnabled",
                                                                                "getDhcpv6SnoopingEnabled",
                                                                                "setDhcpv6SnoopingEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("duplicate_ip_detection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.duplicateIPDetection; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("duplicate_ip_detection",
                                                                                "duplicateIpDetection",
                                                                                "getDuplicateIpDetection",
                                                                                "setDuplicateIpDetection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nd_bindings_limit", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nd_bindings_limit",
                                                                                "ndBindingsLimit",
                                                                                "getNdBindingsLimit",
                                                                                "setNdBindingsLimit");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nd_snooping_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nd_snooping_enabled",
                                                                                "ndSnoopingEnabled",
                                                                                "getNdSnoopingEnabled",
                                                                                "setNdSnoopingEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("trust_on_first_use_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("trust_on_first_use_enabled",
                                                                                "trustOnFirstUseEnabled",
                                                                                "getTrustOnFirstUseEnabled",
                                                                                "setTrustOnFirstUseEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vm_tools_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vm_tools_enabled",
                                                                                "vmToolsEnabled",
                                                                                "getVmToolsEnabled",
                                                                                "setVmToolsEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vm_tools_v6_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vm_tools_v6_enabled",
                                                                                "vmToolsV6Enabled",
                                                                                "getVmToolsV6Enabled",
                                                                                "setVmToolsV6Enabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("required_capabilities", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("required_capabilities",
                                                                                "requiredCapabilities",
                                                                                "getRequiredCapabilities",
                                                                                "setRequiredCapabilities");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.ip_discovery_switching_profile",
                                                            fields,
                                                            com.vmware.nsx.model.IpDiscoverySwitchingProfile.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "IpDiscoverySwitchingProfile");
    }
}

