/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * To join a new node to the NSX cluster, issue a JoinCluster API on the new node.
 * The JoinCluster API takes this object as a parameter. Provide the ID of the NSX
 * cluster you want the new node to join and the IP address of one of the nodes
 * already in that cluster. The Cluster Boot Manager running on the new node will
 * then add the new node to the NSX cluster by making a AttachClusterNode REST API
 * call on the node that is already part of the cluster. In order to make a REST
 * API call to the node in the cluster, the Cluster Boot Manager will need username
 * and password of a priviledged user on the node in the cluster. In place of a
 * username and password, Cluster Boot Manager could also use a OAuth token
 * provided. The Cluster Boot Manager needs either the username and password or the
 * OAuth token to make the REST call but not both.
 */
public final class JoinClusterParameters implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String certficateSha256Thumbprint;

    private java.lang.String certificateSha256Thumbprint;

    private java.lang.String clusterId;

    private java.lang.String ipAddress;

    private java.lang.String password;

    private java.lang.Long port;

    private java.lang.String token;

    private java.lang.String username;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public JoinClusterParameters() {
    }

    protected JoinClusterParameters(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * SHA256 Thumbprint of the API certificate of the cluster node
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getCertficateSha256Thumbprint() {
        return this.certficateSha256Thumbprint;
    }

    /**
     * SHA256 Thumbprint of the API certificate of the cluster node
     *
     * @param certficateSha256Thumbprint New value for the property.
     */
    @Deprecated
    public void setCertficateSha256Thumbprint(java.lang.String certficateSha256Thumbprint) {
        this.certficateSha256Thumbprint = certficateSha256Thumbprint;
    }

    /**
     * SHA256 Thumbprint of the API certificate of the cluster node
     *
     * @return The current value of the property.
     */
    public java.lang.String getCertificateSha256Thumbprint() {
        return this.certificateSha256Thumbprint;
    }

    /**
     * SHA256 Thumbprint of the API certificate of the cluster node
     *
     * @param certificateSha256Thumbprint New value for the property.
     */
    public void setCertificateSha256Thumbprint(java.lang.String certificateSha256Thumbprint) {
        this.certificateSha256Thumbprint = certificateSha256Thumbprint;
    }

    /**
     * UUID of the cluster to join
     *
     * @return The current value of the property.
     */
    public java.lang.String getClusterId() {
        return this.clusterId;
    }

    /**
     * UUID of the cluster to join
     *
     * @param clusterId New value for the property.
     */
    public void setClusterId(java.lang.String clusterId) {
        this.clusterId = clusterId;
    }

    /**
     * IP address of a node already part of the cluster to join
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpAddress() {
        return this.ipAddress;
    }

    /**
     * IP address of a node already part of the cluster to join
     *
     * @param ipAddress New value for the property.
     */
    public void setIpAddress(java.lang.String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * Password of the user on the cluster node
     *
     * @return The current value of the property.
     */
    public java.lang.String getPassword() {
        return this.password;
    }

    /**
     * Password of the user on the cluster node
     *
     * @param password New value for the property.
     */
    public void setPassword(java.lang.String password) {
        this.password = password;
    }

    /**
     * API port on the cluster node format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPort() {
        return this.port;
    }

    /**
     * API port on the cluster node format: int64
     *
     * @param port New value for the property.
     */
    public void setPort(java.lang.Long port) {
        this.port = port;
    }

    /**
     * Limited time OAuth token instead of the username/password
     *
     * @return The current value of the property.
     */
    public java.lang.String getToken() {
        return this.token;
    }

    /**
     * Limited time OAuth token instead of the username/password
     *
     * @param token New value for the property.
     */
    public void setToken(java.lang.String token) {
        this.token = token;
    }

    /**
     * Username on the cluster node
     *
     * @return The current value of the property.
     */
    public java.lang.String getUsername() {
        return this.username;
    }

    /**
     * Username on the cluster node
     *
     * @param username New value for the property.
     */
    public void setUsername(java.lang.String username) {
        this.username = username;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.joinClusterParameters;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("certficate_sha256_thumbprint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certficateSha256Thumbprint, this._getType().getField("certficate_sha256_thumbprint")));
        structValue.setField("certificate_sha256_thumbprint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certificateSha256Thumbprint, this._getType().getField("certificate_sha256_thumbprint")));
        structValue.setField("cluster_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clusterId, this._getType().getField("cluster_id")));
        structValue.setField("ip_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddress, this._getType().getField("ip_address")));
        structValue.setField("password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.password, this._getType().getField("password")));
        structValue.setField("port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.port, this._getType().getField("port")));
        structValue.setField("token",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.token, this._getType().getField("token")));
        structValue.setField("username",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.username, this._getType().getField("username")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.joinClusterParameters;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.joinClusterParameters.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static JoinClusterParameters _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new JoinClusterParameters(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static JoinClusterParameters _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new JoinClusterParameters(structValue);
    }

    /**
     * Builder class for {@link JoinClusterParameters}.
     */
    public static final class Builder {
        private java.lang.String certficateSha256Thumbprint;
        private java.lang.String certificateSha256Thumbprint;
        private java.lang.String clusterId;
        private java.lang.String ipAddress;
        private java.lang.String password;
        private java.lang.Long port;
        private java.lang.String token;
        private java.lang.String username;

        /**
         * Constructor with parameters for the required properties of
         * {@link JoinClusterParameters}.
         */
        public Builder() {
        }

        /**
         * SHA256 Thumbprint of the API certificate of the cluster node
         *
         * @param certficateSha256Thumbprint New value for the property.
         */
        public Builder setCertficateSha256Thumbprint(java.lang.String certficateSha256Thumbprint) {
            this.certficateSha256Thumbprint = certficateSha256Thumbprint;
            return this;
        }

        /**
         * SHA256 Thumbprint of the API certificate of the cluster node
         *
         * @param certificateSha256Thumbprint New value for the property.
         */
        public Builder setCertificateSha256Thumbprint(java.lang.String certificateSha256Thumbprint) {
            this.certificateSha256Thumbprint = certificateSha256Thumbprint;
            return this;
        }

        /**
         * UUID of the cluster to join
         *
         * @param clusterId New value for the property.
         */
        public Builder setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        /**
         * IP address of a node already part of the cluster to join
         *
         * @param ipAddress New value for the property.
         */
        public Builder setIpAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Password of the user on the cluster node
         *
         * @param password New value for the property.
         */
        public Builder setPassword(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * API port on the cluster node format: int64
         *
         * @param port New value for the property.
         */
        public Builder setPort(java.lang.Long port) {
            this.port = port;
            return this;
        }

        /**
         * Limited time OAuth token instead of the username/password
         *
         * @param token New value for the property.
         */
        public Builder setToken(java.lang.String token) {
            this.token = token;
            return this;
        }

        /**
         * Username on the cluster node
         *
         * @param username New value for the property.
         */
        public Builder setUsername(java.lang.String username) {
            this.username = username;
            return this;
        }

        public JoinClusterParameters build() {
            JoinClusterParameters result = new JoinClusterParameters();
            result.setCertficateSha256Thumbprint(this.certficateSha256Thumbprint);
            result.setCertificateSha256Thumbprint(this.certificateSha256Thumbprint);
            result.setClusterId(this.clusterId);
            result.setIpAddress(this.ipAddress);
            result.setPassword(this.password);
            result.setPort(this.port);
            result.setToken(this.token);
            result.setUsername(this.username);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("certficate_sha256_thumbprint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certficate_sha256_thumbprint",
                                                                                "certficateSha256Thumbprint",
                                                                                "getCertficateSha256Thumbprint",
                                                                                "setCertficateSha256Thumbprint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("certificate_sha256_thumbprint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certificate_sha256_thumbprint",
                                                                                "certificateSha256Thumbprint",
                                                                                "getCertificateSha256Thumbprint",
                                                                                "setCertificateSha256Thumbprint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cluster_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cluster_id",
                                                                                "clusterId",
                                                                                "getClusterId",
                                                                                "setClusterId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_address",
                                                                                "ipAddress",
                                                                                "getIpAddress",
                                                                                "setIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("password",
                                                                                "password",
                                                                                "getPassword",
                                                                                "setPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port",
                                                                                "port",
                                                                                "getPort",
                                                                                "setPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("token", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("token",
                                                                                "token",
                                                                                "getToken",
                                                                                "setToken");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("username", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("username",
                                                                                "username",
                                                                                "getUsername",
                                                                                "setUsername");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.join_cluster_parameters",
                                                            fields,
                                                            com.vmware.nsx.model.JoinClusterParameters.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

