/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The load balancer node usage summary for all nodes. Only EdgeNode is supported.
 * The summary calculation is based on all edge nodes configured in edge clusters.
 */
public final class LbNodeUsageSummary implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String SEVERITY_GREEN = "GREEN";

    public static final java.lang.String SEVERITY_ORANGE = "ORANGE";

    public static final java.lang.String SEVERITY_RED = "RED";

    private java.lang.Long currentCreditNumber;

    private java.lang.Long currentPoolMembers;

    private java.util.List<com.vmware.nsx.model.LbNodeCountPerSeverity> nodeCounts;

    private java.util.List<com.vmware.vapi.bindings.Structure> nodeUsages;

    private java.lang.Long remainingCreditNumber;

    private java.lang.Long remainingPoolMembers;

    private java.lang.String severity;

    private java.lang.Double usagePercentage;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbNodeUsageSummary() {
    }

    protected LbNodeUsageSummary(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The current credit number reflects the overall credit usage for all nodes.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentCreditNumber() {
        return this.currentCreditNumber;
    }

    /**
     * The current credit number reflects the overall credit usage for all nodes.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentCreditNumber New value for the property.
     */
    public void setCurrentCreditNumber(java.lang.Long currentCreditNumber) {
        this.currentCreditNumber = currentCreditNumber;
    }

    /**
     * The overall number of pool members configured on all nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentPoolMembers() {
        return this.currentPoolMembers;
    }

    /**
     * The overall number of pool members configured on all nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentPoolMembers New value for the property.
     */
    public void setCurrentPoolMembers(java.lang.Long currentPoolMembers) {
        this.currentPoolMembers = currentPoolMembers;
    }

    /**
     * The property identifies array of node count for each severity (RED, ORANGE and
     * GREEN).
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.LbNodeCountPerSeverity> getNodeCounts() {
        return this.nodeCounts;
    }

    /**
     * The property identifies array of node count for each severity (RED, ORANGE and
     * GREEN).
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nodeCounts New value for the property.
     */
    public void setNodeCounts(java.util.List<com.vmware.nsx.model.LbNodeCountPerSeverity> nodeCounts) {
        this.nodeCounts = nodeCounts;
    }

    /**
     * The property contains lb node usages for each node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link com.vmware.nsx.model.LbNodeUsage}.
     * When methods return a value of this class as a return value, the property will
     * contain all the properties defined in {@link com.vmware.nsx.model.LbNodeUsage}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getNodeUsages() {
        return this.nodeUsages;
    }

    /**
     * The property contains lb node usages for each node.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nodeUsages New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link com.vmware.nsx.model.LbNodeUsage}.
     * When methods return a value of this class as a return value, the property will
     * contain all the properties defined in {@link com.vmware.nsx.model.LbNodeUsage}.
     */
    public void setNodeUsages(java.util.List<com.vmware.vapi.bindings.Structure> nodeUsages) {
        this.nodeUsages = nodeUsages;
    }

    /**
     * The remaining credit number is the overall remaining credits that can be used
     * for load balancer service configuration for all nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemainingCreditNumber() {
        return this.remainingCreditNumber;
    }

    /**
     * The remaining credit number is the overall remaining credits that can be used
     * for load balancer service configuration for all nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remainingCreditNumber New value for the property.
     */
    public void setRemainingCreditNumber(java.lang.Long remainingCreditNumber) {
        this.remainingCreditNumber = remainingCreditNumber;
    }

    /**
     * The overall remaining number of pool members which could be configured on all
     * nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRemainingPoolMembers() {
        return this.remainingPoolMembers;
    }

    /**
     * The overall remaining number of pool members which could be configured on all
     * nodes. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remainingPoolMembers New value for the property.
     */
    public void setRemainingPoolMembers(java.lang.Long remainingPoolMembers) {
        this.remainingPoolMembers = remainingPoolMembers;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbNodeUsageSummary#SEVERITY_GREEN}</li> <li> {@link
     * com.vmware.nsx.model.LbNodeUsageSummary#SEVERITY_ORANGE}</li> <li> {@link
     * com.vmware.nsx.model.LbNodeUsageSummary#SEVERITY_RED}</li> </ul> The severity
     * calculation is based on current credit usage percentage of load balancer for all
     * nodes.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSeverity() {
        return this.severity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbNodeUsageSummary#SEVERITY_GREEN}</li> <li> {@link
     * com.vmware.nsx.model.LbNodeUsageSummary#SEVERITY_ORANGE}</li> <li> {@link
     * com.vmware.nsx.model.LbNodeUsageSummary#SEVERITY_RED}</li> </ul> The severity
     * calculation is based on current credit usage percentage of load balancer for all
     * nodes.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param severity New value for the property.
     */
    public void setSeverity(java.lang.String severity) {
        this.severity = severity;
    }

    /**
     * The overall usage percentage of all nodes for load balancer. The value is the
     * larger value between overall pool member usage percentage and overall load
     * balancer credit usage percentage.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getUsagePercentage() {
        return this.usagePercentage;
    }

    /**
     * The overall usage percentage of all nodes for load balancer. The value is the
     * larger value between overall pool member usage percentage and overall load
     * balancer credit usage percentage.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param usagePercentage New value for the property.
     */
    public void setUsagePercentage(java.lang.Double usagePercentage) {
        this.usagePercentage = usagePercentage;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbNodeUsageSummary;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("current_credit_number",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentCreditNumber, this._getType().getField("current_credit_number")));
        structValue.setField("current_pool_members",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentPoolMembers, this._getType().getField("current_pool_members")));
        structValue.setField("node_counts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeCounts, this._getType().getField("node_counts")));
        structValue.setField("node_usages",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeUsages, this._getType().getField("node_usages")));
        structValue.setField("remaining_credit_number",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remainingCreditNumber, this._getType().getField("remaining_credit_number")));
        structValue.setField("remaining_pool_members",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remainingPoolMembers, this._getType().getField("remaining_pool_members")));
        structValue.setField("severity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.severity, this._getType().getField("severity")));
        structValue.setField("usage_percentage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.usagePercentage, this._getType().getField("usage_percentage")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbNodeUsageSummary;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbNodeUsageSummary.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbNodeUsageSummary _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbNodeUsageSummary(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbNodeUsageSummary _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbNodeUsageSummary(structValue);
    }

    /**
     * Builder class for {@link LbNodeUsageSummary}.
     */
    public static final class Builder {
        private java.lang.Long currentCreditNumber;
        private java.lang.Long currentPoolMembers;
        private java.util.List<com.vmware.nsx.model.LbNodeCountPerSeverity> nodeCounts;
        private java.util.List<com.vmware.vapi.bindings.Structure> nodeUsages;
        private java.lang.Long remainingCreditNumber;
        private java.lang.Long remainingPoolMembers;
        private java.lang.String severity;
        private java.lang.Double usagePercentage;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbNodeUsageSummary}.
         */
        public Builder() {
        }

        /**
         * The current credit number reflects the overall credit usage for all nodes.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentCreditNumber New value for the property.
         */
        public Builder setCurrentCreditNumber(java.lang.Long currentCreditNumber) {
            this.currentCreditNumber = currentCreditNumber;
            return this;
        }

        /**
         * The overall number of pool members configured on all nodes. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentPoolMembers New value for the property.
         */
        public Builder setCurrentPoolMembers(java.lang.Long currentPoolMembers) {
            this.currentPoolMembers = currentPoolMembers;
            return this;
        }

        /**
         * The property identifies array of node count for each severity (RED, ORANGE and
         * GREEN).
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nodeCounts New value for the property.
         */
        public Builder setNodeCounts(java.util.List<com.vmware.nsx.model.LbNodeCountPerSeverity> nodeCounts) {
            this.nodeCounts = nodeCounts;
            return this;
        }

        /**
         * The property contains lb node usages for each node.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nodeUsages New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link com.vmware.nsx.model.LbNodeUsage}.
         * When methods return a value of this class as a return value, the property will
         * contain all the properties defined in {@link com.vmware.nsx.model.LbNodeUsage}.
         */
        public Builder setNodeUsages(java.util.List<com.vmware.vapi.bindings.Structure> nodeUsages) {
            this.nodeUsages = nodeUsages;
            return this;
        }

        /**
         * The remaining credit number is the overall remaining credits that can be used
         * for load balancer service configuration for all nodes. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remainingCreditNumber New value for the property.
         */
        public Builder setRemainingCreditNumber(java.lang.Long remainingCreditNumber) {
            this.remainingCreditNumber = remainingCreditNumber;
            return this;
        }

        /**
         * The overall remaining number of pool members which could be configured on all
         * nodes. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remainingPoolMembers New value for the property.
         */
        public Builder setRemainingPoolMembers(java.lang.Long remainingPoolMembers) {
            this.remainingPoolMembers = remainingPoolMembers;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbNodeUsageSummary#SEVERITY_GREEN}</li> <li> {@link
         * com.vmware.nsx.model.LbNodeUsageSummary#SEVERITY_ORANGE}</li> <li> {@link
         * com.vmware.nsx.model.LbNodeUsageSummary#SEVERITY_RED}</li> </ul> The severity
         * calculation is based on current credit usage percentage of load balancer for all
         * nodes.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param severity New value for the property.
         */
        public Builder setSeverity(java.lang.String severity) {
            this.severity = severity;
            return this;
        }

        /**
         * The overall usage percentage of all nodes for load balancer. The value is the
         * larger value between overall pool member usage percentage and overall load
         * balancer credit usage percentage.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param usagePercentage New value for the property.
         */
        public Builder setUsagePercentage(java.lang.Double usagePercentage) {
            this.usagePercentage = usagePercentage;
            return this;
        }

        public LbNodeUsageSummary build() {
            LbNodeUsageSummary result = new LbNodeUsageSummary();
            result.setCurrentCreditNumber(this.currentCreditNumber);
            result.setCurrentPoolMembers(this.currentPoolMembers);
            result.setNodeCounts(this.nodeCounts);
            result.setNodeUsages(this.nodeUsages);
            result.setRemainingCreditNumber(this.remainingCreditNumber);
            result.setRemainingPoolMembers(this.remainingPoolMembers);
            result.setSeverity(this.severity);
            result.setUsagePercentage(this.usagePercentage);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("current_credit_number", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_credit_number",
                                                                                "currentCreditNumber",
                                                                                "getCurrentCreditNumber",
                                                                                "setCurrentCreditNumber");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_pool_members", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_pool_members",
                                                                                "currentPoolMembers",
                                                                                "getCurrentPoolMembers",
                                                                                "setCurrentPoolMembers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_counts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbNodeCountPerSeverity; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_counts",
                                                                                "nodeCounts",
                                                                                "getNodeCounts",
                                                                                "setNodeCounts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_usages", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbNodeUsage; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_usages",
                                                                                "nodeUsages",
                                                                                "getNodeUsages",
                                                                                "setNodeUsages");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remaining_credit_number", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remaining_credit_number",
                                                                                "remainingCreditNumber",
                                                                                "getRemainingCreditNumber",
                                                                                "setRemainingCreditNumber");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remaining_pool_members", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remaining_pool_members",
                                                                                "remainingPoolMembers",
                                                                                "getRemainingPoolMembers",
                                                                                "setRemainingPoolMembers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("severity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("severity",
                                                                                "severity",
                                                                                "getSeverity",
                                                                                "setSeverity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("usage_percentage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("usage_percentage",
                                                                                "usagePercentage",
                                                                                "getUsagePercentage",
                                                                                "setUsagePercentage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_node_usage_summary",
                                                            fields,
                                                            com.vmware.nsx.model.LbNodeUsageSummary.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

