/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Load balancer rule actions are used to manipulate application traffic. Currently
 * load balancer rules can be used at three load balancer processing phases. Each
 * phase has its own supported type of actions. Supported actions in
 * HTTP_REQUST_REWRITE phase are: LbHttpRequestUriRewriteAction
 * LbHttpRequestHeaderRewriteAction LbHttpRequestHeaderDeleteAction
 * LbVariableAssignmentAction Supported actions in HTTP_FORWARDING phase are:
 * LbHttpRejectAction LbHttpRedirectAction LbSelectPoolAction
 * LbVariablePersistenceOnAction LbConnectionDropAction Supported action in
 * HTTP_RESPONSE_REWRITE phase is: LbHttpResponseHeaderRewriteAction
 * LbHttpResponseHeaderDeleteAction LbVariablePersistenceLearnAction Supported
 * action in HTTP_ACCESS phase is: LbJwtAuthAction LbConnectionDropAction
 * LbVariableAssignmentAction Supported action in TRANSPORT phase is:
 * LbSslModeSelectionAction LbSelectPoolAction If the match type of an
 * LbRuleCondition field is specified as REGEX and named capturing groups are used
 * in the specified regular expression. The groups can be used as variables in
 * LbRuleAction fields. For example, define a rule with LbHttpRequestUriCondition
 * as match condition and LbHttpRequestUriRewriteAction as action. Set match_type
 * field of LbHttpRequestUriCondition to REGEX, and set uri field to
 * \"/news/(?&lt;year&gt;\\d+)/(?&lt;month&gt;\\d+)/(?&lt;article&gt;.*)\". Set uri
 * field of LbHttpRequestUriRewriteAction to: \"/news/$year-$month/$article\" In
 * uri field of LbHttpRequestUriCondition, the (?&lt;year&gt;\\d+),
 * (?&lt;month&gt;\\d+) and (?&lt;article&gt;.*) are named capturing groups, they
 * define variables named $year, $month and $article respectively. The defined
 * variables are used in LbHttpRequestUriRewriteAction. For a matched HTTP request
 * with URI \"/news/2017/06/xyz.html\", the substring \"2017\" is captured in
 * variable $year, \"06\" is captured in variable $month, and \"xyz.html\" is
 * captured in variable $article. The LbHttpRequestUriRewriteAction will rewrite
 * the URI to: \"/news/2017-06/xyz.html\" A set of built-in variables can be used
 * in LbRuleAction as well. The name of built-in variables start with underscore,
 * the name of user defined variables is not allowed to start with underscore.
 * Following are some of the built-in variables: $_scheme: Reference the scheme
 * part of matched HTTP messages, could be \"http\" or \"https\". $_host: Host of
 * matched HTTP messages, for example \"www.example.com\". $_server_port: Port part
 * of URI, it is also the port of the server which accepted a request. Default port
 * is 80 for http and 443 for https. $_uri: The URI path, for example
 * \"/products/sample.html\". $_request_uri: Full original request URI with
 * arguments, for example, \"/products/sample.html?a=b&c=d\". $_args: URI
 * arguments, for instance \"a=b&c=d\" $_is_args: \"?\" if a request has URI
 * arguments, or an empty string otherwise. For the full list of built-in
 * variables, please reference the NSX-T Administrator's Guide.
 */
public final class LbRuleAction implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LbRuleAction";

    public static final java.lang.String TYPE_LBHTTPREQUESTURIREWRITEACTION = "LbHttpRequestUriRewriteAction";

    public static final java.lang.String TYPE_LBHTTPREQUESTHEADERREWRITEACTION = "LbHttpRequestHeaderRewriteAction";

    public static final java.lang.String TYPE_LBHTTPREJECTACTION = "LbHttpRejectAction";

    public static final java.lang.String TYPE_LBHTTPREDIRECTACTION = "LbHttpRedirectAction";

    public static final java.lang.String TYPE_LBSELECTPOOLACTION = "LbSelectPoolAction";

    public static final java.lang.String TYPE_LBSELECTSERVERACTION = "LbSelectServerAction";

    public static final java.lang.String TYPE_LBHTTPRESPONSEHEADERREWRITEACTION = "LbHttpResponseHeaderRewriteAction";

    public static final java.lang.String TYPE_LBHTTPREQUESTHEADERDELETEACTION = "LbHttpRequestHeaderDeleteAction";

    public static final java.lang.String TYPE_LBHTTPRESPONSEHEADERDELETEACTION = "LbHttpResponseHeaderDeleteAction";

    public static final java.lang.String TYPE_LBVARIABLEASSIGNMENTACTION = "LbVariableAssignmentAction";

    public static final java.lang.String TYPE_LBVARIABLEPERSISTENCEONACTION = "LbVariablePersistenceOnAction";

    public static final java.lang.String TYPE_LBVARIABLEPERSISTENCELEARNACTION = "LbVariablePersistenceLearnAction";

    public static final java.lang.String TYPE_LBJWTAUTHACTION = "LbJwtAuthAction";

    public static final java.lang.String TYPE_LBSSLMODESELECTIONACTION = "LbSslModeSelectionAction";

    public static final java.lang.String TYPE_LBCONNECTIONDROPACTION = "LbConnectionDropAction";

    private final java.lang.String type = "LbRuleAction";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbRuleAction() {
    }

    protected LbRuleAction(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPREQUESTURIREWRITEACTION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPREQUESTHEADERREWRITEACTION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPREJECTACTION}</li> <li>
     * {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPREDIRECTACTION}</li> <li>
     * {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBSELECTPOOLACTION}</li> <li>
     * {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBSELECTSERVERACTION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPRESPONSEHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPREQUESTHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBHTTPRESPONSEHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBVARIABLEASSIGNMENTACTION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBVARIABLEPERSISTENCEONACTION}</li> <li>
     * {@link
     * com.vmware.nsx.model.LbRuleAction#TYPE_LBVARIABLEPERSISTENCELEARNACTION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBJWTAUTHACTION}</li> <li>
     * {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBSSLMODESELECTIONACTION}</li>
     * <li> {@link com.vmware.nsx.model.LbRuleAction#TYPE_LBCONNECTIONDROPACTION}</li>
     * </ul> The property identifies the load balancer rule action type.
     * The value of this property is automatically populated to {@code "LbRuleAction"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbRuleAction;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbRuleAction;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbRuleAction.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbRuleAction _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbRuleAction(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbRuleAction _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbRuleAction(structValue);
    }

    /**
     * Builder class for {@link LbRuleAction}.
     */
    public static final class Builder {

        /**
         * Constructor with parameters for the required properties of
         * {@link LbRuleAction}.
         */
        public Builder() {
        }

        public LbRuleAction build() {
            LbRuleAction result = new LbRuleAction();
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_rule_action",
                                                            fields,
                                                            com.vmware.nsx.model.LbRuleAction.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LbRuleAction");
    }
}

