/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The information for a given load balancer service could be used for debugging
 * and troubleshooting. It includes load balancer service, associated virtual
 * servers, associated pools, associated profiles such as persistence, SSL,
 * application, associated monitors and associated rules.
 */
public final class LbServiceDebugInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<com.vmware.vapi.bindings.Structure> applicationProfiles;

    private java.util.List<com.vmware.nsx.model.LbClientSslProfile> clientSslProfiles;

    private java.util.List<com.vmware.vapi.bindings.Structure> monitors;

    private java.util.List<com.vmware.vapi.bindings.Structure> persistenceProfiles;

    private java.util.List<com.vmware.nsx.model.LbPool> pools;

    private java.util.List<com.vmware.nsx.model.LbRule> rules;

    private java.util.List<com.vmware.nsx.model.LbServerSslProfile> serverSslProfiles;

    private com.vmware.nsx.model.LbService service;

    private java.util.List<com.vmware.nsx.model.LbVirtualServer> virtualServers;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbServiceDebugInfo() {
    }

    protected LbServiceDebugInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The application profiles are associated to virtual servers
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link com.vmware.nsx.model.LbAppProfile}.
     * When methods return a value of this class as a return value, the property will
     * contain all the properties defined in {@link com.vmware.nsx.model.LbAppProfile}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getApplicationProfiles() {
        return this.applicationProfiles;
    }

    /**
     * The application profiles are associated to virtual servers
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param applicationProfiles New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link com.vmware.nsx.model.LbAppProfile}.
     * When methods return a value of this class as a return value, the property will
     * contain all the properties defined in {@link com.vmware.nsx.model.LbAppProfile}.
     */
    public void setApplicationProfiles(java.util.List<com.vmware.vapi.bindings.Structure> applicationProfiles) {
        this.applicationProfiles = applicationProfiles;
    }

    /**
     * The client SSL profiles are associated to virtual servers. The property is
     * deprecated as NSX-T Load Balancer is deprecated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx.model.LbClientSslProfile> getClientSslProfiles() {
        return this.clientSslProfiles;
    }

    /**
     * The client SSL profiles are associated to virtual servers. The property is
     * deprecated as NSX-T Load Balancer is deprecated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param clientSslProfiles New value for the property.
     */
    @Deprecated
    public void setClientSslProfiles(java.util.List<com.vmware.nsx.model.LbClientSslProfile> clientSslProfiles) {
        this.clientSslProfiles = clientSslProfiles;
    }

    /**
     * The load balancer monitors are associated to pools. The property is deprecated
     * as NSX-T Load Balancer is deprecated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link com.vmware.nsx.model.LbMonitor}.
     * When methods return a value of this class as a return value, the property will
     * contain all the properties defined in {@link com.vmware.nsx.model.LbMonitor}.
     */
    @Deprecated
    public java.util.List<com.vmware.vapi.bindings.Structure> getMonitors() {
        return this.monitors;
    }

    /**
     * The load balancer monitors are associated to pools. The property is deprecated
     * as NSX-T Load Balancer is deprecated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param monitors New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link com.vmware.nsx.model.LbMonitor}.
     * When methods return a value of this class as a return value, the property will
     * contain all the properties defined in {@link com.vmware.nsx.model.LbMonitor}.
     */
    @Deprecated
    public void setMonitors(java.util.List<com.vmware.vapi.bindings.Structure> monitors) {
        this.monitors = monitors;
    }

    /**
     * The persistence profiles are associated to virtual servers
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.LbPersistenceProfile}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.LbPersistenceProfile}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getPersistenceProfiles() {
        return this.persistenceProfiles;
    }

    /**
     * The persistence profiles are associated to virtual servers
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param persistenceProfiles New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.LbPersistenceProfile}. When methods return a value of this
     * class as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.LbPersistenceProfile}.
     */
    public void setPersistenceProfiles(java.util.List<com.vmware.vapi.bindings.Structure> persistenceProfiles) {
        this.persistenceProfiles = persistenceProfiles;
    }

    /**
     * The pools which are associated to the given load balancer service would be
     * included. The pools could be defined in virtual server default pool, sorry pool
     * or load balancer rule action.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.LbPool> getPools() {
        return this.pools;
    }

    /**
     * The pools which are associated to the given load balancer service would be
     * included. The pools could be defined in virtual server default pool, sorry pool
     * or load balancer rule action.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param pools New value for the property.
     */
    public void setPools(java.util.List<com.vmware.nsx.model.LbPool> pools) {
        this.pools = pools;
    }

    /**
     * The load balancer rules are associated to virtual servers. The property is
     * deprecated as NSX-T Load Balancer is deprecated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx.model.LbRule> getRules() {
        return this.rules;
    }

    /**
     * The load balancer rules are associated to virtual servers. The property is
     * deprecated as NSX-T Load Balancer is deprecated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param rules New value for the property.
     */
    @Deprecated
    public void setRules(java.util.List<com.vmware.nsx.model.LbRule> rules) {
        this.rules = rules;
    }

    /**
     * The server SSL profiles are associated to virtual servers. The property is
     * deprecated as NSX-T Load Balancer is deprecated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx.model.LbServerSslProfile> getServerSslProfiles() {
        return this.serverSslProfiles;
    }

    /**
     * The server SSL profiles are associated to virtual servers. The property is
     * deprecated as NSX-T Load Balancer is deprecated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param serverSslProfiles New value for the property.
     */
    @Deprecated
    public void setServerSslProfiles(java.util.List<com.vmware.nsx.model.LbServerSslProfile> serverSslProfiles) {
        this.serverSslProfiles = serverSslProfiles;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.LbService getService() {
        return this.service;
    }

    /**
     *
     *
     * @param service New value for the property.
     */
    public void setService(com.vmware.nsx.model.LbService service) {
        this.service = service;
    }

    /**
     * The virtual servers which are associated to the given load balancer service
     * would be included.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.LbVirtualServer> getVirtualServers() {
        return this.virtualServers;
    }

    /**
     * The virtual servers which are associated to the given load balancer service
     * would be included.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param virtualServers New value for the property.
     */
    public void setVirtualServers(java.util.List<com.vmware.nsx.model.LbVirtualServer> virtualServers) {
        this.virtualServers = virtualServers;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbServiceDebugInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("application_profiles",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.applicationProfiles, this._getType().getField("application_profiles")));
        structValue.setField("client_ssl_profiles",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientSslProfiles, this._getType().getField("client_ssl_profiles")));
        structValue.setField("monitors",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.monitors, this._getType().getField("monitors")));
        structValue.setField("persistence_profiles",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.persistenceProfiles, this._getType().getField("persistence_profiles")));
        structValue.setField("pools",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pools, this._getType().getField("pools")));
        structValue.setField("rules",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rules, this._getType().getField("rules")));
        structValue.setField("server_ssl_profiles",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverSslProfiles, this._getType().getField("server_ssl_profiles")));
        structValue.setField("service",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.service, this._getType().getField("service")));
        structValue.setField("virtual_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.virtualServers, this._getType().getField("virtual_servers")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbServiceDebugInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbServiceDebugInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbServiceDebugInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbServiceDebugInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbServiceDebugInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbServiceDebugInfo(structValue);
    }

    /**
     * Builder class for {@link LbServiceDebugInfo}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.vapi.bindings.Structure> applicationProfiles;
        private java.util.List<com.vmware.nsx.model.LbClientSslProfile> clientSslProfiles;
        private java.util.List<com.vmware.vapi.bindings.Structure> monitors;
        private java.util.List<com.vmware.vapi.bindings.Structure> persistenceProfiles;
        private java.util.List<com.vmware.nsx.model.LbPool> pools;
        private java.util.List<com.vmware.nsx.model.LbRule> rules;
        private java.util.List<com.vmware.nsx.model.LbServerSslProfile> serverSslProfiles;
        private com.vmware.nsx.model.LbService service;
        private java.util.List<com.vmware.nsx.model.LbVirtualServer> virtualServers;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbServiceDebugInfo}.
         */
        public Builder() {
        }

        /**
         * The application profiles are associated to virtual servers
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param applicationProfiles New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link com.vmware.nsx.model.LbAppProfile}.
         * When methods return a value of this class as a return value, the property will
         * contain all the properties defined in {@link com.vmware.nsx.model.LbAppProfile}.
         */
        public Builder setApplicationProfiles(java.util.List<com.vmware.vapi.bindings.Structure> applicationProfiles) {
            this.applicationProfiles = applicationProfiles;
            return this;
        }

        /**
         * The client SSL profiles are associated to virtual servers. The property is
         * deprecated as NSX-T Load Balancer is deprecated.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param clientSslProfiles New value for the property.
         */
        public Builder setClientSslProfiles(java.util.List<com.vmware.nsx.model.LbClientSslProfile> clientSslProfiles) {
            this.clientSslProfiles = clientSslProfiles;
            return this;
        }

        /**
         * The load balancer monitors are associated to pools. The property is deprecated
         * as NSX-T Load Balancer is deprecated.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param monitors New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link com.vmware.nsx.model.LbMonitor}.
         * When methods return a value of this class as a return value, the property will
         * contain all the properties defined in {@link com.vmware.nsx.model.LbMonitor}.
         */
        public Builder setMonitors(java.util.List<com.vmware.vapi.bindings.Structure> monitors) {
            this.monitors = monitors;
            return this;
        }

        /**
         * The persistence profiles are associated to virtual servers
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param persistenceProfiles New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx.model.LbPersistenceProfile}. When methods return a value of this
         * class as a return value, the property will contain all the properties defined in
         * {@link com.vmware.nsx.model.LbPersistenceProfile}.
         */
        public Builder setPersistenceProfiles(java.util.List<com.vmware.vapi.bindings.Structure> persistenceProfiles) {
            this.persistenceProfiles = persistenceProfiles;
            return this;
        }

        /**
         * The pools which are associated to the given load balancer service would be
         * included. The pools could be defined in virtual server default pool, sorry pool
         * or load balancer rule action.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param pools New value for the property.
         */
        public Builder setPools(java.util.List<com.vmware.nsx.model.LbPool> pools) {
            this.pools = pools;
            return this;
        }

        /**
         * The load balancer rules are associated to virtual servers. The property is
         * deprecated as NSX-T Load Balancer is deprecated.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param rules New value for the property.
         */
        public Builder setRules(java.util.List<com.vmware.nsx.model.LbRule> rules) {
            this.rules = rules;
            return this;
        }

        /**
         * The server SSL profiles are associated to virtual servers. The property is
         * deprecated as NSX-T Load Balancer is deprecated.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param serverSslProfiles New value for the property.
         */
        public Builder setServerSslProfiles(java.util.List<com.vmware.nsx.model.LbServerSslProfile> serverSslProfiles) {
            this.serverSslProfiles = serverSslProfiles;
            return this;
        }

        /**
         *
         *
         * @param service New value for the property.
         */
        public Builder setService(com.vmware.nsx.model.LbService service) {
            this.service = service;
            return this;
        }

        /**
         * The virtual servers which are associated to the given load balancer service
         * would be included.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param virtualServers New value for the property.
         */
        public Builder setVirtualServers(java.util.List<com.vmware.nsx.model.LbVirtualServer> virtualServers) {
            this.virtualServers = virtualServers;
            return this;
        }

        public LbServiceDebugInfo build() {
            LbServiceDebugInfo result = new LbServiceDebugInfo();
            result.setApplicationProfiles(this.applicationProfiles);
            result.setClientSslProfiles(this.clientSslProfiles);
            result.setMonitors(this.monitors);
            result.setPersistenceProfiles(this.persistenceProfiles);
            result.setPools(this.pools);
            result.setRules(this.rules);
            result.setServerSslProfiles(this.serverSslProfiles);
            result.setService(this.service);
            result.setVirtualServers(this.virtualServers);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("application_profiles", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbAppProfile; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("application_profiles",
                                                                                "applicationProfiles",
                                                                                "getApplicationProfiles",
                                                                                "setApplicationProfiles");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_ssl_profiles", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbClientSslProfile; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_ssl_profiles",
                                                                                "clientSslProfiles",
                                                                                "getClientSslProfiles",
                                                                                "setClientSslProfiles");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("monitors", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbMonitor; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("monitors",
                                                                                "monitors",
                                                                                "getMonitors",
                                                                                "setMonitors");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("persistence_profiles", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbPersistenceProfile; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("persistence_profiles",
                                                                                "persistenceProfiles",
                                                                                "getPersistenceProfiles",
                                                                                "setPersistenceProfiles");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pools", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbPool; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pools",
                                                                                "pools",
                                                                                "getPools",
                                                                                "setPools");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rules", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbRule; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rules",
                                                                                "rules",
                                                                                "getRules",
                                                                                "setRules");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_ssl_profiles", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbServerSslProfile; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_ssl_profiles",
                                                                                "serverSslProfiles",
                                                                                "getServerSslProfiles",
                                                                                "setServerSslProfiles");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbService; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service",
                                                                                "service",
                                                                                "getService",
                                                                                "setService");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("virtual_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbVirtualServer; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("virtual_servers",
                                                                                "virtualServers",
                                                                                "getVirtualServers",
                                                                                "setVirtualServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_service_debug_info",
                                                            fields,
                                                            com.vmware.nsx.model.LbServiceDebugInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

