/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

public final class LogicalPort implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ADMIN_STATE_UP = "UP";

    public static final java.lang.String ADMIN_STATE_DOWN = "DOWN";

    public static final java.lang.String INIT_STATE_UNBLOCKED_VLAN = "UNBLOCKED_VLAN";

    public static final java.lang.String INIT_STATE_RESTORE_VIF = "RESTORE_VIF";

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx.model.Tag> tags;

    private java.util.List<com.vmware.nsx.model.PacketAddressClassifier> addressBindings;

    private java.lang.String adminState;

    private com.vmware.nsx.model.LogicalPortAttachment attachment;

    private java.util.List<com.vmware.nsx.model.ExtraConfig> extraConfigs;

    private java.util.List<com.vmware.nsx.model.PacketAddressClassifier> ignoreAddressBindings;

    private java.lang.String initState;

    private java.lang.String internalId;

    private java.lang.String logicalSwitchId;

    private java.lang.String originId;

    private java.util.List<com.vmware.nsx.model.SwitchingProfileTypeIdEntry> switchingProfileIds;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LogicalPort() {
    }

    protected LogicalPort(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * Each address binding must contain both an IPElement and MAC address. VLAN ID is
     * optional. This binding configuration can be used by features such as spoof-guard
     * and overrides any discovered bindings. Any non unique entries are deduplicated
     * to generate a unique set of address bindings and then stored. For IP addresses,
     * a subnet address cannot have host bits set. A maximum of 128 unique address
     * bindings is allowed per port.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.PacketAddressClassifier> getAddressBindings() {
        return this.addressBindings;
    }

    /**
     * Each address binding must contain both an IPElement and MAC address. VLAN ID is
     * optional. This binding configuration can be used by features such as spoof-guard
     * and overrides any discovered bindings. Any non unique entries are deduplicated
     * to generate a unique set of address bindings and then stored. For IP addresses,
     * a subnet address cannot have host bits set. A maximum of 128 unique address
     * bindings is allowed per port.
     *
     * @param addressBindings New value for the property.
     */
    public void setAddressBindings(java.util.List<com.vmware.nsx.model.PacketAddressClassifier> addressBindings) {
        this.addressBindings = addressBindings;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LogicalPort#ADMIN_STATE_UP}</li> <li> {@link
     * com.vmware.nsx.model.LogicalPort#ADMIN_STATE_DOWN}</li> </ul> Represents Desired
     * state of the logical port
     *
     * @return The current value of the property.
     */
    public java.lang.String getAdminState() {
        return this.adminState;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LogicalPort#ADMIN_STATE_UP}</li> <li> {@link
     * com.vmware.nsx.model.LogicalPort#ADMIN_STATE_DOWN}</li> </ul> Represents Desired
     * state of the logical port
     *
     * @param adminState New value for the property.
     */
    public void setAdminState(java.lang.String adminState) {
        this.adminState = adminState;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.LogicalPortAttachment getAttachment() {
        return this.attachment;
    }

    /**
     *
     *
     * @param attachment New value for the property.
     */
    public void setAttachment(com.vmware.nsx.model.LogicalPortAttachment attachment) {
        this.attachment = attachment;
    }

    /**
     * This property could be used for vendor specific configuration in key value
     * string pairs. Logical port setting will override logical switch setting if the
     * same key was set on both logical switch and logical port.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ExtraConfig> getExtraConfigs() {
        return this.extraConfigs;
    }

    /**
     * This property could be used for vendor specific configuration in key value
     * string pairs. Logical port setting will override logical switch setting if the
     * same key was set on both logical switch and logical port.
     *
     * @param extraConfigs New value for the property.
     */
    public void setExtraConfigs(java.util.List<com.vmware.nsx.model.ExtraConfig> extraConfigs) {
        this.extraConfigs = extraConfigs;
    }

    /**
     * IP Discovery module uses various mechanisms to discover address bindings being
     * used on each port. If a user would like to ignore any specific discovered
     * address bindings or prevent the discovery of a particular set of discovered
     * bindings, then those address bindings can be provided here. Currently IP range
     * in CIDR format is not supported.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.PacketAddressClassifier> getIgnoreAddressBindings() {
        return this.ignoreAddressBindings;
    }

    /**
     * IP Discovery module uses various mechanisms to discover address bindings being
     * used on each port. If a user would like to ignore any specific discovered
     * address bindings or prevent the discovery of a particular set of discovered
     * bindings, then those address bindings can be provided here. Currently IP range
     * in CIDR format is not supported.
     *
     * @param ignoreAddressBindings New value for the property.
     */
    public void setIgnoreAddressBindings(java.util.List<com.vmware.nsx.model.PacketAddressClassifier> ignoreAddressBindings) {
        this.ignoreAddressBindings = ignoreAddressBindings;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LogicalPort#INIT_STATE_UNBLOCKED_VLAN}</li> <li> {@link
     * com.vmware.nsx.model.LogicalPort#INIT_STATE_RESTORE_VIF}</li> </ul> Set initial
     * state when a new logical port is created. 'UNBLOCKED_VLAN' means new port will
     * be unblocked on traffic in creation, also VLAN will be set with corresponding
     * logical switch setting. This port setting can only be configured at port
     * creation (POST), and cannot be modified. 'RESTORE_VIF' fetches and restores VIF
     * attachment from ESX host.
     *
     * @return The current value of the property.
     */
    public java.lang.String getInitState() {
        return this.initState;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LogicalPort#INIT_STATE_UNBLOCKED_VLAN}</li> <li> {@link
     * com.vmware.nsx.model.LogicalPort#INIT_STATE_RESTORE_VIF}</li> </ul> Set initial
     * state when a new logical port is created. 'UNBLOCKED_VLAN' means new port will
     * be unblocked on traffic in creation, also VLAN will be set with corresponding
     * logical switch setting. This port setting can only be configured at port
     * creation (POST), and cannot be modified. 'RESTORE_VIF' fetches and restores VIF
     * attachment from ESX host.
     *
     * @param initState New value for the property.
     */
    public void setInitState(java.lang.String initState) {
        this.initState = initState;
    }

    /**
     * The internal_id of the logical port may or may not be identical to it's managed
     * resource ID. If a VirtualMachine connected to logical port migrates from one
     * site to another, then on the destination site, it will be connected to different
     * logical port managed resource. However, the internal_id field will be persisted
     * across vmotion.
     *
     * @return The current value of the property.
     */
    public java.lang.String getInternalId() {
        return this.internalId;
    }

    /**
     * The internal_id of the logical port may or may not be identical to it's managed
     * resource ID. If a VirtualMachine connected to logical port migrates from one
     * site to another, then on the destination site, it will be connected to different
     * logical port managed resource. However, the internal_id field will be persisted
     * across vmotion.
     *
     * @param internalId New value for the property.
     */
    public void setInternalId(java.lang.String internalId) {
        this.internalId = internalId;
    }

    /**
     * Id of the Logical switch that this port belongs to.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLogicalSwitchId() {
        return this.logicalSwitchId;
    }

    /**
     * Id of the Logical switch that this port belongs to.
     *
     * @param logicalSwitchId New value for the property.
     */
    public void setLogicalSwitchId(java.lang.String logicalSwitchId) {
        this.logicalSwitchId = logicalSwitchId;
    }

    /**
     * ID populated by NSX when NSX on DVPG is used to indicate the source distributed
     * virtual port and the corresponding distributed virtual switch. This ID is
     * populated only for logical ports that belong to a logical switch of type DVPG.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOriginId() {
        return this.originId;
    }

    /**
     * ID populated by NSX when NSX on DVPG is used to indicate the source distributed
     * virtual port and the corresponding distributed virtual switch. This ID is
     * populated only for logical ports that belong to a logical switch of type DVPG.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param originId New value for the property.
     */
    public void setOriginId(java.lang.String originId) {
        this.originId = originId;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.SwitchingProfileTypeIdEntry> getSwitchingProfileIds() {
        return this.switchingProfileIds;
    }

    /**
     *
     *
     * @param switchingProfileIds New value for the property.
     */
    public void setSwitchingProfileIds(java.util.List<com.vmware.nsx.model.SwitchingProfileTypeIdEntry> switchingProfileIds) {
        this.switchingProfileIds = switchingProfileIds;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.logicalPort;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("address_bindings",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.addressBindings, this._getType().getField("address_bindings")));
        structValue.setField("admin_state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.adminState, this._getType().getField("admin_state")));
        structValue.setField("attachment",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.attachment, this._getType().getField("attachment")));
        structValue.setField("extra_configs",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.extraConfigs, this._getType().getField("extra_configs")));
        structValue.setField("ignore_address_bindings",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ignoreAddressBindings, this._getType().getField("ignore_address_bindings")));
        structValue.setField("init_state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.initState, this._getType().getField("init_state")));
        structValue.setField("internal_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.internalId, this._getType().getField("internal_id")));
        structValue.setField("logical_switch_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.logicalSwitchId, this._getType().getField("logical_switch_id")));
        structValue.setField("origin_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.originId, this._getType().getField("origin_id")));
        structValue.setField("switching_profile_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.switchingProfileIds, this._getType().getField("switching_profile_ids")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.logicalPort;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.logicalPort.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LogicalPort _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LogicalPort(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LogicalPort _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LogicalPort(structValue);
    }

    /**
     * Builder class for {@link LogicalPort}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx.model.Tag> tags;
        private java.util.List<com.vmware.nsx.model.PacketAddressClassifier> addressBindings;
        private java.lang.String adminState;
        private com.vmware.nsx.model.LogicalPortAttachment attachment;
        private java.util.List<com.vmware.nsx.model.ExtraConfig> extraConfigs;
        private java.util.List<com.vmware.nsx.model.PacketAddressClassifier> ignoreAddressBindings;
        private java.lang.String initState;
        private java.lang.String internalId;
        private java.lang.String logicalSwitchId;
        private java.lang.String originId;
        private java.util.List<com.vmware.nsx.model.SwitchingProfileTypeIdEntry> switchingProfileIds;

        /**
         * Constructor with parameters for the required properties of
         * {@link LogicalPort}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Each address binding must contain both an IPElement and MAC address. VLAN ID is
         * optional. This binding configuration can be used by features such as spoof-guard
         * and overrides any discovered bindings. Any non unique entries are deduplicated
         * to generate a unique set of address bindings and then stored. For IP addresses,
         * a subnet address cannot have host bits set. A maximum of 128 unique address
         * bindings is allowed per port.
         *
         * @param addressBindings New value for the property.
         */
        public Builder setAddressBindings(java.util.List<com.vmware.nsx.model.PacketAddressClassifier> addressBindings) {
            this.addressBindings = addressBindings;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LogicalPort#ADMIN_STATE_UP}</li> <li> {@link
         * com.vmware.nsx.model.LogicalPort#ADMIN_STATE_DOWN}</li> </ul> Represents Desired
         * state of the logical port
         *
         * @param adminState New value for the property.
         */
        public Builder setAdminState(java.lang.String adminState) {
            this.adminState = adminState;
            return this;
        }

        /**
         *
         *
         * @param attachment New value for the property.
         */
        public Builder setAttachment(com.vmware.nsx.model.LogicalPortAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        /**
         * This property could be used for vendor specific configuration in key value
         * string pairs. Logical port setting will override logical switch setting if the
         * same key was set on both logical switch and logical port.
         *
         * @param extraConfigs New value for the property.
         */
        public Builder setExtraConfigs(java.util.List<com.vmware.nsx.model.ExtraConfig> extraConfigs) {
            this.extraConfigs = extraConfigs;
            return this;
        }

        /**
         * IP Discovery module uses various mechanisms to discover address bindings being
         * used on each port. If a user would like to ignore any specific discovered
         * address bindings or prevent the discovery of a particular set of discovered
         * bindings, then those address bindings can be provided here. Currently IP range
         * in CIDR format is not supported.
         *
         * @param ignoreAddressBindings New value for the property.
         */
        public Builder setIgnoreAddressBindings(java.util.List<com.vmware.nsx.model.PacketAddressClassifier> ignoreAddressBindings) {
            this.ignoreAddressBindings = ignoreAddressBindings;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LogicalPort#INIT_STATE_UNBLOCKED_VLAN}</li> <li> {@link
         * com.vmware.nsx.model.LogicalPort#INIT_STATE_RESTORE_VIF}</li> </ul> Set initial
         * state when a new logical port is created. 'UNBLOCKED_VLAN' means new port will
         * be unblocked on traffic in creation, also VLAN will be set with corresponding
         * logical switch setting. This port setting can only be configured at port
         * creation (POST), and cannot be modified. 'RESTORE_VIF' fetches and restores VIF
         * attachment from ESX host.
         *
         * @param initState New value for the property.
         */
        public Builder setInitState(java.lang.String initState) {
            this.initState = initState;
            return this;
        }

        /**
         * The internal_id of the logical port may or may not be identical to it's managed
         * resource ID. If a VirtualMachine connected to logical port migrates from one
         * site to another, then on the destination site, it will be connected to different
         * logical port managed resource. However, the internal_id field will be persisted
         * across vmotion.
         *
         * @param internalId New value for the property.
         */
        public Builder setInternalId(java.lang.String internalId) {
            this.internalId = internalId;
            return this;
        }

        /**
         * Id of the Logical switch that this port belongs to.
         *
         * @param logicalSwitchId New value for the property.
         */
        public Builder setLogicalSwitchId(java.lang.String logicalSwitchId) {
            this.logicalSwitchId = logicalSwitchId;
            return this;
        }

        /**
         * ID populated by NSX when NSX on DVPG is used to indicate the source distributed
         * virtual port and the corresponding distributed virtual switch. This ID is
         * populated only for logical ports that belong to a logical switch of type DVPG.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param originId New value for the property.
         */
        public Builder setOriginId(java.lang.String originId) {
            this.originId = originId;
            return this;
        }

        /**
         *
         *
         * @param switchingProfileIds New value for the property.
         */
        public Builder setSwitchingProfileIds(java.util.List<com.vmware.nsx.model.SwitchingProfileTypeIdEntry> switchingProfileIds) {
            this.switchingProfileIds = switchingProfileIds;
            return this;
        }

        public LogicalPort build() {
            LogicalPort result = new LogicalPort();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setAddressBindings(this.addressBindings);
            result.setAdminState(this.adminState);
            result.setAttachment(this.attachment);
            result.setExtraConfigs(this.extraConfigs);
            result.setIgnoreAddressBindings(this.ignoreAddressBindings);
            result.setInitState(this.initState);
            result.setInternalId(this.internalId);
            result.setLogicalSwitchId(this.logicalSwitchId);
            result.setOriginId(this.originId);
            result.setSwitchingProfileIds(this.switchingProfileIds);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("address_bindings", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.packetAddressClassifier; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("address_bindings",
                                                                                "addressBindings",
                                                                                "getAddressBindings",
                                                                                "setAddressBindings");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("admin_state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("admin_state",
                                                                                "adminState",
                                                                                "getAdminState",
                                                                                "setAdminState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("attachment", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.logicalPortAttachment; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("attachment",
                                                                                "attachment",
                                                                                "getAttachment",
                                                                                "setAttachment");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("extra_configs", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.extraConfig; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("extra_configs",
                                                                                "extraConfigs",
                                                                                "getExtraConfigs",
                                                                                "setExtraConfigs");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ignore_address_bindings", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.packetAddressClassifier; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ignore_address_bindings",
                                                                                "ignoreAddressBindings",
                                                                                "getIgnoreAddressBindings",
                                                                                "setIgnoreAddressBindings");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("init_state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("init_state",
                                                                                "initState",
                                                                                "getInitState",
                                                                                "setInitState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("internal_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("internal_id",
                                                                                "internalId",
                                                                                "getInternalId",
                                                                                "setInternalId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("logical_switch_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("logical_switch_id",
                                                                                "logicalSwitchId",
                                                                                "getLogicalSwitchId",
                                                                                "setLogicalSwitchId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("origin_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("origin_id",
                                                                                "originId",
                                                                                "getOriginId",
                                                                                "setOriginId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("switching_profile_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.switchingProfileTypeIdEntry; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("switching_profile_ids",
                                                                                "switchingProfileIds",
                                                                                "getSwitchingProfileIds",
                                                                                "setSwitchingProfileIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.logical_port",
                                                            fields,
                                                            com.vmware.nsx.model.LogicalPort.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

