/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * It is a reference to any NSX profile. It comprise of NSX profile type eg.
 * DFWCPUProfile, CentralConfigProfile etc. and id of profile i.e. target_id
 */
public final class NSXProfileReference implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String PROFILE_TYPE_FIREWALLSESSIONTIMERPROFILE = "FirewallSessionTimerProfile";

    public static final java.lang.String PROFILE_TYPE_FIREWALLCPUMEMTHRESHOLDSPROFILE = "FirewallCpuMemThresholdsProfile";

    public static final java.lang.String PROFILE_TYPE_GISERVICEPROFILE = "GiServiceProfile";

    public static final java.lang.String PROFILE_TYPE_FIREWALLFLOODPROTECTIONPROFILE = "FirewallFloodProtectionProfile";

    public static final java.lang.String PROFILE_TYPE_FIREWALLDNSPROFILE = "FirewallDnsProfile";

    public static final java.lang.String PROFILE_TYPE_LATENCYSTATPROFILE = "LatencyStatProfile";

    public static final java.lang.String PROFILE_TYPE_SHAPROFILE = "SHAProfile";

    public static final java.lang.String PROFILE_TYPE_IPDISCOVERYSWITCHINGUPMPROFILE = "IpDiscoverySwitchingUpmProfile";

    public static final java.lang.String PROFILE_TYPE_SYSTEMHEALTHPLUGINPROFILE = "SystemHealthPluginProfile";

    public static final java.lang.String PROFILE_TYPE_GENERALSECURITYSETTINGSPROFILE = "GeneralSecuritySettingsProfile";

    public static final java.lang.String PROFILE_TYPE_IPFIXSWITCHUPMPROFILE = "IpfixSwitchUpmProfile";

    public static final java.lang.String PROFILE_TYPE_IPFIXCOLLECTORUPMPROFILE = "IpfixCollectorUpmProfile";

    public static final java.lang.String PROFILE_TYPE_PACEHOSTCONFIGPROFILE = "PaceHostConfigProfile";

    public static final java.lang.String PROFILE_TYPE_COMMONAGENTHOSTCONFIGPROFILE = "CommonAgentHostConfigProfile";

    public static final java.lang.String PROFILE_TYPE_ODSPROFILE = "OdsProfile";

    private java.lang.Boolean isValid;

    private java.lang.String targetDisplayName;

    private java.lang.String targetId;

    private java.lang.String targetType;

    private java.lang.String profileType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NSXProfileReference() {
    }

    protected NSXProfileReference(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Will be set to false if the referenced NSX resource has been deleted.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsValid() {
        return this.isValid;
    }

    /**
     * Will be set to false if the referenced NSX resource has been deleted.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param isValid New value for the property.
     */
    public void setIsValid(java.lang.Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * Display name of the NSX resource.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTargetDisplayName() {
        return this.targetDisplayName;
    }

    /**
     * Display name of the NSX resource.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param targetDisplayName New value for the property.
     */
    public void setTargetDisplayName(java.lang.String targetDisplayName) {
        this.targetDisplayName = targetDisplayName;
    }

    /**
     * Identifier of the NSX resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTargetId() {
        return this.targetId;
    }

    /**
     * Identifier of the NSX resource.
     *
     * @param targetId New value for the property.
     */
    public void setTargetId(java.lang.String targetId) {
        this.targetId = targetId;
    }

    /**
     * Type of the NSX resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTargetType() {
        return this.targetType;
    }

    /**
     * Type of the NSX resource.
     *
     * @param targetType New value for the property.
     */
    public void setTargetType(java.lang.String targetType) {
        this.targetType = targetType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_FIREWALLSESSIONTIMERPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_FIREWALLCPUMEMTHRESHOLDSPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_GISERVICEPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_FIREWALLFLOODPROTECTIONPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_FIREWALLDNSPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_LATENCYSTATPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_SHAPROFILE}</li> <li>
     * {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_IPDISCOVERYSWITCHINGUPMPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_SYSTEMHEALTHPLUGINPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_GENERALSECURITYSETTINGSPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_IPFIXSWITCHUPMPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_IPFIXCOLLECTORUPMPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_PACEHOSTCONFIGPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_COMMONAGENTHOSTCONFIGPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_ODSPROFILE}</li> </ul>
     * Profile type of the ServiceConfig
     *
     * @return The current value of the property.
     */
    public java.lang.String getProfileType() {
        return this.profileType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_FIREWALLSESSIONTIMERPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_FIREWALLCPUMEMTHRESHOLDSPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_GISERVICEPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_FIREWALLFLOODPROTECTIONPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_FIREWALLDNSPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_LATENCYSTATPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_SHAPROFILE}</li> <li>
     * {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_IPDISCOVERYSWITCHINGUPMPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_SYSTEMHEALTHPLUGINPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_GENERALSECURITYSETTINGSPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_IPFIXSWITCHUPMPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_IPFIXCOLLECTORUPMPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_PACEHOSTCONFIGPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_COMMONAGENTHOSTCONFIGPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_ODSPROFILE}</li> </ul>
     * Profile type of the ServiceConfig
     *
     * @param profileType New value for the property.
     */
    public void setProfileType(java.lang.String profileType) {
        this.profileType = profileType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.NSXProfileReference;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("is_valid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isValid, this._getType().getField("is_valid")));
        structValue.setField("target_display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.targetDisplayName, this._getType().getField("target_display_name")));
        structValue.setField("target_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.targetId, this._getType().getField("target_id")));
        structValue.setField("target_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.targetType, this._getType().getField("target_type")));
        structValue.setField("profile_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.profileType, this._getType().getField("profile_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.NSXProfileReference;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.NSXProfileReference.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NSXProfileReference _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NSXProfileReference(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NSXProfileReference _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NSXProfileReference(structValue);
    }

    /**
     * Builder class for {@link NSXProfileReference}.
     */
    public static final class Builder {
        private java.lang.Boolean isValid;
        private java.lang.String targetDisplayName;
        private java.lang.String targetId;
        private java.lang.String targetType;
        private java.lang.String profileType;

        /**
         * Constructor with parameters for the required properties of
         * {@link NSXProfileReference}.
         */
        public Builder() {
        }

        /**
         * Will be set to false if the referenced NSX resource has been deleted.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param isValid New value for the property.
         */
        public Builder setIsValid(java.lang.Boolean isValid) {
            this.isValid = isValid;
            return this;
        }

        /**
         * Display name of the NSX resource.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param targetDisplayName New value for the property.
         */
        public Builder setTargetDisplayName(java.lang.String targetDisplayName) {
            this.targetDisplayName = targetDisplayName;
            return this;
        }

        /**
         * Identifier of the NSX resource.
         *
         * @param targetId New value for the property.
         */
        public Builder setTargetId(java.lang.String targetId) {
            this.targetId = targetId;
            return this;
        }

        /**
         * Type of the NSX resource.
         *
         * @param targetType New value for the property.
         */
        public Builder setTargetType(java.lang.String targetType) {
            this.targetType = targetType;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_FIREWALLSESSIONTIMERPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_FIREWALLCPUMEMTHRESHOLDSPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_GISERVICEPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_FIREWALLFLOODPROTECTIONPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_FIREWALLDNSPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_LATENCYSTATPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_SHAPROFILE}</li> <li>
         * {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_IPDISCOVERYSWITCHINGUPMPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_SYSTEMHEALTHPLUGINPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_GENERALSECURITYSETTINGSPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_IPFIXSWITCHUPMPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_IPFIXCOLLECTORUPMPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_PACEHOSTCONFIGPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_COMMONAGENTHOSTCONFIGPROFILE}</li>
         * <li> {@link
         * com.vmware.nsx.model.NSXProfileReference#PROFILE_TYPE_ODSPROFILE}</li> </ul>
         * Profile type of the ServiceConfig
         *
         * @param profileType New value for the property.
         */
        public Builder setProfileType(java.lang.String profileType) {
            this.profileType = profileType;
            return this;
        }

        public NSXProfileReference build() {
            NSXProfileReference result = new NSXProfileReference();
            result.setIsValid(this.isValid);
            result.setTargetDisplayName(this.targetDisplayName);
            result.setTargetId(this.targetId);
            result.setTargetType(this.targetType);
            result.setProfileType(this.profileType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("is_valid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_valid",
                                                                                "isValid",
                                                                                "getIsValid",
                                                                                "setIsValid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("target_display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("target_display_name",
                                                                                "targetDisplayName",
                                                                                "getTargetDisplayName",
                                                                                "setTargetDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("target_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("target_id",
                                                                                "targetId",
                                                                                "getTargetId",
                                                                                "setTargetId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("target_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("target_type",
                                                                                "targetType",
                                                                                "getTargetType",
                                                                                "setTargetType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("profile_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("profile_type",
                                                                                "profileType",
                                                                                "getProfileType",
                                                                                "setProfileType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.NSX_profile_reference",
                                                            fields,
                                                            com.vmware.nsx.model.NSXProfileReference.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

