/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Node network interface properties
 */
public final class NodeInterfaceProperties implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ADMIN_STATUS_UP = "UP";

    public static final java.lang.String ADMIN_STATUS_DOWN = "DOWN";

    public static final java.lang.String CONNECTED_SWITCH_TYPE_VSS = "VSS";

    public static final java.lang.String CONNECTED_SWITCH_TYPE_DVS = "DVS";

    public static final java.lang.String CONNECTED_SWITCH_TYPE_N_VDS = "N-VDS";

    public static final java.lang.String INTERFACE_TYPE_PHYSICAL = "PHYSICAL";

    public static final java.lang.String INTERFACE_TYPE_VIRTUAL = "VIRTUAL";

    public static final java.lang.String INTERFACE_TYPE_BOND = "BOND";

    public static final java.lang.String INTERFACE_TYPE_TEAMING = "TEAMING";

    public static final java.lang.String LINK_STATUS_UP = "UP";

    public static final java.lang.String LINK_STATUS_DOWN = "DOWN";

    public static final java.lang.String SOURCE_REALTIME = "realtime";

    public static final java.lang.String SOURCE_CACHED = "cached";

    public static final java.lang.String STATE_INVALID_STATE = "INVALID_STATE";

    public static final java.lang.String STATE_INIT = "INIT";

    public static final java.lang.String STATE_NORMAL = "NORMAL";

    public static final java.lang.String STATE_IP_WAITING = "IP_WAITING";

    public static final java.lang.String STATE_BFD_DOWN = "BFD_DOWN";

    public static final java.lang.String STATE_MAINTENANCE = "MAINTENANCE";

    private java.lang.String adminStatus;

    private java.lang.Boolean backingNsxManaged;

    private java.lang.String connectedSwitch;

    private java.lang.String connectedSwitchType;

    private java.lang.String device;

    private java.lang.Boolean dpuBacked;

    private java.lang.String dpuId;

    private java.lang.String driver;

    private java.lang.Boolean ensCapable;

    private java.lang.Boolean ensEnabled;

    private java.lang.Boolean ensInterruptCapable;

    private java.lang.Boolean ensInterruptEnabled;

    private java.lang.Boolean hostManaged;

    private java.util.List<com.vmware.nsx.model.NodeInterfaceAlias> interfaceAlias;

    private java.lang.String interfaceId;

    private java.lang.String interfaceType;

    private java.lang.String interfaceUuid;

    private java.lang.String key;

    private java.lang.String linkStatus;

    private java.lang.String lportAttachmentId;

    private java.lang.Long mtu;

    private java.lang.String pci;

    private java.lang.String source;

    private java.lang.Double speed;

    private java.lang.String state;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NodeInterfaceProperties() {
    }

    protected NodeInterfaceProperties(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#ADMIN_STATUS_UP}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#ADMIN_STATUS_DOWN}</li> </ul>
     * Interface administration status
     *
     * @return The current value of the property.
     */
    public java.lang.String getAdminStatus() {
        return this.adminStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#ADMIN_STATUS_UP}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#ADMIN_STATUS_DOWN}</li> </ul>
     * Interface administration status
     *
     * @param adminStatus New value for the property.
     */
    public void setAdminStatus(java.lang.String adminStatus) {
        this.adminStatus = adminStatus;
    }

    /**
     * Indicates whether backing of VIRTUAL network interface is managed by NSX
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getBackingNsxManaged() {
        return this.backingNsxManaged;
    }

    /**
     * Indicates whether backing of VIRTUAL network interface is managed by NSX
     *
     * @param backingNsxManaged New value for the property.
     */
    public void setBackingNsxManaged(java.lang.Boolean backingNsxManaged) {
        this.backingNsxManaged = backingNsxManaged;
    }

    /**
     * Connected switch
     *
     * @return The current value of the property.
     */
    public java.lang.String getConnectedSwitch() {
        return this.connectedSwitch;
    }

    /**
     * Connected switch
     *
     * @param connectedSwitch New value for the property.
     */
    public void setConnectedSwitch(java.lang.String connectedSwitch) {
        this.connectedSwitch = connectedSwitch;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#CONNECTED_SWITCH_TYPE_VSS}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#CONNECTED_SWITCH_TYPE_DVS}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#CONNECTED_SWITCH_TYPE_N_VDS}</li>
     * </ul> Type of switch associated with the interface.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getConnectedSwitchType() {
        return this.connectedSwitchType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#CONNECTED_SWITCH_TYPE_VSS}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#CONNECTED_SWITCH_TYPE_DVS}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#CONNECTED_SWITCH_TYPE_N_VDS}</li>
     * </ul> Type of switch associated with the interface.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param connectedSwitchType New value for the property.
     */
    public void setConnectedSwitchType(java.lang.String connectedSwitchType) {
        this.connectedSwitchType = connectedSwitchType;
    }

    /**
     * Device name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDevice() {
        return this.device;
    }

    /**
     * Device name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param device New value for the property.
     */
    public void setDevice(java.lang.String device) {
        this.device = device;
    }

    /**
     * If interface is backed by data processing unit (DPU) and state of DPU is
     * MANAGED, then this property is true.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDpuBacked() {
        return this.dpuBacked;
    }

    /**
     * If interface is backed by data processing unit (DPU) and state of DPU is
     * MANAGED, then this property is true.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dpuBacked New value for the property.
     */
    public void setDpuBacked(java.lang.Boolean dpuBacked) {
        this.dpuBacked = dpuBacked;
    }

    /**
     * Data processing unit ID if the interface is backed by a DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDpuId() {
        return this.dpuId;
    }

    /**
     * Data processing unit ID if the interface is backed by a DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dpuId New value for the property.
     */
    public void setDpuId(java.lang.String dpuId) {
        this.dpuId = dpuId;
    }

    /**
     * Driver name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDriver() {
        return this.driver;
    }

    /**
     * Driver name.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param driver New value for the property.
     */
    public void setDriver(java.lang.String driver) {
        this.driver = driver;
    }

    /**
     * Interface capability for Enhanced Networking Stack
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnsCapable() {
        return this.ensCapable;
    }

    /**
     * Interface capability for Enhanced Networking Stack
     *
     * @param ensCapable New value for the property.
     */
    public void setEnsCapable(java.lang.Boolean ensCapable) {
        this.ensCapable = ensCapable;
    }

    /**
     * Indicates whether interface is enabled for Enhanced Networking Stack
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnsEnabled() {
        return this.ensEnabled;
    }

    /**
     * Indicates whether interface is enabled for Enhanced Networking Stack
     *
     * @param ensEnabled New value for the property.
     */
    public void setEnsEnabled(java.lang.Boolean ensEnabled) {
        this.ensEnabled = ensEnabled;
    }

    /**
     * This boolean property describes if network interface is capable for Enhanced
     * Networking Stack interrupt
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnsInterruptCapable() {
        return this.ensInterruptCapable;
    }

    /**
     * This boolean property describes if network interface is capable for Enhanced
     * Networking Stack interrupt
     *
     * @param ensInterruptCapable New value for the property.
     */
    public void setEnsInterruptCapable(java.lang.Boolean ensInterruptCapable) {
        this.ensInterruptCapable = ensInterruptCapable;
    }

    /**
     * This boolean property describes if network interface is enabled for Enhanced
     * Networking Stack interrupt
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnsInterruptEnabled() {
        return this.ensInterruptEnabled;
    }

    /**
     * This boolean property describes if network interface is enabled for Enhanced
     * Networking Stack interrupt
     *
     * @param ensInterruptEnabled New value for the property.
     */
    public void setEnsInterruptEnabled(java.lang.Boolean ensInterruptEnabled) {
        this.ensInterruptEnabled = ensInterruptEnabled;
    }

    /**
     * Indicates whether interface is managed by the host
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getHostManaged() {
        return this.hostManaged;
    }

    /**
     * Indicates whether interface is managed by the host
     *
     * @param hostManaged New value for the property.
     */
    public void setHostManaged(java.lang.Boolean hostManaged) {
        this.hostManaged = hostManaged;
    }

    /**
     * IP Alias
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.NodeInterfaceAlias> getInterfaceAlias() {
        return this.interfaceAlias;
    }

    /**
     * IP Alias
     *
     * @param interfaceAlias New value for the property.
     */
    public void setInterfaceAlias(java.util.List<com.vmware.nsx.model.NodeInterfaceAlias> interfaceAlias) {
        this.interfaceAlias = interfaceAlias;
    }

    /**
     * Interface ID
     *
     * @return The current value of the property.
     */
    public java.lang.String getInterfaceId() {
        return this.interfaceId;
    }

    /**
     * Interface ID
     *
     * @param interfaceId New value for the property.
     */
    public void setInterfaceId(java.lang.String interfaceId) {
        this.interfaceId = interfaceId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#INTERFACE_TYPE_PHYSICAL}</li> <li>
     * {@link com.vmware.nsx.model.NodeInterfaceProperties#INTERFACE_TYPE_VIRTUAL}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#INTERFACE_TYPE_BOND}</li> <li>
     * {@link com.vmware.nsx.model.NodeInterfaceProperties#INTERFACE_TYPE_TEAMING}</li>
     * </ul> Interface Type
     *
     * @return The current value of the property.
     */
    public java.lang.String getInterfaceType() {
        return this.interfaceType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#INTERFACE_TYPE_PHYSICAL}</li> <li>
     * {@link com.vmware.nsx.model.NodeInterfaceProperties#INTERFACE_TYPE_VIRTUAL}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#INTERFACE_TYPE_BOND}</li> <li>
     * {@link com.vmware.nsx.model.NodeInterfaceProperties#INTERFACE_TYPE_TEAMING}</li>
     * </ul> Interface Type
     *
     * @param interfaceType New value for the property.
     */
    public void setInterfaceType(java.lang.String interfaceType) {
        this.interfaceType = interfaceType;
    }

    /**
     * UUID of the interface
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getInterfaceUuid() {
        return this.interfaceUuid;
    }

    /**
     * UUID of the interface
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param interfaceUuid New value for the property.
     */
    public void setInterfaceUuid(java.lang.String interfaceUuid) {
        this.interfaceUuid = interfaceUuid;
    }

    /**
     * Device key.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getKey() {
        return this.key;
    }

    /**
     * Device key.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param key New value for the property.
     */
    public void setKey(java.lang.String key) {
        this.key = key;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#LINK_STATUS_UP}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#LINK_STATUS_DOWN}</li> </ul>
     * Interface administration status
     *
     * @return The current value of the property.
     */
    public java.lang.String getLinkStatus() {
        return this.linkStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#LINK_STATUS_UP}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#LINK_STATUS_DOWN}</li> </ul>
     * Interface administration status
     *
     * @param linkStatus New value for the property.
     */
    public void setLinkStatus(java.lang.String linkStatus) {
        this.linkStatus = linkStatus;
    }

    /**
     * LPort Attachment Id assigned to VIRTUAL network interface of a node
     *
     * @return The current value of the property.
     */
    public java.lang.String getLportAttachmentId() {
        return this.lportAttachmentId;
    }

    /**
     * LPort Attachment Id assigned to VIRTUAL network interface of a node
     *
     * @param lportAttachmentId New value for the property.
     */
    public void setLportAttachmentId(java.lang.String lportAttachmentId) {
        this.lportAttachmentId = lportAttachmentId;
    }

    /**
     * Interface MTU format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMtu() {
        return this.mtu;
    }

    /**
     * Interface MTU format: int64
     *
     * @param mtu New value for the property.
     */
    public void setMtu(java.lang.Long mtu) {
        this.mtu = mtu;
    }

    /**
     * PCI device.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPci() {
        return this.pci;
    }

    /**
     * PCI device.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param pci New value for the property.
     */
    public void setPci(java.lang.String pci) {
        this.pci = pci;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#SOURCE_REALTIME}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#SOURCE_CACHED}</li> </ul> Source of
     * status data
     *
     * @return The current value of the property.
     */
    public java.lang.String getSource() {
        return this.source;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#SOURCE_REALTIME}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#SOURCE_CACHED}</li> </ul> Source of
     * status data
     *
     * @param source New value for the property.
     */
    public void setSource(java.lang.String source) {
        this.source = source;
    }

    /**
     * Interface speed in Mbps.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getSpeed() {
        return this.speed;
    }

    /**
     * Interface speed in Mbps.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param speed New value for the property.
     */
    public void setSpeed(java.lang.Double speed) {
        this.speed = speed;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#STATE_INVALID_STATE}</li> <li>
     * {@link com.vmware.nsx.model.NodeInterfaceProperties#STATE_INIT}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#STATE_NORMAL}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#STATE_IP_WAITING}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#STATE_BFD_DOWN}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#STATE_MAINTENANCE}</li> </ul> This
     * property shows the current state of virtual tunnel end point (VTEP). If not in
     * NORMAL state, then overlay workloads using this TEP will face network outage. In
     * those cases, check if TEP has valid IP or any other underlay connectivity
     * issues, and enable TEP HA to failover workloads to other healthy TEPs. Note that
     * MAINTENANCE state is triggered by user and TEP will be disabled.
     *
     * @return The current value of the property.
     */
    public java.lang.String getState() {
        return this.state;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#STATE_INVALID_STATE}</li> <li>
     * {@link com.vmware.nsx.model.NodeInterfaceProperties#STATE_INIT}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#STATE_NORMAL}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#STATE_IP_WAITING}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#STATE_BFD_DOWN}</li> <li> {@link
     * com.vmware.nsx.model.NodeInterfaceProperties#STATE_MAINTENANCE}</li> </ul> This
     * property shows the current state of virtual tunnel end point (VTEP). If not in
     * NORMAL state, then overlay workloads using this TEP will face network outage. In
     * those cases, check if TEP has valid IP or any other underlay connectivity
     * issues, and enable TEP HA to failover workloads to other healthy TEPs. Note that
     * MAINTENANCE state is triggered by user and TEP will be disabled.
     *
     * @param state New value for the property.
     */
    public void setState(java.lang.String state) {
        this.state = state;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.nodeInterfaceProperties;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("admin_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.adminStatus, this._getType().getField("admin_status")));
        structValue.setField("backing_nsx_managed",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.backingNsxManaged, this._getType().getField("backing_nsx_managed")));
        structValue.setField("connected_switch",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectedSwitch, this._getType().getField("connected_switch")));
        structValue.setField("connected_switch_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectedSwitchType, this._getType().getField("connected_switch_type")));
        structValue.setField("device",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.device, this._getType().getField("device")));
        structValue.setField("dpu_backed",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dpuBacked, this._getType().getField("dpu_backed")));
        structValue.setField("dpu_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dpuId, this._getType().getField("dpu_id")));
        structValue.setField("driver",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.driver, this._getType().getField("driver")));
        structValue.setField("ens_capable",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ensCapable, this._getType().getField("ens_capable")));
        structValue.setField("ens_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ensEnabled, this._getType().getField("ens_enabled")));
        structValue.setField("ens_interrupt_capable",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ensInterruptCapable, this._getType().getField("ens_interrupt_capable")));
        structValue.setField("ens_interrupt_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ensInterruptEnabled, this._getType().getField("ens_interrupt_enabled")));
        structValue.setField("host_managed",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostManaged, this._getType().getField("host_managed")));
        structValue.setField("interface_alias",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.interfaceAlias, this._getType().getField("interface_alias")));
        structValue.setField("interface_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.interfaceId, this._getType().getField("interface_id")));
        structValue.setField("interface_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.interfaceType, this._getType().getField("interface_type")));
        structValue.setField("interface_uuid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.interfaceUuid, this._getType().getField("interface_uuid")));
        structValue.setField("key",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.key, this._getType().getField("key")));
        structValue.setField("link_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.linkStatus, this._getType().getField("link_status")));
        structValue.setField("lport_attachment_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lportAttachmentId, this._getType().getField("lport_attachment_id")));
        structValue.setField("mtu",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.mtu, this._getType().getField("mtu")));
        structValue.setField("pci",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pci, this._getType().getField("pci")));
        structValue.setField("source",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.source, this._getType().getField("source")));
        structValue.setField("speed",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.speed, this._getType().getField("speed")));
        structValue.setField("state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.state, this._getType().getField("state")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.nodeInterfaceProperties;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.nodeInterfaceProperties.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NodeInterfaceProperties _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NodeInterfaceProperties(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NodeInterfaceProperties _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NodeInterfaceProperties(structValue);
    }

    /**
     * Builder class for {@link NodeInterfaceProperties}.
     */
    public static final class Builder {
        private java.lang.String adminStatus;
        private java.lang.Boolean backingNsxManaged;
        private java.lang.String connectedSwitch;
        private java.lang.String connectedSwitchType;
        private java.lang.String device;
        private java.lang.Boolean dpuBacked;
        private java.lang.String dpuId;
        private java.lang.String driver;
        private java.lang.Boolean ensCapable;
        private java.lang.Boolean ensEnabled;
        private java.lang.Boolean ensInterruptCapable;
        private java.lang.Boolean ensInterruptEnabled;
        private java.lang.Boolean hostManaged;
        private java.util.List<com.vmware.nsx.model.NodeInterfaceAlias> interfaceAlias;
        private java.lang.String interfaceId;
        private java.lang.String interfaceType;
        private java.lang.String interfaceUuid;
        private java.lang.String key;
        private java.lang.String linkStatus;
        private java.lang.String lportAttachmentId;
        private java.lang.Long mtu;
        private java.lang.String pci;
        private java.lang.String source;
        private java.lang.Double speed;
        private java.lang.String state;

        /**
         * Constructor with parameters for the required properties of
         * {@link NodeInterfaceProperties}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#ADMIN_STATUS_UP}</li> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#ADMIN_STATUS_DOWN}</li> </ul>
         * Interface administration status
         *
         * @param adminStatus New value for the property.
         */
        public Builder setAdminStatus(java.lang.String adminStatus) {
            this.adminStatus = adminStatus;
            return this;
        }

        /**
         * Indicates whether backing of VIRTUAL network interface is managed by NSX
         *
         * @param backingNsxManaged New value for the property.
         */
        public Builder setBackingNsxManaged(java.lang.Boolean backingNsxManaged) {
            this.backingNsxManaged = backingNsxManaged;
            return this;
        }

        /**
         * Connected switch
         *
         * @param connectedSwitch New value for the property.
         */
        public Builder setConnectedSwitch(java.lang.String connectedSwitch) {
            this.connectedSwitch = connectedSwitch;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#CONNECTED_SWITCH_TYPE_VSS}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#CONNECTED_SWITCH_TYPE_DVS}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#CONNECTED_SWITCH_TYPE_N_VDS}</li>
         * </ul> Type of switch associated with the interface.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param connectedSwitchType New value for the property.
         */
        public Builder setConnectedSwitchType(java.lang.String connectedSwitchType) {
            this.connectedSwitchType = connectedSwitchType;
            return this;
        }

        /**
         * Device name.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param device New value for the property.
         */
        public Builder setDevice(java.lang.String device) {
            this.device = device;
            return this;
        }

        /**
         * If interface is backed by data processing unit (DPU) and state of DPU is
         * MANAGED, then this property is true.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dpuBacked New value for the property.
         */
        public Builder setDpuBacked(java.lang.Boolean dpuBacked) {
            this.dpuBacked = dpuBacked;
            return this;
        }

        /**
         * Data processing unit ID if the interface is backed by a DPU.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dpuId New value for the property.
         */
        public Builder setDpuId(java.lang.String dpuId) {
            this.dpuId = dpuId;
            return this;
        }

        /**
         * Driver name.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param driver New value for the property.
         */
        public Builder setDriver(java.lang.String driver) {
            this.driver = driver;
            return this;
        }

        /**
         * Interface capability for Enhanced Networking Stack
         *
         * @param ensCapable New value for the property.
         */
        public Builder setEnsCapable(java.lang.Boolean ensCapable) {
            this.ensCapable = ensCapable;
            return this;
        }

        /**
         * Indicates whether interface is enabled for Enhanced Networking Stack
         *
         * @param ensEnabled New value for the property.
         */
        public Builder setEnsEnabled(java.lang.Boolean ensEnabled) {
            this.ensEnabled = ensEnabled;
            return this;
        }

        /**
         * This boolean property describes if network interface is capable for Enhanced
         * Networking Stack interrupt
         *
         * @param ensInterruptCapable New value for the property.
         */
        public Builder setEnsInterruptCapable(java.lang.Boolean ensInterruptCapable) {
            this.ensInterruptCapable = ensInterruptCapable;
            return this;
        }

        /**
         * This boolean property describes if network interface is enabled for Enhanced
         * Networking Stack interrupt
         *
         * @param ensInterruptEnabled New value for the property.
         */
        public Builder setEnsInterruptEnabled(java.lang.Boolean ensInterruptEnabled) {
            this.ensInterruptEnabled = ensInterruptEnabled;
            return this;
        }

        /**
         * Indicates whether interface is managed by the host
         *
         * @param hostManaged New value for the property.
         */
        public Builder setHostManaged(java.lang.Boolean hostManaged) {
            this.hostManaged = hostManaged;
            return this;
        }

        /**
         * IP Alias
         *
         * @param interfaceAlias New value for the property.
         */
        public Builder setInterfaceAlias(java.util.List<com.vmware.nsx.model.NodeInterfaceAlias> interfaceAlias) {
            this.interfaceAlias = interfaceAlias;
            return this;
        }

        /**
         * Interface ID
         *
         * @param interfaceId New value for the property.
         */
        public Builder setInterfaceId(java.lang.String interfaceId) {
            this.interfaceId = interfaceId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#INTERFACE_TYPE_PHYSICAL}</li> <li>
         * {@link com.vmware.nsx.model.NodeInterfaceProperties#INTERFACE_TYPE_VIRTUAL}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#INTERFACE_TYPE_BOND}</li> <li>
         * {@link com.vmware.nsx.model.NodeInterfaceProperties#INTERFACE_TYPE_TEAMING}</li>
         * </ul> Interface Type
         *
         * @param interfaceType New value for the property.
         */
        public Builder setInterfaceType(java.lang.String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        /**
         * UUID of the interface
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param interfaceUuid New value for the property.
         */
        public Builder setInterfaceUuid(java.lang.String interfaceUuid) {
            this.interfaceUuid = interfaceUuid;
            return this;
        }

        /**
         * Device key.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param key New value for the property.
         */
        public Builder setKey(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#LINK_STATUS_UP}</li> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#LINK_STATUS_DOWN}</li> </ul>
         * Interface administration status
         *
         * @param linkStatus New value for the property.
         */
        public Builder setLinkStatus(java.lang.String linkStatus) {
            this.linkStatus = linkStatus;
            return this;
        }

        /**
         * LPort Attachment Id assigned to VIRTUAL network interface of a node
         *
         * @param lportAttachmentId New value for the property.
         */
        public Builder setLportAttachmentId(java.lang.String lportAttachmentId) {
            this.lportAttachmentId = lportAttachmentId;
            return this;
        }

        /**
         * Interface MTU format: int64
         *
         * @param mtu New value for the property.
         */
        public Builder setMtu(java.lang.Long mtu) {
            this.mtu = mtu;
            return this;
        }

        /**
         * PCI device.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param pci New value for the property.
         */
        public Builder setPci(java.lang.String pci) {
            this.pci = pci;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#SOURCE_REALTIME}</li> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#SOURCE_CACHED}</li> </ul> Source of
         * status data
         *
         * @param source New value for the property.
         */
        public Builder setSource(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Interface speed in Mbps.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param speed New value for the property.
         */
        public Builder setSpeed(java.lang.Double speed) {
            this.speed = speed;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#STATE_INVALID_STATE}</li> <li>
         * {@link com.vmware.nsx.model.NodeInterfaceProperties#STATE_INIT}</li> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#STATE_NORMAL}</li> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#STATE_IP_WAITING}</li> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#STATE_BFD_DOWN}</li> <li> {@link
         * com.vmware.nsx.model.NodeInterfaceProperties#STATE_MAINTENANCE}</li> </ul> This
         * property shows the current state of virtual tunnel end point (VTEP). If not in
         * NORMAL state, then overlay workloads using this TEP will face network outage. In
         * those cases, check if TEP has valid IP or any other underlay connectivity
         * issues, and enable TEP HA to failover workloads to other healthy TEPs. Note that
         * MAINTENANCE state is triggered by user and TEP will be disabled.
         *
         * @param state New value for the property.
         */
        public Builder setState(java.lang.String state) {
            this.state = state;
            return this;
        }

        public NodeInterfaceProperties build() {
            NodeInterfaceProperties result = new NodeInterfaceProperties();
            result.setAdminStatus(this.adminStatus);
            result.setBackingNsxManaged(this.backingNsxManaged);
            result.setConnectedSwitch(this.connectedSwitch);
            result.setConnectedSwitchType(this.connectedSwitchType);
            result.setDevice(this.device);
            result.setDpuBacked(this.dpuBacked);
            result.setDpuId(this.dpuId);
            result.setDriver(this.driver);
            result.setEnsCapable(this.ensCapable);
            result.setEnsEnabled(this.ensEnabled);
            result.setEnsInterruptCapable(this.ensInterruptCapable);
            result.setEnsInterruptEnabled(this.ensInterruptEnabled);
            result.setHostManaged(this.hostManaged);
            result.setInterfaceAlias(this.interfaceAlias);
            result.setInterfaceId(this.interfaceId);
            result.setInterfaceType(this.interfaceType);
            result.setInterfaceUuid(this.interfaceUuid);
            result.setKey(this.key);
            result.setLinkStatus(this.linkStatus);
            result.setLportAttachmentId(this.lportAttachmentId);
            result.setMtu(this.mtu);
            result.setPci(this.pci);
            result.setSource(this.source);
            result.setSpeed(this.speed);
            result.setState(this.state);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("admin_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("admin_status",
                                                                                "adminStatus",
                                                                                "getAdminStatus",
                                                                                "setAdminStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("backing_nsx_managed", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("backing_nsx_managed",
                                                                                "backingNsxManaged",
                                                                                "getBackingNsxManaged",
                                                                                "setBackingNsxManaged");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connected_switch", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connected_switch",
                                                                                "connectedSwitch",
                                                                                "getConnectedSwitch",
                                                                                "setConnectedSwitch");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connected_switch_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connected_switch_type",
                                                                                "connectedSwitchType",
                                                                                "getConnectedSwitchType",
                                                                                "setConnectedSwitchType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("device", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("device",
                                                                                "device",
                                                                                "getDevice",
                                                                                "setDevice");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dpu_backed", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dpu_backed",
                                                                                "dpuBacked",
                                                                                "getDpuBacked",
                                                                                "setDpuBacked");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dpu_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dpu_id",
                                                                                "dpuId",
                                                                                "getDpuId",
                                                                                "setDpuId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("driver", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("driver",
                                                                                "driver",
                                                                                "getDriver",
                                                                                "setDriver");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ens_capable", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ens_capable",
                                                                                "ensCapable",
                                                                                "getEnsCapable",
                                                                                "setEnsCapable");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ens_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ens_enabled",
                                                                                "ensEnabled",
                                                                                "getEnsEnabled",
                                                                                "setEnsEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ens_interrupt_capable", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ens_interrupt_capable",
                                                                                "ensInterruptCapable",
                                                                                "getEnsInterruptCapable",
                                                                                "setEnsInterruptCapable");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ens_interrupt_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ens_interrupt_enabled",
                                                                                "ensInterruptEnabled",
                                                                                "getEnsInterruptEnabled",
                                                                                "setEnsInterruptEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_managed", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_managed",
                                                                                "hostManaged",
                                                                                "getHostManaged",
                                                                                "setHostManaged");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("interface_alias", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.nodeInterfaceAlias; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("interface_alias",
                                                                                "interfaceAlias",
                                                                                "getInterfaceAlias",
                                                                                "setInterfaceAlias");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("interface_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("interface_id",
                                                                                "interfaceId",
                                                                                "getInterfaceId",
                                                                                "setInterfaceId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("interface_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("interface_type",
                                                                                "interfaceType",
                                                                                "getInterfaceType",
                                                                                "setInterfaceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("interface_uuid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("interface_uuid",
                                                                                "interfaceUuid",
                                                                                "getInterfaceUuid",
                                                                                "setInterfaceUuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("key", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("key",
                                                                                "key",
                                                                                "getKey",
                                                                                "setKey");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("link_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("link_status",
                                                                                "linkStatus",
                                                                                "getLinkStatus",
                                                                                "setLinkStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("lport_attachment_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("lport_attachment_id",
                                                                                "lportAttachmentId",
                                                                                "getLportAttachmentId",
                                                                                "setLportAttachmentId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mtu", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mtu",
                                                                                "mtu",
                                                                                "getMtu",
                                                                                "setMtu");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pci", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pci",
                                                                                "pci",
                                                                                "getPci",
                                                                                "setPci");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("source", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("source",
                                                                                "source",
                                                                                "getSource",
                                                                                "setSource");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("speed", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("speed",
                                                                                "speed",
                                                                                "getSpeed",
                                                                                "setSpeed");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("state",
                                                                                "state",
                                                                                "getState",
                                                                                "setState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.node_interface_properties",
                                                            fields,
                                                            com.vmware.nsx.model.NodeInterfaceProperties.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

