/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Node network interface properties
 */
public final class NodeNetworkInterfaceProperties implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ADMIN_STATUS_UP = "up";

    public static final java.lang.String ADMIN_STATUS_DOWN = "down";

    public static final java.lang.String BOND_MODE_ACTIVE_BACKUP = "ACTIVE_BACKUP";

    public static final java.lang.String BOND_MODE_802_3AD = "802_3AD";

    public static final java.lang.String BOND_MODE_ROUND_ROBIN = "ROUND_ROBIN";

    public static final java.lang.String BOND_MODE_BROADCAST = "BROADCAST";

    public static final java.lang.String BOND_MODE_XOR = "XOR";

    public static final java.lang.String BOND_MODE_TLB = "TLB";

    public static final java.lang.String BOND_MODE_ALB = "ALB";

    public static final java.lang.String BOND_XMIT_HASH_POLICY_LAYER2 = "layer2";

    public static final java.lang.String BOND_XMIT_HASH_POLICY_LAYER2_3 = "layer2+3";

    public static final java.lang.String BOND_XMIT_HASH_POLICY_LAYER3_4 = "layer3+4";

    public static final java.lang.String BOND_XMIT_HASH_POLICY_ENCAP2_3 = "encap2+3";

    public static final java.lang.String BOND_XMIT_HASH_POLICY_ENCAP3_4 = "encap3+4";

    public static final java.lang.String IP_CONFIGURATION_DHCP = "dhcp";

    public static final java.lang.String IP_CONFIGURATION_STATIC = "static";

    public static final java.lang.String IP_CONFIGURATION_NOT_CONFIGURED = "not configured";

    public static final java.lang.String LINK_STATUS_UP = "up";

    public static final java.lang.String LINK_STATUS_DOWN = "down";

    public static final java.lang.String PLANE_MGMT = "mgmt";

    public static final java.lang.String PLANE_DEBUG = "debug";

    public static final java.lang.String PLANE_NONE = "none";

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.String adminStatus;

    private java.lang.String bondCurActiveSlave;

    private java.lang.String bondLacpRate;

    private java.lang.String bondMode;

    private java.lang.String bondPrimary;

    private java.lang.String bondPrimarySlave;

    private java.util.List<java.lang.String> bondSlaves;

    private java.lang.String bondXmitHashPolicy;

    private java.lang.String broadcastAddress;

    private java.lang.String defaultGateway;

    private java.lang.String interfaceId;

    private java.util.List<com.vmware.nsx.model.IPv6AddressProperties> ip6Addresses;

    private java.util.List<com.vmware.nsx.model.IPv4AddressProperties> ipAddresses;

    private java.lang.String ipConfiguration;

    private java.lang.Boolean isKni;

    private java.lang.String linkStatus;

    private java.lang.Long mtu;

    private java.lang.String physicalAddress;

    private java.lang.String plane;

    private java.lang.Long vlan;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NodeNetworkInterfaceProperties() {
    }

    protected NodeNetworkInterfaceProperties(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#ADMIN_STATUS_UP}</li> <li>
     * {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#ADMIN_STATUS_DOWN}</li>
     * </ul> Interface administration status
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAdminStatus() {
        return this.adminStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#ADMIN_STATUS_UP}</li> <li>
     * {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#ADMIN_STATUS_DOWN}</li>
     * </ul> Interface administration status
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param adminStatus New value for the property.
     */
    public void setAdminStatus(java.lang.String adminStatus) {
        this.adminStatus = adminStatus;
    }

    /**
     * Bond's currently active slave device
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBondCurActiveSlave() {
        return this.bondCurActiveSlave;
    }

    /**
     * Bond's currently active slave device
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param bondCurActiveSlave New value for the property.
     */
    public void setBondCurActiveSlave(java.lang.String bondCurActiveSlave) {
        this.bondCurActiveSlave = bondCurActiveSlave;
    }

    /**
     * Bond's rate at which we'll ask our link partner to transmit LACPDU packets in
     * 802.3ad mode
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBondLacpRate() {
        return this.bondLacpRate;
    }

    /**
     * Bond's rate at which we'll ask our link partner to transmit LACPDU packets in
     * 802.3ad mode
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param bondLacpRate New value for the property.
     */
    public void setBondLacpRate(java.lang.String bondLacpRate) {
        this.bondLacpRate = bondLacpRate;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_ACTIVE_BACKUP}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_802_3AD}</li> <li>
     * {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_ROUND_ROBIN}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_BROADCAST}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_XOR}</li> <li>
     * {@link com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_TLB}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_ALB}</li> </ul>
     * Bond mode
     *
     * @return The current value of the property.
     */
    public java.lang.String getBondMode() {
        return this.bondMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_ACTIVE_BACKUP}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_802_3AD}</li> <li>
     * {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_ROUND_ROBIN}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_BROADCAST}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_XOR}</li> <li>
     * {@link com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_TLB}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_ALB}</li> </ul>
     * Bond mode
     *
     * @param bondMode New value for the property.
     */
    public void setBondMode(java.lang.String bondMode) {
        this.bondMode = bondMode;
    }

    /**
     * Bond's primary device name in active-backup bond mode
     *
     * @return The current value of the property.
     */
    public java.lang.String getBondPrimary() {
        return this.bondPrimary;
    }

    /**
     * Bond's primary device name in active-backup bond mode
     *
     * @param bondPrimary New value for the property.
     */
    public void setBondPrimary(java.lang.String bondPrimary) {
        this.bondPrimary = bondPrimary;
    }

    /**
     * Bond's primary device name in active-backup bond mode
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBondPrimarySlave() {
        return this.bondPrimarySlave;
    }

    /**
     * Bond's primary device name in active-backup bond mode
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param bondPrimarySlave New value for the property.
     */
    public void setBondPrimarySlave(java.lang.String bondPrimarySlave) {
        this.bondPrimarySlave = bondPrimarySlave;
    }

    /**
     * Bond's slave devices
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getBondSlaves() {
        return this.bondSlaves;
    }

    /**
     * Bond's slave devices
     *
     * @param bondSlaves New value for the property.
     */
    public void setBondSlaves(java.util.List<java.lang.String> bondSlaves) {
        this.bondSlaves = bondSlaves;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_LAYER2}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_LAYER2_3}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_LAYER3_4}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_ENCAP2_3}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_ENCAP3_4}</li>
     * </ul> Bond's transmit hash policy for balance-xor and 802.3ad modes
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBondXmitHashPolicy() {
        return this.bondXmitHashPolicy;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_LAYER2}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_LAYER2_3}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_LAYER3_4}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_ENCAP2_3}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_ENCAP3_4}</li>
     * </ul> Bond's transmit hash policy for balance-xor and 802.3ad modes
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param bondXmitHashPolicy New value for the property.
     */
    public void setBondXmitHashPolicy(java.lang.String bondXmitHashPolicy) {
        this.bondXmitHashPolicy = bondXmitHashPolicy;
    }

    /**
     * Interface broadcast address
     *
     * @return The current value of the property.
     */
    public java.lang.String getBroadcastAddress() {
        return this.broadcastAddress;
    }

    /**
     * Interface broadcast address
     *
     * @param broadcastAddress New value for the property.
     */
    public void setBroadcastAddress(java.lang.String broadcastAddress) {
        this.broadcastAddress = broadcastAddress;
    }

    /**
     * Interface's default gateway
     *
     * @return The current value of the property.
     */
    public java.lang.String getDefaultGateway() {
        return this.defaultGateway;
    }

    /**
     * Interface's default gateway
     *
     * @param defaultGateway New value for the property.
     */
    public void setDefaultGateway(java.lang.String defaultGateway) {
        this.defaultGateway = defaultGateway;
    }

    /**
     * Interface ID
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getInterfaceId() {
        return this.interfaceId;
    }

    /**
     * Interface ID
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param interfaceId New value for the property.
     */
    public void setInterfaceId(java.lang.String interfaceId) {
        this.interfaceId = interfaceId;
    }

    /**
     * Interface IPv6 addresses
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.IPv6AddressProperties> getIp6Addresses() {
        return this.ip6Addresses;
    }

    /**
     * Interface IPv6 addresses
     *
     * @param ip6Addresses New value for the property.
     */
    public void setIp6Addresses(java.util.List<com.vmware.nsx.model.IPv6AddressProperties> ip6Addresses) {
        this.ip6Addresses = ip6Addresses;
    }

    /**
     * Interface IP addresses
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.IPv4AddressProperties> getIpAddresses() {
        return this.ipAddresses;
    }

    /**
     * Interface IP addresses
     *
     * @param ipAddresses New value for the property.
     */
    public void setIpAddresses(java.util.List<com.vmware.nsx.model.IPv4AddressProperties> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#IP_CONFIGURATION_DHCP}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#IP_CONFIGURATION_STATIC}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#IP_CONFIGURATION_NOT_CONFIGURED}</li>
     * </ul> Interface configuration
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpConfiguration() {
        return this.ipConfiguration;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#IP_CONFIGURATION_DHCP}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#IP_CONFIGURATION_STATIC}</li>
     * <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#IP_CONFIGURATION_NOT_CONFIGURED}</li>
     * </ul> Interface configuration
     *
     * @param ipConfiguration New value for the property.
     */
    public void setIpConfiguration(java.lang.String ipConfiguration) {
        this.ipConfiguration = ipConfiguration;
    }

    /**
     * Interface is a KNI
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsKni() {
        return this.isKni;
    }

    /**
     * Interface is a KNI
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param isKni New value for the property.
     */
    public void setIsKni(java.lang.Boolean isKni) {
        this.isKni = isKni;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#LINK_STATUS_UP}</li> <li>
     * {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#LINK_STATUS_DOWN}</li> </ul>
     * Interface administration status
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLinkStatus() {
        return this.linkStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#LINK_STATUS_UP}</li> <li>
     * {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#LINK_STATUS_DOWN}</li> </ul>
     * Interface administration status
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param linkStatus New value for the property.
     */
    public void setLinkStatus(java.lang.String linkStatus) {
        this.linkStatus = linkStatus;
    }

    /**
     * Interface MTU format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMtu() {
        return this.mtu;
    }

    /**
     * Interface MTU format: int64
     *
     * @param mtu New value for the property.
     */
    public void setMtu(java.lang.Long mtu) {
        this.mtu = mtu;
    }

    /**
     * Interface MAC address
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPhysicalAddress() {
        return this.physicalAddress;
    }

    /**
     * Interface MAC address
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param physicalAddress New value for the property.
     */
    public void setPhysicalAddress(java.lang.String physicalAddress) {
        this.physicalAddress = physicalAddress;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#PLANE_MGMT}</li> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#PLANE_DEBUG}</li> <li>
     * {@link com.vmware.nsx.model.NodeNetworkInterfaceProperties#PLANE_NONE}</li>
     * </ul> Interface plane
     *
     * @return The current value of the property.
     */
    public java.lang.String getPlane() {
        return this.plane;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#PLANE_MGMT}</li> <li> {@link
     * com.vmware.nsx.model.NodeNetworkInterfaceProperties#PLANE_DEBUG}</li> <li>
     * {@link com.vmware.nsx.model.NodeNetworkInterfaceProperties#PLANE_NONE}</li>
     * </ul> Interface plane
     *
     * @param plane New value for the property.
     */
    public void setPlane(java.lang.String plane) {
        this.plane = plane;
    }

    /**
     * VLAN Id format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getVlan() {
        return this.vlan;
    }

    /**
     * VLAN Id format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param vlan New value for the property.
     */
    public void setVlan(java.lang.Long vlan) {
        this.vlan = vlan;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.nodeNetworkInterfaceProperties;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("admin_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.adminStatus, this._getType().getField("admin_status")));
        structValue.setField("bond_cur_active_slave",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bondCurActiveSlave, this._getType().getField("bond_cur_active_slave")));
        structValue.setField("bond_lacp_rate",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bondLacpRate, this._getType().getField("bond_lacp_rate")));
        structValue.setField("bond_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bondMode, this._getType().getField("bond_mode")));
        structValue.setField("bond_primary",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bondPrimary, this._getType().getField("bond_primary")));
        structValue.setField("bond_primary_slave",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bondPrimarySlave, this._getType().getField("bond_primary_slave")));
        structValue.setField("bond_slaves",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bondSlaves, this._getType().getField("bond_slaves")));
        structValue.setField("bond_xmit_hash_policy",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bondXmitHashPolicy, this._getType().getField("bond_xmit_hash_policy")));
        structValue.setField("broadcast_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.broadcastAddress, this._getType().getField("broadcast_address")));
        structValue.setField("default_gateway",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultGateway, this._getType().getField("default_gateway")));
        structValue.setField("interface_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.interfaceId, this._getType().getField("interface_id")));
        structValue.setField("ip6_addresses",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ip6Addresses, this._getType().getField("ip6_addresses")));
        structValue.setField("ip_addresses",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddresses, this._getType().getField("ip_addresses")));
        structValue.setField("ip_configuration",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipConfiguration, this._getType().getField("ip_configuration")));
        structValue.setField("is_kni",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isKni, this._getType().getField("is_kni")));
        structValue.setField("link_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.linkStatus, this._getType().getField("link_status")));
        structValue.setField("mtu",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.mtu, this._getType().getField("mtu")));
        structValue.setField("physical_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.physicalAddress, this._getType().getField("physical_address")));
        structValue.setField("plane",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.plane, this._getType().getField("plane")));
        structValue.setField("vlan",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vlan, this._getType().getField("vlan")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.nodeNetworkInterfaceProperties;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.nodeNetworkInterfaceProperties.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NodeNetworkInterfaceProperties _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NodeNetworkInterfaceProperties(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NodeNetworkInterfaceProperties _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NodeNetworkInterfaceProperties(structValue);
    }

    /**
     * Builder class for {@link NodeNetworkInterfaceProperties}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.String adminStatus;
        private java.lang.String bondCurActiveSlave;
        private java.lang.String bondLacpRate;
        private java.lang.String bondMode;
        private java.lang.String bondPrimary;
        private java.lang.String bondPrimarySlave;
        private java.util.List<java.lang.String> bondSlaves;
        private java.lang.String bondXmitHashPolicy;
        private java.lang.String broadcastAddress;
        private java.lang.String defaultGateway;
        private java.lang.String interfaceId;
        private java.util.List<com.vmware.nsx.model.IPv6AddressProperties> ip6Addresses;
        private java.util.List<com.vmware.nsx.model.IPv4AddressProperties> ipAddresses;
        private java.lang.String ipConfiguration;
        private java.lang.Boolean isKni;
        private java.lang.String linkStatus;
        private java.lang.Long mtu;
        private java.lang.String physicalAddress;
        private java.lang.String plane;
        private java.lang.Long vlan;

        /**
         * Constructor with parameters for the required properties of
         * {@link NodeNetworkInterfaceProperties}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#ADMIN_STATUS_UP}</li> <li>
         * {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#ADMIN_STATUS_DOWN}</li>
         * </ul> Interface administration status
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param adminStatus New value for the property.
         */
        public Builder setAdminStatus(java.lang.String adminStatus) {
            this.adminStatus = adminStatus;
            return this;
        }

        /**
         * Bond's currently active slave device
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param bondCurActiveSlave New value for the property.
         */
        public Builder setBondCurActiveSlave(java.lang.String bondCurActiveSlave) {
            this.bondCurActiveSlave = bondCurActiveSlave;
            return this;
        }

        /**
         * Bond's rate at which we'll ask our link partner to transmit LACPDU packets in
         * 802.3ad mode
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param bondLacpRate New value for the property.
         */
        public Builder setBondLacpRate(java.lang.String bondLacpRate) {
            this.bondLacpRate = bondLacpRate;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_ACTIVE_BACKUP}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_802_3AD}</li> <li>
         * {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_ROUND_ROBIN}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_BROADCAST}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_XOR}</li> <li>
         * {@link com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_TLB}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_MODE_ALB}</li> </ul>
         * Bond mode
         *
         * @param bondMode New value for the property.
         */
        public Builder setBondMode(java.lang.String bondMode) {
            this.bondMode = bondMode;
            return this;
        }

        /**
         * Bond's primary device name in active-backup bond mode
         *
         * @param bondPrimary New value for the property.
         */
        public Builder setBondPrimary(java.lang.String bondPrimary) {
            this.bondPrimary = bondPrimary;
            return this;
        }

        /**
         * Bond's primary device name in active-backup bond mode
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param bondPrimarySlave New value for the property.
         */
        public Builder setBondPrimarySlave(java.lang.String bondPrimarySlave) {
            this.bondPrimarySlave = bondPrimarySlave;
            return this;
        }

        /**
         * Bond's slave devices
         *
         * @param bondSlaves New value for the property.
         */
        public Builder setBondSlaves(java.util.List<java.lang.String> bondSlaves) {
            this.bondSlaves = bondSlaves;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_LAYER2}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_LAYER2_3}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_LAYER3_4}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_ENCAP2_3}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#BOND_XMIT_HASH_POLICY_ENCAP3_4}</li>
         * </ul> Bond's transmit hash policy for balance-xor and 802.3ad modes
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param bondXmitHashPolicy New value for the property.
         */
        public Builder setBondXmitHashPolicy(java.lang.String bondXmitHashPolicy) {
            this.bondXmitHashPolicy = bondXmitHashPolicy;
            return this;
        }

        /**
         * Interface broadcast address
         *
         * @param broadcastAddress New value for the property.
         */
        public Builder setBroadcastAddress(java.lang.String broadcastAddress) {
            this.broadcastAddress = broadcastAddress;
            return this;
        }

        /**
         * Interface's default gateway
         *
         * @param defaultGateway New value for the property.
         */
        public Builder setDefaultGateway(java.lang.String defaultGateway) {
            this.defaultGateway = defaultGateway;
            return this;
        }

        /**
         * Interface ID
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param interfaceId New value for the property.
         */
        public Builder setInterfaceId(java.lang.String interfaceId) {
            this.interfaceId = interfaceId;
            return this;
        }

        /**
         * Interface IPv6 addresses
         *
         * @param ip6Addresses New value for the property.
         */
        public Builder setIp6Addresses(java.util.List<com.vmware.nsx.model.IPv6AddressProperties> ip6Addresses) {
            this.ip6Addresses = ip6Addresses;
            return this;
        }

        /**
         * Interface IP addresses
         *
         * @param ipAddresses New value for the property.
         */
        public Builder setIpAddresses(java.util.List<com.vmware.nsx.model.IPv4AddressProperties> ipAddresses) {
            this.ipAddresses = ipAddresses;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#IP_CONFIGURATION_DHCP}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#IP_CONFIGURATION_STATIC}</li>
         * <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#IP_CONFIGURATION_NOT_CONFIGURED}</li>
         * </ul> Interface configuration
         *
         * @param ipConfiguration New value for the property.
         */
        public Builder setIpConfiguration(java.lang.String ipConfiguration) {
            this.ipConfiguration = ipConfiguration;
            return this;
        }

        /**
         * Interface is a KNI
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param isKni New value for the property.
         */
        public Builder setIsKni(java.lang.Boolean isKni) {
            this.isKni = isKni;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#LINK_STATUS_UP}</li> <li>
         * {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#LINK_STATUS_DOWN}</li> </ul>
         * Interface administration status
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param linkStatus New value for the property.
         */
        public Builder setLinkStatus(java.lang.String linkStatus) {
            this.linkStatus = linkStatus;
            return this;
        }

        /**
         * Interface MTU format: int64
         *
         * @param mtu New value for the property.
         */
        public Builder setMtu(java.lang.Long mtu) {
            this.mtu = mtu;
            return this;
        }

        /**
         * Interface MAC address
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param physicalAddress New value for the property.
         */
        public Builder setPhysicalAddress(java.lang.String physicalAddress) {
            this.physicalAddress = physicalAddress;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#PLANE_MGMT}</li> <li> {@link
         * com.vmware.nsx.model.NodeNetworkInterfaceProperties#PLANE_DEBUG}</li> <li>
         * {@link com.vmware.nsx.model.NodeNetworkInterfaceProperties#PLANE_NONE}</li>
         * </ul> Interface plane
         *
         * @param plane New value for the property.
         */
        public Builder setPlane(java.lang.String plane) {
            this.plane = plane;
            return this;
        }

        /**
         * VLAN Id format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param vlan New value for the property.
         */
        public Builder setVlan(java.lang.Long vlan) {
            this.vlan = vlan;
            return this;
        }

        public NodeNetworkInterfaceProperties build() {
            NodeNetworkInterfaceProperties result = new NodeNetworkInterfaceProperties();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setAdminStatus(this.adminStatus);
            result.setBondCurActiveSlave(this.bondCurActiveSlave);
            result.setBondLacpRate(this.bondLacpRate);
            result.setBondMode(this.bondMode);
            result.setBondPrimary(this.bondPrimary);
            result.setBondPrimarySlave(this.bondPrimarySlave);
            result.setBondSlaves(this.bondSlaves);
            result.setBondXmitHashPolicy(this.bondXmitHashPolicy);
            result.setBroadcastAddress(this.broadcastAddress);
            result.setDefaultGateway(this.defaultGateway);
            result.setInterfaceId(this.interfaceId);
            result.setIp6Addresses(this.ip6Addresses);
            result.setIpAddresses(this.ipAddresses);
            result.setIpConfiguration(this.ipConfiguration);
            result.setIsKni(this.isKni);
            result.setLinkStatus(this.linkStatus);
            result.setMtu(this.mtu);
            result.setPhysicalAddress(this.physicalAddress);
            result.setPlane(this.plane);
            result.setVlan(this.vlan);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("admin_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("admin_status",
                                                                                "adminStatus",
                                                                                "getAdminStatus",
                                                                                "setAdminStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bond_cur_active_slave", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bond_cur_active_slave",
                                                                                "bondCurActiveSlave",
                                                                                "getBondCurActiveSlave",
                                                                                "setBondCurActiveSlave");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bond_lacp_rate", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bond_lacp_rate",
                                                                                "bondLacpRate",
                                                                                "getBondLacpRate",
                                                                                "setBondLacpRate");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bond_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bond_mode",
                                                                                "bondMode",
                                                                                "getBondMode",
                                                                                "setBondMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bond_primary", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bond_primary",
                                                                                "bondPrimary",
                                                                                "getBondPrimary",
                                                                                "setBondPrimary");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bond_primary_slave", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bond_primary_slave",
                                                                                "bondPrimarySlave",
                                                                                "getBondPrimarySlave",
                                                                                "setBondPrimarySlave");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bond_slaves", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bond_slaves",
                                                                                "bondSlaves",
                                                                                "getBondSlaves",
                                                                                "setBondSlaves");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bond_xmit_hash_policy", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bond_xmit_hash_policy",
                                                                                "bondXmitHashPolicy",
                                                                                "getBondXmitHashPolicy",
                                                                                "setBondXmitHashPolicy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("broadcast_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("broadcast_address",
                                                                                "broadcastAddress",
                                                                                "getBroadcastAddress",
                                                                                "setBroadcastAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_gateway", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_gateway",
                                                                                "defaultGateway",
                                                                                "getDefaultGateway",
                                                                                "setDefaultGateway");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("interface_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("interface_id",
                                                                                "interfaceId",
                                                                                "getInterfaceId",
                                                                                "setInterfaceId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip6_addresses", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.IPv6AddressProperties; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip6_addresses",
                                                                                "ip6Addresses",
                                                                                "getIp6Addresses",
                                                                                "setIp6Addresses");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_addresses", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.IPv4AddressProperties; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_addresses",
                                                                                "ipAddresses",
                                                                                "getIpAddresses",
                                                                                "setIpAddresses");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_configuration", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_configuration",
                                                                                "ipConfiguration",
                                                                                "getIpConfiguration",
                                                                                "setIpConfiguration");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_kni", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_kni",
                                                                                "isKni",
                                                                                "getIsKni",
                                                                                "setIsKni");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("link_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("link_status",
                                                                                "linkStatus",
                                                                                "getLinkStatus",
                                                                                "setLinkStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mtu", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mtu",
                                                                                "mtu",
                                                                                "getMtu",
                                                                                "setMtu");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("physical_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("physical_address",
                                                                                "physicalAddress",
                                                                                "getPhysicalAddress",
                                                                                "setPhysicalAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("plane", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("plane",
                                                                                "plane",
                                                                                "getPlane",
                                                                                "setPlane");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vlan", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vlan",
                                                                                "vlan",
                                                                                "getVlan",
                                                                                "setVlan");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.node_network_interface_properties",
                                                            fields,
                                                            com.vmware.nsx.model.NodeNetworkInterfaceProperties.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

