/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Details about NSX-T site.
 */
public final class NsxtSite implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String FEDERATION_SITE_TYPE_GLOBALMANAGER = "GlobalManager";

    public static final java.lang.String FEDERATION_SITE_TYPE_SITE = "Site";

    private java.lang.String federationSiteDisplayName;

    private java.lang.String federationSiteId;

    private java.lang.String federationSiteType;

    private java.lang.String nsxtIp;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NsxtSite() {
    }

    protected NsxtSite(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Display name for the federation site.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFederationSiteDisplayName() {
        return this.federationSiteDisplayName;
    }

    /**
     * Display name for the federation site.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param federationSiteDisplayName New value for the property.
     */
    public void setFederationSiteDisplayName(java.lang.String federationSiteDisplayName) {
        this.federationSiteDisplayName = federationSiteDisplayName;
    }

    /**
     * Federation site id.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFederationSiteId() {
        return this.federationSiteId;
    }

    /**
     * Federation site id.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param federationSiteId New value for the property.
     */
    public void setFederationSiteId(java.lang.String federationSiteId) {
        this.federationSiteId = federationSiteId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NsxtSite#FEDERATION_SITE_TYPE_GLOBALMANAGER}</li> <li>
     * {@link com.vmware.nsx.model.NsxtSite#FEDERATION_SITE_TYPE_SITE}</li> </ul> Type
     * of federation site. It can be GlobalManager or Site.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFederationSiteType() {
        return this.federationSiteType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NsxtSite#FEDERATION_SITE_TYPE_GLOBALMANAGER}</li> <li>
     * {@link com.vmware.nsx.model.NsxtSite#FEDERATION_SITE_TYPE_SITE}</li> </ul> Type
     * of federation site. It can be GlobalManager or Site.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param federationSiteType New value for the property.
     */
    public void setFederationSiteType(java.lang.String federationSiteType) {
        this.federationSiteType = federationSiteType;
    }

    /**
     * IP address of NSX-T appliance at the site. format: hostname-or-ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNsxtIp() {
        return this.nsxtIp;
    }

    /**
     * IP address of NSX-T appliance at the site. format: hostname-or-ip
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nsxtIp New value for the property.
     */
    public void setNsxtIp(java.lang.String nsxtIp) {
        this.nsxtIp = nsxtIp;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.nsxtSite;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("federation_site_display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.federationSiteDisplayName, this._getType().getField("federation_site_display_name")));
        structValue.setField("federation_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.federationSiteId, this._getType().getField("federation_site_id")));
        structValue.setField("federation_site_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.federationSiteType, this._getType().getField("federation_site_type")));
        structValue.setField("nsxt_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nsxtIp, this._getType().getField("nsxt_ip")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.nsxtSite;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.nsxtSite.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NsxtSite _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NsxtSite(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NsxtSite _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NsxtSite(structValue);
    }

    /**
     * Builder class for {@link NsxtSite}.
     */
    public static final class Builder {
        private java.lang.String federationSiteDisplayName;
        private java.lang.String federationSiteId;
        private java.lang.String federationSiteType;
        private java.lang.String nsxtIp;

        /**
         * Constructor with parameters for the required properties of
         * {@link NsxtSite}.
         */
        public Builder() {
        }

        /**
         * Display name for the federation site.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param federationSiteDisplayName New value for the property.
         */
        public Builder setFederationSiteDisplayName(java.lang.String federationSiteDisplayName) {
            this.federationSiteDisplayName = federationSiteDisplayName;
            return this;
        }

        /**
         * Federation site id.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param federationSiteId New value for the property.
         */
        public Builder setFederationSiteId(java.lang.String federationSiteId) {
            this.federationSiteId = federationSiteId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.NsxtSite#FEDERATION_SITE_TYPE_GLOBALMANAGER}</li> <li>
         * {@link com.vmware.nsx.model.NsxtSite#FEDERATION_SITE_TYPE_SITE}</li> </ul> Type
         * of federation site. It can be GlobalManager or Site.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param federationSiteType New value for the property.
         */
        public Builder setFederationSiteType(java.lang.String federationSiteType) {
            this.federationSiteType = federationSiteType;
            return this;
        }

        /**
         * IP address of NSX-T appliance at the site. format: hostname-or-ip
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nsxtIp New value for the property.
         */
        public Builder setNsxtIp(java.lang.String nsxtIp) {
            this.nsxtIp = nsxtIp;
            return this;
        }

        public NsxtSite build() {
            NsxtSite result = new NsxtSite();
            result.setFederationSiteDisplayName(this.federationSiteDisplayName);
            result.setFederationSiteId(this.federationSiteId);
            result.setFederationSiteType(this.federationSiteType);
            result.setNsxtIp(this.nsxtIp);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("federation_site_display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("federation_site_display_name",
                                                                                "federationSiteDisplayName",
                                                                                "getFederationSiteDisplayName",
                                                                                "setFederationSiteDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("federation_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("federation_site_id",
                                                                                "federationSiteId",
                                                                                "getFederationSiteId",
                                                                                "setFederationSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("federation_site_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("federation_site_type",
                                                                                "federationSiteType",
                                                                                "getFederationSiteType",
                                                                                "setFederationSiteType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nsxt_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nsxt_ip",
                                                                                "nsxtIp",
                                                                                "getNsxtIp",
                                                                                "setNsxtIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.nsxt_site",
                                                            fields,
                                                            com.vmware.nsx.model.NsxtSite.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

