/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * NSX global configs for Routing
 */
public final class RoutingGlobalConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "RoutingGlobalConfig";

    public static final java.lang.String L3FORWARDING_MODE_ONLY = "IPV4_ONLY";

    public static final java.lang.String L3FORWARDING_MODE_AND_IPV6 = "IPV4_AND_IPV6";

    private java.lang.Boolean allowChangingVdrMacInUse;

    private java.lang.String l3ForwardingMode;

    private java.lang.Long logicalUplinkMtu;

    private java.lang.String vdrMac;

    private java.lang.String vdrMacNested;

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private final java.lang.String resourceType = "RoutingGlobalConfig";

    private java.util.List<com.vmware.nsx.model.Tag> tags;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public RoutingGlobalConfig() {
    }

    protected RoutingGlobalConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * When this flag is set to true, it is allowed to change the VDR MAC being used by
     * existing transport nodes in a NSX system. The VDR MAC used by a host switch in a
     * transport node is decided by the OVERLAY transport zone(s) which the host switch
     * joins. If any of the OVERLAY transport zone(s) has \"nested_nsx\" property being
     * true, the MAC in \"vdr_mac_nested\" is used; otherwise the MAC in \"vdr_mac\" is
     * used. Thus the VDR MAC being used by a host switch in a transport node can be
     * changed in below ways. If the host switch is not in any OVERLAY transport zone
     * whose \"nested_nsx\" property is true but is in an OVERLAY transport zone, the
     * first way is updating the \"vdr_mac\" property. The 2nd way is updating one of
     * the OVERLAY tranport zones joined by the host switch to set \"nested_nsx\"
     * property true which will make the host switch use the VDR MAC in
     * \"vdr_mac_nested\". The third way is directly updating the transport node to add
     * an OVERLAY transport zone whose \"nested_nsx\" property is true into the host
     * switch which will also make the host switch use the VDR MAC in
     * \"vdr_mac_nested\". If the host switch is in some OVERLAY transport zone(s)
     * whose \"nested_nsx\" property is true, the first way is updating the
     * \"vdr_mac_nested\" property. The 2nd way is updating all those OVERLAY tranport
     * zones to set \"nested_nsx\" property false which will make the host switch use
     * the VDR MAC in \"vdr_mac\". The third way is directly updating the transport
     * node to remove all those OVERLAY transport zones from the host switch which will
     * also make the host switch use the VDR MAC in \"vdr_mac\". Please note that
     * changing the VDR MAC being used by existing transport nodes will most likely
     * cause traffic disruption and network outage!
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAllowChangingVdrMacInUse() {
        return this.allowChangingVdrMacInUse;
    }

    /**
     * When this flag is set to true, it is allowed to change the VDR MAC being used by
     * existing transport nodes in a NSX system. The VDR MAC used by a host switch in a
     * transport node is decided by the OVERLAY transport zone(s) which the host switch
     * joins. If any of the OVERLAY transport zone(s) has \"nested_nsx\" property being
     * true, the MAC in \"vdr_mac_nested\" is used; otherwise the MAC in \"vdr_mac\" is
     * used. Thus the VDR MAC being used by a host switch in a transport node can be
     * changed in below ways. If the host switch is not in any OVERLAY transport zone
     * whose \"nested_nsx\" property is true but is in an OVERLAY transport zone, the
     * first way is updating the \"vdr_mac\" property. The 2nd way is updating one of
     * the OVERLAY tranport zones joined by the host switch to set \"nested_nsx\"
     * property true which will make the host switch use the VDR MAC in
     * \"vdr_mac_nested\". The third way is directly updating the transport node to add
     * an OVERLAY transport zone whose \"nested_nsx\" property is true into the host
     * switch which will also make the host switch use the VDR MAC in
     * \"vdr_mac_nested\". If the host switch is in some OVERLAY transport zone(s)
     * whose \"nested_nsx\" property is true, the first way is updating the
     * \"vdr_mac_nested\" property. The 2nd way is updating all those OVERLAY tranport
     * zones to set \"nested_nsx\" property false which will make the host switch use
     * the VDR MAC in \"vdr_mac\". The third way is directly updating the transport
     * node to remove all those OVERLAY transport zones from the host switch which will
     * also make the host switch use the VDR MAC in \"vdr_mac\". Please note that
     * changing the VDR MAC being used by existing transport nodes will most likely
     * cause traffic disruption and network outage!
     *
     * @param allowChangingVdrMacInUse New value for the property.
     */
    public void setAllowChangingVdrMacInUse(java.lang.Boolean allowChangingVdrMacInUse) {
        this.allowChangingVdrMacInUse = allowChangingVdrMacInUse;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.RoutingGlobalConfig#L3FORWARDING_MODE_ONLY}</li> <li>
     * {@link com.vmware.nsx.model.RoutingGlobalConfig#L3FORWARDING_MODE_AND_IPV6}</li>
     * </ul> This setting does not restrict configuration as per other modes. But the
     * forwarding will only work as per the mode set here.
     *
     * @return The current value of the property.
     */
    public java.lang.String getL3ForwardingMode() {
        return this.l3ForwardingMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.RoutingGlobalConfig#L3FORWARDING_MODE_ONLY}</li> <li>
     * {@link com.vmware.nsx.model.RoutingGlobalConfig#L3FORWARDING_MODE_AND_IPV6}</li>
     * </ul> This setting does not restrict configuration as per other modes. But the
     * forwarding will only work as per the mode set here.
     *
     * @param l3ForwardingMode New value for the property.
     */
    public void setL3ForwardingMode(java.lang.String l3ForwardingMode) {
        this.l3ForwardingMode = l3ForwardingMode;
    }

    /**
     * This is the global default MTU for all the logical uplinks in a NSX domain.
     * Currently logical uplink MTU can only be set globally and applies to the entire
     * NSX domain. There is no option to override this value at transport zone level or
     * transport node level. If this value is not set, the default value of 1500 will
     * be used. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLogicalUplinkMtu() {
        return this.logicalUplinkMtu;
    }

    /**
     * This is the global default MTU for all the logical uplinks in a NSX domain.
     * Currently logical uplink MTU can only be set globally and applies to the entire
     * NSX domain. There is no option to override this value at transport zone level or
     * transport node level. If this value is not set, the default value of 1500 will
     * be used. format: int32
     *
     * @param logicalUplinkMtu New value for the property.
     */
    public void setLogicalUplinkMtu(java.lang.Long logicalUplinkMtu) {
        this.logicalUplinkMtu = logicalUplinkMtu;
    }

    /**
     * This is the global default MAC address for all VDRs in all transport nodes in a
     * NSX system. When the property \"allow_changing_vdr_mac_in_use\" is false, it can
     * not be changed if the current VDR MAC is being used by any transport node. A
     * transport node uses this VDR MAC if any host switch in the node is in OVERLAY
     * transport zone(s) but none of the transport zone(s) has \"nested_nsx\" property
     * being true. format: mac-address
     *
     * @return The current value of the property.
     */
    public java.lang.String getVdrMac() {
        return this.vdrMac;
    }

    /**
     * This is the global default MAC address for all VDRs in all transport nodes in a
     * NSX system. When the property \"allow_changing_vdr_mac_in_use\" is false, it can
     * not be changed if the current VDR MAC is being used by any transport node. A
     * transport node uses this VDR MAC if any host switch in the node is in OVERLAY
     * transport zone(s) but none of the transport zone(s) has \"nested_nsx\" property
     * being true. format: mac-address
     *
     * @param vdrMac New value for the property.
     */
    public void setVdrMac(java.lang.String vdrMac) {
        this.vdrMac = vdrMac;
    }

    /**
     * This is the global default MAC address for all VDRs in all transport nodes in a
     * NSX system nested in another NSX system. All transport zones in such a nested
     * NSX system will have the \"nested_nsx\" property being true so that all
     * transport nodes will use this MAC for the VDR ports to avoid conflict with the
     * VDR MAC in the outer NSX system. When the property
     * \"allow_changing_vdr_mac_in_use\" is false, it can not be changed if the current
     * VDR MAC is being used by any transport node in a nested NSX environment. A
     * transport node uses this VDR MAC if any host switch in the node is in an OVERLAY
     * transport zone whose \"nested_nsx\" property is true. format: mac-address
     *
     * @return The current value of the property.
     */
    public java.lang.String getVdrMacNested() {
        return this.vdrMacNested;
    }

    /**
     * This is the global default MAC address for all VDRs in all transport nodes in a
     * NSX system nested in another NSX system. All transport zones in such a nested
     * NSX system will have the \"nested_nsx\" property being true so that all
     * transport nodes will use this MAC for the VDR ports to avoid conflict with the
     * VDR MAC in the outer NSX system. When the property
     * \"allow_changing_vdr_mac_in_use\" is false, it can not be changed if the current
     * VDR MAC is being used by any transport node in a nested NSX environment. A
     * transport node uses this VDR MAC if any host switch in the node is in an OVERLAY
     * transport zone whose \"nested_nsx\" property is true. format: mac-address
     *
     * @param vdrMacNested New value for the property.
     */
    public void setVdrMacNested(java.lang.String vdrMacNested) {
        this.vdrMacNested = vdrMacNested;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.GlobalConfigs#RESOURCE_TYPE_SWITCHINGGLOBALCONFIG}</li>
     * <li> {@link
     * com.vmware.nsx.model.GlobalConfigs#RESOURCE_TYPE_ROUTINGGLOBALCONFIG}</li> <li>
     * {@link
     * com.vmware.nsx.model.GlobalConfigs#RESOURCE_TYPE_OPERATIONCOLLECTORGLOBALCONFIG}</li>
     * <li> {@link
     * com.vmware.nsx.model.GlobalConfigs#RESOURCE_TYPE_FIREWALLGLOBALCONFIG}</li> <li>
     * {@link
     * com.vmware.nsx.model.GlobalConfigs#RESOURCE_TYPE_ESXGLOBALOPAQUECONFIG}</li>
     * <li> {@link
     * com.vmware.nsx.model.GlobalConfigs#RESOURCE_TYPE_SECURITYGLOBALCONFIG}</li> <li>
     * {@link com.vmware.nsx.model.GlobalConfigs#RESOURCE_TYPE_FIPSGLOBALCONFIG}</li>
     * <li> {@link
     * com.vmware.nsx.model.GlobalConfigs#RESOURCE_TYPE_FEDERATIONGLOBALCONFIG}</li>
     * <li> {@link
     * com.vmware.nsx.model.GlobalConfigs#RESOURCE_TYPE_IDSGLOBALCONFIG}</li> </ul>
     * Valid Global configuration types
     * The value of this property is automatically populated to {@code "RoutingGlobalConfig"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
        this.tags = tags;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.routingGlobalConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("allow_changing_vdr_mac_in_use",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allowChangingVdrMacInUse, this._getType().getField("allow_changing_vdr_mac_in_use")));
        structValue.setField("l3_forwarding_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.l3ForwardingMode, this._getType().getField("l3_forwarding_mode")));
        structValue.setField("logical_uplink_mtu",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.logicalUplinkMtu, this._getType().getField("logical_uplink_mtu")));
        structValue.setField("vdr_mac",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vdrMac, this._getType().getField("vdr_mac")));
        structValue.setField("vdr_mac_nested",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vdrMacNested, this._getType().getField("vdr_mac_nested")));
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.routingGlobalConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.routingGlobalConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static RoutingGlobalConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new RoutingGlobalConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static RoutingGlobalConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new RoutingGlobalConfig(structValue);
    }

    /**
     * Builder class for {@link RoutingGlobalConfig}.
     */
    public static final class Builder {
        private java.lang.Boolean allowChangingVdrMacInUse;
        private java.lang.String l3ForwardingMode;
        private java.lang.Long logicalUplinkMtu;
        private java.lang.String vdrMac;
        private java.lang.String vdrMacNested;
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.util.List<com.vmware.nsx.model.Tag> tags;

        /**
         * Constructor with parameters for the required properties of
         * {@link RoutingGlobalConfig}.
         */
        public Builder() {
        }

        /**
         * When this flag is set to true, it is allowed to change the VDR MAC being used by
         * existing transport nodes in a NSX system. The VDR MAC used by a host switch in a
         * transport node is decided by the OVERLAY transport zone(s) which the host switch
         * joins. If any of the OVERLAY transport zone(s) has \"nested_nsx\" property being
         * true, the MAC in \"vdr_mac_nested\" is used; otherwise the MAC in \"vdr_mac\" is
         * used. Thus the VDR MAC being used by a host switch in a transport node can be
         * changed in below ways. If the host switch is not in any OVERLAY transport zone
         * whose \"nested_nsx\" property is true but is in an OVERLAY transport zone, the
         * first way is updating the \"vdr_mac\" property. The 2nd way is updating one of
         * the OVERLAY tranport zones joined by the host switch to set \"nested_nsx\"
         * property true which will make the host switch use the VDR MAC in
         * \"vdr_mac_nested\". The third way is directly updating the transport node to add
         * an OVERLAY transport zone whose \"nested_nsx\" property is true into the host
         * switch which will also make the host switch use the VDR MAC in
         * \"vdr_mac_nested\". If the host switch is in some OVERLAY transport zone(s)
         * whose \"nested_nsx\" property is true, the first way is updating the
         * \"vdr_mac_nested\" property. The 2nd way is updating all those OVERLAY tranport
         * zones to set \"nested_nsx\" property false which will make the host switch use
         * the VDR MAC in \"vdr_mac\". The third way is directly updating the transport
         * node to remove all those OVERLAY transport zones from the host switch which will
         * also make the host switch use the VDR MAC in \"vdr_mac\". Please note that
         * changing the VDR MAC being used by existing transport nodes will most likely
         * cause traffic disruption and network outage!
         *
         * @param allowChangingVdrMacInUse New value for the property.
         */
        public Builder setAllowChangingVdrMacInUse(java.lang.Boolean allowChangingVdrMacInUse) {
            this.allowChangingVdrMacInUse = allowChangingVdrMacInUse;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.RoutingGlobalConfig#L3FORWARDING_MODE_ONLY}</li> <li>
         * {@link com.vmware.nsx.model.RoutingGlobalConfig#L3FORWARDING_MODE_AND_IPV6}</li>
         * </ul> This setting does not restrict configuration as per other modes. But the
         * forwarding will only work as per the mode set here.
         *
         * @param l3ForwardingMode New value for the property.
         */
        public Builder setL3ForwardingMode(java.lang.String l3ForwardingMode) {
            this.l3ForwardingMode = l3ForwardingMode;
            return this;
        }

        /**
         * This is the global default MTU for all the logical uplinks in a NSX domain.
         * Currently logical uplink MTU can only be set globally and applies to the entire
         * NSX domain. There is no option to override this value at transport zone level or
         * transport node level. If this value is not set, the default value of 1500 will
         * be used. format: int32
         *
         * @param logicalUplinkMtu New value for the property.
         */
        public Builder setLogicalUplinkMtu(java.lang.Long logicalUplinkMtu) {
            this.logicalUplinkMtu = logicalUplinkMtu;
            return this;
        }

        /**
         * This is the global default MAC address for all VDRs in all transport nodes in a
         * NSX system. When the property \"allow_changing_vdr_mac_in_use\" is false, it can
         * not be changed if the current VDR MAC is being used by any transport node. A
         * transport node uses this VDR MAC if any host switch in the node is in OVERLAY
         * transport zone(s) but none of the transport zone(s) has \"nested_nsx\" property
         * being true. format: mac-address
         *
         * @param vdrMac New value for the property.
         */
        public Builder setVdrMac(java.lang.String vdrMac) {
            this.vdrMac = vdrMac;
            return this;
        }

        /**
         * This is the global default MAC address for all VDRs in all transport nodes in a
         * NSX system nested in another NSX system. All transport zones in such a nested
         * NSX system will have the \"nested_nsx\" property being true so that all
         * transport nodes will use this MAC for the VDR ports to avoid conflict with the
         * VDR MAC in the outer NSX system. When the property
         * \"allow_changing_vdr_mac_in_use\" is false, it can not be changed if the current
         * VDR MAC is being used by any transport node in a nested NSX environment. A
         * transport node uses this VDR MAC if any host switch in the node is in an OVERLAY
         * transport zone whose \"nested_nsx\" property is true. format: mac-address
         *
         * @param vdrMacNested New value for the property.
         */
        public Builder setVdrMacNested(java.lang.String vdrMacNested) {
            this.vdrMacNested = vdrMacNested;
            return this;
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        public RoutingGlobalConfig build() {
            RoutingGlobalConfig result = new RoutingGlobalConfig();
            result.setAllowChangingVdrMacInUse(this.allowChangingVdrMacInUse);
            result.setL3ForwardingMode(this.l3ForwardingMode);
            result.setLogicalUplinkMtu(this.logicalUplinkMtu);
            result.setVdrMac(this.vdrMac);
            result.setVdrMacNested(this.vdrMacNested);
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setTags(this.tags);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("allow_changing_vdr_mac_in_use", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allow_changing_vdr_mac_in_use",
                                                                                "allowChangingVdrMacInUse",
                                                                                "getAllowChangingVdrMacInUse",
                                                                                "setAllowChangingVdrMacInUse");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("l3_forwarding_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("l3_forwarding_mode",
                                                                                "l3ForwardingMode",
                                                                                "getL3ForwardingMode",
                                                                                "setL3ForwardingMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("logical_uplink_mtu", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("logical_uplink_mtu",
                                                                                "logicalUplinkMtu",
                                                                                "getLogicalUplinkMtu",
                                                                                "setLogicalUplinkMtu");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vdr_mac", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vdr_mac",
                                                                                "vdrMac",
                                                                                "getVdrMac",
                                                                                "setVdrMac");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vdr_mac_nested", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vdr_mac_nested",
                                                                                "vdrMacNested",
                                                                                "getVdrMacNested",
                                                                                "setVdrMacNested");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.routing_global_config",
                                                            fields,
                                                            com.vmware.nsx.model.RoutingGlobalConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "RoutingGlobalConfig");
    }
}

