/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * A ServiceInsertionServiceProfile can be part of multiple ServiceChains.
 * ServiceChainMapping for a particular profile will contain a list of all the
 * ServiceChains it's part of. Each Mapping will also contain some metadata to
 * uniquely identify a profile from other profiles.
 */
public final class ServiceChainMapping implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String DIRECTION_FORWARD = "FORWARD";

    public static final java.lang.String DIRECTION_REVERSE = "REVERSE";

    private java.lang.String direction;

    private java.lang.String serviceChainId;

    private java.lang.Long serviceIndex;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ServiceChainMapping() {
    }

    protected ServiceChainMapping(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ServiceChainMapping#DIRECTION_FORWARD}</li> <li> {@link
     * com.vmware.nsx.model.ServiceChainMapping#DIRECTION_REVERSE}</li> </ul> Each
     * ServiceChain has forward_path_service_profiles and
     * reverse_path_service_profiles. This property will indicate which of them being
     * used. FORWARD - forward_path_service_profiles REVERSE -
     * reverse_path_service_profiles
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDirection() {
        return this.direction;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ServiceChainMapping#DIRECTION_FORWARD}</li> <li> {@link
     * com.vmware.nsx.model.ServiceChainMapping#DIRECTION_REVERSE}</li> </ul> Each
     * ServiceChain has forward_path_service_profiles and
     * reverse_path_service_profiles. This property will indicate which of them being
     * used. FORWARD - forward_path_service_profiles REVERSE -
     * reverse_path_service_profiles
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param direction New value for the property.
     */
    public void setDirection(java.lang.String direction) {
        this.direction = direction;
    }

    /**
     * A unique id generated for every ServiceChain. This is not a uuid.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServiceChainId() {
        return this.serviceChainId;
    }

    /**
     * A unique id generated for every ServiceChain. This is not a uuid.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param serviceChainId New value for the property.
     */
    public void setServiceChainId(java.lang.String serviceChainId) {
        this.serviceChainId = serviceChainId;
    }

    /**
     * Service Index represents a numerical position of a
     * ServiceInsertionServiceProfile in a ServiceChain. It will be in reverse order.
     * Service Index can point to either forward_path_service_profiles or
     * reverse_path_service_profiles indicated by direction property. Example - For a
     * ServiceChain A-B-C, A will have index of 3, B will have index of 2 and C will
     * have index of 1. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getServiceIndex() {
        return this.serviceIndex;
    }

    /**
     * Service Index represents a numerical position of a
     * ServiceInsertionServiceProfile in a ServiceChain. It will be in reverse order.
     * Service Index can point to either forward_path_service_profiles or
     * reverse_path_service_profiles indicated by direction property. Example - For a
     * ServiceChain A-B-C, A will have index of 3, B will have index of 2 and C will
     * have index of 1. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param serviceIndex New value for the property.
     */
    public void setServiceIndex(java.lang.Long serviceIndex) {
        this.serviceIndex = serviceIndex;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.serviceChainMapping;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("direction",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.direction, this._getType().getField("direction")));
        structValue.setField("service_chain_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceChainId, this._getType().getField("service_chain_id")));
        structValue.setField("service_index",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceIndex, this._getType().getField("service_index")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.serviceChainMapping;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.serviceChainMapping.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ServiceChainMapping _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ServiceChainMapping(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ServiceChainMapping _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ServiceChainMapping(structValue);
    }

    /**
     * Builder class for {@link ServiceChainMapping}.
     */
    public static final class Builder {
        private java.lang.String direction;
        private java.lang.String serviceChainId;
        private java.lang.Long serviceIndex;

        /**
         * Constructor with parameters for the required properties of
         * {@link ServiceChainMapping}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.ServiceChainMapping#DIRECTION_FORWARD}</li> <li> {@link
         * com.vmware.nsx.model.ServiceChainMapping#DIRECTION_REVERSE}</li> </ul> Each
         * ServiceChain has forward_path_service_profiles and
         * reverse_path_service_profiles. This property will indicate which of them being
         * used. FORWARD - forward_path_service_profiles REVERSE -
         * reverse_path_service_profiles
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param direction New value for the property.
         */
        public Builder setDirection(java.lang.String direction) {
            this.direction = direction;
            return this;
        }

        /**
         * A unique id generated for every ServiceChain. This is not a uuid.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param serviceChainId New value for the property.
         */
        public Builder setServiceChainId(java.lang.String serviceChainId) {
            this.serviceChainId = serviceChainId;
            return this;
        }

        /**
         * Service Index represents a numerical position of a
         * ServiceInsertionServiceProfile in a ServiceChain. It will be in reverse order.
         * Service Index can point to either forward_path_service_profiles or
         * reverse_path_service_profiles indicated by direction property. Example - For a
         * ServiceChain A-B-C, A will have index of 3, B will have index of 2 and C will
         * have index of 1. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param serviceIndex New value for the property.
         */
        public Builder setServiceIndex(java.lang.Long serviceIndex) {
            this.serviceIndex = serviceIndex;
            return this;
        }

        public ServiceChainMapping build() {
            ServiceChainMapping result = new ServiceChainMapping();
            result.setDirection(this.direction);
            result.setServiceChainId(this.serviceChainId);
            result.setServiceIndex(this.serviceIndex);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("direction", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("direction",
                                                                                "direction",
                                                                                "getDirection",
                                                                                "setDirection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_chain_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_chain_id",
                                                                                "serviceChainId",
                                                                                "getServiceChainId",
                                                                                "setServiceChainId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_index", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_index",
                                                                                "serviceIndex",
                                                                                "getServiceIndex",
                                                                                "setServiceIndex");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.service_chain_mapping",
                                                            fields,
                                                            com.vmware.nsx.model.ServiceChainMapping.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

