/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * This object contains list of SNMP v3 users used to poll NSX nodes over SNMP and
 * list of SNMP v3 targets used to receive SNMP traps/notifications from NSX nodes.
 * Users specified in a SNMP v3 target must exist in the list of SNMP v3 users.
 */
public final class Snmpv3Properties implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String AUTH_PROTOCOL_SHA1 = "SHA1";

    public static final java.lang.String PRIV_PROTOCOL_AES128 = "AES128";

    private java.lang.String authProtocol;

    private java.util.List<com.vmware.nsx.model.CCSnmpV3User> ccUsers;

    private java.lang.String privProtocol;

    private java.util.List<com.vmware.nsx.model.Snmpv3Target> targets;

    private java.util.List<com.vmware.nsx.model.Snmpv3User> users;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public Snmpv3Properties() {
    }

    protected Snmpv3Properties(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.Snmpv3Properties#AUTH_PROTOCOL_SHA1}</li> </ul>
     * Authentication protocol used for SNMP v3 communication.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAuthProtocol() {
        return this.authProtocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.Snmpv3Properties#AUTH_PROTOCOL_SHA1}</li> </ul>
     * Authentication protocol used for SNMP v3 communication.
     *
     * @param authProtocol New value for the property.
     */
    public void setAuthProtocol(java.lang.String authProtocol) {
        this.authProtocol = authProtocol;
    }

    /**
     * List of CentralConfig SNMP v3 users allowed to poll NSX nodes over SNMP. Also,
     * users specified in a SNMP v3 target must exist in this list.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.CCSnmpV3User> getCcUsers() {
        return this.ccUsers;
    }

    /**
     * List of CentralConfig SNMP v3 users allowed to poll NSX nodes over SNMP. Also,
     * users specified in a SNMP v3 target must exist in this list.
     *
     * @param ccUsers New value for the property.
     */
    public void setCcUsers(java.util.List<com.vmware.nsx.model.CCSnmpV3User> ccUsers) {
        this.ccUsers = ccUsers;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.Snmpv3Properties#PRIV_PROTOCOL_AES128}</li> </ul> Privacy
     * protocol used for SNMP v3 communication.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPrivProtocol() {
        return this.privProtocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.Snmpv3Properties#PRIV_PROTOCOL_AES128}</li> </ul> Privacy
     * protocol used for SNMP v3 communication.
     *
     * @param privProtocol New value for the property.
     */
    public void setPrivProtocol(java.lang.String privProtocol) {
        this.privProtocol = privProtocol;
    }

    /**
     * List of SNMP v3 targets/receivers where SNMP v3 traps/notifications will be sent
     * from NSX nodes.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Snmpv3Target> getTargets() {
        return this.targets;
    }

    /**
     * List of SNMP v3 targets/receivers where SNMP v3 traps/notifications will be sent
     * from NSX nodes.
     *
     * @param targets New value for the property.
     */
    public void setTargets(java.util.List<com.vmware.nsx.model.Snmpv3Target> targets) {
        this.targets = targets;
    }

    /**
     * List of SNMP v3 users allowed to poll NSX nodes over SNMP. Also, users specified
     * in a SNMP v3 target must exist in this list.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx.model.Snmpv3User> getUsers() {
        return this.users;
    }

    /**
     * List of SNMP v3 users allowed to poll NSX nodes over SNMP. Also, users specified
     * in a SNMP v3 target must exist in this list.
     *
     * @param users New value for the property.
     */
    @Deprecated
    public void setUsers(java.util.List<com.vmware.nsx.model.Snmpv3User> users) {
        this.users = users;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.snmpv3Properties;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("auth_protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.authProtocol, this._getType().getField("auth_protocol")));
        structValue.setField("cc_users",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ccUsers, this._getType().getField("cc_users")));
        structValue.setField("priv_protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.privProtocol, this._getType().getField("priv_protocol")));
        structValue.setField("targets",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.targets, this._getType().getField("targets")));
        structValue.setField("users",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.users, this._getType().getField("users")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.snmpv3Properties;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.snmpv3Properties.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static Snmpv3Properties _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new Snmpv3Properties(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static Snmpv3Properties _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new Snmpv3Properties(structValue);
    }

    /**
     * Builder class for {@link Snmpv3Properties}.
     */
    public static final class Builder {
        private java.lang.String authProtocol;
        private java.util.List<com.vmware.nsx.model.CCSnmpV3User> ccUsers;
        private java.lang.String privProtocol;
        private java.util.List<com.vmware.nsx.model.Snmpv3Target> targets;
        private java.util.List<com.vmware.nsx.model.Snmpv3User> users;

        /**
         * Constructor with parameters for the required properties of
         * {@link Snmpv3Properties}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.Snmpv3Properties#AUTH_PROTOCOL_SHA1}</li> </ul>
         * Authentication protocol used for SNMP v3 communication.
         *
         * @param authProtocol New value for the property.
         */
        public Builder setAuthProtocol(java.lang.String authProtocol) {
            this.authProtocol = authProtocol;
            return this;
        }

        /**
         * List of CentralConfig SNMP v3 users allowed to poll NSX nodes over SNMP. Also,
         * users specified in a SNMP v3 target must exist in this list.
         *
         * @param ccUsers New value for the property.
         */
        public Builder setCcUsers(java.util.List<com.vmware.nsx.model.CCSnmpV3User> ccUsers) {
            this.ccUsers = ccUsers;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.Snmpv3Properties#PRIV_PROTOCOL_AES128}</li> </ul> Privacy
         * protocol used for SNMP v3 communication.
         *
         * @param privProtocol New value for the property.
         */
        public Builder setPrivProtocol(java.lang.String privProtocol) {
            this.privProtocol = privProtocol;
            return this;
        }

        /**
         * List of SNMP v3 targets/receivers where SNMP v3 traps/notifications will be sent
         * from NSX nodes.
         *
         * @param targets New value for the property.
         */
        public Builder setTargets(java.util.List<com.vmware.nsx.model.Snmpv3Target> targets) {
            this.targets = targets;
            return this;
        }

        /**
         * List of SNMP v3 users allowed to poll NSX nodes over SNMP. Also, users specified
         * in a SNMP v3 target must exist in this list.
         *
         * @param users New value for the property.
         */
        public Builder setUsers(java.util.List<com.vmware.nsx.model.Snmpv3User> users) {
            this.users = users;
            return this;
        }

        public Snmpv3Properties build() {
            Snmpv3Properties result = new Snmpv3Properties();
            result.setAuthProtocol(this.authProtocol);
            result.setCcUsers(this.ccUsers);
            result.setPrivProtocol(this.privProtocol);
            result.setTargets(this.targets);
            result.setUsers(this.users);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("auth_protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("auth_protocol",
                                                                                "authProtocol",
                                                                                "getAuthProtocol",
                                                                                "setAuthProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cc_users", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.CCSnmpV3User; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cc_users",
                                                                                "ccUsers",
                                                                                "getCcUsers",
                                                                                "setCcUsers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("priv_protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("priv_protocol",
                                                                                "privProtocol",
                                                                                "getPrivProtocol",
                                                                                "setPrivProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("targets", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.snmpv3Target; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("targets",
                                                                                "targets",
                                                                                "getTargets",
                                                                                "setTargets");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("users", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.snmpv3User; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("users",
                                                                                "users",
                                                                                "getUsers",
                                                                                "setUsers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.snmpv3_properties",
                                                            fields,
                                                            com.vmware.nsx.model.Snmpv3Properties.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

